/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.TargetError;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.symmetric.config.INodeIdCreator;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.RegistrationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNodeIdCreator
implements INodeIdCreator,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected IParameterService parameterService;
    protected INodeService nodeService;
    protected ISecurityService securityService;

    public DefaultNodeIdCreator(IParameterService parameterService, INodeService nodeService, ISecurityService securityService) {
        this.parameterService = parameterService;
        this.nodeService = nodeService;
        this.securityService = securityService;
    }

    @Override
    public String selectNodeId(Node node, String remoteHost, String remoteAddress) {
        String nodeId = node.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = this.evaluateScript(node, remoteHost, remoteAddress);
        }
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            String defaultNodeId = this.buildNodeId(this.nodeService, node);
            if (this.parameterService.is("external.id.is.unique.enabled")) {
                nodeId = defaultNodeId;
            } else {
                int maxTries = this.parameterService.getInt("node.id.creator.max.nodes", 100);
                String checkNodeId = defaultNodeId;
                for (int sequence = 0; sequence < maxTries; ++sequence) {
                    NodeSecurity security = this.nodeService.findNodeSecurity(checkNodeId);
                    if (security != null && security.isRegistrationEnabled()) {
                        nodeId = checkNodeId;
                        break;
                    }
                    checkNodeId = defaultNodeId + "-" + sequence;
                }
            }
        }
        return nodeId;
    }

    @Override
    public String generateNodeId(Node node, String remoteHost, String remoteAddress) {
        String nodeId = node.getNodeId();
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            nodeId = this.evaluateScript(node, remoteHost, remoteAddress);
        }
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            String defaultNodeId = this.buildNodeId(this.nodeService, node);
            if (this.parameterService.is("external.id.is.unique.enabled")) {
                nodeId = defaultNodeId;
            } else {
                int maxTries = this.parameterService.getInt("node.id.creator.max.nodes", 100);
                String checkNodeId = defaultNodeId;
                for (int sequence = 0; sequence < maxTries; ++sequence) {
                    NodeSecurity security = this.nodeService.findNodeSecurity(checkNodeId);
                    if (security == null || security.isRegistrationEnabled()) {
                        nodeId = checkNodeId;
                        break;
                    }
                    checkNodeId = defaultNodeId + "-" + sequence;
                }
                if (StringUtils.isBlank((CharSequence)nodeId)) {
                    throw new RegistrationFailedException("Could not find an available nodeId to use for externalId of " + node.getExternalId() + " after " + maxTries + " tries.");
                }
            }
        }
        return nodeId;
    }

    protected String buildNodeId(INodeService nodeService, Node node) {
        return StringUtils.isBlank((CharSequence)node.getExternalId()) ? "0" : node.getExternalId();
    }

    @Override
    public String generatePassword(Node node) {
        return this.securityService.nextSecureHexString(30);
    }

    protected String evaluateScript(Node node, String remoteHost, String remoteAddress) {
        String script = this.parameterService.getString("node.id.creator.script");
        if (StringUtils.isNotBlank((CharSequence)script)) {
            try {
                Interpreter interpreter = new Interpreter();
                interpreter.set("node", (Object)node);
                interpreter.set("hostname", (Object)remoteHost);
                interpreter.set("remoteHost", (Object)remoteHost);
                interpreter.set("remoteAddress", (Object)remoteAddress);
                interpreter.set("log", (Object)this.log);
                Object retValue = interpreter.eval(script);
                if (retValue != null) {
                    return retValue.toString();
                }
            }
            catch (TargetError e) {
                if (e.getTarget() instanceof RuntimeException) {
                    throw (RuntimeException)e.getTarget();
                }
                throw new RuntimeException(e.getTarget() != null ? e.getTarget() : e);
            }
            catch (EvalError e) {
                this.log.error("Failed to evalute node id generator script.  The default node id generation mechanism will be used.", (Throwable)e);
            }
        }
        return null;
    }
}

