/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.util.TypedPropertiesFactory;
import org.jumpmind.util.AppUtils;

public class PropertiesUtil {
    public static final String PROPERTIES_FACTORY_CLASS_NAME = "properties.factory.class.name";

    public static String getEnginesDir() {
        String enginesDir = System.getProperty("symmetric.engines.dir", AppUtils.getSymHome() + "/engines");
        new File(enginesDir).mkdirs();
        return enginesDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File findPropertiesFileForEngineWithName(String engineName) {
        File[] files = PropertiesUtil.findEnginePropertiesFiles();
        int i = 0;
        while (i < files.length) {
            File file2 = files[i];
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(file2);){
                properties.load(is);
                if (engineName.equals(properties.getProperty("engine.name"))) {
                    File file = file2;
                    return file;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    public static File[] findEnginePropertiesFiles() {
        ArrayList<File> propFiles = new ArrayList<File>();
        File enginesDir = new File(PropertiesUtil.getEnginesDir());
        File[] files = enginesDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (!file.getName().endsWith(".properties")) continue;
                propFiles.add(file);
            }
        }
        return propFiles.toArray(new File[propFiles.size()]);
    }

    public static ITypedPropertiesFactory createTypedPropertiesFactory(File propFile, Properties prop) {
        String propFactoryClassName = System.getProperties().getProperty(PROPERTIES_FACTORY_CLASS_NAME);
        ITypedPropertiesFactory factory = null;
        if (propFactoryClassName != null) {
            try {
                factory = (ITypedPropertiesFactory)Class.forName(propFactoryClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            factory = new TypedPropertiesFactory();
        }
        factory.init(propFile, prop);
        return factory;
    }
}

