/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Monitor;
import org.jumpmind.symmetric.model.MonitorEvent;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.CollectionUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SymmetricUtils {
    private static final Logger log = LoggerFactory.getLogger(SymmetricUtils.class);
    protected static boolean isNoticeLogged;

    private SymmetricUtils() {
    }

    public static String quote(ISymmetricDialect symmetricDialect, String name) {
        String quote = symmetricDialect.getPlatform().getDatabaseInfo().getDelimiterToken();
        if (StringUtils.isNotBlank((CharSequence)quote)) {
            return quote + name + quote;
        }
        return name;
    }

    public static final void replaceSystemAndEnvironmentVariables(Properties properties) {
        HashSet<Object> keys = new HashSet<Object>(properties.keySet());
        Map<String, String> env = System.getenv();
        Map systemProperties = CollectionUtils.toMap((Properties)System.getProperties());
        for (Object e : keys) {
            String value = properties.getProperty((String)e);
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            value = FormatUtils.replaceTokens((String)value, env, (boolean)true);
            if ((value = FormatUtils.replaceTokens((String)value, (Map)systemProperties, (boolean)true)).contains("hostName")) {
                value = FormatUtils.replace((String)"hostName", (String)AppUtils.getHostName(), (String)value);
            }
            if (value.contains("portNumber")) {
                value = FormatUtils.replace((String)"portNumber", (String)AppUtils.getPortNumber(), (String)value);
            }
            if (value.contains("protocol")) {
                value = FormatUtils.replace((String)"protocol", (String)AppUtils.getProtocol(), (String)value);
            }
            if (value.contains("ipAddress")) {
                value = FormatUtils.replace((String)"ipAddress", (String)AppUtils.getIpAddress(), (String)value);
            }
            if (value.contains("engineName")) {
                value = FormatUtils.replace((String)"engineName", (String)properties.getProperty("engine.name", ""), (String)value);
            }
            if (value.contains("nodeGroupId")) {
                value = FormatUtils.replace((String)"nodeGroupId", (String)properties.getProperty("group.id", ""), (String)value);
            }
            if (value.contains("externalId")) {
                value = FormatUtils.replace((String)"externalId", (String)properties.getProperty("external.id", ""), (String)value);
            }
            if (value.contains("syncUrl")) {
                value = FormatUtils.replace((String)"syncUrl", (String)properties.getProperty("sync.url", ""), (String)value);
            }
            if (value.contains("registrationUrl")) {
                value = FormatUtils.replace((String)"registrationUrl", (String)properties.getProperty("registration.url", ""), (String)value);
            }
            properties.put(e, value);
        }
    }

    public static Map<String, String> getReplacementsForMonitorEvent(ISymmetricEngine engine, MonitorEvent event) {
        Node eventNode = engine.getNodeService().findNode(event.getNodeId());
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("engineName", engine.getEngineName());
        replacements.put("eventCount", String.valueOf(event.getCount()));
        replacements.put("eventDetails", event.getDetails());
        replacements.put("eventHostName", event.getHostName());
        replacements.put("eventIsNotified", String.valueOf(event.isNotified()));
        replacements.put("eventIsResolved", String.valueOf(event.isResolved()));
        replacements.put("eventLastUpdateTime", FormatUtils.formatDateTimeISO((Date)event.getLastUpdateTime()));
        replacements.put("eventMonitorId", event.getMonitorId());
        if (eventNode != null) {
            replacements.put("eventNodeExternalId", eventNode.getExternalId());
            replacements.put("eventNodeGroupId", eventNode.getNodeGroupId());
        } else {
            replacements.put("eventNodeExternalId", "<unknown>");
            replacements.put("eventNodeGroupId", "<unknown>");
        }
        replacements.put("eventNodeId", event.getNodeId());
        replacements.put("eventSeverityLevel", Monitor.getSeverityLevelNames().get(event.getSeverityLevel()));
        replacements.put("eventThreshold", String.valueOf(event.getThreshold()));
        replacements.put("eventTime", FormatUtils.formatDateTimeISO((Date)event.getEventTime()));
        replacements.put("eventType", event.getType());
        replacements.put("eventValue", String.valueOf(event.getValue()));
        replacements.put("serverName", AppUtils.getHostName());
        return replacements;
    }

    public static Map<String, String> getReplacementsForMonitorEventList(ISymmetricEngine engine, List<MonitorEvent> events) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        HashSet<String> nodeIds = new HashSet<String>();
        HashSet<String> types = new HashSet<String>();
        for (MonitorEvent event : events) {
            nodeIds.add(event.getNodeId());
            types.add(event.getType());
        }
        replacements.put("engineName", engine.getEngineName());
        replacements.put("eventCount", String.valueOf(events.size()));
        replacements.put("eventNodeCount", String.valueOf(nodeIds.size()));
        replacements.put("eventNodeIds", String.join((CharSequence)", ", nodeIds));
        replacements.put("eventTypes", String.join((CharSequence)", ", types));
        replacements.put("serverName", AppUtils.getHostName());
        return replacements;
    }

    public static String replaceNodeVariables(Node sourceNode, Node targetNode, String str) {
        if (sourceNode != null) {
            str = FormatUtils.replace((String)"sourceNodeId", (String)sourceNode.getNodeId(), (String)str);
            str = FormatUtils.replace((String)"sourceExternalId", (String)sourceNode.getExternalId(), (String)str);
            str = FormatUtils.replace((String)"sourceNodeGroupId", (String)sourceNode.getNodeGroupId(), (String)str);
        }
        if (targetNode != null) {
            str = FormatUtils.replace((String)"targetNodeId", (String)targetNode.getNodeGroupId(), (String)str);
            str = FormatUtils.replace((String)"targetExternalId", (String)targetNode.getExternalId(), (String)str);
            str = FormatUtils.replace((String)"targetNodeGroupId", (String)targetNode.getNodeGroupId(), (String)str);
        }
        return str;
    }

    public static String replaceCatalogSchemaVariables(String catalogName, String defaultCatalogName, String schemaName, String defaultSchemaName, String str) {
        if (catalogName == null) {
            catalogName = defaultCatalogName;
        }
        if (schemaName == null) {
            schemaName = defaultSchemaName;
        }
        if (catalogName != null) {
            str = FormatUtils.replace((String)"sourceCatalogName", (String)catalogName, (String)str);
        }
        if (schemaName != null) {
            str = FormatUtils.replace((String)"sourceSchemaName", (String)schemaName, (String)str);
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logNotices() {
        Class<SymmetricUtils> clazz = SymmetricUtils.class;
        synchronized (SymmetricUtils.class) {
            if (isNoticeLogged) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            isNoticeLogged = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            String notices = null;
            try {
                notices = String.format("%n%s%n", IOUtils.toString((URL)Thread.currentThread().getContextClassLoader().getResource("symmetricds.asciiart"), (Charset)Charset.defaultCharset()));
                notices = notices.replaceAll("\n", String.format("%n", new Object[0]));
            }
            catch (Exception ex) {
                notices = String.format("SymmetricDS Start%n", new Object[0]);
            }
            String buildTime = Long.toString(Version.getBuildTime());
            String year = null;
            year = buildTime.length() >= 4 ? buildTime.substring(0, 4) : new SimpleDateFormat("yyyy").format(new Date());
            int pad = 65;
            notices = notices + String.format("+" + StringUtils.repeat((String)"-", (int)pad) + "+%n|" + StringUtils.rightPad((String)(" Copyright (C) 2007-" + year + " JumpMind, Inc."), (int)pad) + "|%n|" + StringUtils.repeat((String)" ", (int)pad) + "|%n", new Object[0]);
            InputStream in = null;
            try {
                in = AppUtils.class.getResourceAsStream("/symmetric-console-default.properties");
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            notices = in != null ? notices + String.format("|" + StringUtils.rightPad((String)" Licensed under one or more agreements from JumpMind, Inc.", (int)pad) + "|%n|" + StringUtils.rightPad((String)" See doc/license.html", (int)pad) + "|%n", new Object[0]) : notices + String.format("|" + StringUtils.rightPad((String)" Licensed under the GNU General Public License version 3.", (int)pad) + "|%n|" + StringUtils.rightPad((String)" This software comes with ABSOLUTELY NO WARRANTY.", (int)pad) + "|%n|" + StringUtils.rightPad((String)" See http://www.gnu.org/licenses/gpl.html", (int)pad) + "|%n", new Object[0]);
            notices = notices + "+" + StringUtils.repeat((String)"-", (int)pad) + "+";
            log.info(notices);
            return;
        }
    }
}

