/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.jumpmind.exception.IoException;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.util.PropertiesFactoryBean;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class TypedPropertiesFactory
implements ITypedPropertiesFactory {
    protected File propertiesFile;
    protected Properties properties;

    @Override
    public void init(File propertiesFile, Properties properties) {
        this.propertiesFile = propertiesFile;
        this.properties = properties;
    }

    @Override
    public TypedProperties reload() {
        PropertiesFactoryBean factoryBean = new PropertiesFactoryBean();
        factoryBean.setIgnoreResourceNotFound(true);
        factoryBean.setLocalOverride(true);
        factoryBean.setSingleton(false);
        factoryBean.setProperties(this.properties);
        factoryBean.setLocations(this.buildLocations(this.propertiesFile));
        try {
            TypedProperties properties = new TypedProperties(factoryBean.getObject());
            SymmetricUtils.replaceSystemAndEnvironmentVariables((Properties)properties);
            return properties;
        }
        catch (IOException e) {
            throw new IoException((Exception)e);
        }
    }

    @Override
    public TypedProperties reload(File propFile) {
        TypedProperties typedProperties = new TypedProperties(propFile);
        return typedProperties;
    }

    @Override
    public TypedProperties reload(Properties properties) {
        TypedProperties typedProperties = new TypedProperties(properties);
        return typedProperties;
    }

    @Override
    public void save(Properties props, File propFile, String comments) throws IOException {
        try (FileOutputStream os = new FileOutputStream(propFile);){
            props.store(os, comments);
        }
    }

    protected Resource[] buildLocations(File propertiesFile) {
        ArrayList<Object> resources = new ArrayList<Object>();
        resources.add(new ClassPathResource("/symmetric-default.properties"));
        resources.add(new ClassPathResource("/symmetric-console-default.properties"));
        resources.add(new FileSystemResource(AppUtils.getSymHome() + "/conf/symmetric.properties"));
        resources.add(new ClassPathResource("/symmetric.properties"));
        resources.add(new ClassPathResource("/symmetric-console-default.properties"));
        resources.add(new ClassPathResource("/symmetric-override.properties"));
        if (propertiesFile != null && propertiesFile.exists()) {
            resources.add(new FileSystemResource(propertiesFile.getAbsolutePath()));
        }
        return resources.toArray(new Resource[resources.size()]);
    }
}

