/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.ase.AseDatabasePlatform;
import org.jumpmind.db.platform.db2.Db2DatabasePlatform;
import org.jumpmind.db.platform.derby.DerbyDatabasePlatform;
import org.jumpmind.db.platform.firebird.FirebirdDatabasePlatform;
import org.jumpmind.db.platform.greenplum.GreenplumPlatform;
import org.jumpmind.db.platform.h2.H2DatabasePlatform;
import org.jumpmind.db.platform.hana.HanaDatabasePlatform;
import org.jumpmind.db.platform.hsqldb.HsqlDbDatabasePlatform;
import org.jumpmind.db.platform.hsqldb2.HsqlDb2DatabasePlatform;
import org.jumpmind.db.platform.informix.InformixDatabasePlatform;
import org.jumpmind.db.platform.ingres.IngresDatabasePlatform;
import org.jumpmind.db.platform.interbase.InterbaseDatabasePlatform;
import org.jumpmind.db.platform.mariadb.MariaDBDatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2000DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2005DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2008DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2016DatabasePlatform;
import org.jumpmind.db.platform.mysql.MySqlDatabasePlatform;
import org.jumpmind.db.platform.nuodb.NuoDbDatabasePlatform;
import org.jumpmind.db.platform.oracle.OracleDatabasePlatform;
import org.jumpmind.db.platform.postgresql.PostgreSqlDatabasePlatform;
import org.jumpmind.db.platform.raima.RaimaDatabasePlatform;
import org.jumpmind.db.platform.redshift.RedshiftDatabasePlatform;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhere12DatabasePlatform;
import org.jumpmind.db.platform.sqlanywhere.SqlAnywhereDatabasePlatform;
import org.jumpmind.db.platform.sqlite.SqliteDatabasePlatform;
import org.jumpmind.db.platform.tibero.TiberoDatabasePlatform;
import org.jumpmind.db.platform.voltdb.VoltDbDatabasePlatform;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialectFactory;
import org.jumpmind.symmetric.db.ase.AseSymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2SymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2v9SymmetricDialect;
import org.jumpmind.symmetric.db.derby.DerbySymmetricDialect;
import org.jumpmind.symmetric.db.firebird.Firebird20SymmetricDialect;
import org.jumpmind.symmetric.db.firebird.Firebird21SymmetricDialect;
import org.jumpmind.symmetric.db.firebird.FirebirdSymmetricDialect;
import org.jumpmind.symmetric.db.generic.GenericSymmetricDialect;
import org.jumpmind.symmetric.db.h2.H2SymmetricDialect;
import org.jumpmind.symmetric.db.hana.HanaSymmetricDialect;
import org.jumpmind.symmetric.db.hsqldb.HsqlDbSymmetricDialect;
import org.jumpmind.symmetric.db.hsqldb2.HsqlDb2SymmetricDialect;
import org.jumpmind.symmetric.db.informix.InformixSymmetricDialect;
import org.jumpmind.symmetric.db.ingres.IngresSymmetricDialect;
import org.jumpmind.symmetric.db.interbase.InterbaseSymmetricDialect;
import org.jumpmind.symmetric.db.mariadb.MariaDBSymmetricDialect;
import org.jumpmind.symmetric.db.mssql.MsSql2008SymmetricDialect;
import org.jumpmind.symmetric.db.mssql.MsSql2016SymmetricDialect;
import org.jumpmind.symmetric.db.mssql.MsSqlSymmetricDialect;
import org.jumpmind.symmetric.db.mssql2000.MsSql2000SymmetricDialect;
import org.jumpmind.symmetric.db.mysql.MySqlSymmetricDialect;
import org.jumpmind.symmetric.db.nuodb.NuoDbSymmetricDialect;
import org.jumpmind.symmetric.db.oracle.OracleSymmetricDialect;
import org.jumpmind.symmetric.db.postgresql.GreenplumSymmetricDialect;
import org.jumpmind.symmetric.db.postgresql.PostgreSqlSymmetricDialect;
import org.jumpmind.symmetric.db.raima.RaimaSymmetricDialect;
import org.jumpmind.symmetric.db.redshift.RedshiftSymmetricDialect;
import org.jumpmind.symmetric.db.sqlanywhere.SqlAnywhere12SymmetricDialect;
import org.jumpmind.symmetric.db.sqlanywhere.SqlAnywhereSymmetricDialect;
import org.jumpmind.symmetric.db.sqlite.SqliteJdbcSymmetricDialect;
import org.jumpmind.symmetric.db.tibero.TiberoSymmetricDialect;
import org.jumpmind.symmetric.db.voltdb.VoltDbSymmetricDialect;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.util.AppUtils;

public class JdbcSymmetricDialectFactory
implements ISymmetricDialectFactory {
    protected static ISymmetricDialectFactory instance;

    protected JdbcSymmetricDialectFactory() {
    }

    public static synchronized ISymmetricDialectFactory getInstance() {
        if (instance == null) {
            instance = (ISymmetricDialectFactory)AppUtils.newInstance(ISymmetricDialectFactory.class, JdbcSymmetricDialectFactory.class);
        }
        return instance;
    }

    @Override
    public ISymmetricDialect create(IParameterService parameterService, IDatabasePlatform platform) {
        Object dialect = null;
        if (platform instanceof MariaDBDatabasePlatform) {
            dialect = new MariaDBSymmetricDialect(parameterService, platform);
        } else if (platform instanceof MySqlDatabasePlatform) {
            dialect = new MySqlSymmetricDialect(parameterService, platform);
        } else if (platform instanceof OracleDatabasePlatform) {
            dialect = new OracleSymmetricDialect(parameterService, platform);
        } else if (platform instanceof MsSql2016DatabasePlatform) {
            dialect = new MsSql2016SymmetricDialect(parameterService, platform);
        } else if (platform instanceof MsSql2008DatabasePlatform) {
            dialect = new MsSql2008SymmetricDialect(parameterService, platform);
        } else if (platform instanceof MsSql2005DatabasePlatform) {
            dialect = new MsSqlSymmetricDialect(parameterService, platform);
        } else if (platform instanceof MsSql2000DatabasePlatform) {
            dialect = new MsSql2000SymmetricDialect(parameterService, platform);
        } else if (platform instanceof GreenplumPlatform) {
            dialect = new GreenplumSymmetricDialect(parameterService, platform);
        } else if (platform instanceof RedshiftDatabasePlatform) {
            dialect = new RedshiftSymmetricDialect(parameterService, platform);
        } else if (platform instanceof PostgreSqlDatabasePlatform) {
            dialect = new PostgreSqlSymmetricDialect(parameterService, platform);
        } else if (platform instanceof DerbyDatabasePlatform) {
            dialect = new DerbySymmetricDialect(parameterService, platform);
        } else if (platform instanceof H2DatabasePlatform) {
            dialect = new H2SymmetricDialect(parameterService, platform);
        } else if (platform instanceof HsqlDbDatabasePlatform) {
            dialect = new HsqlDbSymmetricDialect(parameterService, platform);
        } else if (platform instanceof HsqlDb2DatabasePlatform) {
            dialect = new HsqlDb2SymmetricDialect(parameterService, platform);
        } else if (platform instanceof InformixDatabasePlatform) {
            dialect = new InformixSymmetricDialect(parameterService, platform);
        } else if (platform instanceof Db2DatabasePlatform) {
            int dbMajorVersion = platform.getSqlTemplate().getDatabaseMajorVersion();
            int dbMinorVersion = platform.getSqlTemplate().getDatabaseMinorVersion();
            dialect = dbMajorVersion < 9 || dbMajorVersion == 9 && dbMinorVersion < 5 ? new Db2SymmetricDialect(parameterService, platform) : new Db2v9SymmetricDialect(parameterService, platform);
        } else if (platform instanceof FirebirdDatabasePlatform) {
            int dbMajorVersion = platform.getSqlTemplate().getDatabaseMajorVersion();
            int dbMinorVersion = platform.getSqlTemplate().getDatabaseMinorVersion();
            dialect = dbMajorVersion == 2 && dbMinorVersion == 0 ? new Firebird20SymmetricDialect(parameterService, platform) : (dbMajorVersion >= 2 ? new Firebird21SymmetricDialect(parameterService, platform) : new FirebirdSymmetricDialect(parameterService, platform));
        } else {
            dialect = platform instanceof AseDatabasePlatform ? new AseSymmetricDialect(parameterService, platform) : (platform instanceof SqlAnywhere12DatabasePlatform ? new SqlAnywhere12SymmetricDialect(parameterService, platform) : (platform instanceof SqlAnywhereDatabasePlatform ? new SqlAnywhereSymmetricDialect(parameterService, platform) : (platform instanceof InterbaseDatabasePlatform ? new InterbaseSymmetricDialect(parameterService, platform) : (platform instanceof SqliteDatabasePlatform ? new SqliteJdbcSymmetricDialect(parameterService, platform) : (platform instanceof VoltDbDatabasePlatform ? new VoltDbSymmetricDialect(parameterService, platform) : (platform instanceof TiberoDatabasePlatform ? new TiberoSymmetricDialect(parameterService, platform) : (platform instanceof NuoDbDatabasePlatform ? new NuoDbSymmetricDialect(parameterService, platform) : (platform instanceof RaimaDatabasePlatform ? new RaimaSymmetricDialect(parameterService, platform) : (platform instanceof HanaDatabasePlatform ? new HanaSymmetricDialect(parameterService, platform) : (platform instanceof IngresDatabasePlatform ? new IngresSymmetricDialect(parameterService, platform) : new GenericSymmetricDialect(parameterService, platform)))))))))));
        }
        return dialect;
    }
}

