/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.db2;

import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.db2.Db2As400TriggerTemplate;
import org.jumpmind.symmetric.db.db2.Db2SymmetricDialect;
import org.jumpmind.symmetric.service.IParameterService;

public class Db2As400SymmetricDialect
extends Db2SymmetricDialect
implements ISymmetricDialect {
    boolean supportsGlobalVariables = false;

    public Db2As400SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new Db2As400TriggerTemplate(this);
        this.supportsGlobalVariables = platform.getSqlTemplate().getDatabaseMajorVersion() >= 7;
    }

    @Override
    protected boolean doesTriggerExistOnPlatform(String catalog, String schema, String tableName, String triggerName) {
        if (schema == null) {
            schema = this.platform.getDefaultSchema();
        }
        if (schema != null) {
            schema = schema.toUpperCase();
        }
        triggerName = triggerName == null ? null : triggerName.toUpperCase();
        return this.platform.getSqlTemplate().queryForInt("SELECT COUNT(*) FROM " + this.getSystemSchemaName() + ".SYSTRIGGERS WHERE TRIGNAME = ? AND TRIGSCHEMA = ?", new Object[]{triggerName, schema}) > 0;
    }

    @Override
    public void enableSyncTriggers(ISqlTransaction transaction) {
        if (this.supportsGlobalVariables) {
            super.enableSyncTriggers(transaction);
        }
    }

    @Override
    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        if (this.supportsGlobalVariables) {
            super.disableSyncTriggers(transaction, nodeId);
        }
    }

    @Override
    public String getSyncTriggersExpression() {
        return this.supportsGlobalVariables ? super.getSyncTriggersExpression() : "1=1";
    }

    @Override
    public String getSourceNodeExpression() {
        return this.supportsGlobalVariables ? super.getSourceNodeExpression() : "null";
    }

    @Override
    public void createRequiredDatabaseObjects() {
        if (this.supportsGlobalVariables) {
            super.createRequiredDatabaseObjects();
        }
    }

    @Override
    protected String getSystemSchemaName() {
        return "QSYS2";
    }

    @Override
    public String getDatabaseTimeSQL() {
        return "select current_timestamp from sysibm.sysdummy1";
    }
}

