/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.derby;

import java.util.ArrayList;
import java.util.HashMap;
import org.jumpmind.db.model.Column;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;

public class DerbyTriggerTemplate
extends AbstractTriggerTemplate {
    public DerbyTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "sym_escape($(tableAlias).\"$(columnName)\")";
        this.xmlColumnTemplate = null;
        this.arrayColumnTemplate = null;
        this.numberColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || rtrim(char($(tableAlias).\"$(columnName)\")) || '\"' end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' || rtrim(char($(tableAlias).\"$(columnName)\")) || '\"' end";
        this.timeColumnTemplate = null;
        this.dateColumnTemplate = null;
        this.clobColumnTemplate = "sym_clob_to_string('\"$(columnName)\"', '$(schemaName)$(tableName)', $(primaryKeyWhereString) )";
        this.blobColumnTemplate = "sym_blob_to_string('\"$(columnName)\"', '$(schemaName)$(tableName)', $(primaryKeyWhereString) )";
        this.wrappedBlobColumnTemplate = null;
        this.booleanColumnTemplate = null;
        this.triggerConcatCharacter = "||";
        this.newTriggerValue = "new";
        this.oldTriggerValue = "old";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.otherColumnTemplate = null;
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "CREATE TRIGGER $(triggerName)                                            \n AFTER INSERT ON $(schemaName)$(tableName)                               \n REFERENCING NEW AS NEW                                                  \n FOR EACH ROW MODE DB2SQL                                                \n call $(prefixName)_save_data(                                                   \n   case when $(syncOnInsertCondition) and $(syncOnIncomingBatchCondition) then 1 else 0 end, \n   '$(defaultSchema)', '$(prefixName)', '$(targetTableName)',                      \n   $(channelExpression), 'I', $(triggerHistoryId),                           \n   $(txIdExpression),                                                    \n   $(externalSelect),                                                    \n   '$(columnNames)',                                                       \n   '$(pkColumnNames)')                                                     \n");
        this.sqlTemplates.put("updateTriggerTemplate", "CREATE TRIGGER $(triggerName)                                            \n AFTER UPDATE ON $(schemaName)$(tableName)                               \n REFERENCING OLD AS OLD NEW AS NEW                                       \n FOR EACH ROW MODE DB2SQL                                                \n call $(prefixName)_save_data(                                                   \n   case when $(syncOnUpdateCondition) and $(syncOnIncomingBatchCondition) then 1 else 0 end, \n   '$(defaultSchema)', '$(prefixName)', '$(targetTableName)',                      \n   $(channelExpression), 'U', $(triggerHistoryId),                           \n   $(txIdExpression),                                                    \n   $(externalSelect),                                                    \n   '$(columnNames)',                                                       \n   '$(pkColumnNames)')                                                     \n");
        this.sqlTemplates.put("deleteTriggerTemplate", "CREATE TRIGGER $(triggerName)                                            \n AFTER DELETE ON $(schemaName)$(tableName)                               \n REFERENCING OLD AS OLD                                                  \n FOR EACH ROW MODE DB2SQL                                                \n call $(prefixName)_save_data(                                                   \n   case when $(syncOnDeleteCondition) and $(syncOnIncomingBatchCondition) then 1 else 0 end, \n   '$(defaultSchema)', '$(prefixName)', '$(targetTableName)',                      \n   $(channelExpression), 'D', $(triggerHistoryId),                           \n   $(txIdExpression),                                                    \n   $(externalSelect),                                                    \n   '$(columnNames)',                                                       \n   '$(pkColumnNames)')                                                     \n");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t  where $(whereClause)     ");
    }

    protected String getPrimaryKeyWhereString(String alias, Column[] columns) {
        ArrayList<Column> columnsMinusLobs = new ArrayList<Column>();
        for (Column column : columns) {
            if (column.isOfBinaryType()) continue;
            columnsMinusLobs.add(column);
        }
        StringBuilder b = new StringBuilder("'");
        for (Column column : columnsMinusLobs) {
            b.append("\"").append(column.getName()).append("\"=");
            switch (column.getMappedTypeCode()) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    b.append("'").append(this.triggerConcatCharacter);
                    b.append("rtrim(char(").append(alias).append(".\"").append(column.getName()).append("\"))");
                    b.append(this.triggerConcatCharacter).append("'");
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    b.append("'''").append(this.triggerConcatCharacter);
                    b.append(alias).append(".\"").append(column.getName()).append("\"");
                    b.append(this.triggerConcatCharacter).append("'''");
                    break;
                }
                case 91: 
                case 93: {
                    b.append("{ts '''").append(this.triggerConcatCharacter);
                    b.append("rtrim(char(").append(alias).append(".\"").append(column.getName()).append("\"))");
                    b.append(this.triggerConcatCharacter).append("'''}");
                }
            }
            if (column.equals(columnsMinusLobs.get(columnsMinusLobs.size() - 1))) continue;
            b.append(" and ");
        }
        b.append("'");
        return b.toString();
    }
}

