/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.firebird;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.SequenceIdentifier;
import org.jumpmind.symmetric.db.firebird.FirebirdTriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;
import org.springframework.jdbc.UncategorizedSQLException;

public class FirebirdSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "DROP EXTERNAL FUNCTION $(functionName)";
    static final String SQL_FUNCTION_INSTALLED = "select count(*) from rdb$functions where rdb$function_name = upper('$(functionName)')";
    static final String SYNC_TRIGGERS_DISABLED_USER_VARIABLE = "sync_triggers_disabled";
    static final String SYNC_TRIGGERS_DISABLED_NODE_VARIABLE = "sync_node_disabled";

    public FirebirdSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new FirebirdTriggerTemplate(this);
    }

    public void createRequiredDatabaseObjects() {
        String hex;
        String escape = this.parameterService.getTablePrefix() + "_escape";
        if (!this.installed(SQL_FUNCTION_INSTALLED, escape)) {
            String sql = "declare external function $(functionName) cstring(32660)                                                                                                                                                 returns cstring(32660) free_it entry_point 'sym_escape' module_name 'sym_udf'                                                                                          ";
            this.install(sql, escape);
        }
        if (!this.installed(SQL_FUNCTION_INSTALLED, hex = this.parameterService.getTablePrefix() + "_hex")) {
            String sql = "declare external function $(functionName) blob                                                                                                                                                           returns cstring(32660) free_it entry_point 'sym_hex' module_name 'sym_udf'                                                                                             ";
            this.install(sql, hex);
        }
        try {
            this.platform.getSqlTemplate().queryForInt("select char_length(" + escape + "('')) from rdb$database", new Object[0]);
        }
        catch (UncategorizedSQLException e) {
            if (e.getSQLException().getErrorCode() == -804) {
                this.log.error("Please install the sym_udf.so/dll to your {firebird_home}/UDF folder");
            }
            throw new RuntimeException("Function " + escape + " is not installed", e);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String hex;
        String escape = this.parameterService.getTablePrefix() + "_escape";
        if (this.installed(SQL_FUNCTION_INSTALLED, escape)) {
            this.uninstall(SQL_DROP_FUNCTION, escape);
        }
        if (this.installed(SQL_FUNCTION_INSTALLED, hex = this.parameterService.getTablePrefix() + "_hex")) {
            this.uninstall(SQL_DROP_FUNCTION, hex);
        }
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schema, String tableName, String triggerName) {
        return this.platform.getSqlTemplate().queryForInt("select count(*) from rdb$triggers where rdb$trigger_name = ?", new Object[]{triggerName.toUpperCase()}) > 0;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
    }

    public String getSyncTriggersExpression() {
        return "1=1";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "current_transaction||''";
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.HEX;
    }

    public void cleanDatabase() {
    }

    public String getName() {
        return StringUtils.left((String)super.getName(), (int)50);
    }

    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public void truncateTable(String tableName) {
        this.platform.getSqlTemplate().update("delete from " + tableName, new Object[0]);
    }

    public void cleanupTriggers() {
        List names = this.platform.getSqlTemplate().query("select rdb$trigger_name from rdb$triggers where rdb$trigger_name like '" + this.parameterService.getTablePrefix().toUpperCase() + "_%'", (ISqlRowMapper)new StringMapper(), new Object[0]);
        int count = 0;
        for (String name : names) {
            count += this.platform.getSqlTemplate().update("drop trigger " + name, new Object[0]);
        }
        if (count > 0) {
            this.log.info("Remove {} triggers", (Object)count);
        }
    }

    public String massageDataExtractionSql(String sql, boolean isContainsBigLob) {
        if (!isContainsBigLob) {
            String[] sizes = this.parameterService.getString("firebird.extract.varchar.row.old.pk.data", "20000,20000,1000").split(",");
            sql = StringUtils.replace((String)sql, (String)"d.row_data", (String)("cast(d.row_data as varchar(" + sizes[0] + "))"));
            sql = StringUtils.replace((String)sql, (String)"d.old_data", (String)("cast(d.old_data as varchar(" + sizes[1] + "))"));
            sql = StringUtils.replace((String)sql, (String)"d.pk_data", (String)("cast(d.pk_data as varchar(" + sizes[2] + "))"));
        }
        return sql;
    }

    public long getCurrentSequenceValue(SequenceIdentifier identifier) {
        return this.platform.getSqlTemplate().queryForLong("select gen_id(GEN_" + this.getSequenceName(identifier) + ", 0) from rdb$database", new Object[0]);
    }

    public String getDatabaseTimeSQL() {
        return "select current_timestamp from rdb$database";
    }
}

