/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.h2;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.h2.H2DdlBuilder;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTransaction;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.db.AbstractEmbeddedSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.db.h2.H2TriggerTemplate;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.service.IParameterService;

public class H2SymmetricDialect
extends AbstractEmbeddedSymmetricDialect
implements ISymmetricDialect {
    static final String SQL_DROP_FUNCTION = "DROP ALIAS $(functionName)";
    static String SQL_FUNCTION_INSTALLED;

    public H2SymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
        this.triggerTemplate = new H2TriggerTemplate(this);
        if (!Version.isOlderThanVersion((String)this.getProductVersion(), (String)"2.0.202")) {
            SQL_FUNCTION_INSTALLED = "select count(*) from INFORMATION_SCHEMA.ROUTINES where ROUTINE_NAME='$(functionName)'";
            platform.getDatabaseInfo().addNativeTypeMapping(-1, "VARCHAR(1000000000)", 12);
            platform.getDatabaseInfo().setDefaultSize(1, 1000000000);
            platform.getDatabaseInfo().setMaxSize("CHAR", 1000000000);
            platform.getDatabaseInfo().setDefaultSize(12, 1000000000);
            platform.getDatabaseInfo().setMaxSize("VARCHAR", 1000000000);
            platform.getDatabaseInfo().setDefaultSize(-2, 1000000000);
            platform.getDatabaseInfo().setMaxSize("BINARY", 1000000000);
            platform.getDatabaseInfo().setDefaultSize(-3, 1000000000);
            platform.getDatabaseInfo().setMaxSize("VARBINARY", 1000000000);
            platform.getDatabaseInfo().setNonBlankCharColumnSpacePadded(true);
            platform.getDatabaseInfo().setBlankCharColumnSpacePadded(true);
            platform.getDatabaseInfo().setCharColumnSpaceTrimmed(false);
            ((H2DdlBuilder)platform.getDdlBuilder()).setVersion2(true);
        } else {
            SQL_FUNCTION_INSTALLED = "select count(*) from INFORMATION_SCHEMA.FUNCTION_ALIASES where ALIAS_NAME='$(functionName)'";
        }
    }

    protected boolean doesTriggerExistOnPlatform(String catalogName, String schemaName, String tableName, String triggerName) {
        boolean exists;
        boolean bl = exists = this.platform.getSqlTemplate().queryForInt("select count(*) from INFORMATION_SCHEMA.TRIGGERS WHERE TRIGGER_NAME = ? and (TRIGGER_CATALOG=? or ? is null) and (TRIGGER_SCHEMA=? or ? is null)", new Object[]{triggerName, catalogName, catalogName, schemaName, schemaName}) > 0 && this.platform.getSqlTemplate().queryForInt("select count(*) from INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = ? and (TABLE_CATALOG=? or ? is null) and (TABLE_SCHEMA=? or ? is null)", new Object[]{String.format("%s_CONFIG", triggerName), catalogName, catalogName, schemaName, schemaName}) > 0;
        if (!exists && !StringUtils.isBlank((CharSequence)triggerName)) {
            this.removeTrigger(new StringBuilder(), catalogName, schemaName, triggerName, tableName);
        }
        return exists;
    }

    public void removeTrigger(StringBuilder sqlBuffer, String catalogName, String schemaName, String triggerName, String tableName, ISqlTransaction transaction) {
        DatabaseInfo dbInfo = this.getPlatform().getDatabaseInfo();
        String prefix = Table.getFullyQualifiedTablePrefix((String)catalogName, (String)schemaName, (String)dbInfo.getDelimiterToken(), (String)dbInfo.getCatalogSeparator(), (String)dbInfo.getSchemaSeparator());
        String dropSql = String.format("DROP TRIGGER IF EXISTS %s%s", prefix, triggerName);
        this.logSql(dropSql, sqlBuffer);
        String dropTable = String.format("DROP TABLE IF EXISTS %s%s_CONFIG", prefix, triggerName);
        this.logSql(dropTable, sqlBuffer);
        if (this.parameterService.is("auto.sync.triggers")) {
            this.log.info("Dropping trigger {} for {}", (Object)triggerName, (Object)Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName));
            transaction.execute(dropSql);
            transaction.execute(dropTable);
        }
    }

    public void createRequiredDatabaseObjects() {
        String encode = this.parameterService.getTablePrefix().toUpperCase() + "_BASE64_ENCODE";
        if (!this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            String sql = "CREATE ALIAS IF NOT EXISTS $(functionName) for \"org.jumpmind.symmetric.db.EmbeddedDbFunctions.encodeBase64\"; ";
            this.install(sql, encode);
        }
    }

    public void dropRequiredDatabaseObjects() {
        String encode = this.parameterService.getTablePrefix().toUpperCase() + "_BASE64_ENCODE";
        if (this.installed(SQL_FUNCTION_INSTALLED, encode)) {
            this.uninstall(SQL_DROP_FUNCTION, encode);
        }
    }

    public boolean isBlobSyncSupported() {
        return true;
    }

    public boolean isClobSyncSupported() {
        return true;
    }

    public void disableSyncTriggers(ISqlTransaction transaction, String nodeId) {
        transaction.prepareAndExecute("set @sync_prevented=1", new Object[0]);
        transaction.prepareAndExecute("set @node_value=?", new Object[]{nodeId});
    }

    public void enableSyncTriggers(ISqlTransaction transaction) {
        transaction.prepareAndExecute("set @sync_prevented=null", new Object[0]);
        transaction.prepareAndExecute("set @node_value=null", new Object[0]);
    }

    public String getSyncTriggersExpression() {
        return " @sync_prevented is null ";
    }

    public String getTransactionTriggerExpression(String defaultCatalog, String defaultSchema, Trigger trigger) {
        return "TRANSACTION_ID()";
    }

    public BinaryEncoding getBinaryEncoding() {
        return BinaryEncoding.BASE64;
    }

    public boolean supportsTransactionId() {
        return true;
    }

    public void cleanupTriggers() {
        List names = this.platform.getSqlTemplate().query("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA() AND TABLE_NAME LIKE '" + this.parameterService.getTablePrefix().toUpperCase() + "_%_CONFIG'", (ISqlRowMapper)new StringMapper(), new Object[0]);
        for (String name : names) {
            this.platform.getSqlTemplate().update("drop table " + name, new Object[0]);
            this.log.info("Dropped table {}", (Object)name);
        }
    }
}

