/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db.sqlanywhere;

import java.util.HashMap;
import org.apache.commons.lang3.NotImplementedException;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.util.FormatUtils;

public class SqlAnywhereTriggerTemplate
extends AbstractTriggerTemplate {
    public SqlAnywhereTriggerTemplate(ISymmetricDialect symmetricDialect) {
        super(symmetricDialect);
        this.emptyColumnTemplate = "''";
        this.stringColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace($(tableAlias).\"$(columnName)\",'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.numberColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else ('\"' + cast($(tableAlias).\"$(columnName)\" as varchar) + '\"') end";
        this.datetimeColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else ('\"' + replace(convert(varchar,$(tableAlias).\"$(columnName)\",21),'T',' ') + '\"') end";
        this.clobColumnTemplate = "case when $(origTableAlias).\"$(columnName)\" is null then '' else '\"' + replace(replace(cast($(origTableAlias).\"$(columnName)\" as varchar(16384)),'\\','\\\\'),'\"','\\\"') + '\"' end";
        this.blobColumnTemplate = "case when $(origTableAlias).\"$(columnName)\" is null then '' else '\"' + base64_encode($(origTableAlias).\"$(columnName)\") + '\"' end";
        this.binaryColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' else '\"' + base64_encode($(tableAlias).\"$(columnName)\") + '\"' end";
        this.booleanColumnTemplate = "case when $(tableAlias).\"$(columnName)\" is null then '' when $(tableAlias).\"$(columnName)\" = 1 then '\"1\"' else '\"0\"' end";
        this.triggerConcatCharacter = "+";
        this.newTriggerValue = "inserted";
        this.oldTriggerValue = "deleted";
        this.oldColumnPrefix = "";
        this.newColumnPrefix = "";
        this.sqlTemplates = new HashMap();
        this.sqlTemplates.put("insertTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for insert as                                                                                                                                                               begin                                                                                                                                                                                                    declare @DataRow varchar(16384)                                                                                                                                                                        $(declareNewKeyVariables)                                                                                                                                                                              declare @ChannelId varchar(128)                                                                                                                                                                        $(custom_before_insert_text) \n                                  if ($(syncOnIncomingBatchCondition)) begin                                                                                                                                                               declare DataCursor cursor for                                                                                                                                                                          $(if:containsBlobClobColumns)                                                                                                                                                                             select $(columns) $(newKeyNames), $(channelExpression) from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) where $(syncOnInsertCondition)                                    $(else:containsBlobClobColumns)                                                                                                                                                                           select $(columns) $(newKeyNames), $(channelExpression) from inserted where $(syncOnInsertCondition)                                                                                                                      $(end:containsBlobClobColumns)                                                                                                                                                                            open DataCursor                                                                                                                                                                                        fetch next DataCursor into @DataRow $(newKeyVariables), @ChannelId                                                                                                                                          while @@FETCH_STATUS = 0 begin                                                                                                                                                                             insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                              values('$(targetTableName)','I', $(triggerHistoryId), @DataRow, @ChannelId, $(txIdExpression), $(defaultCatalog)$(defaultSchema)$(prefixName)_node_disabled(0), $(externalSelect), getdate())                                                                              fetch next DataCursor into @DataRow $(newKeyVariables), @ChannelId                                                                                                                                        end                                                                                                                                                                                                    close DataCursor                                                                                                                                                                                       deallocate DataCursor                                                                                                                                                                             end                                                                                                                                                                                                    $(custom_on_insert_text)                                                                                                                                                                             end                                                                                                                                                                    ");
        this.sqlTemplates.put("updateTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for update as                                                                                                                                                               begin                                                                                                                                                                                                    declare @DataRow varchar(16384)                                                                                                                                                                        declare @OldPk varchar(2000)                                                                                                                                                                           declare @OldDataRow varchar(16384)                                                                                                                                                                     declare @ChannelId varchar(128)                                                                                                                                                                        $(declareOldKeyVariables)                                                                                                                                                                              $(declareNewKeyVariables)                                                                                                                                                                              $(custom_before_update_text) \n                                  if ($(syncOnIncomingBatchCondition)) begin                                                                                                                                                               declare DataCursor cursor for                                                                                                                                                                          $(if:containsBlobClobColumns)                                                                                                                                                                             select $(columns), $(oldKeys), $(oldColumns) $(oldKeyNames) $(newKeyNames), $(channelExpression) from inserted inner join $(schemaName)$(tableName) $(origTableAlias) on $(tableNewPrimaryKeyJoin) inner join deleted on $(oldNewPrimaryKeyJoin) where $(syncOnUpdateCondition)                                    $(else:containsBlobClobColumns)                                                                                                                                                                           select $(columns), $(oldKeys), $(oldColumns) $(oldKeyNames) $(newKeyNames), $(channelExpression) from inserted inner join deleted on $(oldNewPrimaryKeyJoin) where $(syncOnUpdateCondition)                                                                        $(end:containsBlobClobColumns)                                                                                                                                                                            open DataCursor                                                                                                                                                                                        fetch next DataCursor into @DataRow, @OldPk, @OldDataRow $(oldKeyVariables) $(newKeyVariables), @ChannelId                                                                                             while @@FETCH_STATUS = 0 begin                                                                                                                                                                           insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, row_data, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                            values('$(targetTableName)','U', $(triggerHistoryId), @DataRow, @OldPk, @OldDataRow, @ChannelId, $(txIdExpression), $(defaultCatalog)$(defaultSchema)$(prefixName)_node_disabled(0), $(externalSelect), getdate())                                         fetch next DataCursor into @DataRow, @OldPk, @OldDataRow $(oldKeyVariables) $(newKeyVariables), @ChannelId                                                                                           end                                                                                                                                                                                                    close DataCursor                                                                                                                                                                                       deallocate DataCursor                                                                                                                                                                               end                                                                                                                                                                                                  $(custom_on_update_text)                                                                                                                                                                               end                                                                                                                                                                  ");
        this.sqlTemplates.put("deleteTriggerTemplate", "create trigger $(triggerName) on $(schemaName)$(tableName) for delete as                                                                                                                                                               begin                                                                                                                                                                                                    declare @OldPk varchar(2000)                                                                                                                                                                           declare @OldDataRow varchar(16384)                                                                                                                                                                     declare @ChannelId varchar(128)                                                                                                                                                                        $(declareOldKeyVariables)                                                                                                                                                                              $(custom_before_delete_text) \n                                  if ($(syncOnIncomingBatchCondition)) begin                                                                                                                                                               declare DataCursor cursor for                                                                                                                                                                            select $(oldKeys), $(oldColumns) $(oldKeyNames), $(channelExpression) from deleted where $(syncOnDeleteCondition)                                                                                                            open DataCursor                                                                                                                                                                                         fetch next DataCursor into @OldPk, @OldDataRow $(oldKeyVariables), @ChannelId                                                                                                                          while @@FETCH_STATUS = 0 begin                                                                                                                                                                           insert into $(defaultCatalog)$(defaultSchema)$(prefixName)_data (table_name, event_type, trigger_hist_id, pk_data, old_data, channel_id, transaction_id, source_node_id, external_data, create_time)                                            values('$(targetTableName)','D', $(triggerHistoryId), @OldPk, @OldDataRow, @ChannelId, $(txIdExpression), $(defaultCatalog)$(defaultSchema)$(prefixName)_node_disabled(0), $(externalSelect), getdate())                                         fetch next DataCursor into @OldPk,@OldDataRow $(oldKeyVariables), @ChannelId                                                                                                                         end                                                                                                                                                                                                    close DataCursor                                                                                                                                                                                       deallocate DataCursor                                                                                                                                                                             end                                                                                                                                                                                                    $(custom_on_delete_text)                                                                                                                                                                             end                                                                                                                                                                    ");
        this.sqlTemplates.put("initialLoadSqlTemplate", "select $(columns) from $(schemaName)$(tableName) t where $(whereClause)                                                                                                                                ");
    }

    protected String replaceTemplateVariables(DataEventType dml, Trigger trigger, TriggerHistory history, Channel channel, String tablePrefix, Table originalTable, Table table, String defaultCatalog, String defaultSchema, String ddl) {
        ddl = super.replaceTemplateVariables(dml, trigger, history, channel, tablePrefix, originalTable, table, defaultCatalog, defaultSchema, ddl);
        Column[] columns = table.getPrimaryKeyColumns();
        ddl = FormatUtils.replace((String)"declareOldKeyVariables", (String)this.buildKeyVariablesDeclare(columns, "old"), (String)ddl);
        ddl = FormatUtils.replace((String)"declareNewKeyVariables", (String)this.buildKeyVariablesDeclare(columns, "new"), (String)ddl);
        return ddl;
    }

    protected String buildKeyVariablesDeclare(Column[] columns, String prefix) {
        String text = "";
        for (int i = 0; i < columns.length; ++i) {
            text = text + "declare @" + prefix + "pk" + i + " ";
            switch (columns[i].getMappedTypeCode()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    text = text + "bigint\n";
                    break;
                }
                case 2: 
                case 3: {
                    text = text + "decimal\n";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    text = text + "float\n";
                    break;
                }
                case -16: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    text = text + "varchar(1000)\n";
                    break;
                }
                case 91: {
                    text = text + "date\n";
                    break;
                }
                case 92: {
                    text = text + "time\n";
                    break;
                }
                case 93: {
                    text = text + "datetime\n";
                    break;
                }
                case -7: 
                case 16: {
                    text = text + "bit\n";
                    break;
                }
                case 2005: {
                    text = text + "varchar(16384)\n";
                    break;
                }
                case -10: 
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    text = text + "varbinary(16384)\n";
                    break;
                }
                case 1111: {
                    text = text + "varbinary(16384)\n";
                    break;
                }
                default: {
                    if (columns[i].getJdbcTypeName() != null && columns[i].getJdbcTypeName().equalsIgnoreCase("interval")) {
                        text = text + "interval";
                        break;
                    }
                    throw new NotImplementedException(columns[i] + " is of type " + columns[i].getMappedType());
                }
            }
            text = text + this.appendSemicolonAfterDeclare();
        }
        return text;
    }

    protected String appendSemicolonAfterDeclare() {
        return "";
    }

    protected boolean useTriggerTemplateForColumnTemplatesDuringInitialLoad(Column column) {
        boolean result = super.useTriggerTemplateForColumnTemplatesDuringInitialLoad(column);
        if (column != null && column.getJdbcTypeName() != null && column.getJdbcTypeName().toUpperCase().contains("VARBIT")) {
            result = true;
        }
        return result;
    }
}

