/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.job.AbstractJob;
import org.jumpmind.symmetric.job.BuiltInJobs;
import org.jumpmind.symmetric.job.IJob;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.job.JobCreator;
import org.jumpmind.symmetric.job.JobManagerSqlMap;
import org.jumpmind.symmetric.job.JobMapper;
import org.jumpmind.symmetric.model.JobDefinition;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ISqlMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public class JobManager
extends AbstractService
implements IJobManager {
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private List<IJob> jobs;
    private ThreadPoolTaskScheduler taskScheduler;
    private ISymmetricEngine engine;
    private JobCreator jobCreator = new JobCreator();
    private boolean started = false;

    public JobManager(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.taskScheduler = new ThreadPoolTaskScheduler();
        this.setSqlMap((ISqlMap)new JobManagerSqlMap(engine.getSymmetricDialect().getPlatform(), this.createSqlReplacementTokens()));
        this.taskScheduler.setThreadNamePrefix(String.format("%s-job-", engine.getParameterService().getEngineName()));
        this.taskScheduler.setPoolSize(20);
        this.taskScheduler.initialize();
    }

    public void init() {
        this.stopJobs();
        List<JobDefinition> jobDefinitions = this.getCustomJobDefinitions();
        BuiltInJobs builtInJobs = new BuiltInJobs();
        jobDefinitions = builtInJobs.syncBuiltInJobs(jobDefinitions, this.engine, this.taskScheduler);
        this.jobs = new ArrayList<IJob>();
        for (JobDefinition jobDefinition : jobDefinitions) {
            IJob job = this.jobCreator.createJob(jobDefinition, this.engine, this.taskScheduler);
            if (job != null) {
                this.jobs.add(job);
            }
            if (!jobDefinition.isClustered()) continue;
            this.engine.getClusterService().addLock(jobDefinition.getJobName(), "CLUSTER");
        }
    }

    public List<JobDefinition> getCustomJobDefinitions() {
        return this.sqlTemplate.query(this.getSql(new String[]{"loadCustomJobs"}), (ISqlRowMapper)new JobMapper(), new Object[0]);
    }

    public boolean isStarted() {
        return this.started;
    }

    public IJob getJob(String name) {
        for (IJob job : this.jobs) {
            if (!job.getName().equalsIgnoreCase(name)) continue;
            return job;
        }
        return null;
    }

    public synchronized void startJobs() {
        for (IJob job : this.jobs) {
            if (this.isAutoStartConfigured(job) && this.isJobApplicableToNodeGroup(job)) {
                job.start();
                continue;
            }
            log.info("Job {} not configured for auto start", (Object)job.getName());
        }
        this.started = true;
    }

    public boolean isJobApplicableToNodeGroup(IJob job) {
        String nodeGroupId = job.getJobDefinition().getNodeGroupId();
        if (StringUtils.isEmpty((CharSequence)nodeGroupId) || nodeGroupId.equals("ALL")) {
            return true;
        }
        return this.engine.getParameterService().getNodeGroupId().equals(nodeGroupId);
    }

    protected boolean isAutoStartConfigured(IJob job) {
        String autoStartValue = null;
        if (job.getDeprecatedStartParameter() != null) {
            autoStartValue = this.engine.getParameterService().getString(job.getDeprecatedStartParameter());
        }
        if (StringUtils.isEmpty(autoStartValue) && StringUtils.isEmpty((CharSequence)(autoStartValue = this.engine.getParameterService().getString(job.getJobDefinition().getStartParameter())))) {
            autoStartValue = String.valueOf(job.getJobDefinition().isDefaultAutomaticStartup());
        }
        return "1".equals(autoStartValue) || Boolean.parseBoolean(autoStartValue);
    }

    public synchronized void stopJobs() {
        if (this.jobs != null) {
            for (IJob job : this.jobs) {
                job.stop();
            }
            Thread.interrupted();
            this.started = false;
        }
    }

    public synchronized void destroy() {
        this.stopJobs();
        if (this.taskScheduler != null) {
            this.taskScheduler.shutdown();
        }
    }

    public List<IJob> getJobs() {
        List<IJob> sortedJobs = this.sortJobs(this.jobs);
        return sortedJobs;
    }

    protected List<IJob> sortJobs(List<IJob> jobs) {
        ArrayList<IJob> jobsSorted = new ArrayList<IJob>();
        if (jobs != null) {
            jobsSorted.addAll(jobs);
            Collections.sort(jobsSorted, new Comparator<IJob>(){

                @Override
                public int compare(IJob job1, IJob job2) {
                    Integer job2Started;
                    Integer job1Started = job1.isStarted() ? 1 : 0;
                    if (job1Started.equals(job2Started = Integer.valueOf(job2.isStarted() ? 1 : 0))) {
                        return -job1.getJobDefinition().getJobType().compareTo((Enum)job2.getJobDefinition().getJobType());
                    }
                    return -job1Started.compareTo(job2Started);
                }
            });
        }
        return jobsSorted;
    }

    public void restartJobs() {
        this.init();
        this.startJobs();
    }

    public void restartJob(String name) {
        IJob job = this.getJob(name);
        if (job != null) {
            job.stop();
            if (job instanceof AbstractJob) {
                job.getJobDefinition().setDefaultAutomaticStartup(((AbstractJob)job).getDefaults().isEnabled());
            }
            if (this.isAutoStartConfigured(job) && this.isJobApplicableToNodeGroup(job)) {
                job.start();
            }
        }
    }

    public void saveJob(JobDefinition job) {
        if (this.sqlTemplate.update(this.getSql(new String[]{"updateJobSql"}), new Object[]{job.getDescription(), job.getJobType().toString(), job.getJobExpression(), job.isDefaultAutomaticStartup() ? 1 : 0, job.getDefaultSchedule(), job.getNodeGroupId(), job.isClustered() ? 1 : 0, job.getCreateBy(), job.getLastUpdateBy(), new Date(), job.getJobName()}) <= 0) {
            this.sqlTemplate.update(this.getSql(new String[]{"insertJobSql"}), new Object[]{job.getDescription(), job.getJobType().toString(), job.getJobExpression(), job.isDefaultAutomaticStartup() ? 1 : 0, job.getDefaultSchedule(), job.getNodeGroupId(), job.isClustered() ? 1 : 0, job.getCreateBy(), new Date(), job.getLastUpdateBy(), new Date(), job.getJobName()});
        }
        if (job.isClustered()) {
            this.engine.getClusterService().addLock(job.getJobName(), "CLUSTER");
        }
    }

    public void saveJobAsCopy(JobDefinition job) {
        String newName = job.getJobName();
        List names = this.jobs.stream().map(IJob::getName).collect(Collectors.toList());
        String suffix = "";
        int i = 2;
        while (names.contains(newName + suffix)) {
            suffix = "_" + i;
            ++i;
        }
        job.setJobName(newName + suffix);
        this.saveJob(job);
    }

    public void renameJob(String oldName, JobDefinition job) {
        this.removeJob(oldName);
        this.saveJob(job);
    }

    public void removeJob(String name) {
        Object[] args = new Object[]{name};
        if (this.sqlTemplate.update(this.getSql(new String[]{"deleteJobSql"}), args) != 1) {
            throw new SymmetricException("Failed to remove job " + name + ".  Note that BUILT_IN jobs cannot be removed.", new Object[0]);
        }
        for (IJob job : this.jobs) {
            if (!name.equals(job.getName()) || !job.getJobDefinition().isClustered()) continue;
            this.engine.getClusterService().removeLock(job.getName());
        }
    }

    public void removeAllJobs() {
        this.sqlTemplate.update(this.getSql(new String[]{"deleteAllJobsSql"}), new Object[0]);
    }
}

