/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.exception.IoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppUtils {
    public static final String SYSPROP_HOST_NAME = "host.name";
    public static final String SYSPROP_PORT_NUMBER = "port.number";
    public static final String SYSPROP_IP_ADDRESS = "ip.address";
    private static String UNKNOWN = "unknown";
    private static Logger log = LoggerFactory.getLogger(AppUtils.class);
    private static FastDateFormat timezoneFormatter = FastDateFormat.getInstance((String)"Z");
    private static Properties implProp = new Properties();

    private static void loadProperties(Properties prop, String resourceName) {
        URL url = ClassLoader.getSystemResource(resourceName);
        if (url != null) {
            try (InputStream fis = url.openStream();){
                prop.load(fis);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getSymHome() {
        String home = System.getenv("SYM_HOME");
        if (home == null) {
            home = ".";
        }
        return home;
    }

    public static String getCanonicalSymHome(String dirName) {
        if (!dirName.startsWith("/") && !dirName.startsWith("\\")) {
            dirName = AppUtils.getSymHome() + "/" + dirName;
        }
        return dirName;
    }

    public static String getHostName() {
        String hostName = System.getProperty(SYSPROP_HOST_NAME, UNKNOWN);
        if (UNKNOWN.equals(hostName)) {
            try {
                hostName = System.getenv("HOSTNAME");
                if (StringUtils.isBlank((CharSequence)hostName)) {
                    hostName = System.getenv("COMPUTERNAME");
                }
                if (StringUtils.isBlank((CharSequence)hostName)) {
                    try {
                        hostName = IOUtils.toString((InputStream)Runtime.getRuntime().exec("hostname").getInputStream(), (Charset)Charset.defaultCharset());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (StringUtils.isBlank((CharSequence)hostName)) {
                    hostName = InetAddress.getByName(InetAddress.getLocalHost().getHostAddress()).getHostName();
                }
                if (StringUtils.isNotBlank((CharSequence)hostName)) {
                    hostName = hostName.trim();
                }
            }
            catch (Exception ex) {
                log.info("Unable to lookup hostname: " + ex.getMessage());
            }
        }
        return hostName;
    }

    public static String getPortNumber() {
        String httpPort = System.getProperty(SYSPROP_PORT_NUMBER, System.getProperty("http.port"));
        String port = httpPort == null ? "31415" : httpPort;
        String httpsEnable = System.getProperty("https.enable");
        if (httpsEnable != null && httpsEnable.equalsIgnoreCase("true")) {
            String httpsPort = System.getProperty("https.port");
            port = httpsPort == null ? "31417" : httpsPort;
        }
        return port;
    }

    public static String getProtocol() {
        String protocol = "http";
        String httpsEnable = System.getProperty("https.enable");
        if (httpsEnable != null && httpsEnable.equalsIgnoreCase("true")) {
            protocol = "https";
        }
        return protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIpAddress() {
        String ipAddress = System.getProperty(SYSPROP_IP_ADDRESS, UNKNOWN);
        if (UNKNOWN.equals(ipAddress)) {
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        InetAddress inetAddress = inetAddresses.nextElement();
                        if (inetAddress.isLoopbackAddress()) continue;
                        ipAddress = inetAddress.getHostAddress();
                    }
                }
            }
            catch (Exception ex) {
                log.warn("", (Throwable)ex);
            }
        }
        if (UNKNOWN.equals(ipAddress)) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex) {
                log.warn("", (Throwable)ex);
                ipAddress = "127.0.0.1";
            }
        }
        return ipAddress;
    }

    public static String getTimezoneOffset() {
        String tz = timezoneFormatter.format(new Date());
        if (tz != null && tz.length() == 5) {
            return tz.substring(0, 3) + ":" + tz.substring(3, 5);
        }
        return null;
    }

    public static Date getLocalDateForOffset(String timezoneOffset) {
        long currentTime = System.currentTimeMillis();
        int myOffset = TimeZone.getDefault().getOffset(currentTime);
        int theirOffset = TimeZone.getTimeZone("GMT" + timezoneOffset).getOffset(currentTime);
        return new Date(currentTime - (long)myOffset + (long)theirOffset);
    }

    public static void sleep(long ms) {
        if (ms > 0L) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException e) {
                log.info("Interrupted while sleeping for " + ms);
            }
        }
    }

    public static boolean isSystemPropertySet(String propName, boolean defaultValue) {
        return "true".equalsIgnoreCase(System.getProperty(propName, Boolean.toString(defaultValue)));
    }

    public static void unzip(InputStream in, File toDir) {
        try {
            ZipInputStream is = new ZipInputStream(in);
            ZipEntry entry = null;
            do {
                if ((entry = is.getNextEntry()) == null) continue;
                if (entry.isDirectory()) {
                    File dir = new File(toDir, entry.getName());
                    dir.mkdirs();
                    dir.setLastModified(entry.getTime());
                    continue;
                }
                File file = new File(toDir, entry.getName());
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                    file.getParentFile().setLastModified(entry.getTime());
                }
                try (FileOutputStream fos = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)fos);
                    file.setLastModified(entry.getTime());
                }
            } while (entry != null);
        }
        catch (IOException e) {
            throw new IoException(e);
        }
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        return AppUtils.formatStackTrace(stackTrace, 0, true);
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace, int indentSpaces, boolean indentFirst) {
        StringBuilder buff = new StringBuilder(256);
        boolean first = true;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!first || indentFirst) {
                buff.append(StringUtils.rightPad((String)"", (int)indentSpaces));
            } else {
                first = false;
            }
            buff.append(stackTraceElement.getClassName());
            buff.append(".");
            buff.append(stackTraceElement.getMethodName());
            buff.append("()");
            int lineNumber = stackTraceElement.getLineNumber();
            if (lineNumber > 0) {
                buff.append(":");
                buff.append(Integer.toString(stackTraceElement.getLineNumber()));
            }
            buff.append("\r\n");
        }
        return buff.toString();
    }

    public static <T> T newInstance(Class<T> clazz, Class<?> defaultClass) {
        return AppUtils.newInstance(clazz, defaultClass, new Object[0], new Class[0]);
    }

    public static <T> T newInstance(Class<T> clazz, Class<?> defaultClass, Object[] args, Class<?>[] argTypes) {
        T instance = null;
        String propertyName = clazz.getSimpleName();
        String className = implProp.getProperty(propertyName, defaultClass == null ? null : defaultClass.getName());
        if (className != null) {
            try {
                Constructor<?> cons = Class.forName(className).getDeclaredConstructor(argTypes);
                cons.setAccessible(true);
                instance = (T)cons.newInstance(args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    static {
        AppUtils.loadProperties(implProp, "symmetric-impl.properties");
    }
}

