/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.jumpmind.util.Log4j2Helper;
import org.jumpmind.util.LogSummary;

public class LogSummaryAppender
extends AbstractAppender {
    protected Map<String, Map<String, LogSummary>> errorsByEngineByMessage = new ConcurrentHashMap<String, Map<String, LogSummary>>();
    protected Map<String, Map<String, LogSummary>> warningByEngineByMessage = new ConcurrentHashMap<String, Map<String, LogSummary>>();
    protected Log4j2Helper helper = new Log4j2Helper();

    public LogSummaryAppender(String name, Filter filter) {
        super(name, filter, null, false, null);
    }

    public void append(LogEvent event) {
        String engineName;
        Map<String, Map<String, LogSummary>> summaries = null;
        if (event.getLevel() == Level.ERROR) {
            summaries = this.errorsByEngineByMessage;
        } else if (event.getLevel() == Level.WARN) {
            summaries = this.warningByEngineByMessage;
        }
        if (summaries != null && StringUtils.isNotBlank((CharSequence)(engineName = (String)event.getContextData().getValue("engineName")))) {
            Map<String, LogSummary> byMessage = summaries.get(engineName);
            if (byMessage == null) {
                byMessage = new ConcurrentHashMap<String, LogSummary>();
                summaries.put(engineName, byMessage);
            }
            String message = null;
            if (event.getMessage() != null && !event.getMessage().toString().equals("") && !event.getMessage().toString().equals("null")) {
                message = event.getMessage().toString();
            } else if (event.getThrown() != null) {
                Throwable t = event.getThrown();
                message = t.getClass().getName() + ": " + t.getMessage();
            } else {
                message = "Unhandled error";
            }
            LogSummary summary = byMessage.get(message);
            if (summary == null) {
                summary = new LogSummary();
                summary.setMessage(message);
                summary.setFirstOccurranceTime(event.getInstant().getEpochMillisecond());
                byMessage.put(message, summary);
            }
            summary.setLevel(this.helper.convertFromLevel(event.getLevel()));
            summary.setMostRecentTime(event.getInstant().getEpochMillisecond());
            summary.setCount(summary.getCount() + 1);
            Throwable throwable = event.getThrown();
            summary.setThrowable(throwable);
            if (throwable != null) {
                StringWriter st = new StringWriter();
                throwable.printStackTrace(new PrintWriter(st));
                summary.setStackTrace(st.toString());
            }
            summary.setMostRecentThreadName(event.getThreadName());
        }
    }

    public List<LogSummary> getLogSummaries(String engineName, Level level) {
        Map<String, Map<String, LogSummary>> summaries = null;
        if (level == Level.ERROR) {
            summaries = this.errorsByEngineByMessage;
        } else if (level == Level.WARN) {
            summaries = this.warningByEngineByMessage;
        }
        ArrayList<LogSummary> list = new ArrayList<LogSummary>();
        if (summaries != null && summaries.get(engineName) != null) {
            list.addAll(summaries.get(engineName).values());
            Collections.sort(list, new Comparator<LogSummary>(){

                @Override
                public int compare(LogSummary o1, LogSummary o2) {
                    return Long.valueOf(o1.getMostRecentTime()).compareTo(o2.getMostRecentTime());
                }
            });
        }
        return list;
    }

    public void clearAll(String engineName) {
        this.errorsByEngineByMessage.remove(engineName);
        this.warningByEngineByMessage.remove(engineName);
    }

    public void purgeOlderThan(long time) {
        this.purgeOlderThan(time, this.errorsByEngineByMessage);
        this.purgeOlderThan(time, this.warningByEngineByMessage);
    }

    protected void purgeOlderThan(long time, Map<String, Map<String, LogSummary>> logSummaryByEngineByMessage) {
        Collection<Map<String, LogSummary>> all = logSummaryByEngineByMessage.values();
        for (Map<String, LogSummary> map : all) {
            Set<String> keys = map.keySet();
            for (String key : keys) {
                LogSummary summary = map.get(key);
                if (summary == null || summary.getMostRecentTime() >= time) continue;
                map.remove(key);
            }
        }
    }
}

