/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.jumpmind.util.SimpleClassCompilerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@IgnoreJRERequirement
public class SimpleClassCompiler {
    protected static final String REGEX_CLASS = "public\\s*class\\s*(\\w*)";
    protected Map<Integer, Object> objectMap = new HashMap<Integer, Object>();
    protected int classSuffix;
    private Logger log = LoggerFactory.getLogger(SimpleClassCompiler.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getCompiledClass(String javaCode) throws Exception {
        JavaCompiler compiler;
        Integer id = javaCode.hashCode();
        Object javaObject = this.objectMap.get(id);
        if (javaObject != null) return javaObject;
        String className = this.getNextClassName();
        String origClassName = null;
        Pattern pattern = Pattern.compile(REGEX_CLASS);
        Matcher matcher = pattern.matcher(javaCode);
        if (matcher.find()) {
            origClassName = matcher.group(1);
        }
        javaCode = javaCode.replaceAll(REGEX_CLASS, "public class " + className);
        this.log.info("Compiling class '" + origClassName + "'");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compiling code: \n" + javaCode);
        }
        if ((compiler = ToolProvider.getSystemJavaCompiler()) == null) {
            throw new SimpleClassCompilerException("Missing Java compiler: the JDK (rather than just JRE) is required for compiling classes.");
        }
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(null, null, null));
        DiagnosticCollector diag = new DiagnosticCollector();
        ArrayList<JavaObjectFromString> javaFiles = new ArrayList<JavaObjectFromString>();
        javaFiles.add(new JavaObjectFromString(className, javaCode));
        Boolean success = compiler.getTask(null, fileManager, diag, null, null, javaFiles).call();
        if (success.booleanValue()) {
            this.log.debug("Compilation has succeeded");
            Class<?> clazz = fileManager.getClassLoader(null).loadClass(className);
            if (clazz == null) throw new SimpleClassCompilerException("The '" + className + "' class could not be located");
            javaObject = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.objectMap.put(id, javaObject);
            return javaObject;
        } else {
            StringBuilder msg = new StringBuilder(256);
            msg.append("Compilation of '").append(origClassName).append("' failed.\n");
            for (Diagnostic diagnostic : diag.getDiagnostics()) {
                msg.append(origClassName + " at line " + diagnostic.getLineNumber() + ", column " + diagnostic.getColumnNumber() + ": " + diagnostic.getMessage(null)).append("\n");
            }
            throw new SimpleClassCompilerException(msg.toString(), diag.getDiagnostics());
        }
    }

    protected synchronized String getNextClassName() {
        return this.getClass().getSimpleName() + this.classSuffix++;
    }

    @IgnoreJRERequirement
    public static class ClassFileManager
    extends ForwardingJavaFileManager {
        private HashMap<String, JavaClassObject> jclassObjects = new HashMap();

        public ClassFileManager(StandardJavaFileManager standardManager) {
            super(standardManager);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new SecureClassLoader(){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    JavaClassObject jclassObject = (JavaClassObject)jclassObjects.get(name);
                    if (jclassObject != null) {
                        byte[] bytes = jclassObject.getBytes();
                        return super.defineClass(name, bytes, 0, bytes.length);
                    }
                    return null;
                }
            };
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            JavaClassObject jclassObject = new JavaClassObject(className, kind);
            this.jclassObjects.put(className, jclassObject);
            return jclassObject;
        }
    }

    @IgnoreJRERequirement
    static class JavaClassObject
    extends SimpleJavaFileObject {
        protected final ByteArrayOutputStream bos = new ByteArrayOutputStream();

        public JavaClassObject(String name, JavaFileObject.Kind kind) {
            super(URI.create("string:///" + name.replace('.', '/') + kind.extension), kind);
        }

        public byte[] getBytes() {
            return this.bos.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bos;
        }
    }

    @IgnoreJRERequirement
    static class JavaObjectFromString
    extends SimpleJavaFileObject {
        private String data = null;

        public JavaObjectFromString(String className, String data) throws Exception {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.data = data;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.data;
        }
    }
}

