/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="SymRollingFile", category="Core", elementType="appender", printObject=true)
public class SymRollingFileAppender
extends AbstractOutputStreamAppender<RollingFileManager> {
    private String fileName;
    private String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;
    private int historySize = 2048;
    private Map<String, String> loggedEventKeys;
    private long lastFileTime;

    private SymRollingFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, RollingFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.advertiser = advertiser;
        this.loggedEventKeys = new LinkedHashMap<String, String>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() >= SymRollingFileAppender.this.historySize;
            }
        };
    }

    public synchronized void append(LogEvent event) {
        String key;
        if (!this.isLoggerAtDebug(event) && (key = this.toKey(event)) != null) {
            if (this.loggedEventKeys.containsKey(key)) {
                event = this.supressStackTrace(event, key);
            } else {
                event = this.appendKey(event, key);
                this.loggedEventKeys.put(key, null);
            }
        }
        ((RollingFileManager)this.getManager()).checkRollover(event);
        if (((RollingFileManager)this.getManager()).getFileTime() != this.lastFileTime) {
            this.loggedEventKeys.clear();
            this.lastFileTime = ((RollingFileManager)this.getManager()).getFileTime();
        }
        super.append(event);
    }

    private boolean isLoggerAtDebug(LogEvent event) {
        if (event != null && event.getLevel() != null) {
            return event.getLevel().intLevel() >= Level.DEBUG.intLevel();
        }
        return false;
    }

    protected String toKey(LogEvent event) {
        if (event.getThrown() == null || event.getThrown().getStackTrace() == null) {
            return null;
        }
        try {
            StringBuilder buff = new StringBuilder(128);
            Throwable throwable = event.getThrown();
            buff.append(throwable.getClass().getSimpleName());
            if (throwable.getStackTrace().length == 0) {
                buff.append("-jvm-optimized");
            }
            buff.append(":");
            buff.append(this.getThrowableHash(event.getThrown().getStackTrace(), event.getThrown().getMessage()));
            return buff.toString();
        }
        catch (Exception ex) {
            StatusLogger.getLogger().error("Failed to hash stack trace.", (Throwable)ex);
            return null;
        }
    }

    protected long getThrowableHash(StackTraceElement[] elements, String message) throws UnsupportedEncodingException {
        CRC32 crc = new CRC32();
        if (message != null) {
            crc.update(message.getBytes("UTF8"));
        }
        for (StackTraceElement element : elements) {
            crc.update((element.getClassName() + element.getMethodName() + element.getLineNumber()).getBytes("UTF8"));
        }
        return crc.getValue();
    }

    protected LogEvent appendKey(LogEvent event, String key) {
        String message = this.getMessageWithKey(event, key, ".init");
        Log4jLogEvent eventClone = new Log4jLogEvent.Builder(event).setMessage((Message)new SimpleMessage(message)).build();
        return eventClone;
    }

    protected LogEvent supressStackTrace(LogEvent event, String key) {
        String message = this.getMessageWithKey(event, key);
        Log4jLogEvent eventClone = new Log4jLogEvent.Builder(event).setMessage((Message)new SimpleMessage(message)).setThrown(null).build();
        return eventClone;
    }

    protected String getMessageWithKey(LogEvent event, String key) {
        return this.getMessageWithKey(event, key, null);
    }

    protected String getMessageWithKey(LogEvent event, String key, String prefix) {
        StringBuilder buff = new StringBuilder(128);
        if (event.getMessage() != null) {
            buff.append(event.getMessage()).append(" ");
        }
        buff.append("StackTraceKey");
        if (prefix != null) {
            buff.append(prefix);
        }
        buff.append(" [").append(key).append("]");
        return buff.toString();
    }

    public void start() {
        super.start();
        this.lastFileTime = ((RollingFileManager)this.getManager()).getFileTime();
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return stopped;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return (T)((RollingFileManager)this.getManager()).getTriggeringPolicy();
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<SymRollingFileAppender> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public SymRollingFileAppender build() {
            boolean isBufferedIo = this.isBufferedIo();
            int bufferSize = this.getBufferSize();
            if (this.getName() == null) {
                LOGGER.error("RollingFileAppender '{}': No name provided.", (Object)this.getName());
                return null;
            }
            if (!isBufferedIo && bufferSize > 0) {
                LOGGER.warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)bufferSize);
            }
            if (this.filePattern == null) {
                LOGGER.error("RollingFileAppender '{}': No file name pattern provided.", (Object)this.getName());
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("RollingFileAppender '{}': No TriggeringPolicy provided.", (Object)this.getName());
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().withCompressionLevelStr(String.valueOf(-1)).withConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a DirectFilenameRolloverStrategy must be configured", (Object)this.getName());
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            RollingFileManager manager = RollingFileManager.getFileManager((String)this.fileName, (String)this.filePattern, (boolean)this.append, (boolean)isBufferedIo, (TriggeringPolicy)this.policy, (RolloverStrategy)this.strategy, (String)this.advertiseUri, (Layout)layout, (int)bufferSize, (boolean)this.isImmediateFlush(), (boolean)this.createOnDemand, (String)this.filePermissions, (String)this.fileOwner, (String)this.fileGroup, (Configuration)this.getConfiguration());
            if (manager == null) {
                return null;
            }
            manager.initialize();
            return new SymRollingFileAppender(this.getName(), layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null, this.getPropertyArray());
        }

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        public B withAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAdvertiseUri(String advertiseUri) {
            this.advertiseUri = advertiseUri;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withAppend(boolean append) {
            this.append = append;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withCreateOnDemand(boolean createOnDemand) {
            this.createOnDemand = createOnDemand;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withLocking(boolean locking) {
            this.locking = locking;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public TriggeringPolicy getPolicy() {
            return this.policy;
        }

        public RolloverStrategy getStrategy() {
            return this.strategy;
        }

        public B withFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B withFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Object)((Builder)this.asBuilder()));
        }
    }
}

