/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipBuilder {
    private File baseDir;
    private File[] sourceFiles;
    private File outputFile;

    public ZipBuilder(File baseDir, File outputFile, File[] sourceFiles) {
        this.sourceFiles = sourceFiles;
        this.outputFile = outputFile;
        this.baseDir = baseDir;
    }

    public void build() throws IOException {
        this.outputFile.delete();
        if (this.outputFile.getParentFile() != null) {
            this.outputFile.getParentFile().mkdirs();
        }
        ZipOutputStream target = new ZipOutputStream(new FileOutputStream(this.outputFile));
        for (File file : this.sourceFiles) {
            this.add(file, target);
        }
        target.close();
    }

    private String massageEntryName(File source) {
        String name = source.getPath();
        if (this.baseDir != null && name.startsWith(this.baseDir.getPath())) {
            name = name.length() > this.baseDir.getPath().length() ? name.substring(this.baseDir.getPath().length() + 1) : "";
        }
        if ((name = name.replace("\\", "/")).equals("META-INF/MANIFEST.MF")) {
            name = "";
        }
        return name;
    }

    private void add(File source, ZipOutputStream target) throws IOException {
        block17: {
            block16: {
                File[] files;
                if (!source.isDirectory()) break block16;
                String name = this.massageEntryName(source);
                if (name.trim().length() != 0) {
                    if (!name.endsWith("/")) {
                        name = name + "/";
                    }
                    JarEntry entry = new JarEntry(name);
                    entry.setTime(source.lastModified());
                    target.putNextEntry(entry);
                    target.closeEntry();
                }
                if ((files = source.listFiles()) == null) break block17;
                for (File nestedFile : files) {
                    this.add(nestedFile, target);
                }
                break block17;
            }
            ZipEntry entry = new ZipEntry(this.massageEntryName(source));
            entry.setTime(source.lastModified());
            target.putNextEntry(entry);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));){
                int count;
                byte[] buffer = new byte[1024];
                while ((count = in.read(buffer)) != -1) {
                    target.write(buffer, 0, count);
                }
                target.closeEntry();
            }
        }
    }
}

