# 常见问题整理

> [!WARNING]
> 该文档待更新到ms-swift4.0

下面是swift使用过程中遇到的一些常见问题。

## 训练

### Q1: Swift微调支持的模型和数据集有哪些？
详见文档[支持的模型和数据集](https://swift.readthedocs.io/zh-cn/latest/Instruction/Supported-models-and-datasets.html)。

### Q2: 使用自定义数据集训练时支持的数据格式有哪些？
自定义数据集格式见文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html)。

### Q3: 自定义数据集dataset_info.json格式，如何通过这种方式使用自定义数据集？
dataset_info.json格式见文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html)。命令行，`--custom_dataset_info xxx.json`，`--dataset <dataset_id_or_path>`。

### Q4: 如何在界面训练使用自定义数据集？
界面训练使用自定义数据集与命令行一致，参考文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html)。

### Q5: 数据集jsonl文件里的一行能不能写成这样？{"index": "00000", "query": "11111", "response": "22222", 'source':'qqq'}
可以有额外字段的，这些字段默认不会被使用。详见[命令行参数remove_unused_columns](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id4)。

### Q6: 命令行参数在哪个文档中查看？
详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q7: 离线环境训练需要配置的参数有哪些？
`--model 本地路径`，`--check_model false`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q8: model_type在哪儿查看？
查看文档[支持的模型和数据集](https://swift.readthedocs.io/zh-cn/latest/Instruction/Supported-models-and-datasets.html)。

### Q9: 模型训练完能直接转gguf格式吗？
目前只支持导出ModelFile，详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q10: swift支持预训练吗，我看只有sft？
支持，命令行`swift pt`，[预训练例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/pretrain)，数据集格式见[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html)。

### Q11: 想问一下用lora微调的模型，如果想断点续训的话，是应该先把它合成一整个模型吗，还是可以不合起来，直接通过路径来指定原模型和lora块
不合并，`--resume_from_checkpoint output/xxx/vx-xxx/checkpoint-xxx`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q12: 我想控制一下从网上下载下来的原始模型权重的位置，怎么才能做到把原始的模型放在指定的文件夹里呢？
可以配置环境变量`MODELSCOPE_CACHE=your_path`将原始的模型存到指定路径；如果用sdk下载，通过`cache_dir="本地地址"`；也可以使用`modelscope download`命令行工具或`git`下载，详见modelscope文档[模型下载](https://modelscope.cn/docs/models/download)。训练时`--model`配置本地路径即可。如果需要在离线环境训练，配置`--check_model false`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q14: 有微调qwen-2-vl的完整的教程和命令行吗？
参考多模态模型训练的[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multimodal)。

### Q15: 多模态大模型微调有什么支持的trick吗，类似llm的neftune?
`piassa/olora/dora`这些`lora`的变种或者`fourierft`都可以尝试。参考`sft`参数里面的各种trick，有一些不一定在多模态上适用。

### Q16: 训练过程中eval得到的acc和对应保存的ckpt去重新推理一遍计算得到的acc不是一致的
训练时候的eval_acc和推理时候的acc 计算方式不一样的。`acc_strategy`: 默认为`'token'`, 可选择的值包括: `'token'`, `'seq'`.

### Q17: 魔搭官方镜像与swift环境
`docker run`命令启动容器即可，如：`docker run --gpus all -p 8000:8000 -it -d --name ms modelscope-registry.cn-beijing.cr.aliyuncs.com/modelscope-repo/modelscope:ubuntu22.04-cuda12.4.0-py311-torch2.6.0-1.26.0-LLM /bin/bash`，启动容器后拉最新代码安装swift。另外，针对大模型训练场景，提供了`ms-swift`镜像，额外增加了`Megatron-SWIFT`的依赖，如：`modelscope-registry.cn-beijing.cr.aliyuncs.com/modelscope-repo/modelscope:ubuntu22.04-cuda12.4.0-py311-torch2.6.0-vllm0.8.5.post1-modelscope1.26.0-swift3.4.1.post1`，详见[swift安装文档](https://swift.readthedocs.io/zh-cn/latest/GetStarted/SWIFT-installation.html)。

### Q18: 多机多卡训练命令行
详见[多机多卡例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multi-node)

### Q19: 如何选择template?
见[issue](https://github.com/modelscope/ms-swift/issues/1813)。

### Q20: 多卡训练torchrun和swift sft如何使用？
`swift sft`走的就是`torchrun`。

### Q21: 有个问题，因为我的sft数据集太大了，然后每次tokenize都需要很久，有解决方案吗？
使用`lazy_tokenize`或流式读取`streaming`，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q22: 训练时，如果两个数据集直接追加一起放在训练集中，模型在训练的时候内部会有shuffle的流程吗？还是按顺序取数据去训练？
命令行参数`dataset_shuffle`，详见[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q23: 如果模型两张卡，数据不开并行，deepspeed就会出现报错，怎么处理呢？
`deepspeed` 和 `device_map`是不兼容的，两个只能选1个。

### Q24: vlm模型训练如何减少显存使用？
配置`--freeze_vit true`，以及限制最大像素的参数`--max_pixels`。

### Q25: 没有适配model_type的模型，sft时可以自定义special_tokens和chat_template吗？
可以。参考[注册多模态模型最佳实践](https://swift.readthedocs.io/zh-cn/latest/BestPractices/MLLM-Registration.html)。

### Q26: 可以在python脚本里面用DPO去训练qwen2-vl吗？
可以。从`swift.pipelines`中导入`rlhf_main` 和`RLHFArguments`。

### Q27: 请问训练MLLM时，可否先进行纯文本的预训练，然后接入VQA数据集进行微调呢？
可以。也可以混着训练。

### Q28: 基于qwen2的sft模型进行dpo训练，v100的机器，训练时都是Nan呢？
V100机器要用fp32训练qwen2。

### Q29: 想问一下，swift，能支持蒸馏吗？
参考这个[例子](https://github.com/modelscope/ms-swift/blob/main/examples/sampler/distill/distill.sh)。

### Q30: 当前训练完默认保存多少个checkpoint？
默认保存所有的checkpoint，详见[命令行参数 save_total_limit](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。该参数在megatron swift中不支持，请设置save_interval保存checkpoint，详见[megatron swift命令行参数](https://swift.readthedocs.io/zh-cn/latest/Megatron-SWIFT/Command-line-parameters.html)。

### Q31: Grounding任务中通用数据格式支持一个类别有多个实例吗？
目前均支持了一个物体对应多个bbox，参考文档[自定义数据集](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html#grounding)。

### Q32: 这个错误为什么会出现在这，numpy.object找不到在哪？
`numpy==1.26.3`，尝试一下。

### Q33: swift框架能支持序列并行了吗？
支持。参考这里的[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/sequence_parallel)。

### Q34: 用v100微调qwen2-1.5B时，loss': 0.0, 'acc': 0.0, 'grad_norm': nan，是什么问题呢?
尝试用fp32。

### Q35: gptq量化模型，能全参数微调吗？
不能。gptq模型的int型参数无法参与求导，只能附着lora等额外结构参与更新。

### Q36: 请问如果想用qlora的方式微调的话应该如何设置参数呢?glm4-chat
参考qlora[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/qlora)。

### Q37: 请教一个问题，我应该如何在swift框架下扩充我的词表呢？
详见[命令行参数new_special_tokens](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id3)。

### Q38: 同名的模型是可以直接使用huggingface上的吗？
设置环境变量`USE_HF=1`。

### Q39: 请问Qwen2-VL-2B能进行增量预训练吗？有指导文件吗?有图文,也有纯文本的。
支持，按[自定义数据集文档](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html)中的格式组织数据就行。

### Q40: 请问下用视频做训练的时候，如何在参数中控制抽帧率，设了frame_rate设不起, minicpmv
设置环境变量`MAX_NUM_FRAMES`。

### Q41: swift在训练的时候，可以把验证集的推理结果保存下来吗？
训练结束后，运行swift infer，会保存。

### Q42: 我全量full参数dpo，为何保存的checkpoint 比原本模型文件要大呢?整整大了1倍
用V100微调，存的是fp32类型。

### Q43: 多机训练速度缓慢，在使用swift框架进行LLM训练时，发现采用deepspeed zero3训练会出现严重的速度下降问题
详见[issue](https://github.com/modelscope/ms-swift/issues/1825)。

### Q44: swift现在是支持qwen2-vl多阶段预训练的吗？我看官方的最佳实践里的sft好像都是vit+llm一起训的，不知道支不支持单独finetune
`--freeze_vit`，`--freeze_aligner`，`--freeze_llm`这几个参数可以控制，详见[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#tuner)。

### Q45: qwen2-vl是不是不支持混合纯文本数据?
支持图文和纯文本。

### Q46: 微调的时候可以绘制不同数据集的loss曲线吗？
支持channel loss，参考`--enable_channel_loss`。

### Q47: 模型训练后，回复重复了很多内容
参考[预训练与微调](https://swift.readthedocs.io/zh-cn/latest/Instruction/Pre-training-and-Fine-tuning.html)。如果训练过程中出现重复的情况，请多训练几个epoch, 清洗数据, 全参数训练, 采用RLHF的方式缓解。

### Q48: 想问一下swift目前支持prompt tuning或者prefix tuning吗？
不支持，这两个方法知识遗忘比较严重，目前不推荐使用。

### Q49: 两张A10训练报错如下：
```text
[rank0]: torch.distributed.DistBackendError: NCCL error in:../torch/csrc/distributed/c10d/ProcessGroupNCCL.cpp:1970， unhandled system error (run with NCCL_DEBUG=INFO for details),NCCL version 2.20.5
[rank0]:ncclSystemError: System call (e.g. socket,malloc) or external library call failed or device error.
```
请检查共享内存是否太小，nccl需要共享内存。

### Q50: 请问在采用DDP微调训练的过程中，冻结某些层时导致的某些参数未参与梯度回传问题怎么解决？
配置参数`--ddp_find_unused_parameters true`。

### Q51: swift有没有数据集质检工具？
[data-juicer](https://github.com/modelscope/data-juicer)。

### Q52: web端在哪启动模型并行?只找到了数据并行的勾选项，没找到模型并行在哪。
指定可见显卡就可以。

### Q53: 设置--dataset的话，怎么让数据集下载到固定位置，我在命令行参数没找到，下次如果再次读取的话如何可以从下载的地方读取
`dataset_path`支持文件夹，一般是`git clone`下载下来的数据集文件夹。详见[自定义数据集文档](https://swift.readthedocs.io/zh-cn/latest/Customization/Custom-dataset.html#dataset-info-json)。

### Q54: --streaming true，我设置num_train_epochs会报错让我设置max_steps。不可以只设置num_train_epochs吗？
详见`streaming`参数说明，[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id4)。

### Q55: 好奇tools为啥是"[]"，不是直接支持[]呢，能否帮忙解答一下，这个tools为啥是"[]"这种格式呢，不是直接使用[]呢，有些不理解
这是因为datasets的底层pyarrow对于类型管控比较严格。我们官方的grounding数据集的objects部分也是因为这个原因要用str，要不pyarrow就会报错：你每行的类型不一致。

### Q56: 这个参数不能用吗？check_dataset_strategy==discard
swift3.0没这个参数了，用`strict`参数。

### Q57: 运行sft命令出现报错如下：
```text
RuntimeError: Expected to mark a variable ready only once.This error is caused by one of the following reasons: 1) Use of a module parameter outsid forward function. Please make sure model parameters are not shared across multiple concurrent forward-backward passes. or try to use _set_static_graph( ) as round if this module graph does not change during training loop.2) Reused parameters in multiple reentrant backward passes. For example, if you use multiple oint` functions to wrap the same part of your model, it would result in the same set of parameters been used by different reentrant backward passes multiple and hence marking a variable ready multiple times. DDP does not support such use cases in default. You can try to use _set_static_graph( ) as a workaround if dule graph does not change over iterations.
```
加一下这个参数，`--gradient_checkpointing_kwargs '{"use_reentrant": false}'`。或者升级ms-swift，默认设置了这个参数。

### Q58: 有遇到过这个问题嘛？AttributeError:’TrainerState’ object has no attribute ’last_model_checkpoint’
数据集太少了，增加一些。数据数量不足一个step导致的报错。

### Q59: 我看到custompreprocessor里面可以定义preprocess，这个是在训练开始前全部会处理好，还是一边训练一边加载的啊
如果设置了参数`--streaming true`，就是一边训练一边加载。默认是全部处理完然后训练。

### Q60: 全参数训练internvl2_5，为啥里面的 freeze parameters默认就有vision_model 和 mlp1？我看命令行参数的文档里面freeze parameters默认为[],命令中显示设置 freeze vit， freeze aligner， freeze llm都为False，又会打印出来trainable parameters：[‘mlp1’] 也不知道是指只有mlp1可以train 还是 所有的paras都可以train 只是mlp1打印一下
先freeze parameters再active parameters。`freeze vit/freeze aligner/freeze llm`这三个参数会对freeze parameters 和trainable parameters进行调整.因为有些模型的`vit`中包含`aligner`，所以会将`aligner`单独加入trainable_parameters。

### Q61: 请问swift中的llamapro对多模态做适配了吗？
支持的。

### Q62: 我发现2.x支持MAX_PIXELS，3.x文档里有个--max_pixel参数是一个意思吗，他的处理逻辑是啥样的？我用12000*9000的图片，2.x设置resacle_image训练internvl还是会崩
环境变量的参数是对应模型的参数，`MAX_PIXELS`只支持qwen2vl的，internvl有自己的环境变量参数，详见[特定模型参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id18)。

### Q63: 从qwen base模型微调成chat模型有没有实践文档，有什么要特别配置的吗?
`swift sft`，没有其他需要特别配置的，参考[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/base_to_chat)。

### Q64: sequence parallel例子在哪呀？
看这个例子[sequence_parallel](https://github.com/modelscope/ms-swift/tree/main/examples/train/sequence_parallel)。

### Q65: swift能支持训练自己定义的模型结构吗？
可以的，只需要自定义`get_model_tokenizer_xxx`函数就好了，返回`model`和`tokenizer`。

### Q66: 我用"name_or_path": "/mnt/workspace/model/Qwen2.5-14B-Instruct"跑longlora 发现出现了报错，不会是只有个llama系列可以使用longlora吧
只有llama系列能用`longlora`。

### Q67: 想问下swift怎么加入自己的special token？
详见[命令行参数文档new_special_tokens](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id3)。

### Q68: --freeze_parameters_ratio这个参数，如果设定为0.7，是不是说明训练的时候只更新llm的30%的参数？是随机更新30%吗，这个参数更新的机制是什么呀？
从下往上freeze。

### Q69: map过程为啥这么慢，这是正常的吗？
```text
Map: 4%|██ | 9000/203823 [02:18<50:34, 64.19 examples/s]
```
设置参数`--dataset_num_proc`可以开多进程。

### Q70: 请问数据集如何能够删除重新下载，感觉数据集出了点问题
设置参数`--download_mode`。

### Q71: 请问这个问题如何解决？safetensors_rust.SafetensorError: Error while deserializing header: HeaderTooLarge
磁盘空间不足了，模型没有保存完整。

### Q72: swift3.0不支持get_default_template_type是吗？
请查看`model.model_meta.template`，信息都存在`model.model_meta和model.model_info`。

### Q73: 请问默认模型训练都是left padding是吧?
训练可以选择使用左padding还是右padding。默认是右padding, `batch infer`都是左padding。

### Q74: 请问下现在支持grounding任务了吗
examples下有[例子](https://github.com/modelscope/ms-swift/blob/main/examples/train/multimodal/grounding.sh)。

### Q75: 请问现在ms-swift支持对比学习，从而训练llm_emb吗?
支持，[例子](https://github.com/modelscope/ms-swift/blob/main/examples/train/embedding)。

### Q76: 话说直接从peft和trl库，手搓微调和grpo代码和swift官方在同参数下进行训练，效果差异大吗？
区别不大，额外支持了多模态。

### Q77: swift 目前不支持 minicpmo2_6 使用音频模态输入的训练吗？会报错： assert media_type in {'image', 'video'}
目前不支持音频。

### Q78: swift可以微调deepseek R1 671B吗？
可以，template是接入了的，不过过程会比较麻烦，要先fp8转bf16。

### Q79: 最新的swift框架不是通过这个命令来指定模型的位置的么？这是我已经下载好的模型位置，不知道为什么还要下载，还下不下来，提示报错git clone
```shell
--model /mnt/workspace/.cache/modelscope/hub/deepseek-ai/deepseek-vl2/ \
```
有些需要clone repo，然后通过`local_repo_path`指定。

### Q80: swift现在支持多模态的grpo吗？
支持。

### Q81: grpo的reward函数支持自己定义么?
支持，参考[examples/train/grpo/plugin](https://github.com/modelscope/ms-swift/tree/main/examples/train/grpo/plugin)。

### Q82: 请问为什么 --torch_dtype float16 （卡不能使用bf16）会出现报错：lib/python3.12/site-packages/torch/amp/grad_scaler.py", line 260, in _unscale_grads_ raise ValueError("Attempting to unscale FP16 gradients.") ValueError: Attempting to unscale FP16 gradients.
全参数，不能fp16训练的。

### Q83: 请教一个问题。我用swift训练了一个reward模型（基线是qwen2.5-7b），然后用在ppo或者grpo中加载会报错。reward模型是lora训练的。
```shell
--rlhf_type ppo \
--model Qwen/Qwen2.5-14B-Instruct \
--reward_model /mnt/workspace/output/rm/model --train_type lora \
--dataset 'AI-ModelScope/alpaca-gpt4-data-zh#20000' --torch_dtype float32 --num_train_epochs 1 \
--per_device_train_batch_size 1 --per_device_eval_batch_size 1 --learning_rate 1e-5 --lora_rank 8 --lora_alpha 32 \
--target_modules all-linear \
--gradient_accumulation_steps 16 --eval_steps 100 --save_steps 100 \
```
lora训练的reward model需要merge一下。

### Q84: 各位大佬，请问要微调deepseek_vl2，transformers用什么什么版本？官方文档说<4.42，但是4.42及以下也报错。peft版本也要降低吗？
`peft==0.11.*`。

### Q85: 请问generate train split太慢了有没有什么好办法呀（大概有30多个数据集，总数据量百万左右）。之前swift 2.x好像没有这么慢。lazy tokenize 已经开了
设置`--dataset_num_proc 16`。

### Q86: 请问下微调qwen2.5vl的时候，我想使用全参数微调visual encoder同时使用LoRA微调LLM，怎么实现呢？
参考这里[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multimodal/lora_llm_full_vit)。
 
### Q87: 问一下，swift怎么使用自定义的损失函数？
plugin中加就可以了。

### Q88: 请问下MoE的参数有哪些，参数表里关键字搜索不到？专家数量，专家路由这些参数怎么设置？
直接用config.json中的参数。

### Q89: grpo训练中使用lmdeploy会报相关函数不存在的问题，想请教下具体问题，在lmdeployengine类里面确实没找到load_weights这个函数
只在turbomind引擎下支持。

### Q90: Moonlight-16B-A3B-Instruct, 我在微调这个模型的时候报错怎么办?ms-swift好像不支持这个模型进行微调
因为是模型文件中禁止了训练, 参考deepseek_vl2的解决方案，你搜搜issue。

### Q91: 训练时出了这个错应该咋解决？RuntimeError: “triu_tril_cuda_template“ not implemented for ‘BFloat16'
```shell
CUDA_VISIBLE_DEVICES=01,2,3,4,5,6,7 \
swift sft \
    --model Internlm3-8b \
    --dataset train.json \
    --train_type full \
    --torch_dtype bfloat16 \
    --num_train_epochs 5 \
    --per_device_train_batch_size 1 \
    --deepspeed zero3 \
    --per_device_eval_batch_size 1 \
    --learning_rate 1e-4 \
    --gradient_accumulation_steps 16 \
    --eval_steps 100 \
    --save_steps 100 \
    --save_total_limit 5 \
    --logging_steps 5 \
    --max_length 2048 \
    --output_dir output \
    --warmup_ratio 0.05 \
    --dataloader_num_workers 4
```
升级torch。

### Q92: grpo训练，loss和grad_norm全是0，正常的吗？
```text
{'loss':    0.0.    'grad norm':0.0,    'learning_rate':9e-08,    'memory(GiB)':88.1，    'train_speed(iter/s)':0.009252，    'completion_length':    150.00000763，    'response_clip ratio': 0.0,    'rewards/Format':1.0,    'reward
: 1.0,    'reward std':0.0，    'kl': 0.0, 'clip_ratio': 0.0,    'epoch': 0.0， 'qlobal step/max steps':'1/1052'，    'percentage':'0.10%    'elapsed time':    '36s    'remaining time': '10h 43m 54s'}
{'loss': 0.0，'grad_norm':0.0，'learning_rate': 1.8e-07,'memory(GiB)':94.15，'train_speed(iter/s)':0.014782，'completion_length': 133.25000763，'response_clip_ratio': 0.0，'rewards/Format': 1.0, 'rewa rd': 1.0，'reward_std': 0.0, 'kl': 0.0，'clip_ratio': 0.0,'epoch': 0.0, 'global_step/max_steps': '2/1052'，'percentage': '0.19%', 'elapsed_time': '1m 3s'， 'remaining_time': '9h 19m 49s'}
{'loss': 0.0， 'qrad norm': 0.0, 'learning rate': 2.7e-07,'memory(GiB)': 94.15，'train_speed(iter/s)': 0.018695，'completion_length': 123.08333969，，'response_clip_ratio': 0.0，'rewards/Format': 1.0, 'rewa rd': 1.0， 'reward_ std': 0.0,'kl': 0.0,'clip_ratio': 0.0， 'epoch': 0.0， 'global_step/max_steps': '3/1052'，'percentage': '0.29%，'elapsed_time': '1m 29s'，'remaining_time': '8h 39m 34s'}
```
训练过程中loss接近0是正常情况，参考[issue](https://github.com/huggingface/open-r1/issues/239#issuecomment-2646297851)。

### Q93: 请教一下这个grpo的内置奖励函数，从哪里可以传入accuracy_orm
目前是直接改代码。

### Q94: 我看这奖励函数有solution参数，是要从数据集里面传过来吗？就是我数据集必须有solution这项？
是的，针对math问题，不然不好算accuracy。

### Q95: 训练为什么没有token_acc？
有些模型`logits`和`labels`数量对不上，就不算的。

### Q96: 微调Ovis2 使用lora参数不起作用？加不加--train_type lora \，好像都是全参数微调？显存没变化。
`--max_length`限制一下，这个模型有点特殊，需要padding到max_length。

### Q97: 请问下用qwen2.5跑一个分类任务，抱下面的错误，是哪里配置的有问题呢？ValueError: The model did not return a loss from the inputs, only the following keys: logits. For reference, the inputs it received are input_ids,attention_mask.
数据集是这样的：{"messages": [{"role": "user", "content": "xxxxx"}, {"label": 1}]}
`label`写在`message`同级。

### Q98: 启动了VllmEngine，要如何退出呀？就是调用了engine，模型就被载入显存准备工作。但是我推理完想要engine释放显存。下次调用时，再加载。而不是一直占用
sleep mode啊，支持的。`engine.sleep(level=1)/engine.wake_up()`，构造的时候加一个`enable_sleep_mode=True`。

### Q99: 求问，streaming模式下，trainer_sampler_random是不是就没有作用了呢？
streaming是不随机的。

### Q100: 请问grpo使用vllm进行推理，vllm可以设置trust_rwmote_code吗？
默认就是true的。

### Q101: 请教一下，pretrain阶段数据集比较大，用了streaming流式和packing打包数据，这时候需要设置 max_steps，有没有参数或者命令可以根据epochs、bs等参数计算打包后的总的steps吗？
设置`--max_steps`或`--max_epochs`，详见[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id4)streaming参数说明。

### Q102: unsloth训练，报错：assert(type(target modules) in (list,tuple,))。配置的参数是--target modules all-linear
别用`all-linear`，改为具体的模块列表，比如`--target_modules q k v`。

### Q103: Swift现在支持多标签分类么？
支持的。自定义数据集文档有格式，然后在命令行参数文档中搜索一下`problem_type`，改一下，其他和回归是一样的。

### Q104: 请问packing中flash_attn是分开处理的还是合并处理的？
一定需要flash_attn，不然是有误差，attention_mask会出问题。

### Q105: 请问对于qwen2.5-omni来说--freeze_vit false意味这视觉编码器和音频编码器都打开了，有什么办法可以只打开音频编码器不打开视觉编码器吗？
`--target_regex`写一下。

### Q106: 请问现在swift的强化学习那几种训练方法支持序列并行么？
支持pt, sft, dpo and grpo。

### Q107: 使用 lora sft之后是不会储存tokenizer.json吗
lora不会存储，merge后才会把这些文件迁移过来，因为lora目录需要配合原模型使用。

### Q108: GRPO 的reward_model 和 reward_funcs可以一起用吗？
可以。

### Q109: 想请教一下，在进行GRPO时不打算引入KL项，有相关的参数可以调整吗？
命令行参数搜一下beta。

### Q110: 请教一个问题，做grpo的时候，如何在orm的自定义奖励函数中获取原始标签呢？我打印了kwargs的messages字段，里面的每一项的assistant的content的值已经被替换成生成的结果了
放到另外的列里。

### Q111: 默认只用 num_iterations=1 的话，clip 就失去作用了吧？dapo 的 clip higher 也没用。我看 veRL 有个 micro batch 可以设置单轮小批次更新 policy model 来使得 clip 项生效，ms-swift 的 mini batch 看源码貌似只是做了梯度累加？
是的，需要num_iterations>1。

### Q112: 请问qwen2.5-omni的训练支持全参训练吗，是否支持talker的训练？
目前不支持talker训练，只有thinker。

### Q113: 请问，sequence parallel是否可以和liger kernel同时启用呀？
可以。

### Q114: 请问ppo训练rm和policy有什么要求呢？
现在ppo还只支持rm和policy是同一系列的模型(tokenizer/template)。

### Q115: 还想问一下，由于llama3.1没有小于8B的模型，因此我想用3.2 1B的的来微调，那么还能用Llama-3.1这个奖励模型吗？
要求是`template`和`tokenizer`要一样， 3.1 和 3.2 应该问题不大。

### Q116: 请问swift是否能缓存一份mappiing之后的数据？方便排查训练数据的问题
设置`--load_from_cache_file false`。

### Q117: 全参数训练为啥会有warning: none of the inputs have requires_grad=True?
如果vit没有训练，那有这个warning是正常的，如果训练了，则不应该抛出。

### Q118: 现在qwen2.5vl ulysses支持sdpa吗？
vl模型的目前仅支持flash-attn，纯文本两种都支持。

### Q119: 请问这图片列表形式的videos现在支持了吗？格式如下
```json
{"messages": [{"role": "assistant", "content": "<video>是一只狮子在跑步"}], "videos": [["1.jpg","2.jpg"]]}
```
支持了，使用文件目录的方式。

### Q120: 请教一个问题，grpo脚本中的save_steps指的是step还是global step？目前本地训练显示的global step是18， wandb上显示的step是628。
`global_step`，本地tqdm显示的。

### Q121: use_logits_to_keep 现在多模态大模型上可以用吗？
如果多模态token的展开在模型的forward内会报错。

### Q122: 请问一下为什么训练到会有好几次显存大幅度增加，已经50step或者100step
设置环境变量`PYTORCH_CUDA_ALLOC_CONF`，具体查看torch文档。

### Q123: 请问packing_cache这个参数设置，多机训练，我设置了文件夹地址后还是会报错，这有啥特殊要求吗?
需要设置为共享的磁盘路径。

### Q124: Qwen3非thinking模式和thinking模式，数据集和参数设置有什么不同吗？
查看这个[issue](https://github.com/modelscope/ms-swift/issues/4030)。

### Q125: 请问megatron-swift如何配置断点续训？
配置`--load`加载checkpoint，另外根据需要配置这几个参数，`--finetune`，`--no_load_optim`，`--no_load_rng`。如果是lora断点续训，配置`--adapter_load`，其他同全参数训练，详见[megatron-swift命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Megatron-SWIFT/Command-line-parameters.html)。

### Q126: 有没有人在复现Kimi-VL-A3B-Instruct的时候出现了如下的报错？
```text
[rank7]:    File "/root/.cache/huggingface/modules/transformers_modules/Kimi-VL-A3B-Instruet/modeling_kimi_v1.py", line 946, in forward
[rank7]:      assert not self.training
[rank7]:
[rank7]:    AssertionError
```
需要将`config.json`中的`topk_method`改成`greedy`。

### Q127: 想问下训练qwenvl2.5的时候，怎么保证设定max_pixels后检测框的坐标是对的？这部分swift是怎么处理的？
会保存预处理前和后的，然后对bbox进行调整，不过推理没有这样的调整，需要提前手动处理图片。

### Q128: 问一个问题，我想在dataset中返回solution 字段，所以我写了preprocess，但是dataset只返回messages和images，没返回solution这该如何修改呢？
设置`--remove_unused_columns false`。

### Q129: 请问下，lora参数合并报错，目前peft是0.11.0，这个是因为peft版本需要升级吗
```text
File "/opt/conda/lib/python3.9/site-packages/peft/config.py", line 118, in from_peft_type
  return config_cls(**kwargs)
TypeError: __init__() got an unexpected keyword argument 'corda_config'
```
训练和合并的peft版本不一致导致的。

### Q130: 请问现在支持多轮的DPO吗？
不支持。

### Q131: 想问下，我之前运行过一次注册数据集了，后面修改了action_preprocessor的代码，但是数据还是和原来的一样，像是忽略了我的修改？
设置一下`--load_from_cache_file false`。

### Q132: 请问sequence_parallel_size和自定义loss冲突吗？我在自定义loss里面打印了一些debug信息，但是发现开启了sequence_parallel_size 过后就没有信息被打印出来了，也没有报错，sft训练是正常的，担心是自动调了什么别的库。
冲突的，sequence parallel在自己的代码中定制了loss，可以自己改下[这里](https://github.com/modelscope/ms-swift/blob/main/swift/trainers/sequence_parallel/ulysses.py)。

### Q133: swift pt这种训练方式，如果传入了`<image>`，`<image>`是不是没有被屏蔽，每个token也参与损失计算？
不算损失的，可以在命令行日志中找一下打印的labels看看。

### Q134: 想问一个问题，多模态packing预训练每次pytorch allocator cache flushes since last step后，显存使用好像就会增长一点，步数多了容易oom
加个环境变量`PYTORCH_CUDA_ALLOC_CONF='expandable_segments:True'`。

### Q135: 如何在训练时使用focal loss？当前支持的loss种类哪里有？
可以在这里添加新的[loss](https://github.com/modelscope/ms-swift/blob/main/swift/loss/mapping.py)。

### Q136: rollout设置了pipeline parallel size，貌似trl和vllm里获取不到word size这个值。
rollout应该是不兼容pipeline parallel。

### Q137: 请问qwen2audio的sft支持packing吗？
不支持。

### Q138: 请问gspo训练支持传入参数top_entropy_quantile吗？传入了--importance_sampling_level sequence后，还能实现对熵分布前x%的token的优化吗？
支持，顺序是先正常计算loss（受importance_sampling_level影响），再根据top_entropy_quantile mask掉loss。

### Q139: gkd训练student model和teacher model的model_type需要一致吗，一个dense一个moe可以吗?
可以的，只需要词表一样，不过带moe就会比较慢。

### Q140: 请问在不支持flash attention的设备上attention implemation默认是什么呢？文档中默认是none
默认使用sdpa。

### Q141: freeze_parameters_ratio参数是从注意力层开始算的吗？
从embedding开始算，可以结合trainable_parameters设置。

### Q142: 请问，lora微调后，不支持在adapter上继续做dpo或者grpo训练吗？
支持了, 命令行参数文档中搜索`--adapters`。

### Q143: 多模态数据集希望在加载数据之后做动态数据增强，例如，给输入数据随机添加噪声。请问要自定义动态数据增强，需要继承或重写哪些部分呢？
在template中修改encode方法。

### Q144: ppo训练支持梯度裁剪吗？
不支持。

### Q145: 请问liger kernel和padding free没法在grpo阶段一起开吗？
是的。如果一起开，需要改liger grpo loss的实现，在liger kernel库中，不方便改。

### Q146: 请问，swift sft的命令行参数里面，使用lora训练和--trainable_parameters参数是兼容的吗？就是用lora训练language model，然后同时在最后一层加个score head一起训练。
不兼容，用modules_to_save。

### Q147: 多机多卡训练，只有主节点有日志，是正常的吗？
正常的。

### Q148: swift能够支持设置最小的learning rate吗，感觉最后减到太小了
可以设置，`--lr_scheduler_type cosine_with_min_lr --lr_scheduler_kwargs '{"min_lr": 1e-6}'`。

### Q149: 设置了split_dataset_ratio，但是一直到训练结束也没有验证集的验证过程，是哪里没配置好吗？
流式读取streaming不划分验证集，设置一下val_dataset。

### Q150: grpo支持channel_loss吗
不支持。

### Q151: 请问grpo有什么办法透传task_id吗？想区别训练集的不同task。
[多任务训练](https://swift.readthedocs.io/zh-cn/latest/Instruction/GRPO/DeveloperGuide/multi_task.html)。

### Q152: 目前支持用yaml文件配置grpo和sft吗？
都支持的，该配置是在main.py中直接处理成命令行。

### Q153: swift支持多节点的分布式训练吗？
参考这里的[例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/multi-node)。

### Q154: 几个任务一起finetune vlm，不同任务视频采样规则不一致，ms swift是否支持？在哪里配置？
[命令行参数文档](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)看下`interleave_prob`。

### Q155: 请教gkd现在支持教师和学生模型tokenizer不一样吗？
不支持。

### Q156: 请问现在是不支持use_liger_kernel和log_entropy一起用吗？
不支持。

### Q157: 训练grpo的时候，进行观察的时候，怎么没有熵这个曲线呀
设置`--log_entropy true`，算entropy会有额外的一点开销，所以没有默认记录。

### Q158: swift里把图像读进来转换成tensor的位置在哪里？
Template的_encode方法。

### Q159: 问一下，原始数据集包含question和answer两列，命令行做映射之后--columns {"question": "query", "answer": "response"}，奖励函数无论是用answer还是response都会报错没有列。怎么样才能把数据集的列透传进去呢？
这些是保留列，换个列名。

### Q160: 想问下，ms-swift对qwen3-30b-a3b的moe模型lora微调，aux-loss基本没变化，即使设置aux-loss-coef为1也没变化。
all-router也加到target_modules。

### Q161: 下面的脚本，可以按epoch保存checkpoint吗？
```shell
megatron sft \
    --load "$MODEL_PATH" \
    --dataset "$DATA_PATH"  \
    --train_type lora \
    --lora_rank 8 \
    --lora_alpha 16 \
    --target_modules all-linear \
    --sequence_parallel true \
    --micro_batch_size 4 \
    --global_batch_size 128 \
    --recompute_granularity full \
    --recompute_method uniform \
    --recompute_num_layers 1 \
    --attention_backend flash \
    --tensor_model_parallel_size 2 \
    --sequence_parallel true \
    --cross_entropy_loss_fusion true \
    --lr 1e-4 \
    --lr_warmup_fraction 0.05 \
    --min_lr 1e-5 \
    --max_epochs 2 \
    --save "$OUTPUT_PATH" \
    --split_dataset_ratio 0.02 \
    --save_interval 25 \
    --max_length 8192 \
    --finetune false \
    --num_workers 4 \
    --no_load_rng true \
    --no_load_optim true \
    --no_save_optim true \
    --no_save_rng true \
    --dataset_num_proc 4 \
    --model_author swift \
    --model_name swift-robot
```
还没支持按epoch存储。

### Q162: 请问下，遇到这个报错，怎么处理？安装了apex也不行
```text
RuntimeError: ColumnParallelLinear was called with gradient_accumulation_fusion set to True but the custom CUDA extension fused_weight_gradient_mlp_cuda module is not found. To use gradient_accumulation_fusion you must install APEX with --cpp_ext and --cuda_ext. For example: pip install --global-option="--cpp_ext" --global-option="--cuda_ext ." Note that the extension requires CUDA>=11. Otherwise, you must turn off gradient accumulation fusion.
```
设置一下`--no_gradient_accumulation_fusion true`。

### Q163: moe的lora训练，target_modules参数设置了all-linear，是包括了路由器模块吗？
看gate是否是nn.Linear实现，如果是nn.Parameter就不训练，详见命令行参数[target_parameters](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#tuner)。

### Q164: grpo训练colocate模式不支持use_async_engine吗？
不支持。

### Q165: qlora训练后的模型可以merge吗？
参考[qlora例子](https://github.com/modelscope/ms-swift/tree/main/examples/train/qlora)。

## 推理

### Q1:swift推理有文档吗？
swift支持python脚本、命令行、ui界面推理，详见[推理和部署](https://swift.readthedocs.io/zh-cn/latest/Instruction/Inference-and-deployment.html)。

### Q2: 训练后的模型如何使用数据集推理？
参数`--load_data_args true`或`--val_dataset <your-val-dataset>`，见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q3: swift推理的时候可以指定下载好的模型吗？
`--model`配置本地路径即可，详见[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q4: 我想在一个没有label的数据集上推理，怎么做呢？我看文档里面的数据集格式都是训练集
配置参数`--val_dataset <your-val-dataset>`。

### Q5: 遇到报错ValueError: Input length of input_ids is 35, but `max_length` is set to 20.如何解决？
```text
raise ValueError(
ValueError: Input length of input_ids is 35, but `max_length` is set to 20. This can lead to unexpected behavior. You should consider increasing `max_length` or, better yet, setting `max_new_tokens`.
```
设置`model.generation_config.max_new_tokens`。

### Q6: qwen2-vl推理（训练）爆显存
设置命令行参数`--max_pixels xxx`、环境变量`MAX_PIXELS=xxx`、或特定模型参数`--model_kwargs '{"max_pixels": xxx}'`，其中环境变量仅对文档中对应的模型生效，详见文档[特定模型参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id18)。

### Q7: v100显卡，在python虚拟环境中，参考https://swift2x.readthedocs.io/zh-cn/latest/Multi-Modal/qwen2-vl%E6%9C%80%E4%BD%B3%E5%AE%9E%E8%B7%B5.html 完成环境准备，在测试推理命令：CUDA_VISIBLE_DEVICES=0,1,2,3 swift infer --model_type qwen2-vl-7b-instruct 时报错：RuntimeError: probability tensor contains either `inf`, `nan` or element < 0
尝试用A10或者3090机器推理。

### Q8: 运行下面命令，预测之后的结果在哪里？CUDA_VISIBLE_DEVICES=0 swift infer --ckpt_dir output/glm4v-9b-chat/vx-xxx/checkpoint-xxx-merged --load_data_args true
日志中会打印路径。

### Q9: 现在最新的swift版本，infer命令能通过logprobs参数输出概率值吗？
可以输出logprobs，命令行推理设置`--logprobs true`，python脚本推理设置`request_config = RequestConfig(..., logprobs=True, top_logprobs=2)`，参考[test_logprobs.py](https://github.com/modelscope/ms-swift/blob/main/tests/infer/test_logprobs.py)。

### Q10: vllm会报错，assert factor in rope_scaling
详见qwen2-vl [issue#96](https://github.com/QwenLM/Qwen2.5-VL/issues/96)。

### Q11: vllm作为推理后端的话，模型必须合并以后才能调用吗？
可以不合并，详见文档[命令行参数](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html)。

### Q12: 请问在使用python脚本推理时，如何使用cpu?
设置环境变量，`os.environ['CUDA_VISIBLE_DEVICES'] = '-1'`。

### Q13: 有人遇到过这个问题吗?RuntimeError: "triu_tril_cuda_template" not implemented for'BFloat16'
升级torch,这个版本的torch没实现这个算子。

### Q14: qwen2-audio支持流式推理吗？
支持，详见[issue](https://github.com/modelscope/ms-swift/issues/1653)

### Q15: inference client推理多模态，do_sample在哪里设置？
设置`temperature=0`。

### Q16: ms-swift支持大模型批处理不？
支持的。详见[demo](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo.py)。

### Q17: ms-swift量化模型的时候，显示内存不足，可以在量化的时候少占用一些资源吗，慢一点没关系。
尝试设置`--device_map cpu`。

### Q18: swift支持对多模态模型量化吗？
支持。

### Q19: 使用GPTQ报错如下，请问是啥原因？
```text
if llm_config['architectures'][0] == 'LlamaForCausalLM':
KeyError: 'architectures'
```
尝试transformers==4.44.*版本。

### Q20: swift infer如何将评估的结果保存到指定文件呢 每次都不知道保存到哪里了
设置`--result_path your_path`，详见[InferArguments](https://github.com/modelscope/ms-swift/blob/main/swift/arguments/infer_args.py)。

### Q21: AWQ量化yi-vl-6b出错如下：
```text
TypeError: swift.llm.utils.model.get_model_tokenizer_with_flash_attn() got multiple values for keyword argument 'automodel_class'.
```
请使用gptq量化。

### Q22: 想问一下用swift export对qwen2.5 72B模型进行gptq int4量化，max model length=32768用的是默认值，给的校准数据集有128个样本，但是量化的时候报错了，报错日志是：factorization could not be completed because the input is not positive-definite(the leading minor of order 18145 is not pisitive-definite)。是什么原因？
海森矩阵不正定的问题，试试其他的数据集。

### Q23: 请问批量推理是只能自己编写代码运行吗？不可以按照 sft 那样填脚本参数码
可以，`swift infer --val_dataset xxx --max_batch_size 16 ... `

### Q24: 问一下，swift app推理时，temperature默认是多少的？
默认从generation_config.json中读取。

### Q25: 请问，导出和量化的时候可以多卡吗？
加载模型可以多卡，量化是单卡。

### Q26: swift export的时候传入自定义的template_type,是不是就可以永久改掉template_type了？如果swift export --template_type 自定义,是不是就可以把模型对应的template改掉
不会被修改,swift中的template是定义在swift内部的,不是以jinja方式保存的。

### Q27: awq量化Qwen2VL报错：TypeError: Qwen2VLForConditionalGeneration.__init__() got an unexpected keyword argument 'use_cache'
用`gptq`量化。

### Q28: ddp 推理，infer里面的这个max_batch_size，是指每张卡的batch_size还是总的batch_size
每张卡。

### Q29: 请问swift.inference现在支持messages格式的输入吗？现在看到好像只能用query格式，得到response。数据answer里面已经包含了部分prompt，希望补全answer，应该怎么修改inference
```text
{"messages": [{"role": "system", "content": "<system>"}, {"role": "user", "content": "<query1>"}, {"role": "assistant", "content": "answer1, "}]}
```
用swift3是可以的，参考[examples/infer/demo_agent](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo_agent.py)。

### Q30: 请问swift infer的时候，如何让结果实时写入result_path，而不是最后一次性写入呢？
```shell
swift infer \
--ckpt_dir model_dir \
--streaming true \
--val_dataset dataset.jsonl \
--result_path result.jsonl
```
`--stream true`，这样可以一条条写，不过是非batch推理的。

### Q31: 我在swift训练推理的时候是有效果的，但是用merge_lora后再通过ollama的api开接口的时候效果就没了
试试transformers加载，swift的template是对齐transformers的。

### Q32: 模型推理的时候如果需要在特定前缀下继续推理的话是设置哪个参数？
参数`--response_prefix`。

### Q33: 一直报这个错怎么改呀？
```text
File "/mnt/workspace/swift/swift/1lm/dataset/preprocessor/core. py", line 69, in _check_messages raise
ValueError(f'assistant_message; {assistant_message}')
ValueError: assistant_message: {'role' :'assistant', 'content': ''}
```
```shell
CUDA_VISIBLE_DEVICES=0 NPROC_PER_NODE=1 MAX_PIXELS=1003520 swift sft --model Qwen/Qwen2.5-VL-7B-Instruct --train_type lora --dataset /mnt/workspace/data.json --deepspeed zero2 --max_length 16384
```
数据集assistant字段为空，如果是推理，把这个空字符串删掉，因为这个会导致训练时nan，会做检查。

### Q34: 推理报错，ImportError: cannot import name 'shard_checkpoint' from 'transformers.modeling_utils' (/usr/local/lib/python3.10/dist-packages/transformers/modeling_utilspy）
尝试卸载autoawq。

### Q35: swift sample的时候，好像不支持batch？好像是for循环一个个例子sample，有点慢
有一个[脚本](https://github.com/modelscope/ms-swift/blob/main/examples/train/rft/rft.py)，可以用多进程对数据集拆分采样。

### Q36: 请问swift支持embedding模型的推理吗？
参考这里的[例子](https://github.com/modelscope/ms-swift/blob/main/examples/infer/demo_embedding.py)。

### Q37: swift框架推理支持模型或者张量并行么？训练不会oom，推理时候报oom了
```shell
CUDA_VISIBLE_DEVICES=0,1 \
MAX_PIXELS=1003520 \
swift infer \
    --adapters /path/to/checkpoint-xxx \
    --merge_lora true \
    --infer_backend vllm \
    --load_data_args true \
    --vllm_gpu_memory_utilization 0.9 \
    --vllm_tensor_parallel_size 2 \
    --vllm_max_model_len 32768 \
    --max_new_tokens 15536 \
    --vllm_limit_mm_per_prompt '{"image": 8, "video": 2}'
```
```text
Failed: Cuda error /workspace/csrc/custom_all_reduce.cuh:368 'invalid argument'
```
加一下`--disable_custom_all_reduce true`。

### Q38: 请问流式推理支持ddp吗？
流式不支持ddp。

### Q39: 在Ovis2-2B推理的过程中出现的问题
```text
[rank1]: safetensors_rust.SafetensorError: Error while deserializing header:MetadataIncompleteBuffer
Downloading Model from https://www.modelscope.cn to directory:/mnt/workspace/.cache/modelscope/hub/models/AIDC-AI/Ovis2-2B
```
模型权重损坏了。

### Q40: 问一个问题，请问在grpo训练中如果做贪心搜索那么如何设置呢？文档中有说推理时可通过temprature=0设置为贪心搜索但是训练如果这样设置，计算logits / self.temperature，logits会出现很多nan，是不是将temperature设置为1，topk设置为1，topp也设置为1，模型推理就是贪心搜索的结果呢？
topk设置成1就可以了。

### Q41: 请问下，swift做量化时，gptq/awq/fp8三种方法分别是针对activation和weight中的哪个做的量化呢？
只有权重。

### Q42: 请问用ms-swift推理时transformers engine和vllm engine，推理结果差了很多，这个是什么原因呢？
看看参数有没有对齐。此外，VllmEngine和TransformersEngine是有差异的，TransformersEngine和transformers推理是对齐的。

### Q43: 请问用swift做qwen2audio的推理，推理结果出现混乱，可能是啥原因呢？
使用transformers4.48。

### Q44: 多卡推理，--max_batch_size是所有卡加起来的batch_size吗？
不是，是每张卡的。

### Q45: 推理只能传图片路径吗？有没有办法传Image对象？
可以传`PIL.Image`。

### Q46: swift训练的模型不能通过modelscope加载，怎么解决的？
详见[issue#5440](https://github.com/modelscope/ms-swift/issues/5440)，transformers4.55.2训练的LoRA不能使用小于4.52的版本加载了。

### Q47: 有没有示例脚本支持大模型推理的时候输出last_hidden_state？
没有，可以参考grpo trainer的`_get_last_hidden_state`方法。

### Q48: 请问，用--init_weights lora-ga微调完的adaper，推理的时候会报这种错误，如何解决？
```text
raise ValueError(f"Unknown initialization {init_lora_weights=}") ValueError: Unknown initialization init_lora_weights='lora-ga'
```
在你的checkpoint文件夹里面有一个叫converted的文件夹，用那个。

### Q49: 使用swift infer命令进行推理，支持多机推理吗？
如果单节点放得下模型，外面封装k8s就行。如果单节点放不下那就不支持。

### Q50: 推理时如何计算acc/rouge等指标？
参考[推理参数metric](https://swift.readthedocs.io/zh-cn/latest/Instruction/Command-line-parameters.html#id14)。

### Q51: 如何将system_prompt置空？我删除了--system参数，但是它会给我加上默认的system。
设置`--system ''`。

### Q52: 推理数据里面有一个extra字段，推理结果没法保存这个字段，应该如何设置才能保存额外的字段呢？
设置`--remove_unused_columns false`。

## 部署

### Q1: 如何部署训练后的模型？
`swift deploy --adapters xxx`，见文档[推理和部署](https://swift.readthedocs.io/zh-cn/latest/Instruction/Inference-and-deployment.html)。

### Q2: 如何使用vllm部署进行多卡部署？
详见[例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy)。

### Q3: 请问用vllm部署的时候，客户端怎么传入图片？
详见[客户端例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client/mllm)。

### Q4: 有个问题想问一下，qwen2-7b部署后使用客户端时，调用openai的api要使用client.completions.create，不能使用client.chat.completions.create，但是使用qwen2-7b-instruct-q5_k_m.gguf的时候可以使用client.chat.completions.create，这是为什么呀？
base模型可以用client.chat.completions.create的，不过这个是兼容行为。

### Q5: 使用两张卡用swift deploy启动服务端后，用Ctrl+C退出后，会一直有一个python进程，一直占用一张卡的显存，这是正常现象吗？
需要kill 一下, 这是vllm的问题。

### Q6: 在哪查看模型是否支持lmdeploy或vllm加速？
vllm和lmdeploy分别有自己的模型支持范围，请查看各自官方文档来确定是否可用。

### Q7: 通义千问2.5-数学-7B-Instruct，会偶尔这样一直返回乱码，是什么问题呢？用vllm部署，fp16。
尝试bf16。

### Q8: swift推理服务启动后，交互进行设置的温度之类的配置，如何设置呢？
推理只能启动前设置。部署可以在启动时设置默认，之后在客户端继续设置，覆盖默认。

### Q9: 在本地部署qwen2vl模型，推理后端使用vllm，本地视频怎么传入呢？可以使用 base64 传进去吗？curl调用如何加载视频呢？
base64，详见[mllm客户端例子](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client/mllm)

### Q10: qwen2-vl部署时报错如下，是vllm的版本不对么？
```text
Unrecognized keys in `rope_scaling`for 'rope_type'='default': {'mrope_section'} Unrecognized keys in `rope_scaling`for 'rope_type'='default': {'mrope_section'}
```
详见[issue](https://github.com/QwenLM/Qwen2.5-VL/issues/209)。

### Q11: 我用swift deploy做推理的时候，想让他输出token的概率，我加了logprobs True，但是它输出null，这个是什么原因呢？
```shell
RAY_memory_monitor_refresh_ms=0 CUDA_VISIBLE_DEVICES=1 nohup swift deploy --ckpt_dir /mnt/workspace/checkpoint_600 --infer_backend vllm --logprobs True --load_data_args false --host 0.0.0.0 --port 8000 &
```
需要客户端传参数，`request_config = RequestConfig(..., logprobs=True, top_logprobs=2)`。

### Q12: swift3.0 部署推理，可以设置请求的超时时间么？如果图片url非法，会等在那里
设置环境变量`SWIFT_TIMEOUT`。或者`InferClient`中可以传参数。

### Q13: swift部署的模型怎么没法流式生成啊？服务端的stream设为True了，客户端的stream也设为True了，但它就是没法流式生成
客户端控制的，查看[examples/deploy/client](https://github.com/modelscope/ms-swift/tree/main/examples/deploy/client)。

### Q14: swift部署好多模态模型之后，客户端传PIL.Image，有示例没?
看这个[client例子](https://github.com/modelscope/ms-swift/blob/main/examples/deploy/client/mllm/openai_client.py)。

### Q15: 请问 deploy部署时候，设置什么参数可以实现一次输出，输出多个结果呢？
`RequestConfig`参数`n`。

### Q16: 比使用 swift deploy 部署，指定参数为 --infer_backend vllm，直接使用 vllm 部署：vllm serve ，效果差了接近10个点，有人知道什么原因不？
估计是template没对上。

### Q17: 部署命令怎么关闭qwem3的深度思考模式？
查看这个[issue](https://github.com/modelscope/ms-swift/issues/4030)。

### Q18: 请问，我用ms-swift的vllm部署推理，比原生vllm要慢很多，这个是swift框架的问题嘛？
main分支应该默认使用V1 engine了，加一个`VLLM_USE_V1=1`试试，还有是图像分辨率，要对齐一下。

### Q19: 如果swift部署用vllm加速，能分别指定不同卡上使用显存的比例吗？
不支持异构。

### Q20: 模型保存后，好像无法被vllm读取，会报错没有“model.language_model.embed_tokens.weight”，有解法吗？
训练前后的transformers版本需要一致。

### Q21: 通过--system参数指定system prompt与数据集中每个数据前加system prompt以及template的system prompt是不是有一个就行？这些方式对模型来说，是不是一样的？
system优先级：数据集中的>命令行的>template中默认的。

### Q22: swift transformers engine部署模型后，推理无法并行，数据也没办法分配到其他显卡上，用的全是第一张卡。
尝试swift infer，deploy不支持DDP。

### Q23: swift deploy部署的模型，怎么在客户端禁止thinking？我在请求的时候加了extra body也不行。
现在只能在swift deploy启动的时候禁止thinking。

## 评测

### Q1: swift支持的评测集有哪些？
纯文本评测：
```text
'obqa', 'cmb', 'AX_b', 'siqa', 'nq', 'mbpp', 'winogrande', 'mmlu', 'BoolQ', 'cluewsc', 'ocnli', 'lambada',
'CMRC', 'ceval', 'csl', 'cmnli', 'bbh', 'ReCoRD', 'math', 'humaneval', 'eprstmt', 'WSC', 'storycloze',
'MultiRC', 'RTE', 'chid', 'gsm8k', 'AX_g', 'bustm', 'afqmc', 'piqa', 'lcsts', 'strategyqa', 'Xsum', 'agieval',
'ocnli_fc', 'C3', 'tnews', 'race', 'triviaqa', 'CB', 'WiC', 'hellaswag', 'summedits', 'GaokaoBench',
'ARC_e', 'COPA', 'ARC_c', 'DRCD'
```

多模态评测：
```text
'COCO_VAL', 'MME', 'HallusionBench', 'POPE', 'MMBench_DEV_EN', 'MMBench_TEST_EN', 'MMBench_DEV_CN', 'MMBench_TEST_CN',
'MMBench', 'MMBench_CN', 'MMBench_DEV_EN_V11', 'MMBench_TEST_EN_V11', 'MMBench_DEV_CN_V11',
'MMBench_TEST_CN_V11', 'MMBench_V11', 'MMBench_CN_V11', 'SEEDBench_IMG', 'SEEDBench2',
'SEEDBench2_Plus', 'ScienceQA_VAL', 'ScienceQA_TEST', 'MMT-Bench_ALL_MI', 'MMT-Bench_ALL',
'MMT-Bench_VAL_MI', 'MMT-Bench_VAL', 'AesBench_VAL', 'AesBench_TEST', 'CCBench', 'AI2D_TEST', 'MMStar',
'RealWorldQA', 'MLLMGuard_DS', 'BLINK', 'OCRVQA_TEST', 'OCRVQA_TESTCORE', 'TextVQA_VAL', 'DocVQA_VAL',
'DocVQA_TEST', 'InfoVQA_VAL', 'InfoVQA_TEST', 'ChartQA_TEST', 'MathVision', 'MathVision_MINI',
'MMMU_DEV_VAL', 'MMMU_TEST', 'OCRBench', 'MathVista_MINI', 'LLaVABench', 'MMVet', 'MTVQA_TEST',
'MMLongBench_DOC', 'VCR_EN_EASY_500', 'VCR_EN_EASY_100', 'VCR_EN_EASY_ALL', 'VCR_EN_HARD_500',
'VCR_EN_HARD_100', 'VCR_EN_HARD_ALL', 'VCR_ZH_EASY_500', 'VCR_ZH_EASY_100', 'VCR_ZH_EASY_ALL',
'VCR_ZH_HARD_500', 'VCR_ZH_HARD_100', 'VCR_ZH_HARD_ALL', 'MMDU', 'MMBench-Video', 'Video-MME'
```

详见文档[评测](https://swift.readthedocs.io/zh-cn/latest/Instruction/Evaluation.html)。

### Q2: 如何使用自定义评测集？
纯文本、多模态自定义评测集必须和某个官方评测集数据格式（pattern）保持一致，见文档[评测](https://swift.readthedocs.io/zh-cn/latest/Instruction/Evaluation.html)。

### Q3: python3.11环境，评测时mmengine报错
尝试python3.10环境。或先安装全量依赖： `pip3 install evalscope[all]`，再打patch： `pip3 install https://modelscope-open.oss-cn-hangzhou.aliyuncs.com/package/evalscope-0.5.3.post1-py3-none-any.whl`。

### Q4: 官方支持的评测数据集手动下载后，swift eval能配置本地路径评测吗？
先下载评测数据集[eval.zip](https://modelscope.cn/datasets/swift/evalscope_resource/files)，解压后将里面的内容放到 `~/.cache/modelscope/media_resources/evalscope/data`文件夹下；再执行swift eval命令就可以使用本地数据。

### Q5: 自定义评测是不是有bug，把标准例子改成英文，一直都跑不通？
```shell
swift eval --model_type 'qwen2_5-1_5b-instruct' --eval_dataset no --custom_eval_config '/mnt/workspace/test_data/config_eval.json'
```
这是依赖了nltk的包，然后nltk的tokenizer需要下载一个punkt_tab的zip文件，国内有些环境下载不太稳定或者直接失败。已尝试改了代码做兜底，规避这个问题；参考[issue](https://github.com/nltk/nltk/issues/3293)。

### Q6: eval微调后的模型，总是会在固定的百分比停掉，但是vllm服务看着一直是有在正常运行的。模型越大，断开的越早。
`SWIFT_TIMEOUT`环境变量设置为-1。

### Q7: evalscope 支持多模型对比吗？
详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/arena.html)。

### Q8: 多模态数据集有没有自定义评估？
多模态自定义评估可以参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/advanced_guides/custom_dataset/index.html)。

### Q9: ms-swift有方法测试qps，延迟，tokens/s吗？
可以尝试使用evalscope的[模型推理性能压测](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/index.html)。

### Q10: 评估的时候可不可以控制数据集条数？评估一个mmlu需要一个多小时，也太慢了。
配置参数`--eval_limit`，这里的`--eval_limit`是控制了每个subset的条数，比如mmlu有50多个subset，每个limit10条，那就是500多条。

### Q11: 想请问一下，评测时不是相当于让模型输出一次回答然后检查答案对不对吗，有没有办法可以记录或看到每次完整的回答呢？
ceval这种多选题的评测是通过计算每个选项的logits来得到的，没有输出回答内容；想得到回答内容的话，可以部署模型服务指定api url来评测，这样是通过解析模型输出来评测的，详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/get_started/basic_usage.html#api)，后面这两种可以做成可选项。

### Q12: 我想用evalscope压测一下我的模型，想采用prompt.txt文件的形式，这个文件内容的格式应该是什么样子的呀？
配置line_by_line，详见[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/parameters.html#id5)。

### Q13: 使用evalscope perf进行模型推理性能压测，parallel和number这两个参数怎样使用呢？
number是请求的总数量，parallel是并发数量。

### Q14: 问一下评估swift eval里，模型最多生成1024token就结束了，这个如何修改？设置--max_new_tokens 5000，看起来没起作用
swift里面这个参数还没透出，可以使用evalscope来运行，model里面配置max_tokens参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/vlmevalkit_backend.html#id6)。

### Q15: 请问evalscope现在支持deepseek-r1 的相关benchmark吗？AIME、MATH-500这样
支持的，这里有[最佳实践](https://evalscope.readthedocs.io/zh-cn/latest/best_practice/deepseek_r1_distill.html)。

### Q16: 想问一下evalscope测评gpqa使用本地路径报错： ValueError: BuildingConfig 'gpqa_extended' not found. Available: ['default']
参数配置如下：
```shell
 --datasets gpqa --dataset-args '{"gpqa": {"local_path": "/mnt/workspace/gpqa"} }'
 ```
数据集如果要下载到本地使用，建议从modelscope上克隆仓库再指定路径。

### Q17: 用evalscope评测arc数据集的时候，报这个错误，这是什么原因呢，用的是加载本地数据路径方式
```text
KeyError: 'RequestId'
```
```shell
--datasets arc --dataset-args '{"arc": {"local_path": "/mnt/workspace/arc"}}'
```
参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/get_started/basic_usage.html#id10)，arc数据集本身需要通过py脚本来下载数据，直接clone仓库不行。

### Q18: 请教一下，想使用opencompass的后端评测，如何从本地加载下载好的数据集？
opencompass后端不支持设置`data_args`。

### Q19: swift eval 来评估模型，--eval_backend OpenCompass不支持自定义数据集吗？
```text
ValueError: eval_dataset: /mnt/workspace/data.jsonl is not supported.
eval_backend: OpenCompass supported datasets: ['C3', 'summedits', 'WiC', 'csl', 'lambada', 'mbpp', 'hellaswag', 'ARC_e', 'math', 'nq', 'race', 'MultiRC', 'cmb', 'ceval', 'GaokaoBench', 'mmlu', 'winogrande', 'tnews', 'triviaqa', 'CB', 'cluewsc', 'humaneval', 'AX_g', 'DRCD', 'RTE', 'ocnli_fc', 'gsm8k', 'obqa', 'ReCoRD', 'Xsum', 'ocnli', 'WSC', 'siqa', 'agieval', 'piqa', 'cmnli', 'cmmlu', 'eprstmt', 'storycloze', 'AX_b', 'afqmc', 'strategyqa', 'bustm', 'BoolQ', 'COPA', 'ARC_c', 'PMMEval', 'chid', 'CMRC', 'lcsts']
```
opencompass不支持自定义数据集，用native可以自定义模式。

### Q20: 我在本地用单张A100运行模型来做evalscope官方文档里的[RAGAS评测任务](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/rageval_backend/ragas.html)时，跑文档中的两个样例花费了10分钟的时间，请问这是正常的么？有没有什么办法可以优化运行速度。
rag评测本身确实比较耗资源，使用本地critic llm确实会慢一些，处理不了batch请求，建议用vllm这样的框架来拉起任务。

### Q21: 用evalscope评测RAG，但是嵌入式模型我也想用 API 方式调用，支持吗？我看文档上没有写
目前embedding模型还没支持API调用，后续会支持。

### Q22: 使用evalscpoe测试本地训练后的模型，测试数据输出是很简单的，但是训练模型的时候数据构造的是推理的方式，这样测试结果就比较低，请问evalscope怎么仅仅使用模型输出里<answer>xxx</answer>里的数据测试？
dataset-args中设置 {"filters": {"remove_until": "</think>"}} ，参考这个[文档](https://evalscope.readthedocs.io/zh-cn/latest/get_started/parameters.html#id3)。设置这个参数，计算指标的时候会去掉`<think>`。

### Q23: evalscope原生是可以生成报告的 其他后端如opencompass是不支持生成报告可视化是吗？
目前只支持native的可视化，其他后端还不支持。

### Q24: 请问一下评测ifeval报这个错是什么原因？
```text
[Errno 20] Not a directory: '/root/nltk_data/tokenizers/punkt_tab.zip/punkt_tab/english/collocations.tab'
```
解压这个文件，`unzip /path/to/nltk_data/tokenizers/punkt_tab.zip`。

### Q25: 请问评测时eval_backend='OpenCompass'，怎么指定离线数据集路径？
查看[数据准备教程](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/opencompass_backend.html#id3)，下载数据集并解压。不用指定`dataset-args`，将数据集文件夹（即data文件夹）放置在当前工作路径下即可。

### Q26: 用evalscope报这个错是什么原因
```text
unzip: cannot find or open /root/nltk_data/tokenizers/punkt_tab.zip, /root/nltk_data/tokenizers/punkt_tab.zip.zip or /root/nltk_data/tokenizers/punkt_tab.zip.ZIP
```
这是在下载nltk的依赖，手动下载[punkt_tab.zip](https://modelscope-open.oss-cn-hangzhou.aliyuncs.com/open_data/nltk_data/punkt_tab.zip)，解压到`~/nltk_data/tokenizers`下面。

### Q27: 为啥纯文本没问题，测多模态我们指定路径了，但他还是检测不到数据集，会去下载？
vlmevalkit流程跟native不一样，会自己下载数据放到`~/LMUData/`下面。

### Q28: 请教下，evalscope的score是如何计算的，这部分有文档说明吗？
请参考这个[issue](https://github.com/modelscope/evalscope/issues/610)。

### Q29: 请问一下swift eval做benchmark评测的时候，是否可以指定llm作为judge, 参数应该怎么传进去？
支持，使用swift得从`extra_eval_args`去传递`judge-model-args`参数，包括`api_key，api_url，model_id`，整体是一个json字符串。

### Q30: 请问，思考模型怎么在response中去掉CoT再进行评测？vlmevalkit后端
这个后处理还不支持。

### Q31: 请问embedding评测，第一次运行会去官方下载数据集。可以下载后指定目录吗？
目前embedding评测，只有自定义的数据集才能指定路径。

### Q32: 请问怎么自定义评测指标？
是想在自定义的数据集上使用自定义的评测指标吗？目前还没有plugin的方式，需自行修改evalscope/benchmarks/general_qa/general_qa_adapter.py 里面的match方法。

### Q33: mmvet评测需要配置judge model，按这个[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/backend/vlmevalkit_backend.html#id12)配置judge model，裁判模型的名称一定要是这三个里面的吗？
```text
Traceback (most recent call last):
File "/usr/local/lib/python3.10/dist-packages/vlmeval/run.py", line 484, in run_task eval_results = dataset.evaluate(result_file,**judge_kwargs )
File "/usr/local/lib/python3.10/dist-packages/vlmeval/dataset/image_mcq.py", line 244, in evaluate assert model in ['chatgpt-0125'， 'exact_matching'，'gpt-4-0125'] AssertionError
```
```python
task_cfg_dict = TaskConfig(
    work_dir='outputs',
    eval_backend='VLMEvalKit',
    eval_config={
        'data': ['MMVet', 'DocVQA_VAL', 'MMBench_DEV_EN'],
        'limit': 20,
        'mode': 'all',
        'model': [
            {'api_base': 'http://127.0.0.1:8001/v1/chat/completions',
            'key': 'EMPTY',
            'name': 'CustomAPIModel',
            'temperature': 0.0,
            'type': 'Qwen2.5-VL-72B-Instruct-AWQ',
            'img_size': -1,
            'video_llm': False,
            'max_tokens': 1024,}
            ],
        'reuse': False,
        'nproc': 100,
        'judge': 'exact_matching'}
)
```
对于多选题问答，是有这个要求，不然的话就指定exact_matching。试试MMBench跟MMVet的评测分开，不使用judge model。

### Q34: 请问在执行eval的时候出现了多卡显存分配不均是什么原因？
```shell
NPROC_PER_NODE=8
ASCEND_RT_VISIBLE_DEVICES=0,1,2,3,4,5,6,7\ MAX_PIXELS=802816\ swift eval\
--model "$MODEL_PATH” \$EXTRA_ARGS \
--eval_backend Native \ --infer_backend transformers\ --device_map auto \
--eval_limit"$EVAL_LIMIT"\ --eval_dataset general_qa\
--dataset_args "{\"general_qa\": {\"local_path\": \"${DATA_PATH}\", \"subset_list\": [\"${SUBSET_NAME}\"]}}" \ --host 127.0.0.1\> "$LOG_FILE" 2>&1
```
swift eval不支持ddp方式启动。

### Q35: 请问，使用evalscope评测 如何控制input token为固定长度？
控制长度只支持random数据集，参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/examples.html#random)。

### Q36: evalscope app找不到报告是怎么回事，outputs目录下明明有对应的记录
可能是推理性能压测，evalscope perf可视化参考[文档](https://evalscope.readthedocs.io/zh-cn/latest/user_guides/stress_test/examples.html#id5)。

### Q37: 请问哪里可以看到swift评测的时候送入的query除了问题之外还有哪些额外的字段呢？
最简单的方法是看输出的reviews文件中的input字段，是输入给模型的内容转换后的markdown格式。如果用backend是opencompass的话没有这些，需要用native backend。
