# 8 * 95GiB
# "cuda>=12.9"
# In this example, FP8 training does not provide any speedup.
PYTORCH_CUDA_ALLOC_CONF='expandable_segments:True' \
NPROC_PER_NODE=8 \
CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 \
megatron sft \
    --model Qwen/Qwen3-30B-A3B-Instruct-2507-FP8 \
    --load_safetensors true \
    --save_safetensors true \
    --fp8_recipe blockwise \
    --fp8_format e4m3 \
    --fp8_param_gather true \
    --dataset 'swift/Chinese-Qwen3-235B-2507-Distill-data-110k-SFT#2000' \
              'swift/self-cognition#1000' \
    --load_from_cache_file true \
    --tensor_model_parallel_size 2 \
    --expert_model_parallel_size 8 \
    --moe_permute_fusion true \
    --moe_grouped_gemm true \
    --moe_shared_expert_overlap true \
    --moe_aux_loss_coeff 1e-6 \
    --micro_batch_size 4 \
    --global_batch_size 16 \
    --recompute_granularity full \
    --recompute_method uniform \
    --recompute_num_layers 1 \
    --max_epochs 1 \
    --finetune true \
    --cross_entropy_loss_fusion true \
    --lr 1e-5 \
    --lr_warmup_fraction 0.05 \
    --min_lr 1e-6 \
    --save megatron_output/Qwen3-30B-A3B-Instruct-2507-FP8 \
    --eval_interval 200 \
    --save_interval 200 \
    --max_length 2048 \
    --num_workers 8 \
    --dataset_num_proc 8 \
    --no_save_optim true \
    --no_save_rng true \
    --sequence_parallel true \
    --moe_expert_capacity_factor 2 \
    --use_precision_aware_optimizer true \
    --exp_avg_dtype bf16 \
    --exp_avg_sq_dtype bf16 \
    --attention_backend flash \
    --model_author swift \
    --model_name swift-robot

# CUDA_VISIBLE_DEVICES=0 \
# swift infer \
#     --model megatron_output/Qwen3-30B-A3B-Instruct-2507-FP8/vx-xxx/checkpoint-xxx \
#     --stream true

# CUDA_VISIBLE_DEVICES=0 \
# swift infer \
#     --model megatron_output/Qwen3-30B-A3B-Instruct-2507-FP8/vx-xxx/checkpoint-xxx \
#     --infer_backend vllm \
#     --vllm_max_model_len 8192 \
#     --stream true
