# mcore>=0.15
# 2 * 40GiB
# dataset format: https://github.com/modelscope/ms-swift/pull/5277
PYTORCH_CUDA_ALLOC_CONF='expandable_segments:True' \
NPROC_PER_NODE=2 \
CUDA_VISIBLE_DEVICES=0,1 \
megatron sft \
    --model openai-mirror/gpt-oss-20b \
    --load_safetensors true \
    --save_safetensors true \
    --merge_lora true \
    --dataset 'AI-ModelScope/alpaca-gpt4-data-zh#500' \
              'AI-ModelScope/alpaca-gpt4-data-en#500' \
              'swift/self-cognition#500' \
    --train_type lora \
    --lora_rank 8 \
    --lora_alpha 32 \
    --target_modules all-linear \
    --expert_model_parallel_size 2 \
    --moe_permute_fusion true \
    --moe_grouped_gemm true \
    --moe_shared_expert_overlap true \
    --moe_aux_loss_coeff 1e-6 \
    --micro_batch_size 8 \
    --global_batch_size 16 \
    --recompute_granularity full \
    --recompute_method uniform \
    --recompute_num_layers 1 \
    --max_epochs 1 \
    --finetune true \
    --cross_entropy_loss_fusion true \
    --lr 1e-4 \
    --lr_warmup_fraction 0.05 \
    --min_lr 1e-5 \
    --save megatron_output/gpt-oss-20b \
    --eval_interval 100 \
    --save_interval 100 \
    --max_length 2048 \
    --num_workers 4 \
    --dataset_num_proc 4 \
    --no_save_optim true \
    --no_save_rng true \
    --sequence_parallel true \
    --padding_free false \
    --attention_backend unfused \
    --model_author swift \
    --model_name swift-robot

# CUDA_VISIBLE_DEVICES=0 \
# swift infer \
#     --model megatron_output/gpt-oss-20b/vx-xxx/checkpoint-xxx \
#     --stream true
