/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.SampleModel;

public class BLPPackedSampleModel
extends SampleModel {
    private final int[] bandSizes;
    private final int[] bandOffsets;
    private final int[] bands;

    public BLPPackedSampleModel(int w, int h, int[] bandSizes, int[] bands) {
        super(0, w, h, bands != null ? bands.length : bandSizes.length);
        int i = 0;
        while (i < bandSizes.length) {
            int bandSize = bandSizes[i];
            if (bandSize < 1 || 8 < bandSize) {
                throw new IllegalArgumentException("Invalid bandSizes.");
            }
            ++i;
        }
        this.bandSizes = (int[])bandSizes.clone();
        this.bandOffsets = new int[bandSizes.length + 1];
        i = 0;
        while (i < bandSizes.length) {
            int baseOffset = this.bandOffsets[i];
            int bandSize = bandSizes[i];
            this.bandOffsets[i + 1] = baseOffset + (w * h * bandSize + 7) / 8;
            ++i;
        }
        if (bands == null) {
            bands = new int[bandSizes.length];
            i = 0;
            while (i < bands.length) {
                bands[i] = i;
                ++i;
            }
        } else {
            bands = (int[])bands.clone();
            i = 0;
            while (i < bands.length) {
                int bandref = bands[i];
                if (bandref < 0 || bandSizes.length <= bandref) {
                    throw new IllegalArgumentException("Invalid bands.");
                }
                ++i;
            }
        }
        this.bands = bands;
    }

    @Override
    public int getNumDataElements() {
        return this.numBands;
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        if (obj == null) {
            obj = new byte[this.numBands];
        }
        byte[] pixel = (byte[])obj;
        int i = 0;
        while (i < this.numBands) {
            pixel[i] = (byte)this.getSample(x, y, i, data);
            ++i;
        }
        return obj;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        byte[] pixel = (byte[])obj;
        int i = 0;
        while (i < this.numBands) {
            this.setSample(x, y, i, pixel[i], data);
            ++i;
        }
    }

    private int getPixelNumber(int x, int y) {
        return x + this.width * y;
    }

    private int getSamplePacking(int b) {
        return 8 / this.bandSizes[b];
    }

    private int getElementNumber(int pixelNumber, int samplePacking, int b) {
        return this.bandOffsets[b] + pixelNumber / samplePacking;
    }

    private int getSampleOffset(int pixelNumber, int samplePacking, int b) {
        return pixelNumber % samplePacking * this.bandSizes[b];
    }

    private int getSampleMask(int b) {
        return (1 << this.bandSizes[b]) - 1;
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        b = this.bands[b];
        int pixelNumber = this.getPixelNumber(x, y);
        int samplePacking = this.getSamplePacking(b);
        return data.getElem(this.getElementNumber(pixelNumber, samplePacking, b)) >> this.getSampleOffset(pixelNumber, samplePacking, b) & this.getSampleMask(b);
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        b = this.bands[b];
        int pixelNumber = this.getPixelNumber(x, y);
        int samplePacking = this.getSamplePacking(b);
        int elementNumber = this.getElementNumber(pixelNumber, samplePacking, b);
        int sampleOff = this.getSampleOffset(pixelNumber, samplePacking, b);
        int sampleMask = this.getSampleMask(b);
        data.setElem(elementNumber, data.getElem(elementNumber) & ~(sampleMask << sampleOff) | (s & sampleMask) << sampleOff);
    }

    @Override
    public BLPPackedSampleModel createCompatibleSampleModel(int w, int h) {
        return new BLPPackedSampleModel(w, h, this.bandSizes, this.bands);
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.numBands) {
            throw new IllegalArgumentException("Too many bands.");
        }
        boolean[] bandUsed = new boolean[this.bands.length];
        int[] destBands = new int[bands.length];
        int i = 0;
        while (i < bands.length) {
            int bandref = bands[i];
            if (bandref < 0 || this.bands.length <= bandref || bandUsed[bandref]) {
                throw new IllegalArgumentException("Invalid bands.");
            }
            bandUsed[bandref] = true;
            destBands[i] = this.bands[bandref];
            ++i;
        }
        return new BLPPackedSampleModel(this.width, this.height, this.bandSizes, destBands);
    }

    public int getBufferSize() {
        return this.bandOffsets[this.bandOffsets.length - 1];
    }

    @Override
    public DataBuffer createDataBuffer() {
        return new DataBufferByte(this.getBufferSize());
    }

    @Override
    public int[] getSampleSize() {
        int[] bandSizes = new int[this.numBands];
        int i = 0;
        while (i < this.numBands) {
            bandSizes[i] = this.bandSizes[this.bands[i]];
            ++i;
        }
        return bandSizes;
    }

    @Override
    public int getSampleSize(int band) {
        return this.bandSizes[this.bands[band]];
    }
}

