/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPCommon;
import com.hiveworkshop.blizzard.blp.BLPReader;
import com.hiveworkshop.blizzard.blp.ImageSpiCommon;
import com.hiveworkshop.lang.MagicInt;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class BLPReaderSpi
extends ImageReaderSpi {
    static final String READER_CLASS = "com.hiveworkshop.blizzard.blp.BLPReader";
    static final Class<?>[] INPUT_TYPES = new Class[]{ImageInputStream.class, File.class, Path.class};
    static final String[] WRITER_SPI_CLASSES = new String[]{"com.hiveworkshop.blizzard.blp.BLPWriterSpi"};

    public BLPReaderSpi() {
        super("Hive Workshop", "1.1", ImageSpiCommon.FORMAT_NAMES, ImageSpiCommon.FORMAT_SUFFIXES, ImageSpiCommon.FORMAT_MIMES, READER_CLASS, INPUT_TYPES, WRITER_SPI_CLASSES, false, ImageSpiCommon.NATIVE_STREAM_METADATA_NAME, ImageSpiCommon.NATIVE_STREAM_METADATA_CLASS, ImageSpiCommon.EXTRA_STREAM_METADATA_NAME, ImageSpiCommon.EXTRA_STREAM_METADATA_CLASS, false, ImageSpiCommon.NATIVE_IMAGE_METADATA_NAME, ImageSpiCommon.NATIVE_IMAGE_METADATA_CLASS, ImageSpiCommon.EXTRA_IMAGE_METADATA_NAME, ImageSpiCommon.EXTRA_IMAGE_METADATA_CLASS);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (source instanceof ImageInputStream) {
            ImageInputStream src = (ImageInputStream)source;
            ByteOrder originalByteOrder = src.getByteOrder();
            src.mark();
            try {
                src.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                MagicInt magic = new MagicInt(src.readInt(), ByteOrder.LITTLE_ENDIAN);
                if (BLPCommon.resolveVersion(magic) != -1) {
                    return true;
                }
            }
            finally {
                src.reset();
                src.setByteOrder(originalByteOrder);
            }
        }
        return false;
    }

    @Override
    public ImageReader createReaderInstance(Object arg0) throws IOException {
        return new BLPReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "BLP file image reader.";
    }
}

