/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPEncodingType;
import com.hiveworkshop.blizzard.blp.BLPIndexColorModel;
import com.hiveworkshop.blizzard.blp.BLPStreamMetadata;
import com.hiveworkshop.blizzard.blp.BLPWriteParam;
import com.hiveworkshop.blizzard.blp.ExternalMipmapManager;
import com.hiveworkshop.blizzard.blp.IndexedMipmapProcessor;
import com.hiveworkshop.blizzard.blp.InternalMipmapManager;
import com.hiveworkshop.blizzard.blp.JPEGMipmapProcessor;
import com.hiveworkshop.blizzard.blp.MipmapProcessor;
import com.hiveworkshop.lang.LocalizedFormatedString;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;

public class BLPWriter
extends ImageWriter {
    private int imageIndex = 0;
    private BLPStreamMetadata streamMetadata = null;
    private MipmapWriter mipmapWriter = null;
    private MipmapProcessor mipmapProcessor = null;
    private ImageOutputStream iosOutput = null;
    private boolean internalOutput = false;
    private boolean badOutput = false;
    private List<byte[]> mmDataList = null;
    private boolean canWriteMipmaps = false;

    public BLPWriter(ImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        BLPStreamMetadata smd = new BLPStreamMetadata();
        if (param instanceof BLPWriteParam) {
            BLPWriteParam blpParam = (BLPWriteParam)param;
            smd.setMipmaps(blpParam.isAutoMipmap());
            ImageTypeSpecifier its = blpParam.getDestinationType();
            if (its != null) {
                ColorModel cm = its.getColorModel();
                if (cm instanceof BLPIndexColorModel) {
                    smd.setEncoding(BLPEncodingType.INDEXED, (byte)cm.getComponentSize(cm.getNumColorComponents()));
                } else if (cm instanceof IndexColorModel) {
                    smd.setEncoding(BLPEncodingType.INDEXED, (byte)0);
                } else {
                    smd.setEncoding(BLPEncodingType.JPEG, (byte)(cm.hasAlpha() ? 8 : 0));
                }
            }
        }
        return smd;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return this.getDefaultStreamMetadata(param);
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new BLPWriteParam();
    }

    protected void processWarningOccurred(LocalizedFormatedString msg, int level) {
        if (this.warningListeners == null) {
            return;
        }
        if (msg == null) {
            throw new IllegalArgumentException("msg is null.");
        }
        int numListeners = this.warningListeners.size();
        int i = 0;
        while (i < numListeners) {
            IIOWriteWarningListener listener = (IIOWriteWarningListener)this.warningListeners.get(i);
            Locale locale = (Locale)this.warningLocales.get(i);
            if (locale == null) {
                locale = Locale.getDefault();
            }
            listener.warningOccurred(this, level, msg.toString(locale));
            ++i;
        }
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int mmCount;
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("Cannot encode raster.");
        }
        if (this.output == null) {
            throw new IllegalStateException("No output.");
        }
        if (this.badOutput) {
            throw new IIOException("Cannot write to stream.");
        }
        if (this.iosOutput == null) {
            if (this.output instanceof File) {
                this.iosOutput = new FileImageOutputStream((File)this.output);
                this.internalOutput = true;
            } else if (this.output instanceof Path) {
                this.iosOutput = new FileImageOutputStream(((Path)this.output).toFile());
                this.internalOutput = true;
            } else if (this.output instanceof ImageOutputStream) {
                this.iosOutput = (ImageOutputStream)this.output;
            } else {
                throw new IllegalStateException("Unsupported output.");
            }
            if (this.iosOutput.length() > 0L) {
                this.badOutput = true;
                throw new IIOException("Stream not empty.");
            }
        }
        RenderedImage im = image.getRenderedImage();
        if (param == null) {
            param = this.getDefaultWriteParam();
            param.setDestinationType(new ImageTypeSpecifier(im));
        }
        Rectangle sourceRegion = new Rectangle(0, 0, im.getWidth(), im.getHeight());
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        Point destOff = new Point();
        Rectangle sourceRegionParam = param.getSourceRegion();
        if (sourceRegionParam != null) {
            sourceRegion = sourceRegion.intersection(param.getSourceRegion());
        }
        destOff = param.getDestinationOffset();
        sourceXSubsampling = param.getSourceXSubsampling();
        sourceYSubsampling = param.getSourceYSubsampling();
        sourceBands = param.getSourceBands();
        int subsampleXOffset = param.getSubsamplingXOffset();
        int subsampleYOffset = param.getSubsamplingYOffset();
        sourceRegion.x += subsampleXOffset;
        sourceRegion.y += subsampleYOffset;
        sourceRegion.width -= subsampleXOffset;
        sourceRegion.height -= subsampleYOffset;
        int width = sourceRegion.width;
        int height = sourceRegion.height;
        Raster imRas = im.getData(sourceRegion);
        int numBands = imRas.getNumBands();
        if (sourceBands != null) {
            int i = 0;
            while (i < sourceBands.length) {
                int bandOff = sourceBands[i];
                if (bandOff < 0 || numBands <= bandOff) {
                    throw new IllegalArgumentException("Bad source bands.");
                }
                ++i;
            }
        }
        imRas = imRas.createChild(sourceRegion.x, sourceRegion.y, width, height, 0, 0, sourceBands);
        width = (width + sourceXSubsampling - 1) / sourceXSubsampling;
        height = (height + sourceYSubsampling - 1) / sourceYSubsampling;
        WritableRaster destWR = imRas.createCompatibleWritableRaster(destOff.x, destOff.y, width + destOff.x, height + destOff.y);
        Object transferCache = null;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                transferCache = imRas.getDataElements(x * sourceXSubsampling, y * sourceYSubsampling, transferCache);
                destWR.setDataElements(x, y, transferCache);
                ++x;
            }
            ++y;
        }
        ColorModel srcCM = im.getColorModel();
        BufferedImage destImg = new BufferedImage(srcCM, destWR, srcCM.isAlphaPremultiplied(), null);
        int destW = destImg.getWidth();
        int destH = destImg.getHeight();
        if (this.imageIndex == 0) {
            int max_dimension;
            if (!(streamMetadata instanceof BLPStreamMetadata)) {
                streamMetadata = this.convertStreamMetadata(streamMetadata, param);
            }
            this.streamMetadata = (BLPStreamMetadata)streamMetadata;
            boolean rescaleDest = false;
            BLPWriteParam.ScaleOptimization autoScale = BLPWriteParam.ScaleOptimization.CLAMP;
            if (param instanceof BLPWriteParam) {
                autoScale = ((BLPWriteParam)param).getScaleOptimization();
            }
            int worst = Math.max(destW, destH);
            int n = max_dimension = this.streamMetadata.getVersion() < 2 ? 512 : this.streamMetadata.getDimensionMaximum();
            if (worst > max_dimension) {
                switch (autoScale) {
                    case RATIO: {
                        destW = (int)(((long)destW * (long)max_dimension + (long)(worst / 2)) / (long)worst);
                        destH = (int)(((long)destH * (long)max_dimension + (long)(worst / 2)) / (long)worst);
                        rescaleDest = true;
                        break;
                    }
                    case CLAMP: {
                        destW = Math.min(destW, max_dimension);
                        destH = Math.min(destH, max_dimension);
                        rescaleDest = true;
                        break;
                    }
                }
            }
            this.streamMetadata.setHeight(destH);
            this.streamMetadata.setWidth(destW);
            if (!(param instanceof BLPWriteParam)) {
                this.streamMetadata.setEncoding(BLPEncodingType.JPEG, srcCM.hasAlpha() ? (byte)8 : 0);
            }
            if (rescaleDest) {
                this.processWarningOccurred(new LocalizedFormatedString("com.hiveworkshop.text.blp", "WriteResize", destImg.getWidth(), destImg.getHeight(), destW, destH), this.imageIndex);
                BufferedImage destImgNew = new BufferedImage(srcCM, destImg.getRaster().createCompatibleWritableRaster(destW, destH), srcCM.isAlphaPremultiplied(), null);
                Graphics2D graphics = destImgNew.createGraphics();
                RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                graphics.setRenderingHints(rh);
                graphics.drawImage(destImg.getScaledInstance(destW, destH, 16), 0, 0, destW, destH, null);
                graphics.dispose();
                destImg = destImgNew;
            }
            if (this.streamMetadata.getVersion() < 1) {
                Path path;
                if (this.output instanceof File) {
                    path = ((File)this.output).toPath();
                } else if (this.output instanceof Path) {
                    path = (Path)this.output;
                } else {
                    throw new IllegalStateException("Version 0 can only be written to Path of File.");
                }
                final ExternalMipmapManager emm = new ExternalMipmapManager(path);
                this.mipmapWriter = new MipmapWriter(){

                    @Override
                    public void setMipmapDataChunk(int mipmap, byte[] mmData) throws IOException {
                        emm.setMipmapDataChunk(mipmap, mmData);
                    }
                };
            } else {
                final InternalMipmapManager imm = new InternalMipmapManager();
                this.mipmapWriter = new MipmapWriter(){
                    private long objectPos;
                    {
                        this.objectPos = -1L;
                    }

                    @Override
                    public void writeMipmapManager(ImageOutputStream ios) throws IOException {
                        if (this.objectPos == -1L) {
                            this.objectPos = ios.getStreamPosition();
                        } else {
                            ios.seek(this.objectPos);
                        }
                        imm.writeObject(ios);
                    }

                    @Override
                    public void startMipmapSequence(ImageOutputStream ios) throws IOException {
                        imm.setMipmapDataChunkBlockOffset(ios);
                    }

                    @Override
                    public void setMipmapDataChunk(int mipmap, byte[] mmData) throws IOException {
                        imm.setMipmapDataChunk(BLPWriter.this.iosOutput, mipmap, mmData);
                    }
                };
            }
            BLPEncodingType encodingType = this.streamMetadata.getEncodingType();
            switch (encodingType) {
                case INDEXED: {
                    this.mipmapProcessor = new IndexedMipmapProcessor(this.streamMetadata.getAlphaBits());
                    break;
                }
                case JPEG: {
                    this.mipmapProcessor = new JPEGMipmapProcessor(this.streamMetadata.getAlphaBits());
                    break;
                }
                default: {
                    throw new IIOException("Unsupported encoding type.");
                }
            }
            this.iosOutput.seek(0L);
            this.streamMetadata.writeObject(this.iosOutput);
            this.mipmapWriter.writeMipmapManager(this.iosOutput);
            this.mmDataList = new ArrayList<byte[]>(this.streamMetadata.getMipmapCount());
        }
        if (this.imageIndex >= (mmCount = this.streamMetadata.getMipmapCount())) {
            throw new IIOException("Image limit reached.");
        }
        int mmH = this.streamMetadata.getHeight(this.imageIndex);
        int mmW = this.streamMetadata.getWidth(this.imageIndex);
        if (destW != mmW || destH != mmH) {
            throw new IIOException(String.format("Invalid image dimensions: Got %d*%d pixels requires %d*%d pixels.", destW, destH, mmW, mmH));
        }
        this.processImageStarted(this.imageIndex);
        byte[] mmData = this.mipmapProcessor.encodeMipmap(destImg, param, warn -> this.processWarningOccurred((LocalizedFormatedString)warn, this.imageIndex));
        if (this.mipmapProcessor.mustPostProcess()) {
            this.mmDataList.add(mmData);
        } else {
            if (!this.canWriteMipmaps && this.mipmapProcessor.canDecode()) {
                this.mipmapProcessor.writeObject(this.iosOutput);
                this.mipmapWriter.startMipmapSequence(this.iosOutput);
                this.canWriteMipmaps = true;
            }
            this.mipmapWriter.setMipmapDataChunk(this.imageIndex, mmData);
            this.mipmapWriter.writeMipmapManager(this.iosOutput);
        }
        ++this.imageIndex;
        this.processImageComplete();
        boolean autoMipmap = true;
        if (param instanceof BLPWriteParam) {
            autoMipmap = ((BLPWriteParam)param).isAutoMipmap();
        }
        if (autoMipmap) {
            RenderingHints rh = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            while (this.imageIndex < mmCount) {
                this.processImageStarted(this.imageIndex);
                mmH = this.streamMetadata.getHeight(this.imageIndex);
                mmW = this.streamMetadata.getWidth(this.imageIndex);
                BufferedImage mmImg = new BufferedImage(srcCM, destImg.getRaster().createCompatibleWritableRaster(mmW, mmH), srcCM.isAlphaPremultiplied(), null);
                Graphics2D graphics = mmImg.createGraphics();
                graphics.setRenderingHints(rh);
                graphics.drawImage(destImg.getScaledInstance(mmW, mmH, 16), 0, 0, mmW, mmH, null);
                graphics.dispose();
                mmData = this.mipmapProcessor.encodeMipmap(mmImg, param, warn -> this.processWarningOccurred((LocalizedFormatedString)warn, this.imageIndex));
                if (this.mipmapProcessor.mustPostProcess()) {
                    this.mmDataList.add(mmData);
                } else {
                    this.mipmapWriter.setMipmapDataChunk(this.imageIndex, mmData);
                    this.mipmapWriter.writeMipmapManager(this.iosOutput);
                }
                ++this.imageIndex;
                this.processImageComplete();
            }
        }
        if (this.imageIndex == mmCount) {
            if (this.mipmapProcessor.mustPostProcess()) {
                this.mmDataList = this.mipmapProcessor.postProcessMipmapData(this.mmDataList, warn -> this.processWarningOccurred((LocalizedFormatedString)warn, -1));
                this.mipmapProcessor.writeObject(this.iosOutput);
                this.mipmapWriter.startMipmapSequence(this.iosOutput);
                this.canWriteMipmaps = true;
                int i = 0;
                while (i < mmCount) {
                    this.mipmapWriter.setMipmapDataChunk(i, this.mmDataList.get(i));
                    ++i;
                }
                this.mipmapWriter.writeMipmapManager(this.iosOutput);
                this.mmDataList.clear();
            }
            if (this.internalOutput) {
                this.iosOutput.close();
                this.internalOutput = false;
            }
        }
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        if (this.internalOutput) {
            try {
                this.iosOutput.close();
            }
            catch (IOException e) {
                this.processWarningOccurred(new LocalizedFormatedString("com.hiveworkshop.text.blp", "ISCloseFail", e.getMessage()), -1);
            }
        }
        if (!this.badOutput && this.streamMetadata != null && this.imageIndex != this.streamMetadata.getMipmapCount()) {
            this.processWarningOccurred(new LocalizedFormatedString("com.hiveworkshop.text.blp", "IncompleteFile"), -1);
        }
        this.imageIndex = 0;
        this.streamMetadata = null;
        this.mipmapWriter = null;
        this.mipmapProcessor = null;
        this.iosOutput = null;
        this.internalOutput = false;
        this.badOutput = false;
        this.mmDataList = null;
        this.canWriteMipmaps = false;
    }

    @Override
    public void dispose() {
        this.setOutput(null);
    }

    private static abstract class MipmapWriter {
        private MipmapWriter() {
        }

        public void writeMipmapManager(ImageOutputStream ios) throws IOException {
        }

        public void startMipmapSequence(ImageOutputStream ios) throws IOException {
        }

        public abstract void setMipmapDataChunk(int var1, byte[] var2) throws IOException;
    }
}

