/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.IIOException;

class ExternalMipmapManager {
    private final Path root;
    private final String name;

    private Path getMipmapFilePath(int mipmap) {
        return this.root.resolve(String.valueOf(this.name) + String.format(".b%02d", mipmap));
    }

    public ExternalMipmapManager(Path file) throws IOException {
        String fileName = file.getFileName().toString();
        if (!fileName.endsWith(".blp")) {
            throw new IIOException(String.format("Malformed file path: Got '%s' expected '*.blp'.", file.toString()));
        }
        this.root = file.getParent();
        this.name = fileName.substring(0, fileName.length() - ".blp".length());
    }

    public byte[] getMipmapDataChunk(int mipmap) throws IOException {
        return Files.readAllBytes(this.getMipmapFilePath(mipmap));
    }

    public void setMipmapDataChunk(int mipmap, byte[] chunk) throws IOException {
        Path filePath = this.getMipmapFilePath(mipmap);
        if (chunk == null) {
            Files.deleteIfExists(filePath);
            return;
        }
        Files.write(filePath, chunk, new OpenOption[0]);
    }
}

