/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.lang.LocalizedFormatedString;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

class InternalMipmapManager {
    private final int[] chunkOffsets = new int[16];
    private final int[] chunkSizes = new int[16];
    private long chunkStreamPos = 0L;

    public byte[] getMipmapDataChunk(ImageInputStream src, int mipmap, Consumer<LocalizedFormatedString> warning) throws IOException {
        int size;
        long offset = (long)this.chunkOffsets[mipmap] & 0xFFFFFFFFL;
        long sizeLong = (long)this.chunkSizes[mipmap] & 0xFFFFFFFFL;
        int sizeMax = Integer.MAX_VALUE;
        if (sizeLong > Integer.MAX_VALUE) {
            warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadChunkSize", sizeLong, Integer.MAX_VALUE));
            size = Integer.MAX_VALUE;
        } else {
            size = (int)sizeLong;
        }
        byte[] buff = new byte[size];
        if (size > 0) {
            src.seek(offset);
        }
        int len = size;
        int off = 0;
        while (len > 0) {
            int read = src.read(buff, off, len);
            if (read == -1) {
                warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadChunkPos", size, off));
                buff = Arrays.copyOf(buff, off);
                break;
            }
            len -= read;
            off += read;
        }
        return buff;
    }

    public void setMipmapDataChunk(ImageOutputStream dst, int mipmap, byte[] chunk) throws IOException {
        long offset;
        int len;
        this.chunkSizes[mipmap] = len = chunk.length;
        long l = offset = len > 0 ? this.chunkStreamPos : 0L;
        if (offset > 0xFFFFFFFFL) {
            throw new IOException("Stream offset too big.");
        }
        this.chunkOffsets[mipmap] = (int)offset;
        if (len > 0) {
            dst.seek(this.chunkStreamPos);
            dst.write(chunk);
        }
        this.chunkStreamPos += (long)len;
    }

    public void setMipmapDataChunkBlockOffset(ImageInputStream src) throws IOException {
        long offset = src.getStreamPosition();
        if (offset > 0xFFFFFFFFL) {
            throw new IOException("Stream offset too big.");
        }
        this.chunkStreamPos = offset;
    }

    public void flushToMipmap(ImageInputStream src, int mipmap) throws IOException {
        long pos = Long.MAX_VALUE;
        int i = mipmap + 1;
        while (i < 16) {
            long newpos = (long)this.chunkOffsets[i] & 0xFFFFFFFFL;
            if (newpos < pos) {
                pos = newpos;
            }
            ++i;
        }
        src.flushBefore(pos);
    }

    public void readObject(ImageInputStream in) throws IOException {
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        in.readFully(this.chunkOffsets, 0, this.chunkOffsets.length);
        in.readFully(this.chunkSizes, 0, this.chunkSizes.length);
        long pos = 0L;
        int i = 0;
        while (i < 16) {
            long newpos = (long)this.chunkOffsets[i] & 0xFFFFFFFFL;
            if (this.chunkSizes[i] != 0 && newpos > pos) {
                pos = newpos;
            }
            ++i;
        }
        this.chunkStreamPos = pos;
    }

    public void writeObject(ImageOutputStream out) throws IOException {
        out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        out.writeInts(this.chunkOffsets, 0, this.chunkOffsets.length);
        out.writeInts(this.chunkSizes, 0, this.chunkSizes.length);
    }
}

