/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.blizzard.blp.BLPEncodingType;
import com.hiveworkshop.blizzard.blp.BLPReadParam;
import com.hiveworkshop.blizzard.blp.BLPWriteParam;
import com.hiveworkshop.blizzard.blp.MipmapProcessor;
import com.hiveworkshop.lang.LocalizedFormatedString;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOReadWarningListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

class JPEGMipmapProcessor
extends MipmapProcessor {
    private static final int MAX_SHARED_HEADER_LENGTH = 624;
    private static final int[] JPEG_BAND_ARRAY;
    private final ColorModel jpegBLPColorModel;
    private byte[] jpegHeader = null;

    static {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[1] = 1;
        nArray[3] = 3;
        JPEG_BAND_ARRAY = nArray;
    }

    public JPEGMipmapProcessor(int alphaBits) {
        if (!BLPEncodingType.JPEG.isAlphaBitsValid(alphaBits)) {
            throw new IllegalArgumentException("Unsupported alphaBits.");
        }
        boolean hasAlpha = alphaBits == 8;
        this.jpegBLPColorModel = new ComponentColorModel(ColorSpace.getInstance(1004), hasAlpha, false, hasAlpha ? 3 : 1, 0);
    }

    @Override
    public boolean mustPostProcess() {
        return true;
    }

    @Override
    public List<byte[]> postProcessMipmapData(List<byte[]> mmDataList, Consumer<LocalizedFormatedString> handler) {
        byte[] sharedHeader = (byte[])mmDataList.get(0).clone();
        int sharedLength = sharedHeader.length;
        int mmDataNum = mmDataList.size();
        int i = 1;
        while (i < mmDataNum) {
            byte[] mmData = mmDataList.get(i);
            int shared = 0;
            while (shared < sharedLength) {
                if (mmData[shared] != sharedHeader[shared]) {
                    sharedLength = shared;
                    break;
                }
                ++shared;
            }
            ++i;
        }
        if ((sharedLength = Math.min(sharedLength, 624)) < 64) {
            handler.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "JPEGSmallShared", sharedLength));
        }
        this.jpegHeader = Arrays.copyOf(sharedHeader, sharedLength);
        this.canDecode = true;
        if (sharedLength == 0) {
            return mmDataList;
        }
        ArrayList<byte[]> mmDataListOut = new ArrayList<byte[]>(mmDataNum);
        int i2 = 0;
        while (i2 < mmDataNum) {
            byte[] mmData = mmDataList.get(i2);
            mmDataListOut.add(Arrays.copyOfRange(mmData, sharedLength, mmData.length));
            ++i2;
        }
        return mmDataListOut;
    }

    @Override
    public byte[] encodeMipmap(BufferedImage img, ImageWriteParam param, final Consumer<LocalizedFormatedString> handler) throws IOException {
        ImageWriter jpegWriter = null;
        if (param instanceof BLPWriteParam && ((BLPWriteParam)param).getJPEGSpi() != null) {
            jpegWriter = ((BLPWriteParam)param).getJPEGSpi().createWriterInstance();
        } else {
            Iterator<ImageWriter> jpegWriters = ImageIO.getImageWritersByFormatName("jpeg");
            while (jpegWriters.hasNext()) {
                ImageWriter writer = jpegWriters.next();
                if (!writer.canWriteRasters()) continue;
                jpegWriter = writer;
                break;
            }
        }
        if (jpegWriter == null) {
            throw new IIOException("No suitable JPEG ImageWriter installed.");
        }
        if (!jpegWriter.canWriteRasters()) {
            throw new IIOException(String.format("JPEG ImageWriter cannot write raster: vendor = %s.", jpegWriter.getOriginatingProvider().getVendorName()));
        }
        WritableRaster srcWR = img.getRaster();
        SampleModel srcSM = srcWR.getSampleModel();
        int h = srcSM.getHeight();
        int w = srcSM.getWidth();
        WritableRaster destWR = WritableRaster.createBandedRaster(0, w, h, JPEG_BAND_ARRAY.length, null);
        int srcBandN = srcSM.getSampleSize().length;
        if (srcBandN == JPEG_BAND_ARRAY.length) {
            destWR.setRect(srcWR);
        } else {
            int bandNum = Math.min(JPEG_BAND_ARRAY.length, srcBandN);
            boolean opaque = !this.jpegBLPColorModel.hasAlpha() || bandNum < JPEG_BAND_ARRAY.length;
            int y = 0;
            while (y < h) {
                int x = 0;
                while (x < w) {
                    int b = 0;
                    while (b < bandNum) {
                        destWR.setSample(x, y, b, srcWR.getSample(x, y, b));
                        ++b;
                    }
                    if (opaque) {
                        destWR.setSample(x, y, 3, 255);
                    }
                    ++x;
                }
                ++y;
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(102400);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(bos);
        jpegWriter.setOutput(ios);
        ImageWriteParam jpegParam = jpegWriter.getDefaultWriteParam();
        jpegParam.setSourceBands(JPEG_BAND_ARRAY);
        jpegParam.setCompressionMode(2);
        String[] compressionTypes = jpegParam.getCompressionTypes();
        if (compressionTypes != null && compressionTypes.length > 0) {
            jpegParam.setCompressionType(compressionTypes[0]);
        }
        if (param != null && param.canWriteCompressed() && param.getCompressionMode() == 2) {
            jpegParam.setCompressionQuality(param.getCompressionQuality());
        } else {
            jpegParam.setCompressionQuality(0.8f);
        }
        jpegWriter.addIIOWriteWarningListener(new IIOWriteWarningListener(){

            @Override
            public void warningOccurred(ImageWriter source, int imageIndex, String warning) {
                handler.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "JPEGWarning", warning));
            }
        });
        jpegWriter.write(null, new IIOImage(destWR, null, null), jpegParam);
        jpegWriter.dispose();
        ios.close();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public BufferedImage decodeMipmap(byte[] mmData, ImageReadParam param, int width, int height, final Consumer<LocalizedFormatedString> handler) throws IOException {
        boolean directRead = param == null || param instanceof BLPReadParam && ((BLPReadParam)param).isDirectRead();
        ImageReader jpegReader = null;
        if (param instanceof BLPReadParam && ((BLPReadParam)param).getJPEGSpi() != null) {
            jpegReader = ((BLPReadParam)param).getJPEGSpi().createReaderInstance();
        } else {
            Iterator<ImageReader> jpegReaders = ImageIO.getImageReadersByFormatName("jpeg");
            while (jpegReaders.hasNext()) {
                ImageReader reader = jpegReaders.next();
                if (!reader.canReadRaster()) continue;
                jpegReader = reader;
                break;
            }
        }
        if (jpegReader == null) {
            throw new IIOException("No suitable JPEG ImageReader installed.");
        }
        if (!jpegReader.canReadRaster()) {
            throw new IIOException(String.format("JPEG ImageReader cannot read raster: vendor = %s.", jpegReader.getOriginatingProvider().getVendorName()));
        }
        byte[] jpegBuffer = Arrays.copyOf(this.jpegHeader, this.jpegHeader.length + mmData.length);
        System.arraycopy(mmData, 0, jpegBuffer, this.jpegHeader.length, mmData.length);
        ByteArrayInputStream bis = new ByteArrayInputStream(jpegBuffer);
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(bis);
        jpegReader.setInput(iis, true, true);
        jpegReader.addIIOReadWarningListener(new IIOReadWarningListener(){

            @Override
            public void warningOccurred(ImageReader source, String warning) {
                handler.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "JPEGWarning", warning));
            }
        });
        ImageReadParam jpegParam = jpegReader.getDefaultReadParam();
        jpegParam.setSourceBands(JPEG_BAND_ARRAY);
        if (directRead) {
            jpegParam.setSourceRegion(new Rectangle(width, height));
        }
        Raster srcRaster = jpegReader.readRaster(0, jpegParam);
        iis.close();
        jpegReader.dispose();
        if (directRead && srcRaster instanceof WritableRaster && srcRaster.getWidth() == width && srcRaster.getHeight() == height) {
            WritableRaster destRaster = (WritableRaster)srcRaster;
            if (!this.jpegBLPColorModel.hasAlpha()) {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                destRaster = destRaster.createWritableChild(0, 0, destRaster.getWidth(), destRaster.getHeight(), 0, 0, nArray);
            }
            return new BufferedImage(this.jpegBLPColorModel, destRaster, false, null);
        }
        if (!this.jpegBLPColorModel.hasAlpha()) {
            int[] alphaSamples;
            int[] nArray = alphaSamples = srcRaster.getSamples(0, 0, srcRaster.getWidth(), srcRaster.getHeight(), 3, (int[])null);
            int n = alphaSamples.length;
            int n2 = 0;
            while (n2 < n) {
                int aSample = nArray[n2];
                if (aSample != 255) {
                    handler.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "BadPixelAlpha"));
                    break;
                }
                ++n2;
            }
        }
        if (srcRaster.getWidth() != width || srcRaster.getHeight() != height) {
            handler.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "JPEGDimensionMismatch", srcRaster.getWidth(), srcRaster.getHeight(), width, height));
        }
        BufferedImage destImg = new BufferedImage(this.jpegBLPColorModel, this.jpegBLPColorModel.createCompatibleWritableRaster(width, height), false, null);
        WritableRaster destRaster = destImg.getRaster();
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        destRaster.setRect(srcRaster.createChild(0, 0, srcRaster.getWidth(), srcRaster.getHeight(), 0, 0, Arrays.copyOf(nArray, this.jpegBLPColorModel.getNumComponents())));
        return destImg;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getSupportedImageTypes(int width, int height) {
        return Arrays.asList(new ImageTypeSpecifier(this.jpegBLPColorModel, this.jpegBLPColorModel.createCompatibleSampleModel(width, height))).iterator();
    }

    @Override
    public void readObject(ImageInputStream src, Consumer<LocalizedFormatedString> warning) throws IOException {
        src.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int length = src.readInt();
        byte[] jpegh = new byte[length];
        src.readFully(jpegh, 0, jpegh.length);
        if (length > 624) {
            warning.accept(new LocalizedFormatedString("com.hiveworkshop.text.blp", "JPEGBigShared", length, 624));
        }
        this.jpegHeader = jpegh;
        this.canDecode = true;
    }

    @Override
    public void writeObject(ImageOutputStream dst) throws IOException {
        byte[] jpegh = this.jpegHeader != null ? this.jpegHeader : new byte[]{};
        dst.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        dst.writeInt(jpegh.length);
        dst.write(jpegh);
    }
}

