/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.blizzard.blp;

import com.hiveworkshop.lang.LocalizedFormatedString;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

abstract class MipmapProcessor {
    protected boolean canDecode = false;

    MipmapProcessor() {
    }

    public boolean mustPostProcess() {
        return false;
    }

    public List<byte[]> postProcessMipmapData(List<byte[]> mmDataList, Consumer<LocalizedFormatedString> handler) {
        if (mmDataList.size() < 1) {
            throw new IllegalArgumentException("No mipmap data.");
        }
        return mmDataList;
    }

    public abstract byte[] encodeMipmap(BufferedImage var1, ImageWriteParam var2, Consumer<LocalizedFormatedString> var3) throws IOException;

    public final boolean canDecode() {
        return this.canDecode;
    }

    public abstract BufferedImage decodeMipmap(byte[] var1, ImageReadParam var2, int var3, int var4, Consumer<LocalizedFormatedString> var5) throws IOException;

    public abstract Iterator<ImageTypeSpecifier> getSupportedImageTypes(int var1, int var2);

    public abstract void readObject(ImageInputStream var1, Consumer<LocalizedFormatedString> var2) throws IOException;

    public abstract void writeObject(ImageOutputStream var1) throws IOException;
}

