/*
 * Decompiled with CFR 0.152.
 */
package com.hiveworkshop.lang;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LocalizedFormatedString {
    private final String baseName;
    private final String key;
    private final Object[] arguments;

    public LocalizedFormatedString(String baseName, String keyword, Object ... args) {
        if (baseName == null) {
            throw new IllegalArgumentException("baseName is null.");
        }
        if (keyword == null) {
            throw new IllegalArgumentException("keyword is null.");
        }
        this.baseName = baseName;
        this.key = keyword;
        this.arguments = args;
    }

    public LocalizedFormatedString(String baseName, String keyword) {
        this(baseName, keyword, null);
    }

    public String toString(Locale locale) {
        String text;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(this.baseName, locale);
            text = bundle.getString(this.key);
        }
        catch (MissingResourceException e) {
            text = String.format("missing resource {%S, %S, %S}", this.baseName, this.key, this.arguments);
        }
        if (this.arguments != null) {
            text = String.format(text, this.arguments);
        }
        return text;
    }

    public String toString() {
        return this.toString(Locale.getDefault());
    }
}

