package com.hiveworkshop.wc3.gui.modeledit.components.material;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.hiveworkshop.wc3.mdl.Layer;

import net.miginfocom.swing.MigLayout;

public class LayerFlagsPanel extends JPanel {
	private final JCheckBox unshaded;
	private final JCheckBox sphereEnvMap;
	private final JCheckBox twoSided;
	private final JCheckBox unfogged;
	private final JCheckBox noDepthTest;
	private final JCheckBox noDepthSet;
	private final JCheckBox unlit;

	public LayerFlagsPanel() {
		setLayout(new MigLayout());
		unshaded = new JCheckBox("Unshaded");
		add(unshaded, "wrap");
		sphereEnvMap = new JCheckBox("SphereEnvMap");
		add(sphereEnvMap, "wrap");
		twoSided = new JCheckBox("TwoSided");
		add(twoSided, "wrap");
		unfogged = new JCheckBox("Unfogged");
		add(unfogged, "wrap");
		noDepthTest = new JCheckBox("NoDepthTest");
		add(noDepthTest, "wrap");
		noDepthSet = new JCheckBox("NoDepthSet");
		add(noDepthSet, "wrap");
		unlit = new JCheckBox("Unlit");
		add(unlit, "wrap");
	}

	public void setLayer(final Layer layer) {
		unshaded.setSelected(layer.isUnshaded());
		sphereEnvMap.setSelected(layer.isSphereEnvironmentMap());
		twoSided.setSelected(layer.isTwoSided());
		unfogged.setSelected(layer.isUnfogged());
		noDepthTest.setSelected(layer.isNoDepthTest());
		noDepthSet.setSelected(layer.isNoDepthSet());
		unlit.setSelected(layer.isUnlit());
	}
}
