package com.hiveworkshop.wc3.gui.modeledit.viewport;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;

import com.hiveworkshop.wc3.gui.modeledit.CoordinateSystem;
import com.hiveworkshop.wc3.mdl.Attachment;
import com.hiveworkshop.wc3.mdl.Bone;
import com.hiveworkshop.wc3.mdl.Camera;
import com.hiveworkshop.wc3.mdl.CollisionShape;
import com.hiveworkshop.wc3.mdl.EventObject;
import com.hiveworkshop.wc3.mdl.Helper;
import com.hiveworkshop.wc3.mdl.IdObject;
import com.hiveworkshop.wc3.mdl.Light;
import com.hiveworkshop.wc3.mdl.ParticleEmitter;
import com.hiveworkshop.wc3.mdl.ParticleEmitter2;
import com.hiveworkshop.wc3.mdl.ParticleEmitterPopcorn;
import com.hiveworkshop.wc3.mdl.RibbonEmitter;
import com.hiveworkshop.wc3.mdl.Vertex;
import com.hiveworkshop.wc3.mdl.v2.visitor.IdObjectVisitor;

public final class IdObjectRenderer implements IdObjectVisitor {
	private CoordinateSystem coordinateSystem;
	private Graphics2D graphics;
	private final int vertexSize;
	private final Color lightColor;
	private final Color pivotPointColor;
	private final NodeIconPalette nodeIconPalette;

	public IdObjectRenderer(final Color lightColor, final Color pivotPointColor, final int vertexSize,
			final NodeIconPalette nodeIconPalette) {
		this.lightColor = lightColor;
		this.pivotPointColor = pivotPointColor;
		this.vertexSize = vertexSize;
		this.nodeIconPalette = nodeIconPalette;
	}

	public IdObjectRenderer reset(final CoordinateSystem coordinateSystem, final Graphics2D graphics) {
		this.coordinateSystem = coordinateSystem;
		this.graphics = graphics;
		return this;
	}

	@Override
	public void bone(final Bone object) {
		graphics.setColor(pivotPointColor);
		drawCrosshair(object);
	}

	@Override
	public void light(final Light light) {
		final Image lightImage = nodeIconPalette.getLightImage();
		graphics.setColor(lightColor);
		final int xCoord = (int) coordinateSystem
				.convertX(light.getPivotPoint().getCoord(coordinateSystem.getPortFirstXYZ()));
		final int yCoord = (int) coordinateSystem
				.convertY(light.getPivotPoint().getCoord(coordinateSystem.getPortSecondXYZ()));
		final double zoom = CoordinateSystem.Util.getZoom(coordinateSystem);
		// graphics.drawOval(xCoord - vertexSize * 2, yCoord - vertexSize * 2,
		// vertexSize * 4, vertexSize * 4);
		// graphics.setColor(programPreferences.getAmbientLightColor());
		// graphics.drawLine(xCoord - vertexSize * 3, yCoord, xCoord +
		// vertexSize * 3, yCoord);
		// graphics.drawLine(xCoord, yCoord - vertexSize * 3, xCoord, yCoord +
		// vertexSize * 3);
		graphics.drawImage(lightImage, xCoord - lightImage.getWidth(null) / 2, yCoord - lightImage.getHeight(null) / 2,
				lightImage.getWidth(null), lightImage.getHeight(null), null);

		final int attenuationStart = (int) (light.getAttenuationStart() * zoom);
		if (attenuationStart > 0) {
			graphics.drawOval(xCoord - attenuationStart, yCoord - attenuationStart, attenuationStart * 2,
					attenuationStart * 2);
		}
		final int attenuationEnd = (int) (light.getAttenuationEnd() * zoom);
		if (attenuationEnd > 0) {
			graphics.drawOval(xCoord - attenuationEnd, yCoord - attenuationEnd, attenuationEnd * 2, attenuationEnd * 2);
		}
	}

	private void drawCrosshair(final Bone object) {
		final int xCoord = (int) coordinateSystem
				.convertX(object.getPivotPoint().getCoord(coordinateSystem.getPortFirstXYZ()));
		final int yCoord = (int) coordinateSystem
				.convertY(object.getPivotPoint().getCoord(coordinateSystem.getPortSecondXYZ()));
		graphics.drawOval(xCoord - vertexSize, yCoord - vertexSize, vertexSize * 2, vertexSize * 2);
		graphics.drawLine(xCoord - (int) (vertexSize * 1.5f), yCoord, xCoord + (int) (vertexSize * 1.5f), yCoord);
		graphics.drawLine(xCoord, yCoord - (int) (vertexSize * 1.5f), xCoord, yCoord + (int) (vertexSize * 1.5f));
	}

	@Override
	public void helper(final Helper object) {
		graphics.setColor(pivotPointColor.darker());
		drawCrosshair(object);
	}

	@Override
	public void attachment(final Attachment attachment) {
		drawNodeImage(attachment, nodeIconPalette.getAttachmentImage());
	}

	@Override
	public void particleEmitter(final ParticleEmitter particleEmitter) {
		drawNodeImage(particleEmitter, nodeIconPalette.getParticleImage());
	}

	@Override
	public void particleEmitter2(final ParticleEmitter2 particleEmitter) {
		drawNodeImage(particleEmitter, nodeIconPalette.getParticle2Image());
	}

	@Override
	public void popcornFxEmitter(final ParticleEmitterPopcorn particleEmitter) {
		drawNodeImage(particleEmitter, nodeIconPalette.getParticleImage());
	}

	@Override
	public void ribbonEmitter(final RibbonEmitter ribbonEmitter) {
		drawNodeImage(ribbonEmitter, nodeIconPalette.getRibbonImage());
	}

	@Override
	public void eventObject(final EventObject eventObject) {
		drawNodeImage(eventObject, nodeIconPalette.getEventImage());
	}

	@Override
	public void collisionShape(final CollisionShape collisionShape) {
		drawCollisionShape(graphics, pivotPointColor, coordinateSystem, coordinateSystem.getPortFirstXYZ(),
				coordinateSystem.getPortSecondXYZ(), vertexSize, collisionShape, nodeIconPalette.getCollisionImage());
	}

	@Override
	public void camera(final Camera camera) {
		graphics.setColor(Color.GREEN.darker());
		final Graphics2D g2 = (Graphics2D) graphics.create();
		final Vertex ver = camera.getPosition();
		final Vertex targ = camera.getTargetPosition();
		// final boolean verSel = selection.contains(ver);
		// final boolean tarSel = selection.contains(targ);
		final Point start = new Point(
				(int) Math.round(coordinateSystem.convertX(ver.getCoord(coordinateSystem.getPortFirstXYZ()))),
				(int) Math.round(coordinateSystem.convertY(ver.getCoord(coordinateSystem.getPortSecondXYZ()))));
		final Point end = new Point(
				(int) Math.round(coordinateSystem.convertX(targ.getCoord(coordinateSystem.getPortFirstXYZ()))),
				(int) Math.round(coordinateSystem.convertY(targ.getCoord(coordinateSystem.getPortSecondXYZ()))));
		// if (dispCameraNames) {
		// boolean changedCol = false;
		//
		// if (verSel) {
		// g2.setColor(Color.orange.darker());
		// changedCol = true;
		// }
		// g2.drawString(cam.getName(), (int)
		// Math.round(vp.convertX(ver.getCoord(vp.getPortFirstXYZ()))),
		// (int) Math.round(vp.convertY(ver.getCoord(vp.getPortSecondXYZ()))));
		// if (tarSel) {
		// g2.setColor(Color.orange.darker());
		// changedCol = true;
		// } else if (verSel) {
		// g2.setColor(Color.green.darker());
		// changedCol = false;
		// }
		// g2.drawString(cam.getName() + "_target",
		// (int) Math.round(vp.convertX(targ.getCoord(vp.getPortFirstXYZ()))),
		// (int) Math.round(vp.convertY(targ.getCoord(vp.getPortSecondXYZ()))));
		// if (changedCol) {
		// g2.setColor(Color.green.darker());
		// }
		// }

		g2.translate(end.x, end.y);
		g2.rotate(-(Math.PI / 2 + Math.atan2(end.x - start.x, end.y - start.y)));
		final double zoom = CoordinateSystem.Util.getZoom(coordinateSystem);
		final int size = (int) (20 * zoom);
		final double dist = start.distance(end);

		// if (verSel) {
		// g2.setColor(Color.orange.darker());
		// }
		// Cam
		g2.fillRect((int) dist - vertexSize, 0 - vertexSize, 1 + vertexSize * 2, 1 + vertexSize * 2);
		g2.drawRect((int) dist - size, -size, size * 2, size * 2);

		// if (tarSel) {
		// g2.setColor(Color.orange.darker());
		// } else if (verSel) {
		// g2.setColor(Color.green.darker());
		// }
		// Target
		g2.fillRect(0 - vertexSize, 0 - vertexSize, 1 + vertexSize * 2, 1 + vertexSize * 2);
		g2.drawLine(0, 0, size, size);// (int)Math.round(vp.convertX(targ.getCoord(vp.getPortFirstXYZ())+5)),
										// (int)Math.round(vp.convertY(targ.getCoord(vp.getPortSecondXYZ())+5)));
		g2.drawLine(0, 0, size, -size);// (int)Math.round(vp.convertX(targ.getCoord(vp.getPortFirstXYZ())-5)),
										// (int)Math.round(vp.convertY(targ.getCoord(vp.getPortSecondXYZ())-5)));

		// if (!verSel && tarSel) {
		// g2.setColor(Color.green.darker());
		// }
		g2.drawLine(0, 0, (int) dist, 0);
	}

	private void drawNodeImage(final IdObject attachment, final Image nodeImage) {
		drawNodeImage(graphics, coordinateSystem.getPortFirstXYZ(), coordinateSystem.getPortSecondXYZ(),
				coordinateSystem, attachment, nodeImage);
	}

	public static void drawNodeImage(final Graphics2D graphics, final byte xDimension, final byte yDimension,
			final CoordinateSystem coordinateSystem, final IdObject attachment, final Image nodeImage) {
		final int xCoord = (int) coordinateSystem.convertX(attachment.getPivotPoint().getCoord(xDimension));
		final int yCoord = (int) coordinateSystem.convertY(attachment.getPivotPoint().getCoord(yDimension));
		graphics.drawImage(nodeImage, xCoord - nodeImage.getWidth(null) / 2, yCoord - nodeImage.getHeight(null) / 2,
				nodeImage.getWidth(null), nodeImage.getHeight(null), null);
	}

	public static void drawCollisionShape(final Graphics2D graphics, final Color color,
			final CoordinateSystem coordinateSystem, final byte xDimension, final byte yDimension, final int vertexSize,
			final CollisionShape collisionShape, final Image collisionImage) {
		final Vertex pivotPoint = collisionShape.getPivotPoint();
		final ArrayList<Vertex> vertices = collisionShape.getVertices();
		graphics.setColor(color);
		int xCoord = (int) coordinateSystem.convertX(pivotPoint.getCoord(xDimension));
		int yCoord = (int) coordinateSystem.convertY(pivotPoint.getCoord(yDimension));
		if (collisionShape.getFlags().contains("Box")) {
			if (vertices.size() > 1) {
				final Vertex vertex = vertices.get(0);
				final Vertex vertex2 = vertices.get(1);
				final int firstXCoord = (int) coordinateSystem.convertX(vertex2.getCoord(xDimension));
				final int firstYCoord = (int) coordinateSystem.convertY(vertex2.getCoord(yDimension));
				final int secondXCoord = (int) coordinateSystem.convertX(vertex.getCoord(xDimension));
				final int secondYCoord = (int) coordinateSystem.convertY(vertex.getCoord(yDimension));
				final int minXCoord = Math.min(firstXCoord, secondXCoord);
				final int minYCoord = Math.min(firstYCoord, secondYCoord);
				final int maxXCoord = Math.max(firstXCoord, secondXCoord);
				final int maxYCoord = Math.max(firstYCoord, secondYCoord);
				graphics.drawRoundRect(minXCoord, minYCoord, maxXCoord - minXCoord, maxYCoord - minYCoord, vertexSize,
						vertexSize);
			} else {
				drawNodeImage(graphics, xDimension, yDimension, coordinateSystem, collisionShape, collisionImage);
			}
		} else {
			if (collisionShape.getExtents() != null) {
				final double zoom = CoordinateSystem.Util.getZoom(coordinateSystem);
				final double boundsRadius = collisionShape.getExtents().getBoundsRadius() * zoom;
				if (vertices.size() > 0) {
					final Vertex firstVertex = vertices.get(0);
					xCoord = (int) coordinateSystem.convertX(firstVertex.getCoord(xDimension));
					yCoord = (int) coordinateSystem.convertY(firstVertex.getCoord(yDimension));
				}
				graphics.drawOval((int) (xCoord - boundsRadius), (int) (yCoord - boundsRadius),
						(int) (boundsRadius * 2), (int) (boundsRadius * 2));
			} else {
				drawNodeImage(graphics, xDimension, yDimension, coordinateSystem, collisionShape, collisionImage);
			}
		}
	}
}