<div align="center">
  <h2>🚀 Zoer is Launching</h2>
  <p><strong>Powered by Chat2DB Team - AI-powered app builder that creates professional applications in minutes, no coding required</strong></p>
  
  <a href="https://zoer.ai/?utm_source=chat2db&utm_medium=banner&utm_campaign=github" target="_blank">
    <img width="1000" height="auto" alt="Zoer - AI App Builder" src="https://github.com/user-attachments/assets/2f2a682d-9cc0-4470-93d3-19b4f1f6589e" style="border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);" />
  </a>
  
  <br/><br/>
  
  ---
  
  <br/>
  
  <a href="https://trendshift.io/repositories/11808" target="_blank"><img src="https://trendshift.io/api/badge/repositories/11808" alt="CodePhiliaX%2FChat2DB | Trendshift" style="width: 250px; height: 55px;" width="250" height="55"/>
  </a>
</div>

<div align="center">
  
[![ReadmeX][readmex-image]][readmex-url]
[![Discord][discord-image]][discord-url]
[![Twitter][twitter-image]][twitter-url]
[![Telegram][telegram-image]][telegram-url]
[![Whatsapp][whatsapp-image]][whatsapp-url]
[![Reddit][reddit-image]][reddit-url]
[![Gmail][gmail-image]][gmail-url]

[readmex-image]: https://raw.githubusercontent.com/CodePhiliaX/resource-trusteeship/main/readmex.svg
[readmex-url]: https://readmex.com/CodePhiliaX/Chat2DB
[discord-image]: https://img.shields.io/badge/-Join%20us%20on%20Discord-%237289DA.svg?style=flat&logo=discord&logoColor=white
[discord-url]: https://discord.com/invite/uNjb3n5JVN
[twitter-image]: https://img.shields.io/twitter/follow/_Chat2DB?label=Chat2DB
[twitter-url]: https://twitter.com/intent/tweet?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.&url=https://github.com/chat2db/Chat2DB&hashtags=ChatGPT,AGI,SQL%20Client,Reporting%20tool
[telegram-image]: https://img.shields.io/twitter/url?label=Telegram&logo=Telegram&style=social&url=https://github.com/chat2db/Chat2DB
[telegram-url]: https://t.me/share/url?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.&url=https://github.com/chat2db/Chat2DB
[whatsapp-image]: https://img.shields.io/twitter/url?label=whatsapp&logo=whatsapp&style=social&url=https://github.com/chat2db/Chat2DB
[whatsapp-url]: https://api.whatsapp.com/send?text=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.%20https://github.com/chat2db/Chat2DB
[reddit-image]: https://img.shields.io/twitter/url?label=Reddit&logo=Reddit&style=social&url=https://github.com/chat2db/Chat2DB
[reddit-url]: https://www.reddit.com/submit?url=https://github.com/chat2db/Chat2DB&title=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.
[gmail-image]: https://img.shields.io/twitter/url?label=Gmail&logo=Gmail&style=social&url=https://github.com/chat2db/Chat2DB
[gmail-url]: mailto:?subject=Check%20this%20GitHub%20repository%20out.&body=Chat2DB-An%20intelligent%20and%20versatile%20general-purpose%20SQL%20client%20and%20reporting%20tool%20for%20databases%20which%20integrates%20ChatGPT%20capabilities.%3A%0Ahttps://github.com/chat2db/Chat2DB

</div>

<div align="center">
  <a href="./README.md"><img alt="README in English" src="https://img.shields.io/badge/English-d9d9d9"></a>
  <a href="./README_CN.md"><img alt="简体中文版自述文件" src="https://img.shields.io/badge/简体中文-d9d9d9"></a>
  <a href="./README_JA.md"><img alt="日本語のREADME" src="https://img.shields.io/badge/日本語-d9d9d9"></a>

</div>

**1. Intelligent SQL Generation**:  
Chat2DB Pro supports AI-driven intelligent SQL development to help you write SQL queries faster.

**2. Database Management**:  
Supports more than 10 databases, including MySQL, PostgreSQL, H2, Oracle, SQLServer, SQLite, MariaDB, ClickHouse, DM, Presto, DB2, OceanBase, Hive, KingBase, MongoDB, Redis, Snowflake, and more.

**3. Intelligent Report Generation**:  
Chat2DB Pro supports AI-driven intelligent data reporting to help you generate dashboards faster.

**4. Data Structure Synchronization**:  
Chat2DB Pro supports database table structure synchronization to help you sync database table structures faster.

## Feature Comparison

<table style="width: 100%;">
  <tr>
    <th align="center">Feature</th>
    <th align="center">Community Open Source</th>
    <th align="center">Local</th>
    <th align="center">Pro </th>
  </tr>
  <tr>
    <td align="center">Database Types</td>
    <td align="center">16+</td>
    <td align="center">Target 100+</td>
    <td align="center">Target 100+</td>
  </tr>
  <tr>
    <td align="center">Supported AI</td>
    <td align="center">Requires AI Configuration</td>
    <td align="center">AI ready on installation</td>
    <td align="center">AI ready on installation</td>
  </tr>
  <tr>
    <td align="center">AI Capabilities</td>
    <td align="center">Basic</td>
    <td align="center">Varied</td>
    <td align="center">Varied</td>
  </tr>
  <tr>
    <td align="center">Visual Table Editor</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">SQL Console</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">SQL Formatting</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Save Query Records</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Theme Color Settings</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Data Structure Sync</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Database Grouping</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Database Structure Import/Export</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Data Import/Export</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Data Migration</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Copy/Clear Table</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Open and Run SQL Files</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">UML Diagram</td>
    <td align="center">❌</td>
    <td align="center">In Development</td>
    <td align="center">In Development</td>
  </tr>
  <tr>
    <td align="center">Generate Code</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Copy Results as Insert/Update</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Modify Query Results</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Intelligent SQL Editor</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">AI Table Creation</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">AI Data Sets</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Chat2Excel</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Intelligent Dashboard</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Editor Settings</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Custom Shortcuts</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
    <td align="center">✅</td>
  </tr>
  <tr>
    <td align="center">Cross-device Usage</td>
    <td align="center">❌</td>
    <td align="center">❌</td>
    <td align="center">✅</td>
  </tr>
</table>

## Download and Installation
Chat2DB is a cross-platform application that supports Windows, MacOS, and Linux. You can download Chat2DB from the following links:
- [Download Pro Version](https://chat2db.ai/download)
- [Download Local Version](https://chat2db.ai/download)
- [Download Open Source Version](https://github.com/CodePhiliaX/Chat2DB/releases/tag/v0.3.6)

## Community Edition Docker Installation

### System Requirements

Before installing Chat2DB, ensure your system meets the following requirements:
- Docker 19.03.0 or later
- Docker Compose 1.25.0 or later
- CPU >= 2 Cores
- RAM >= 4 GiB

```bash
  docker rm chat2db
  
  docker run --name=chat2db -ti -p 10824:10824 -v ~/.chat2db-docker:/root/.chat2db  chat2db/chat2db:latest

  docker start chat2db
  
```
## Code Debugging

## Runtime Environment

Note:
If local debugging is needed:

- Java runtime: <a href="https://adoptopenjdk.net/" target="_blank">Open JDK 17</a>
- Node.js runtime: Node 16 <a href="https://nodejs.org/" target="_blank">Node.js</a>.

**Clone the repository locally**

```bash
$ git clone git@github.com:chat2db/Chat2DB.git
```

**Frontend Debugging**

```bash
Node version must be 16 or higher  
Use yarn only, npm is not supported
$ cd Chat2DB/chat2db-client
$ yarn
$ yarn run start:web
```

**Backend Debugging**

```bash
$ cd ../chat2db-server
$ mvn clean install # Maven version 3.8 or higher is required
$ cd chat2db-server/chat2db-server-start/target/
$ java -jar -Dloader.path=./lib -Dchatgpt.apiKey=xxxxx chat2db-server-start.jar  # 需要安装java 17以上版本，启动应用 chatgpt.apiKey 需要输入ChatGPT的key,如果不输入无法使用AIGC功能
```
**Standalone Deployment**
```bash
# chat2db-client
$ npm run build:web:prod 
$ cp -r dist ../chat2db-server/chat2db-server-start/src/main/resources/static/front 
$ cp -r dist/index.html ../chat2db-server/chat2db-server-start/src/main/resources/thymeleaf
```

##  Contact Us

- Email: Chat2DB@ch2db.com
- Discord: [Join our Discord server](https://discord.gg/JDkwB6JS8A)
- Twitter: [@Chat2DB](https://x.com/Chat2DB_AI)
- YouTube: [Chat2DB Channel](https://www.youtube.com/@chat2db.tutorial)
- GitHub: [Chat2DB GitHub](https://github.com/codePhiliaX/chat2db)


##  Acknowledgments


Thanks to everyone who has contributed to Chat2DB~~


<a href="https://github.com/chat2db/Chat2DB/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=chat2db/Chat2DB" />
</a>

## Star History

<a href="https://star-history.com/#CodePhiliaX/chat2db&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=CodePhiliaX/chat2db&type=Date" />
  </picture>
</a>

## License
The primary license used by this software is the [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0), supplemented by the [Chat2DB License](./Chat2DB_LICENSE).

