// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package ai.chat2db.server.web.api.controller.ai.fastchat.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

/**
 * The representation of a single prompt completion as part of an overall completions request. Generally, `n` choices
 * are generated per provided prompt with a default value of 1. Token limits and other settings may limit the number of
 * choices generated.
 */
@Data
public final class FastChatChoice {

    /*
     * The generated text for a given completions prompt.
     */
    @JsonProperty(value = "text")
    private String text;

    /*
     * The ordered index associated with this completions choice.
     */
    @JsonProperty(value = "index")
    private int index;

    /*
     * The log probabilities model for tokens associated with this completions choice.
     */
    @JsonProperty(value = "delta")
    private FastChatMessage delta;

    /*
     * Reason for finishing
     */
    @JsonProperty(value = "finish_reason")
    private FastChatCompletionsFinishReason finishReason;

    /**
     * Creates an instance of Choice class.
     *
     * @param text the text value to set.
     * @param index the index value to set.
     * @param delta the message value to set
     * @param finishReason the finishReason value to set.
     */
    @JsonCreator
    private FastChatChoice(
            @JsonProperty(value = "text") String text,
            @JsonProperty(value = "index") int index,
            @JsonProperty(value = "delta") FastChatMessage delta,
            @JsonProperty(value = "finish_reason") FastChatCompletionsFinishReason finishReason) {
        this.text = text;
        this.index = index;
        this.delta = delta;
        this.finishReason = finishReason;
    }

    /**
     * Get the text property: The generated text for a given completions prompt.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Get the index property: The ordered index associated with this completions choice.
     *
     * @return the index value.
     */
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the logprobs property: The log probabilities model for tokens associated with this completions choice.
     *
     * @return the logprobs value.
     */
    public FastChatMessage getDelta() {
        return this.delta;
    }

    /**
     * Get the finishReason property: Reason for finishing.
     *
     * @return the finishReason value.
     */
    public FastChatCompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }
}
