// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package ai.chat2db.server.web.api.controller.ai.fastchat.model;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;

/** Representation of the manner in which a completions response concluded. */
public final class FastChatCompletionsFinishReason extends FastChatExpandableStringEnum<FastChatCompletionsFinishReason> {

    /** Completions ended normally and reached its end of token generation. */
    public static final FastChatCompletionsFinishReason STOPPED = fromString("stopped");

    /** Completions exhausted available token limits before generation could complete. */
    public static final FastChatCompletionsFinishReason TOKEN_LIMIT_REACHED = fromString("tokenLimitReached");

    /**
     * Completions generated a response that was identified as potentially sensitive per content moderation policies.
     */
    public static final FastChatCompletionsFinishReason CONTENT_FILTERED = fromString("contentFiltered");

    /**
     * Creates a new instance of CompletionsFinishReason value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FastChatCompletionsFinishReason() {}

    /**
     * Creates or finds a CompletionsFinishReason from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding CompletionsFinishReason.
     */
    @JsonCreator
    public static FastChatCompletionsFinishReason fromString(String name) {
        return fromString(name, FastChatCompletionsFinishReason.class);
    }

    /**
     * Gets known CompletionsFinishReason values.
     *
     * @return known CompletionsFinishReason values.
     */
    public static Collection<FastChatCompletionsFinishReason> values() {
        return values(FastChatCompletionsFinishReason.class);
    }
}
