// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package ai.chat2db.server.web.api.controller.ai.zhipu.model;

import ai.chat2db.server.web.api.controller.ai.fastchat.model.FastChatMessage;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * The configuration information for a chat completions request. Completions support a wide variety of tasks and
 * generate text that continues from or "completes" provided prompt data.
 */
@Data
public final class ZhipuChatCompletionsOptions {

    @JsonProperty(value = "request_id")
    private String requestId;

    // sse-params
    @JsonProperty(value = "stream")
    private Boolean stream = true;

    @JsonProperty(value = "sseFormat")
    private String sseFormat = "data";


    /*
     * The collection of context messages associated with this chat completions request.
     * Typical usage begins with a chat message for the System role that provides instructions for
     * the behavior of the assistant, followed by alternating messages between the User and
     * Assistant roles.
     */
    @JsonProperty(value = "messages")
    private List<FastChatMessage> prompt;


    //
    /*
     * The model name to provide as part of this completions request.
     * Not applicable to Fast Chat AI, where deployment information should be included in the Fast Chat
     * resource URI that's connected to.
     */
    @JsonProperty(value = "model")
    private String model;
}
