/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.config.simpleconfig.gui;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import julianh06.wynnextras.config.simpleconfig.ConfigData;
import julianh06.wynnextras.config.simpleconfig.ConfigManager;
import julianh06.wynnextras.config.simpleconfig.annotations.ConfigEntry;
import julianh06.wynnextras.config.simpleconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@Environment(value=EnvType.CLIENT)
public class ConfigScreenProvider<T extends ConfigData>
implements Supplier<class_437> {
    private final ConfigManager<T> manager;
    private final GuiRegistryAccess registry;
    private final class_437 parent;

    public ConfigScreenProvider(ConfigManager<T> manager, GuiRegistryAccess registry, class_437 parent) {
        this.manager = manager;
        this.registry = registry;
        this.parent = parent;
    }

    @Override
    public class_437 get() {
        T config = this.manager.getConfig();
        T defaults = this.manager.getSerializer().createDefault();
        String name = this.manager.getDefinition().name();
        String title = this.manager.getDefinition().title();
        ConfigBuilder configBuilder = ConfigBuilder.create().setParentScreen(this.parent).setTitle((class_2561)class_2561.method_43470((String)title));
        ConfigManager<T> configManager = this.manager;
        Objects.requireNonNull(configManager);
        ConfigBuilder builder = configBuilder.setSavingRunnable(configManager::save);
        Class<T> configClass = this.manager.getConfigClass();
        builder.transparentBackground().setDefaultBackgroundTexture(null);
        Arrays.stream(configClass.getDeclaredFields()).collect(Collectors.groupingBy(field -> this.getOrCreateCategoryForField((Field)field, builder, name), LinkedHashMap::new, Collectors.toList())).forEach((key, value) -> value.forEach(field -> {
            ConfigEntry.Name ann = field.getAnnotation(ConfigEntry.Name.class);
            String fieldName = ann != null ? ann.value() : field.getName();
            List<AbstractConfigListEntry<?>> transformed = this.registry.getAndTransform(fieldName, (Field)field, config, defaults, this.registry);
            Objects.requireNonNull(key);
            transformed.forEach(arg_0 -> ((ConfigCategory)key).addEntry(arg_0));
        }));
        return builder.build();
    }

    private ConfigCategory getOrCreateCategoryForField(Field field, ConfigBuilder screenBuilder, String name) {
        String categoryName = "default";
        if (field.isAnnotationPresent(ConfigEntry.Category.class)) {
            categoryName = field.getAnnotation(ConfigEntry.Category.class).value();
        }
        class_5250 categoryKey = class_2561.method_43470((String)categoryName);
        return screenBuilder.getOrCreateCategory((class_2561)categoryKey);
    }
}

