/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.abilitytree;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportTreeData {
    public String name;
    public List<String> input;
    public static Map<String, ImportTreeData> trees = new HashMap<String, ImportTreeData>();
    public static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static ImportTreeData safeLoadTree(Path pathToFile) {
        ImportTreeData importTreeData;
        block9: {
            BufferedReader reader = Files.newBufferedReader(pathToFile);
            try {
                reader.mark(2);
                int firstChar = reader.read();
                if (firstChar == 91) {
                    throw new IOException("Tree file " + String.valueOf(pathToFile.getFileName()) + " is in API array form! Use /savePlayerAbilityTree to convert it to object form.");
                }
                reader.reset();
                importTreeData = (ImportTreeData)gson.fromJson((Reader)reader, ImportTreeData.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | IOException e) {
                    System.err.println("[ImportTreeData] Failed to load " + String.valueOf(pathToFile) + ":");
                    e.printStackTrace();
                    return null;
                }
            }
            reader.close();
        }
        return importTreeData;
    }

    public static void loadAll() {
        trees.clear();
        Path treesDir = Paths.get("wynncraftimportdata", new String[0]);
        if (!Files.isDirectory(treesDir, new LinkOption[0])) {
            try {
                Files.createDirectories(treesDir, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(treesDir, "*.json");){
            for (Path file : stream) {
                ImportTreeData t = ImportTreeData.safeLoadTree(file);
                if (t == null || t.name == null) continue;
                trees.put(t.name, t);
                System.out.println("[ImportTreeData] Loaded ability tree: " + t.name);
            }
        }
        catch (IOException e) {
            System.err.println("[ImportTreeData] Failed to scan directory: " + String.valueOf(treesDir));
        }
    }

    public static ImportTreeData getTree(String name) {
        return trees.get(name);
    }
}

