/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.abilitytree;

import com.wynntils.core.components.Models;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.character.type.SavableSkillPointSet;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.features.abilitytree.TreeData;
import julianh06.wynnextras.features.abilitytree.TreeLoader;
import julianh06.wynnextras.features.profileviewer.PVScreen;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeCache;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;
import julianh06.wynnextras.features.profileviewer.tabs.TreeTabWidget;
import julianh06.wynnextras.utils.UI.AbilityTreeWidget;
import julianh06.wynnextras.utils.UI.TextInputWidget;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.WEScreen;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5348;

public class TreeScreen
extends WEScreen {
    private Map<String, TreeData> trees = new HashMap<String, TreeData>();
    public List<ClassListWidget> classListWidgets = new ArrayList<ClassListWidget>();
    static TreeData currentViewedTreeData;
    public AbilityTreeWidget abilityWidget;
    static TextInputWidget treeSearchBar;
    static int leftScrollOffset;
    static int rightScrollOffset;
    class_2960 abilityTreeBackground = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/treeloader/abilitytreebackground.png");
    static class_2960 trashcan;

    public TreeScreen() {
        super(class_2561.method_30163((String)"Ability Tree Screen"));
        this.trees = TreeData.trees;
        treeSearchBar = null;
    }

    protected void method_25426() {
        this.classListWidgets.clear();
        this.rootWidgets.clear();
        currentViewedTreeData = null;
        this.abilityWidget = null;
        treeSearchBar = null;
        this.registerScrolling();
        leftScrollOffset = 0;
        rightScrollOffset = 0;
        ClassType type = Models.Character.getClassType();
        if (type != ClassType.NONE) {
            ArrayList<TreeListElement> classTrees = new ArrayList<TreeListElement>();
            int i = 0;
            for (TreeData treeData : this.trees.values()) {
                if (treeData == null || !treeData.className.equals(type.getName())) continue;
                classTrees.add(new TreeListElement(i, this.ui, treeData, true, this));
                ++i;
            }
            ClassListWidget element = new ClassListWidget(classTrees, type.getName(), true);
            this.classListWidgets.add(element);
            this.addRootWidget(element);
        }
        for (Classes classes : Classes.values()) {
            if (classes.toString().equals(type.getName())) continue;
            ArrayList<TreeListElement> classTrees = new ArrayList<TreeListElement>();
            int i = 0;
            for (TreeData treeData : this.trees.values()) {
                if (treeData == null || !treeData.className.equals(classes.toString())) continue;
                classTrees.add(new TreeListElement(i, this.ui, treeData, false, this));
                ++i;
            }
            ClassListWidget element = new ClassListWidget(classTrees, classes.toString(), false);
            this.classListWidgets.add(element);
            this.addRootWidget(element);
        }
    }

    protected void initWithoutInitingScrolling() {
        this.classListWidgets.clear();
        this.rootWidgets.clear();
        currentViewedTreeData = null;
        this.abilityWidget = null;
        treeSearchBar = null;
        leftScrollOffset = 0;
        rightScrollOffset = 0;
        ClassType type = Models.Character.getClassType();
        if (type != ClassType.NONE) {
            ArrayList<TreeListElement> classTrees = new ArrayList<TreeListElement>();
            int i = 0;
            for (TreeData treeData : this.trees.values()) {
                if (treeData == null || !treeData.className.equals(type.getName())) continue;
                classTrees.add(new TreeListElement(i, this.ui, treeData, true, this));
                ++i;
            }
            ClassListWidget element = new ClassListWidget(classTrees, type.getName(), true);
            this.classListWidgets.add(element);
            this.addRootWidget(element);
        }
        for (Classes classes : Classes.values()) {
            if (classes.toString().equals(type.getName())) continue;
            ArrayList<TreeListElement> classTrees = new ArrayList<TreeListElement>();
            int i = 0;
            for (TreeData treeData : this.trees.values()) {
                if (treeData == null || !treeData.className.equals(classes.toString())) continue;
                classTrees.add(new TreeListElement(i, this.ui, treeData, false, this));
                ++i;
            }
            ClassListWidget element = new ClassListWidget(classTrees, classes.toString(), false);
            this.classListWidgets.add(element);
            this.addRootWidget(element);
        }
    }

    @Override
    protected void scrollList(float delta) {
        int sectionWidth = 900;
        int xStart = (int)((double)this.screenWidth * this.ui.getScaleFactor() / 2.0 - (double)sectionWidth);
        boolean yStart = false;
        if ((float)PVScreen.mouseX > this.ui.sx(xStart - 75) && (float)PVScreen.mouseY > this.ui.sy((float)yStart) && (float)PVScreen.mouseX < this.ui.sx(xStart - 25 + sectionWidth) && (float)PVScreen.mouseY < (float)yStart + (float)((double)this.screenHeight * this.ui.getScaleFactor()) && (leftScrollOffset -= (int)delta) < 0) {
            leftScrollOffset = 0;
        }
        if ((float)PVScreen.mouseX > this.ui.sx(xStart + sectionWidth + 15) && (float)PVScreen.mouseY > this.ui.sy((float)yStart) && (float)PVScreen.mouseX < this.ui.sx(xStart + 15 + sectionWidth * 2) && (float)PVScreen.mouseY < (float)yStart + (float)((double)this.screenHeight * this.ui.getScaleFactor()) && (rightScrollOffset -= (int)delta) < 0) {
            rightScrollOffset = 0;
        }
    }

    @Override
    public void updateValues() {
        int sectionWidth = 900;
        int xStart = (int)((double)this.screenWidth * this.ui.getScaleFactor() / 2.0 - (double)sectionWidth);
        int yStart = -leftScrollOffset;
        for (ClassListWidget element : this.classListWidgets) {
            element.setBounds(xStart - 25 - 20, yStart, sectionWidth, 50);
            yStart += element.getHeight() + 20;
        }
        if (this.abilityWidget == null && currentViewedTreeData != null) {
            this.abilityWidget = new AbilityTreeWidget(TreeScreen.currentViewedTreeData.className, xStart, 0, 1800, 750, 100000);
            this.rootWidgets.add(this.abilityWidget);
        }
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        PVScreen.mouseX = mouseX;
        PVScreen.mouseY = mouseY;
        int sectionWidth = 900;
        int xStart = (int)((double)this.screenWidth * this.ui.getScaleFactor() / 2.0 - (double)sectionWidth) - 20;
        boolean yStart = false;
        this.ui.drawRect(xStart - 25 - 20, (float)yStart, sectionWidth + 40, (float)((double)this.screenHeight * this.ui.getScaleFactor()), CustomColor.fromHexString((String)"000000").withAlpha(0.2f));
        this.ui.drawImage(this.abilityTreeBackground, (float)((double)this.screenWidth * this.ui.getScaleFactor()) / 2.0f + 25.0f, (float)yStart - (float)rightScrollOffset % ((float)sectionWidth * 0.7f), sectionWidth, (float)sectionWidth * 0.7f);
        this.ui.drawImage(this.abilityTreeBackground, (float)((double)this.screenWidth * this.ui.getScaleFactor()) / 2.0f + 25.0f, (float)yStart + (float)sectionWidth * 0.7f - (float)rightScrollOffset % ((float)sectionWidth * 0.7f), sectionWidth, (float)sectionWidth * 0.7f);
        this.ui.drawImage(this.abilityTreeBackground, (float)((double)this.screenWidth * this.ui.getScaleFactor()) / 2.0f + 25.0f, (float)yStart + (float)sectionWidth * 0.7f * 2.0f - (float)rightScrollOffset % ((float)sectionWidth * 0.7f), sectionWidth, (float)sectionWidth * 0.7f);
        this.ui.drawImage(this.abilityTreeBackground, (float)((double)this.screenWidth * this.ui.getScaleFactor()) / 2.0f + 25.0f, (float)yStart + (float)sectionWidth * 0.7f * 3.0f - (float)rightScrollOffset % ((float)sectionWidth * 0.7f), sectionWidth, (float)sectionWidth * 0.7f);
        if (currentViewedTreeData == null) {
            return;
        }
        AbilityMapData tree = AbilityTreeCache.getClassMap(TreeScreen.currentViewedTreeData.className.toLowerCase());
        if (tree == null) {
            if (!AbilityTreeCache.isLoading(TreeScreen.currentViewedTreeData.className.toLowerCase()) && !AbilityTreeCache.isLoading(TreeScreen.currentViewedTreeData.className.toLowerCase() + "tree")) {
                AbilityTreeCache.loadClassTree(TreeScreen.currentViewedTreeData.className.toLowerCase());
            }
            return;
        }
        AbilityMapData playerTree = TreeScreen.currentViewedTreeData.playerMap;
        if (tree == null || playerTree == null) {
            return;
        }
        this.abilityWidget.setPlayerTree(playerTree);
        this.abilityWidget.setClassTree(tree);
        this.abilityWidget.setScrollOffset(rightScrollOffset);
        if (PVScreen.searchBar != null) {
            this.abilityWidget.setSearchInput(PVScreen.searchBar.getInput());
        }
        this.abilityWidget.setBounds(xStart, -100, 1800, 750);
    }

    @Override
    protected void drawForeground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        AbilityTreeData treeData;
        int sectionWidth = 900;
        int x = (int)((double)this.screenWidth * this.ui.getScaleFactor() / 2.0 - (double)sectionWidth) - 20;
        int y = 0;
        if (this.abilityWidget != null && treeSearchBar != null && (treeData = AbilityTreeCache.getClassTree(this.abilityWidget.className.toLowerCase())) != null && treeData.pages != null) {
            for (Map<String, AbilityTreeData.Ability> pagee : treeData.pages.values()) {
                for (AbilityTreeData.Ability ability : pagee.values()) {
                    int yStart;
                    if (treeSearchBar.getInput().isEmpty() || ability.name == null || !ability.name.toLowerCase().contains(treeSearchBar.getInput().toLowerCase()) || (yStart = y - 25 + ability.coordinates.y * 75 - rightScrollOffset + 450 * (ability.page - 1)) + 75 <= y) continue;
                    this.ui.drawRectBorders(x + ability.coordinates.x * 75 + 943, yStart - 7, x + ability.coordinates.x * 75 + 943 + 90, yStart - 7 + 90, CustomColor.fromHexString((String)"FFFF00"));
                }
            }
        }
        if (treeSearchBar == null) {
            treeSearchBar = new TextInputWidget(x + sectionWidth, this.getLogicalHeight() - 50, sectionWidth, 40, 10, 13);
            treeSearchBar.setBackgroundColor(null);
            treeSearchBar.setTextColor(CustomColor.fromHexString((String)"FFFFFF"));
            treeSearchBar.setPlaceholder("Search for ability...");
            this.rootWidgets.add(treeSearchBar);
        } else {
            this.ui.drawButton(x + sectionWidth + 40, this.getLogicalHeight() - 50, sectionWidth, 50.0f, 17, treeSearchBar.isHovered());
            treeSearchBar.setBounds(x + sectionWidth + 43, this.getLogicalHeight() - 50, sectionWidth, 40);
            treeSearchBar.draw(ctx, mouseX, mouseY, tickDelta, this.ui);
        }
        if (this.abilityWidget != null) {
            this.abilityWidget.drawNodeTooltip(ctx, mouseX, mouseY);
        }
    }

    public void method_25419() {
        for (ClassListWidget widget : this.classListWidgets) {
            for (TreeListElement element : widget.elements) {
                if (element.nameInput == null || element.nameInput.getInput() == null) continue;
                TreeData.getTree((String)element.data.name).visibleName = element.nameInput.getInput();
            }
        }
        PVScreen.scrollOffset = 0;
        TreeData.saveAll();
        TreeData.loadAll();
        super.method_25419();
    }

    static {
        trashcan = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/treeloader/trashcan.png");
    }

    public static class TreeListElement
    extends Widget {
        private final int id;
        TreeData data;
        TextInputWidget nameInput;
        LoadButton loadButton;
        ViewButton viewButton;
        LoadButton loadButtonWithSkillpoints;
        DeleteButton deleteButton;
        ConfirmationButton yesButton;
        ConfirmationButton noButton;
        boolean active;
        public boolean pendingDeletion = false;
        public TreeScreen parentScreen;

        public TreeListElement(int id, UIUtils ui, TreeData data, boolean active, TreeScreen screen) {
            super(0, 0, 100, 20);
            this.id = id;
            this.ui = ui;
            this.data = data;
            this.active = active;
            this.viewButton = new ViewButton(data, screen);
            this.addChild(this.viewButton);
            this.deleteButton = new DeleteButton(this);
            this.addChild(this.deleteButton);
            this.parentScreen = screen;
            if (!active) {
                return;
            }
            this.loadButton = new LoadButton(false, data.name);
            this.loadButtonWithSkillpoints = new LoadButton(true, data.name);
            this.addChild(this.loadButton);
            this.addChild(this.loadButtonWithSkillpoints);
        }

        @Override
        protected void drawBackground(class_332 context, int mouseX, int mouseY, float tickDelta) {
        }

        @Override
        protected void drawContent(class_332 context, int mouseX, int mouseY, float tickDelta) {
            if (this.nameInput == null) {
                this.nameInput = new TextInputWidget(this.x, this.y, this.width - 140, 50, 10, 13);
                this.nameInput.setInput(this.data.visibleName);
                this.nameInput.setBackgroundColor(null);
                this.nameInput.setTextColor(CustomColor.fromHexString((String)"FFFFFF"));
                this.nameInput.setPlaceholder("<Click here to add a name>");
                this.children.add(this.nameInput);
            } else {
                this.nameInput.setBounds(this.x, this.y, this.width - 140, 40);
            }
            if (!this.active) {
                this.viewButton.setBounds(this.x, this.y + 55, (int)((float)this.width / 2.0f - 25.0f), 125);
            } else {
                this.viewButton.setBounds(this.x, this.y + 55, (int)((float)this.width / 2.0f - 25.0f) / 2 - 2, 60);
                this.loadButton.setBounds(this.x + (int)((float)this.width / 2.0f - 25.0f) / 2 + 2, this.y + 55, (int)((float)this.width / 2.0f - 25.0f) / 2 - 2, 60);
                this.loadButtonWithSkillpoints.setBounds(this.x, this.y + 120, (int)((float)this.width / 2.0f) - 25, 60);
            }
            if (this.deleteButton != null) {
                this.deleteButton.setBounds(this.x + this.width - 50, this.y, 50, 50);
            }
            int iconSize = 75;
            int spacing = 18;
            this.ui.drawButton((float)this.x + (float)this.width / 2.0f - 20.0f, this.y + 55, (float)this.width / 2.0f + 20.0f, iconSize + 50, 17, false);
            if (!this.pendingDeletion) {
                if (this.yesButton != null) {
                    this.children.remove(this.yesButton);
                    this.yesButton = null;
                }
                if (this.noButton != null) {
                    this.children.remove(this.noButton);
                    this.noButton = null;
                }
                this.ui.drawImage(TreeTabWidget.strengthTexture, (float)this.x + (float)this.width / 2.0f - 10.0f, this.y + 60, iconSize, iconSize);
                this.ui.drawCenteredText(String.valueOf(this.data.strength), (float)this.x + (float)this.width / 2.0f + (float)iconSize / 2.0f - 10.0f, this.y + 80 + iconSize, CustomColor.fromHexString((String)"00a800"));
                this.ui.drawImage(TreeTabWidget.dexterityTexture, (float)this.x + (float)this.width / 2.0f + (float)(iconSize + spacing) - 10.0f, this.y + 60, iconSize, iconSize);
                this.ui.drawCenteredText(String.valueOf(this.data.dexterity), (float)this.x + (float)this.width / 2.0f + (float)iconSize / 2.0f + (float)(iconSize + spacing) - 10.0f, this.y + 80 + iconSize, CustomColor.fromHexString((String)"fcfc54"));
                this.ui.drawImage(TreeTabWidget.intelligenceTexture, (float)this.x + (float)this.width / 2.0f + (float)((iconSize + spacing) * 2) - 10.0f, this.y + 60, iconSize, iconSize);
                this.ui.drawCenteredText(String.valueOf(this.data.intelligence), (float)this.x + (float)this.width / 2.0f + (float)iconSize / 2.0f + (float)((iconSize + spacing) * 2) - 10.0f, this.y + 80 + iconSize, CustomColor.fromHexString((String)"54fcfc"));
                this.ui.drawImage(TreeTabWidget.defenceTexture, (float)this.x + (float)this.width / 2.0f + (float)((iconSize + spacing) * 3) - 10.0f, this.y + 60, iconSize, iconSize);
                this.ui.drawCenteredText(String.valueOf(this.data.defence), (float)this.x + (float)this.width / 2.0f + (float)iconSize / 2.0f + (float)((iconSize + spacing) * 3) - 10.0f, this.y + 80 + iconSize, CustomColor.fromHexString((String)"fc5454"));
                this.ui.drawImage(TreeTabWidget.agilityTexture, (float)this.x + (float)this.width / 2.0f + (float)((iconSize + spacing) * 4) - 10.0f, this.y + 60, iconSize, iconSize);
                this.ui.drawCenteredText(String.valueOf(this.data.agility), (float)this.x + (float)this.width / 2.0f + (float)iconSize / 2.0f + (float)((iconSize + spacing) * 4) - 10.0f, this.y + 80 + iconSize, CustomColor.fromHexString((String)"fcfcfc"));
            } else {
                this.ui.drawCenteredText("Do you want to delete this tree?", (float)this.x + (float)(this.width * 3) / 4.0f - 7.5f, this.y + 90, CustomColor.fromHexString((String)"FF0000"), 2.7f);
                if (this.yesButton == null) {
                    this.yesButton = new ConfirmationButton(this, true);
                    this.children.add(this.yesButton);
                }
                if (this.noButton == null) {
                    this.noButton = new ConfirmationButton(this, false);
                    this.children.add(this.noButton);
                }
                this.yesButton.setBounds((int)((float)this.x + (float)(this.width * 3) / 4.0f - 87.5f) - 50, this.y + 110, 100, 50);
                this.noButton.setBounds((int)((float)this.x + (float)(this.width * 3) / 4.0f + 72.5f) - 50, this.y + 110, 100, 50);
            }
            this.ui.drawButton(this.x, this.y, this.width - 60, 50.0f, 17, this.nameInput.isHovered());
        }

        public static class ViewButton
        extends Widget {
            private Runnable action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                currentViewedTreeData = data;
                screen.removeRootWidget(screen.abilityWidget);
                screen.abilityWidget = null;
            };

            public ViewButton(TreeData data, TreeScreen screen) {
                super(0, 0, 0, 0);
            }

            @Override
            protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
                this.ui.drawButton(this.x, this.y, this.width, this.height, 17, this.hovered);
                this.ui.drawCenteredText("View Tree", (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, CustomColor.fromHexString((String)"FFFFFF"), this.height == 60 ? 3.0f : 4.0f);
            }

            @Override
            protected boolean onClick(int button) {
                if (!this.isEnabled()) {
                    return false;
                }
                if (this.action != null) {
                    this.action.run();
                }
                return true;
            }
        }

        public static class DeleteButton
        extends Widget {
            private Runnable action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                parent.pendingDeletion = true;
            };

            public DeleteButton(TreeListElement parent) {
                super(0, 0, 0, 0);
            }

            @Override
            protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
                this.ui.drawButton(this.x, this.y, this.width, this.height, 17, this.hovered);
                this.ui.drawImage(trashcan, this.x + 10, this.y + 10, 30.0f, 30.0f);
            }

            @Override
            protected boolean onClick(int button) {
                if (!this.isEnabled()) {
                    return false;
                }
                if (this.action != null) {
                    this.action.run();
                }
                return true;
            }
        }

        public static class LoadButton
        extends Widget {
            boolean withSkillpoints;
            private Runnable action;

            public LoadButton(boolean withSkillpoints, String treeName) {
                super(0, 0, 0, 0);
                this.withSkillpoints = withSkillpoints;
                this.action = () -> {
                    McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                    TreeData tree = TreeData.getTree(treeName);
                    if (tree == null) {
                        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"This tree doesn't exist.")));
                        return;
                    }
                    McUtils.mc().method_1507(null);
                    TreeLoader.resetAll();
                    TreeLoader.wasStarted = true;
                    TreeLoader.resetTree = true;
                    List<AbilityTreeData.Ability> abilities = TreeLoader.calculateNodeOrder(tree.playerTree.archetypes, TreeLoader.convertNodeMapToList(tree.playerMap), new ArrayList<String>(), tree.playerTree);
                    ArrayList<AbilityMapData.Node> nodes = new ArrayList<AbilityMapData.Node>();
                    for (AbilityTreeData.Ability ability : abilities) {
                        nodes.add(TreeLoader.getNodeFromAbility(ability, tree.playerMap));
                    }
                    TreeLoader.abilitiesToClick2 = nodes;
                    TreeLoader.loadSkillpoints = withSkillpoints;
                    int[] points = new int[]{tree.strength, tree.dexterity, tree.intelligence, tree.defence, tree.agility};
                    TreeLoader.skillPointSet = withSkillpoints ? new SavableSkillPointSet(points) : null;
                    TreeLoader.classTree = tree.playerTree;
                };
            }

            @Override
            protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
                this.ui.drawButton(this.x, this.y, this.width, this.height, 17, this.hovered);
                this.ui.drawCenteredText("Load Tree" + (this.withSkillpoints ? " and Skillpoints" : ""), (float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f);
            }

            @Override
            protected boolean onClick(int button) {
                if (!this.isEnabled()) {
                    return false;
                }
                if (this.action != null) {
                    this.action.run();
                }
                return true;
            }
        }

        public static class ConfirmationButton
        extends Widget {
            private Runnable action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                if (yesno) {
                    TreeLoader.deletePlayerAbilityTree(parent.data.name + ".json");
                    ArrayList<Boolean> expanded = new ArrayList<Boolean>();
                    for (ClassListWidget classListWidget : parent.parentScreen.classListWidgets) {
                        expanded.add(classListWidget.expanded);
                    }
                    parent.parentScreen.initWithoutInitingScrolling();
                    int i = 0;
                    for (ClassListWidget classListWidget : parent.parentScreen.classListWidgets) {
                        classListWidget.expanded = (Boolean)expanded.get(i);
                        ++i;
                    }
                    return;
                }
                parent.pendingDeletion = false;
            };
            boolean yesno;

            public ConfirmationButton(TreeListElement parent, boolean yesno) {
                super(0, 0, 0, 0);
                this.yesno = yesno;
            }

            @Override
            protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
                this.ui.drawButton(this.x, this.y, this.width, this.height, 17, this.hovered);
                this.ui.drawCenteredText(this.yesno ? "YES" : "NO", this.x + 50, this.y + 25, CustomColor.fromHexString((String)"FFFFFF"), 2.75f);
            }

            @Override
            protected boolean onClick(int button) {
                if (!this.isEnabled()) {
                    return false;
                }
                if (this.action != null) {
                    this.action.run();
                }
                return true;
            }
        }
    }

    public static class ClassListWidget
    extends Widget {
        class_2960 arrowClosedWhite = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/treeloader/arrow_closed_white.png");
        class_2960 arrowClosedGray = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/treeloader/arrow_closed_gray.png");
        class_2960 arrowOpenedWhite = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/treeloader/arrow_opened_white.png");
        class_2960 arrowOpenedGray = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/treeloader/arrow_opened_gray.png");
        String playerClass;
        boolean active;
        boolean expanded;
        private Runnable action;
        List<TreeListElement> elements;

        public ClassListWidget(List<TreeListElement> elements, String playerClass, boolean active) {
            super(0, 0, 0, 0);
            this.playerClass = playerClass;
            this.active = active;
            this.expanded = active;
            this.elements = elements;
            this.action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                this.expanded = !this.expanded;
            };
            for (TreeListElement element : elements) {
                this.addChild(element);
            }
        }

        @Override
        public int getHeight() {
            if (!this.expanded) {
                return 50;
            }
            return 50 + this.children.size() * 210;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            this.ui.drawCenteredText(this.playerClass, (float)this.x + (float)this.width / 2.0f, this.y + 25, this.active ? CustomColor.fromHexString((String)"FFFFFF") : CustomColor.fromHexString((String)"909090"));
            this.ui.drawRect(this.x, (float)this.y + 22.5f, (float)this.width / 2.0f - (float)McUtils.mc().field_1772.method_27525((class_5348)class_2561.method_30163((String)("     " + this.playerClass + "     "))), 5.0f, this.active ? CustomColor.fromHexString((String)"FFFFFF") : CustomColor.fromHexString((String)"909090"));
            this.ui.drawRect((float)this.x + (float)this.width / 2.0f + (float)McUtils.mc().field_1772.method_27525((class_5348)class_2561.method_30163((String)("     " + this.playerClass + "     "))), (float)this.y + 22.5f, (float)this.width / 2.0f - (float)McUtils.mc().field_1772.method_27525((class_5348)class_2561.method_30163((String)("     " + this.playerClass + "     "))) - 50.0f, 5.0f, this.active ? CustomColor.fromHexString((String)"FFFFFF") : CustomColor.fromHexString((String)"909090"));
            this.ui.drawImage(this.expanded ? (this.active ? this.arrowOpenedWhite : this.arrowOpenedGray) : (this.active ? this.arrowClosedWhite : this.arrowClosedGray), this.x + this.width - 45, this.y + 5, 40.0f, 40.0f);
            if (!this.expanded) {
                this.clearChildren();
                return;
            }
            int i = 0;
            boolean addChildren = this.children.isEmpty();
            for (TreeListElement element : this.elements) {
                if (addChildren) {
                    this.addChild(element);
                }
                element.setBounds(this.x, this.y + 50 + 210 * i, this.width, 185);
                ++i;
            }
        }

        @Override
        protected boolean onClick(int button) {
            if (!this.isEnabled()) {
                return false;
            }
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }

        @Override
        public boolean mouseClicked(double mx, double my, int button) {
            for (TreeListElement element : this.elements) {
                if (element == null || element.nameInput == null) continue;
                element.nameInput.setFocused(false);
                element.nameInput.blinkToggle = false;
            }
            return super.mouseClicked(mx, my, button);
        }
    }

    public static enum Classes {
        Warrior,
        Shaman,
        Mage,
        Assassin,
        Archer;

    }
}

