/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wynntils.core.components.Models;
import com.wynntils.models.raid.raids.RaidKind;
import com.wynntils.models.raid.type.RaidInfo;
import com.wynntils.models.raid.type.RaidRoomInfo;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Time;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.mixin.RaidKindAccessor;
import julianh06.wynnextras.utils.ChatUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class RaidChatNotifier {
    public static RaidChatNotifier INSTANCE = new RaidChatNotifier();
    public Map<String, Long> raidPBs = new HashMap<String, Long>();
    public static long disableChiropUntil = 0L;
    private static final List<RaidMessageDetector> detectors = Arrays.asList(new SlimeGatheringDetector(), new BindingSealDetector(), new LightGatheringDetector(), new WatchPhaseDetector(), new ShadowlingDetector(), new SingleOccurrenceDetector("is preparing to descend! [1/2]", "\u00a7bDescend 1/2 \u00a7c", "descend1"), new SingleOccurrenceDetector("is preparing to descend! [2/2]", "\u00a7bDescend 2/2 \u00a7c", "descend2"), new SingleOccurrenceDetector("Upper Level must kill the Slime Chomper", "\u00a7bSlime Chomper Spawned \u00a7c", "slimemini"), new SingleOccurrenceDetector("players on the Upper Level must kill the Carnivorous", "\u00a7bCarnivore spawned \u00a7c", "carnimini"), new SingleOccurrenceDetector("players on the Upper Level must kill the Invasive", "\u00a7bTarantula spawned \u00a7c", "taramini"), new SingleOccurrenceDetector("players on the Upper Level must kill the Unfurling", "\u00a7bHorsefly spawned \u00a7c", "horseflymini"), new SingleOccurrenceDetector("The Void Holes have begun to destabi", "\u00a7b[4/5] Void Matters \u00a7c", "voidgathered"), new SingleOccurrenceDetector("A Void Pedestal has been activated! [1/2]", "\u00a7bVoid Pedestal Activated [1/2] \u00a7c", "voidpedestal1"), new SingleOccurrenceDetector("A Void Pedestal has been activated! [2/2]", "\u00a7bVoid Pedestal Activated [2/2] \u00a7c", "voidpedestal2"), new SingleOccurrenceDetector("The lower door has been unlocked", "\u00a7bLower door unlocked \u00a7c", "lowerdoorunlock"), new SingleOccurrenceDetector("The Upper door has been unlocked", "\u00a7bUpper door unlocked \u00a7c", "upperdoorunlock"), new SingleOccurrenceDetector("has picked up the Wings!", "\u00a7bWings picked up \u00a7c", "wings"), new MultiOccurrenceDetector("A new platform has appeared on the Lower Area!", "\u00a7bLower Mini spawned \u00a7c", "lowermini"), new MultiOccurrenceDetector("A Bulb Keeper has spawned!", "\u00a7bBulb Keeper spawned \u00a7c", "bulbspawned"), new MultiOccurrenceDetector("A Red Bulb has been captured!", "\u00a7bBulb captured \u00a7c", "bulbcaptured"), new MultiOccurrenceDetector("[+1 Void Matter]", "\u00a7b[+1 Void Matter] \u00a7c", "voidmattergathered"), new MultiOccurrenceDetector("3/3 Clouds Purified", "\u00a7bPurified 3/3 clouds \u00a7c", "clouds"), new MultiOccurrenceDetector("The Team has reached the Checkpoint!", "\u00a7bReached Checkpoint \u00a7c", "mazecheckpoint"), new MultiOccurrenceDetector("100% Rock Destroyed", "\u00a7bRock destroyed \u00a7c", "rockdestroyed"), new MultiOccurrenceDetector("[+1 Slimey Goo]", "\u00a7fGot 1 Slimey Goo \u00a7c", "slimegathered"), new MultiOccurrenceDetector("[+2 Slimey Goo]", "\u00a7fGot 2 Slimey Goo \u00a7c", "2slimesgathered"), new MultiOccurrenceDetector("+1 [Isoptera Heart]", "\u00a7fGot heart \u00a7c", "heart"), new MultiOccurrenceDetector("has entered the tree", "\u00a7bEntered the Tree \u00a7c", "treeenter"), new MultiOccurrenceDetector("A player must stand on the platform at", "\u00a7bPlatform spawned \u00a7c", "platformspawnedtcc"), new MultiOccurrenceDetector("A miniboss has spawned! It has sped", "\u00a7bMiniboss spawned \u00a7c", "minibossspawnedtcc"), new MultiOccurrenceDetector("The golem has been defeated, and the", "\u00a7bGolem defeated \u00a7c", "golemdefeated"));
    private static final WynnExtrasConfig config = SimpleConfig.getInstance(WynnExtrasConfig.class);
    public static final List<Pattern> BLOCKED_PATTERNS = Arrays.asList(Pattern.compile("is preparing to descend! \\[1/2", 2), Pattern.compile("is preparing to descend! \\[2/2", 2), Pattern.compile("upper level must kill the slime chomper", 2), Pattern.compile("players on the upper level must kill the carnivorous", 2), Pattern.compile("players on the upper level must kill the invasive", 2), Pattern.compile("players on the upper level must kill the unfurling", 2), Pattern.compile("the void holes have begun to destabi", 2), Pattern.compile("a new platform has appeared on the lower area!", 2), Pattern.compile("3/3 clouds purified", 2), Pattern.compile("the team has reached the checkpoint!", 2), Pattern.compile("100% rock destroyed", 2), Pattern.compile("1 slimey goo", 2), Pattern.compile("2 slimey goo", 2), Pattern.compile("1 \\[isoptera heart", 2), Pattern.compile("The void holes inside the tree are open!", 2), Pattern.compile("The Altar has opened to the void, you may leave through it.", 2), Pattern.compile("A Red Bulb has been captured!", 2), Pattern.compile("A Bulb Keeper has spawned!", 2), Pattern.compile("A Void Pedestal has been activated! \\[1/2]", 2), Pattern.compile("A Void Pedestal has been activated! \\[2/2]", 2), Pattern.compile("\\[1 Void Matter]", 2), Pattern.compile("has entered the tree", 2), Pattern.compile("goo to the tower! \\[(\\d+/\\d+)]", 2), Pattern.compile("binding seal! \\[(\\d+/\\d+)]", 2), Pattern.compile("light crystals to the tower! \\[(\\d+/\\d+)]", 2), Pattern.compile("has been killed! \\[(\\d+/\\d+)]", 2), Pattern.compile("the obelisks have appeared; they must be", 2), Pattern.compile("The lower door has been unlocked.", 2), Pattern.compile("The Upper door has been unlocked!", 2), Pattern.compile("A player must stand on the platform", 2), Pattern.compile("A miniboss has spawned! It has sped", 2), Pattern.compile("The golem has been defeated, and", 2), Pattern.compile("has picked up the Wings!", 2));

    private static void savePB(String key, long time) {
        Long old = RaidChatNotifier.INSTANCE.raidPBs.get(key);
        if (old == null || time < old) {
            RaidChatNotifier.INSTANCE.raidPBs.put(key, time);
            INSTANCE.save();
        }
    }

    private static Long getPB(String key) {
        return RaidChatNotifier.INSTANCE.raidPBs.get(key);
    }

    public static void handleMessage(String rawMsg) {
        if (!RaidChatNotifier.config.toggleRaidTimestamps) {
            return;
        }
        long currentTime = Models.Raid.getCurrentRaid() != null && Models.Raid.getCurrentRaid().getCurrentRoom() != null ? Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime() : 0L;
        String msg = RaidChatNotifier.stripColorCodes(rawMsg);
        for (RaidMessageDetector detector : detectors) {
            if (!detector.matches(msg)) continue;
            String timestamp = Models.Raid.getCurrentRaid() != null && Models.Raid.getCurrentRaid().getCurrentRoom() != null ? RaidChatNotifier.formatTime(currentTime) : "??:??.???";
            String progress = detector.extractProgress(msg);
            String finalMsg = detector.getFormattedMessage(progress, timestamp);
            new Thread(() -> {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!finalMsg.isEmpty()) {
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)finalMsg)));
                }
            }).start();
            return;
        }
    }

    private static String getCurrentRoomTimestamp() {
        if (Models.Raid.getCurrentRaid() == null || Models.Raid.getCurrentRaid().getCurrentRoom() == null) {
            return "??:??.???";
        }
        return RaidChatNotifier.formatTime(Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime());
    }

    private static String formatTime(long millis) {
        long minutes = millis / 1000L / 60L;
        long seconds = millis / 1000L % 60L;
        long ms = millis % 1000L;
        return String.format("%02d:%02d.%03d", minutes, seconds, ms);
    }

    private static String stripColorCodes(String input) {
        return input.replaceAll("\u00a7[0-9a-fk-or]", "");
    }

    public static void resetCounters() {
        for (RaidMessageDetector detector : detectors) {
            if (detector instanceof MultiOccurrenceDetector) {
                MultiOccurrenceDetector m = (MultiOccurrenceDetector)detector;
                m.occurrenceCount = 0;
                continue;
            }
            if (!(detector instanceof WatchPhaseDetector)) continue;
            WatchPhaseDetector w = (WatchPhaseDetector)detector;
            w.resetForNewRaid();
        }
    }

    public static void onRoomCompleted(RaidInfo raidInfo) {
        if (!RaidChatNotifier.config.toggleRaidTimestamps) {
            return;
        }
        int challengeIndex = raidInfo.completedChallengeCount();
        RaidRoomInfo room = raidInfo.getRoomByNumber(challengeIndex);
        if (room == null) {
            return;
        }
        long time = room.getRoomTotalTime();
        String timestamp = RaidChatNotifier.formatTime(time);
        if (RaidChatNotifier.isBossChallenge(raidInfo, challengeIndex)) {
            RaidChatNotifier.handleBossCompleted(raidInfo, room, challengeIndex, time, timestamp);
        } else {
            RaidChatNotifier.handleRoomCompleted(raidInfo, room, timestamp);
        }
    }

    private static void handleRoomCompleted(RaidInfo raidInfo, RaidRoomInfo room, String timestamp) {
        String roomName = room.getRoomName();
        long time = room.getRoomTotalTime();
        String pbKey = raidInfo.getRaidKind().getAbbreviation() + "_" + roomName.replaceAll("\\s", "");
        Long pb = RaidChatNotifier.getPB(pbKey);
        String msg = "\u00a7b" + roomName + " done after \u00a7c" + timestamp;
        if (pb == null || time < pb) {
            RaidChatNotifier.savePB(pbKey, time);
            msg = msg + (String)(pb == null ? " \u00a7e[First PB]" : " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]");
        } else {
            msg = msg + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
        }
        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)msg)));
    }

    private static void handleBossCompleted(RaidInfo raidInfo, RaidRoomInfo room, int index, long time, String timestamp) {
        String bossName = room.getRoomName();
        String raidAbbr = raidInfo.getRaidKind().getAbbreviation();
        String pbKey = "boss_" + raidAbbr + "_" + index;
        Long pb = RaidChatNotifier.getPB(pbKey);
        String msg = "\u00a7a\u00a7l" + bossName + " \u00a7r\u00a7bdefeated after \u00a7c" + timestamp;
        if (pb == null || time < pb) {
            RaidChatNotifier.savePB(pbKey, time);
            msg = msg + (String)(pb == null ? " \u00a7e[First PB]" : " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]");
        } else {
            msg = msg + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
        }
        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)msg)));
    }

    private static boolean isBossChallenge(RaidInfo raidInfo, int challengeIndex) {
        RaidKind kind = raidInfo.getRaidKind();
        int totalChallenges = ((RaidKindAccessor)kind).getChallengeNames().size();
        if ("NOL".equals(kind.getAbbreviation())) {
            return challengeIndex >= totalChallenges - 1;
        }
        return challengeIndex == totalChallenges;
    }

    public void save() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/raidPBs.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                gson.toJson((Object)INSTANCE, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't write PB data:");
            e.printStackTrace();
        }
    }

    public void load() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/raidPBs.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't create config directory:");
            e.printStackTrace();
        }
        if (Files.exists(path, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                RaidChatNotifier loaded = (RaidChatNotifier)gson.fromJson((Reader)reader, this.getClass());
                if (loaded != null) {
                    INSTANCE = loaded;
                }
            }
            catch (IOException e) {
                System.err.println("[WynnExtras] Couldn't read PB data:");
                e.printStackTrace();
            }
        }
    }

    private static interface RaidMessageDetector {
        public boolean matches(String var1);

        public String extractProgress(String var1);

        public String getFormattedMessage(String var1, String var2);
    }

    private static class MultiOccurrenceDetector
    implements RaidMessageDetector {
        private final Pattern pattern;
        private final String baseMessage;
        private final String pbKeyPrefix;
        private int occurrenceCount = 0;
        private long lastTriggerTime = -1L;

        public MultiOccurrenceDetector(String regex, String baseMessage, String pbKeyPrefix) {
            this.pattern = Pattern.compile(Pattern.quote(regex), 2);
            this.baseMessage = baseMessage;
            this.pbKeyPrefix = pbKeyPrefix;
        }

        @Override
        public boolean matches(String msg) {
            return this.pattern.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            if (Models.Raid.getCurrentRaid() == null || Models.Raid.getCurrentRaid().getCurrentRoom() == null) {
                return null;
            }
            long now = System.currentTimeMillis();
            if (this.lastTriggerTime != -1L && now - this.lastTriggerTime < 555L) {
                return null;
            }
            this.lastTriggerTime = now;
            ++this.occurrenceCount;
            return "[" + this.occurrenceCount + "]";
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            String msg;
            if (progress == null) {
                progress = "[" + this.occurrenceCount + "]";
            }
            if (timestamp == null) {
                timestamp = "??:??";
            }
            String key = this.pbKeyPrefix + "_" + this.occurrenceCount;
            if (Models.Raid.getCurrentRaid() != null && Models.Raid.getCurrentRaid().getCurrentRoom() != null) {
                long currentTime = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
                Long pb = RaidChatNotifier.getPB(key);
                if (pb == null || currentTime < pb) {
                    RaidChatNotifier.savePB(key, currentTime);
                    msg = pb == null ? this.baseMessage + (String)progress + " \u00a7c@ " + timestamp + " \u00a7e[First PB]" : this.baseMessage + (String)progress + " \u00a7c@ " + timestamp + " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]";
                } else {
                    msg = this.baseMessage + (String)progress + " \u00a7c@ " + timestamp + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
                }
            } else {
                msg = this.baseMessage + (String)progress + " \u00a7c@ " + timestamp;
            }
            return msg;
        }
    }

    private static class WatchPhaseDetector
    implements RaidMessageDetector {
        private long lastWatchPhaseTime = -1L;
        private static final Pattern PATTERN = Pattern.compile("The Obelisks have appeared; they must be", 2);

        private WatchPhaseDetector() {
        }

        public void resetForNewRaid() {
            this.lastWatchPhaseTime = -1L;
        }

        @Override
        public boolean matches(String msg) {
            return PATTERN.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            return null;
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            String message;
            if (Models.Raid.getCurrentRaid() == null || Models.Raid.getCurrentRaid().getCurrentRoom() == null) {
                return "\u00a7bStarted Watchphase (no raid data)";
            }
            long currentTime = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
            if (this.lastWatchPhaseTime == -1L) {
                message = "\u00a7bFirst Watchphase started \u00a7c@ " + timestamp;
                Long pb = RaidChatNotifier.INSTANCE.raidPBs.get("watch_phase_first");
                if (pb == null || currentTime < pb) {
                    RaidChatNotifier.INSTANCE.raidPBs.put("watch_phase_first", currentTime);
                    SimpleConfig.save(WynnExtrasConfig.class);
                    message = message + (String)(pb == null ? " \u00a7e[First PB]" : " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]");
                } else {
                    message = message + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
                }
            } else {
                long duration = currentTime - this.lastWatchPhaseTime;
                message = "\u00a7bWatchphase started after \u00a7c" + RaidChatNotifier.formatTime(duration) + " \u00a77(@" + timestamp + ")";
                Long pb = RaidChatNotifier.INSTANCE.raidPBs.get("watch_phase_duration");
                if (pb == null || duration < pb) {
                    RaidChatNotifier.INSTANCE.raidPBs.put("watch_phase_duration", duration);
                    SimpleConfig.save(WynnExtrasConfig.class);
                    message = message + (String)(pb == null ? " \u00a7e[First PB]" : " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]");
                } else {
                    message = message + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
                }
            }
            this.lastWatchPhaseTime = currentTime;
            return message;
        }
    }

    private static class SlimeGatheringDetector
    implements RaidMessageDetector {
        private static final Pattern PATTERN = Pattern.compile("Goo to the tower! \\[(\\d+/\\d+)]", 2);
        static final String PB_PREFIX = "slime";

        private SlimeGatheringDetector() {
        }

        @Override
        public boolean matches(String msg) {
            return PATTERN.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            Matcher matcher = PATTERN.matcher(msg);
            return matcher.find() ? matcher.group(1) : null;
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            if (Models.Raid.getCurrentRaid() == null || Models.Raid.getCurrentRaid().getCurrentRoom() == null) {
                return "\u00a7aAdded Slime " + progress + " \u00a7c@ " + timestamp;
            }
            long elapsed = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
            String key = "slime_" + progress;
            Long pb = RaidChatNotifier.getPB(key);
            String output = "\u00a7aAdded Slime " + progress + " \u00a7c@ " + RaidChatNotifier.formatTime(elapsed);
            if (pb == null || elapsed < pb) {
                RaidChatNotifier.savePB(key, elapsed);
                output = pb != null ? output + " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]" : output + " \u00a7e[First PB]";
            } else {
                output = output + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
            }
            return output;
        }
    }

    private static class BindingSealDetector
    implements RaidMessageDetector {
        private static final Pattern PATTERN = Pattern.compile("Binding Seal! \\[(\\d+/\\d+)]", 2);
        static final String PB_PREFIX = "seal";

        private BindingSealDetector() {
        }

        @Override
        public boolean matches(String msg) {
            return PATTERN.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            Matcher matcher = PATTERN.matcher(msg);
            return matcher.find() ? matcher.group(1) : null;
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            long currentMillis = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
            String key = "seal_" + progress;
            Long pb = RaidChatNotifier.getPB(key);
            String output = "\u00a7bCompleted Seal " + progress + " \u00a7c@ " + timestamp;
            if (pb == null || currentMillis < pb) {
                RaidChatNotifier.savePB(key, currentMillis);
                output = pb != null ? output + " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]" : output + " \u00a7e[First PB]";
            } else {
                output = output + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
            }
            return output;
        }
    }

    private static class LightGatheringDetector
    implements RaidMessageDetector {
        private static final Pattern PATTERN = Pattern.compile("Light Crystals to the tower! \\[(\\d+/\\d+)]", 2);
        static final String PB_PREFIX = "lightgathering";

        private LightGatheringDetector() {
        }

        @Override
        public boolean matches(String msg) {
            return PATTERN.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            Matcher matcher = PATTERN.matcher(msg);
            return matcher.find() ? matcher.group(1) : null;
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            long currentMillis = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
            String key = "lightgathering_" + progress;
            Long pb = RaidChatNotifier.getPB(key);
            String output = "\u00a7bAdded light " + progress + " \u00a7c@ " + timestamp;
            if (pb == null || currentMillis < pb) {
                RaidChatNotifier.savePB(key, currentMillis);
                output = pb != null ? output + " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]" : output + " \u00a7e[First PB]";
            } else {
                output = output + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
            }
            return output;
        }
    }

    private static class ShadowlingDetector
    implements RaidMessageDetector {
        private static final Pattern PATTERN = Pattern.compile("has been killed! \\[(\\d+/\\d+)]", 2);
        static final String PB_PREFIX = "shadowling";

        private ShadowlingDetector() {
        }

        @Override
        public boolean matches(String msg) {
            return PATTERN.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            Matcher matcher = PATTERN.matcher(msg);
            return matcher.find() ? matcher.group(1) : null;
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            long currentMillis = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
            if ("3/3".equals(progress) && Time.now().timestamp() >= disableChiropUntil && SimpleConfig.getInstance(WynnExtrasConfig.class).chiropTimer) {
                this.startSpawnCountdown();
            }
            String key = "shadowling_" + progress;
            Long pb = RaidChatNotifier.getPB(key);
            String output = "\u00a7bKilled Shadowling " + progress + " \u00a7c@ " + timestamp;
            if (pb == null || currentMillis < pb) {
                RaidChatNotifier.savePB(key, currentMillis);
                output = output + (String)(pb == null ? " \u00a7e[First PB]" : " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]");
            } else {
                output = output + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
            }
            return output;
        }

        private void startSpawnCountdown() {
            new Thread(() -> {
                try {
                    int i = 7;
                    while (i >= 0) {
                        int countdown = i--;
                        class_310.method_1551().execute(() -> ChatUtils.displayTitle("\u00a7cSPAWNING IN: \u00a7f" + countdown, "", 20, 0, 0, new class_124[0]));
                        Thread.sleep(1000L);
                    }
                    class_310.method_1551().execute(() -> ChatUtils.displayTitle("", "", 0, 0, 0, new class_124[0]));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }).start();
        }
    }

    private static class SingleOccurrenceDetector
    implements RaidMessageDetector {
        private final Pattern pattern;
        private final String formattedMessage;
        private final String pbKey;

        public SingleOccurrenceDetector(String regex, String formattedMessage, String pbKey) {
            this.pattern = Pattern.compile(Pattern.quote(regex), 2);
            this.formattedMessage = formattedMessage;
            this.pbKey = pbKey;
        }

        @Override
        public boolean matches(String msg) {
            return this.pattern.matcher(msg).find();
        }

        @Override
        public String extractProgress(String msg) {
            return null;
        }

        @Override
        public String getFormattedMessage(String progress, String timestamp) {
            String message = this.formattedMessage + timestamp;
            if (Models.Raid.getCurrentRaid() != null && Models.Raid.getCurrentRaid().getCurrentRoom() != null) {
                long currentTime = Models.Raid.getCurrentRaid().getCurrentRoom().getRoomTotalTime();
                Long pb = RaidChatNotifier.getPB(this.pbKey);
                if (pb == null || currentTime < pb) {
                    RaidChatNotifier.savePB(this.pbKey, currentTime);
                    message = message + (String)(pb == null ? " \u00a7e[First PB]" : " \u00a7e[New PB! Old: " + RaidChatNotifier.formatTime(pb) + "]");
                } else {
                    message = message + " \u00a77[PB: " + RaidChatNotifier.formatTime(pb) + "]";
                }
            }
            return message;
        }
    }
}

