/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.inventory;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.tooltips.ItemStatInfoFeature;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.wynnitem.parsing.WynnItemParser;
import com.wynntils.utils.wynn.ColorScaleUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import julianh06.wynnextras.annotations.WEModule;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.core.Core;
import julianh06.wynnextras.event.KeyInputEvent;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@WEModule
public class WeightDisplay {
    public static Map<String, ItemData> itemCache = new ConcurrentHashMap<String, ItemData>();
    public static final Map<String, ItemData> weightCache = new ConcurrentHashMap<String, ItemData>();
    public static boolean upPressed = false;
    public static boolean downPressed = false;
    public static class_1799 currentHoveredStack = null;
    public static WynnItem currentHoveredWynnitem = null;
    private static final Map<String, String> statToApiKey = Map.ofEntries(Map.entry("Health Regen", "healthRegen"), Map.entry("Health Regen Raw", "healthRegenRaw"), Map.entry("Fire Damage", "fireDamage"), Map.entry("Water Damage", "waterDamage"), Map.entry("Thunder Damage", "thunderDamage"), Map.entry("Earth Damage", "earthDamage"), Map.entry("Air Damage", "airDamage"), Map.entry("Spell Damage", "spellDamage"), Map.entry("Main Attack Damage", "mainAttackDamage"), Map.entry("Mana Steal", "manaSteal"), Map.entry("Life Steal", "lifeSteal"), Map.entry("Attack Speed", "attackSpeed"), Map.entry("Walk Speed", "walkSpeed"), Map.entry("Dexterity", "dexterity"), Map.entry("Defence", "defence"), Map.entry("Agility", "agility"), Map.entry("Intelligence", "intelligence"), Map.entry("Strength", "strength"), Map.entry("Jump Height", "jumpHeight"), Map.entry("Poison", "poison"));
    private static final Map<String, String> spellCostMap = Map.ofEntries(Map.entry("heal", "1stSpellCost"), Map.entry("bash", "1stSpellCost"), Map.entry("arrowStorm", "1stSpellCost"), Map.entry("spinAttack", "1stSpellCost"), Map.entry("totem", "1stSpellCost"), Map.entry("teleport", "2ndSpellCost"), Map.entry("charge", "2ndSpellCost"), Map.entry("escape", "2ndSpellCost"), Map.entry("dash", "2ndSpellCost"), Map.entry("haul", "2ndSpellCost"), Map.entry("meteor", "3rdSpellCost"), Map.entry("uppercut", "3rdSpellCost"), Map.entry("arrowBomb", "3rdSpellCost"), Map.entry("multiHit", "3rdSpellCost"), Map.entry("aura", "3rdSpellCost"), Map.entry("iceSnake", "4thSpellCost"), Map.entry("warScream", "4thSpellCost"), Map.entry("arrowShield", "4thSpellCost"), Map.entry("smokeBomb", "4thSpellCost"), Map.entry("uproot", "4thSpellCost"));

    public WeightDisplay() {
        CompletableFuture.runAsync(WeightDisplay::getWeightsFromWynnpool);
    }

    public static WeightData getCachedWeight(String encodedItem, class_1799 itemStack, List<class_2561> wynntilsTooltip) {
        return WeightDisplay.getCachedWeight(encodedItem, false, itemStack, wynntilsTooltip);
    }

    public static WeightData getCachedWeight(String encodedItem, boolean forceUpdate, class_1799 itemStack, List<class_2561> wynntilsTooltip) {
        ItemData itemData = weightCache.get(encodedItem);
        WeightData weightData = null;
        if (itemData != null) {
            weightData = itemData.data.get(itemData.index);
        }
        if (forceUpdate && weightData == null) {
            WeightDisplay.calculateScale(encodedItem, itemStack, wynntilsTooltip);
        }
        return weightData;
    }

    public static void calculateScale(String encodedItem, class_1799 itemStack, List<class_2561> wynntilsTooltip) {
        if (itemStack.method_65130() == null) {
            return;
        }
        String key = itemStack.method_65130().getString().replace("\u00c0", "").replaceAll("\u00a7[0-9a-fk-or]", "").replace("\u2b21 Shiny ", "").strip();
        ItemData weightProfile = itemCache.get(key);
        if (weightProfile == null) {
            return;
        }
        ArrayList<WeightData> calculatedList = new ArrayList<WeightData>();
        for (WeightData weightData : weightProfile.data) {
            Map<String, Float> identifications = WeightDisplay.extractIdentifications(wynntilsTooltip);
            if (identifications.isEmpty()) {
                return;
            }
            HashMap<String, Float> scaled = new HashMap<String, Float>();
            float score = 0.0f;
            for (Map.Entry<String, Float> entry : identifications.entrySet()) {
                String stat = entry.getKey();
                Float value = entry.getValue();
                Float scale = weightData.identifications.getOrDefault(stat, Float.valueOf(0.0f));
                scaled.put(stat, Float.valueOf(value.floatValue() * scale.floatValue()));
                if (scale.floatValue() < 0.0f) {
                    score += Math.abs((100.0f - value.floatValue()) * scale.floatValue());
                    continue;
                }
                score += value.floatValue() * scale.floatValue();
            }
            WeightData calculated = new WeightData(weightData.weightName, scaled, Float.valueOf(score));
            calculatedList.add(calculated);
        }
        ItemData result = new ItemData(encodedItem, calculatedList, 0);
        weightCache.put(encodedItem, result);
    }

    public static Map<String, Float> extractIdentifications(List<class_2561> wynntilsTooltip) {
        HashMap<String, Float> percentages = new HashMap<String, Float>();
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return percentages;
        }
        for (class_2561 line : wynntilsTooltip) {
            String raw = line.getString().strip();
            if (!raw.matches(".*\\[\\d+(\\.\\d+)?%\\]$")) continue;
            int bracketStart = raw.lastIndexOf(91);
            int bracketEnd = raw.lastIndexOf(37);
            if (bracketStart == -1 || bracketEnd == -1 || bracketEnd <= bracketStart) continue;
            try {
                boolean isRaw;
                float percent = Float.parseFloat(raw.substring(bracketStart + 1, bracketEnd));
                String statPart = raw.substring(0, bracketStart).strip();
                boolean bl = isRaw = !statPart.contains("%");
                String[] parts = statPart.split("\\s+");
                if (parts.length < 2) continue;
                String stat = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
                Object key = statToApiKey.getOrDefault(stat, WeightDisplay.fallbackCamelCase(stat));
                if (((String)key).contains("Cost")) {
                    for (Map.Entry<String, String> entry : spellCostMap.entrySet()) {
                        if (!((String)key).toLowerCase().contains(entry.getKey().toLowerCase())) continue;
                        key = entry.getValue();
                        break;
                    }
                }
                if (!(!isRaw || ((String)key).equals("healthRegen") || ((String)key).equals("manaRegen") || ((String)key).contains("Steal") || ((String)key).contains("poison") || ((String)key).contains("jump") || ((String)key).contains("AttackSpeed"))) {
                    key = ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
                    key = "raw" + (String)key;
                } else if (isRaw && ((String)key).equals("healthRegen")) {
                    key = (String)key + "Raw";
                } else if (isRaw && ((String)key).contains("AttackSpeed")) {
                    key = "rawAttackSpeed";
                }
                percentages.put((String)key, Float.valueOf(percent));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return percentages;
    }

    private static void getWeightsFromWynnpool() {
        try {
            URL url = new URI("https://api.wynnpool.com/item/weight/all").toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(false);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                return;
            }
            try (InputStream is = conn.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                WeightDisplay.parseAndCacheWeights(response.toString());
            }
        }
        catch (IOException e) {
            Core.LOGGER.logError("IOException while getting Weights from Wynnpool API: " + e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void parseAndCacheWeights(String json) {
        JsonArray array = JsonParser.parseString((String)json).getAsJsonArray();
        HashMap<String, List> grouped = new HashMap<String, List>();
        for (JsonElement element : array) {
            JsonObject obj = element.getAsJsonObject();
            String itemName = obj.get("item_name").getAsString();
            String weightName = obj.get("weight_name").getAsString();
            JsonObject identifications = obj.getAsJsonObject("identifications");
            HashMap<String, Float> scales = new HashMap<String, Float>();
            for (Map.Entry entry : identifications.entrySet()) {
                scales.put((String)entry.getKey(), Float.valueOf(((JsonElement)entry.getValue()).getAsFloat()));
            }
            WeightData weightData = new WeightData(weightName, scales, Float.valueOf(0.0f));
            grouped.computeIfAbsent(itemName, k -> new ArrayList()).add(weightData);
        }
        for (Map.Entry entry : grouped.entrySet()) {
            String name = (String)entry.getKey();
            List data = (List)entry.getValue();
            ItemData itemData = new ItemData(name, data, 0);
            itemCache.put(name, itemData);
        }
    }

    private static String fallbackCamelCase(String stat) {
        String[] parts = stat.toLowerCase().split(" ");
        if (parts.length == 0) {
            return stat;
        }
        StringBuilder builder = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            builder.append(Character.toUpperCase(parts[i].charAt(0))).append(parts[i].substring(1));
        }
        return builder.toString();
    }

    @SubscribeEvent
    public void onKey(KeyInputEvent event) {
        if (event.getKey() == 265 && event.getAction() == 1) {
            upPressed = true;
        }
        if (event.getKey() == 264 && event.getAction() == 1) {
            downPressed = true;
        }
    }

    public static List<class_2561> modifyTooltip(List<class_2561> tooltips, WeightData weightData, class_1799 itemStack, String encodedItem) {
        ArrayList<class_2561> modified = new ArrayList<class_2561>();
        if (!tooltips.isEmpty() && itemStack.method_65130() != null) {
            String key = itemStack.method_65130().getString().replace("\u00c0", "").replaceAll("\u00a7[0-9a-fk-or]", "").replace("\u2b21 Shiny ", "").strip();
            ItemData itemData = itemCache.getOrDefault(key, null);
            ItemData scaleData = weightCache.getOrDefault(encodedItem, null);
            if (itemData != null && scaleData != null && !scaleData.data().isEmpty()) {
                int index = itemData.index();
                class_2561 first = tooltips.getFirst();
                modified.add((class_2561)first.method_27661());
                AtomicInteger idx = new AtomicInteger(0);
                for (WeightData data : scaleData.data()) {
                    float score = data.score().floatValue();
                    String scale = data.weightName();
                    class_124 color = index == idx.get() && scaleData.data().size() > 1 && SimpleConfig.getInstance(WynnExtrasConfig.class).showScales ? class_124.field_1068 : class_124.field_1080;
                    ItemStatInfoFeature itemStatInfoFeature = (ItemStatInfoFeature)Managers.Feature.getFeatureInstance(ItemStatInfoFeature.class);
                    class_5250 statWeight = class_2561.method_43470((String)("\u21b3 " + scale + " Scale")).method_27692(color).method_27694(style -> index == idx.get() && scaleData.data().size() > 1 && SimpleConfig.getInstance(WynnExtrasConfig.class).showScales ? style.method_10982(Boolean.valueOf(true)) : style).method_10852((class_2561)ColorScaleUtils.getPercentageTextComponent((NavigableMap)itemStatInfoFeature.getColorMap(), (float)score, (boolean)((Boolean)itemStatInfoFeature.colorLerp.get()), (int)((Integer)itemStatInfoFeature.decimalPlaces.get())));
                    modified.add((class_2561)class_2561.method_43470((String)"  ").method_10852((class_2561)statWeight));
                    idx.incrementAndGet();
                }
                if (scaleData.data().size() > 1 && SimpleConfig.getInstance(WynnExtrasConfig.class).showScales) {
                    modified.add((class_2561)class_2561.method_43470((String)"  \u21b3 Use \u2191 / \u2193 to cycle").method_27692(class_124.field_1063));
                }
            }
        }
        for (int i = 1; i < tooltips.size(); ++i) {
            Float weight;
            String key;
            ItemData itemData;
            StatType statType;
            StyledText normed;
            Matcher statMatcher;
            class_2561 line = tooltips.get(i);
            modified.add(line);
            if (!SimpleConfig.getInstance(WynnExtrasConfig.class).showScales || !(statMatcher = (normed = StyledText.fromComponent((class_2561)line).getNormalized()).getMatcher(WynnItemParser.IDENTIFICATION_STAT_PATTERN)).matches() || (statType = Models.Stat.fromDisplayName(statMatcher.group(6).split("\u00a7")[0], statMatcher.group(3))) == null) continue;
            String apiName = statType.getApiName();
            if (itemStack.method_65130() == null || (itemData = (ItemData)itemCache.getOrDefault(key = itemStack.method_65130().getString().replace("\u00c0", "").replaceAll("\u00a7[0-9a-fk-or]", "").replace("\u2b21 Shiny ", "").strip(), null)) == null || (weight = itemData.data().get(itemData.index()).identifications().get(apiName)) == null) continue;
            String formattedWeight = String.format("%.02f", Float.valueOf(weight.floatValue() * 100.0f));
            class_5250 statWeight = class_2561.method_43470((String)("  \u21b3 Weight: " + formattedWeight + "%")).method_27692(class_124.field_1063);
            modified.add((class_2561)statWeight);
        }
        return modified;
    }

    public record WeightData(String weightName, Map<String, Float> identifications, Float score) {
    }

    public record ItemData(String name, List<WeightData> data, int index) {
    }
}

