/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.misc;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.wynntils.models.raid.raids.RaidKind;
import com.wynntils.models.raid.type.RaidInfo;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.core.command.Command;
import julianh06.wynnextras.core.command.SubCommand;
import julianh06.wynnextras.features.render.PlayerRenderFilter;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class PlayerHider {
    private static WynnExtrasConfig config;
    private static SubCommand toggleSubCmd;
    private static SubCommand addSubCmd;
    private static SubCommand removeSubCmd;
    private static Command playerhiderCmd;
    static boolean inNotg;
    static boolean commandsInitialized;

    public static void registerBossPlayerHider() {
        if (config == null) {
            config = SimpleConfig.getInstance(WynnExtrasConfig.class);
        }
        ClientTickEvents.START_CLIENT_TICK.register(tick -> {
            if (config != null && !commandsInitialized) {
                toggleSubCmd = new SubCommand("toggle", "", context -> {
                    boolean bl = PlayerHider.config.partyMemberHide = !PlayerHider.config.partyMemberHide;
                    if (PlayerHider.config.partyMemberHide) {
                        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Enabled Playerhider")));
                    } else {
                        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Disabled Playerhider")));
                    }
                    SimpleConfig.save(WynnExtrasConfig.class);
                    return 1;
                }, null, null);
                addSubCmd = new SubCommand("add", "", context -> {
                    String arg = StringArgumentType.getString((CommandContext)context, (String)"player");
                    if (arg.isEmpty()) {
                        McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)"Name argument is empty! Usage: /WynnExtras playerhider add <player>"));
                        return 1;
                    }
                    PlayerHider.config.hiddenPlayers.add(arg);
                    McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)("Added " + arg + " to the player hider list.")));
                    SimpleConfig.save(WynnExtrasConfig.class);
                    return 1;
                }, null, List.of(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word())));
                removeSubCmd = new SubCommand("remove", "", context -> {
                    String arg = StringArgumentType.getString((CommandContext)context, (String)"player");
                    if (arg.isEmpty()) {
                        McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)"Name argument is empty! Usage: /WynnExtras playerhider remove <player>"));
                        return 1;
                    }
                    boolean removed = PlayerHider.config.hiddenPlayers.remove(arg);
                    if (removed) {
                        McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)("Removed " + arg + " from the player hider list.")));
                        SimpleConfig.save(WynnExtrasConfig.class);
                    } else {
                        McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)"Player is not in the player hider list!"));
                    }
                    return 1;
                }, null, List.of(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word())));
                playerhiderCmd = new Command("playerhider", "", context -> 1, List.of(addSubCmd, removeSubCmd, toggleSubCmd), null);
                commandsInitialized = true;
            }
            int Distance = SimpleConfig.getInstance(WynnExtrasConfig.class).maxHideDistance;
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            class_746 me = client.field_1724;
            for (class_1657 player : client.field_1687.method_18456()) {
                if (player == null) {
                    if (PlayerHider.config.printDebugToConsole) {
                        System.out.println("PLAYER == NULL");
                    }
                    return;
                }
                if (player == me) continue;
                if (!PlayerHider.config.partyMemberHide || PlayerHider.config.onlyInNotg && !inNotg) {
                    if (PlayerRenderFilter.isHidden(player)) {
                        PlayerRenderFilter.show(player);
                    }
                    return;
                }
                double distance = player.method_19538().method_1022(me.method_19538());
                if (PlayerHider.config.printDebugToConsole) {
                    System.out.println("Distance to " + String.valueOf(player.method_5477()) + " is: " + distance + " max hide distance is: " + Distance);
                }
                if (distance >= (double)Distance) {
                    if (!PlayerRenderFilter.isHidden(player)) continue;
                    PlayerRenderFilter.show(player);
                    continue;
                }
                if (PlayerHider.config.hiddenPlayers.toString().toLowerCase().contains(player.method_5477().getString().toLowerCase())) {
                    PlayerRenderFilter.hide(player);
                    continue;
                }
                if (!PlayerRenderFilter.isHidden(player)) continue;
                PlayerRenderFilter.show(player);
            }
        });
    }

    public static void onRaidStarted(RaidKind raid) {
        if (raid.getAbbreviation().equals("NOG")) {
            inNotg = true;
        }
    }

    public static void onRaidEnded(RaidInfo info) {
        if (info.getRaidKind().getAbbreviation().equals("NOG")) {
            inNotg = false;
        }
    }

    static {
        inNotg = false;
        commandsInitialized = false;
    }
}

