/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.features.profileviewer.CharacterButton;
import julianh06.wynnextras.features.profileviewer.OpenInBrowserButton;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.Searchbar;
import julianh06.wynnextras.features.profileviewer.TabButton;
import julianh06.wynnextras.features.profileviewer.data.CharacterData;
import julianh06.wynnextras.features.profileviewer.tabs.AspectsTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.DungeonsTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.GeneralTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.MiscTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.PlayerWidget;
import julianh06.wynnextras.features.profileviewer.tabs.ProfessionsTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.QuestsTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.RaidsTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.RankingsTabWidget;
import julianh06.wynnextras.features.profileviewer.tabs.TreeTabWidget;
import julianh06.wynnextras.utils.UI.UIUtils;
import julianh06.wynnextras.utils.UI.WEElement;
import julianh06.wynnextras.utils.UI.WEScreen;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1664;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4050;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import net.minecraft.class_898;
import org.joml.Quaternionf;

public class PVScreen
extends WEScreen {
    public static int mouseX = 0;
    public static int mouseY = 0;
    public static List<TabButton> tabButtons = new ArrayList<TabButton>();
    public static List<CharacterButton> characterButtons = new ArrayList<CharacterButton>();
    public static List<String> WETeam = List.of("JulianH06", "Teslanator", "Mikecraft1224", "LegendaryVirus", "elwood24", "BaltrazYT", "pat_crafter07");
    List<String> allQuests = Arrays.asList("???", "A Grave Mistake", "A Hunter's Calling", "A Journey Beyond", "A Journey Further", "A Marauder's Dues", "A Sandy Scandal", "Acquiring Credentials", "Aldorei's Secret Part I", "Aldorei's Secret Part II", "All Roads To Peace", "An Iron Heart Part I", "An Iron Heart Part II", "Arachnids' Ascent", "Beneath the Depths", "Beyond the Grave", "Blazing Retribution", "Bob's Lost Soul", "Canyon Condor", "Clearing the Camps", "Cluck Cluck", "Cook Assistant", "Corrupted Betrayal", "Cowfusion", "Creeper Infiltration", "Crop Failure", "Death Whistle", "Deja Vu", "Desperate Metal", "Dwarves and Doguns Part I", "Dwarves and Doguns Part II", "Dwarves and Doguns Part III", "Dwarves and Doguns Part IV", "Dwelling Walls", "Elemental Exercise", "Enter the Dojo", "Enzan's Brother", "Fallen Delivery", "Fantastic Voyage", "Fate of the Fallen", "Flight in Distress", "Forbidden Prison", "From the Bottom", "From the Mountains", "Frost Bite", "General's Orders", "Grand Youth", "Grave Digger", "Green Gloop", "Haven Antiquity", "Heart of Llevigar", "Hollow Serenity", "Hunger of the Gerts Part I", "Hunger of the Gerts Part II", "Ice Nations", "Infested Plants", "Jungle Fever", "King's Recruit", "Kingdom of Sand", "Lava Springs", "Lazarus Pit", "Lexdale Witch Trials", "Lost in the Jungle", "Lost Royalty", "Lost Soles", "Lost Tower", "Maltic's Well", "Master Piece", "Meaningful Holiday", "Memory Paranoia", "Mini-Quest - Gather Acacia Logs", "Mini-Quest - Gather Acacia Logs II", "Mini-Quest - Gather Avo Logs", "Mini-Quest - Gather Avo Logs II", "Mini-Quest - Gather Avo Logs III", "Mini-Quest - Gather Avo Logs IV", "Mini-Quest - Gather Bamboo", "Mini-Quest - Gather Barley", "Mini-Quest - Gather Bass", "Mini-Quest - Gather Bass II", "Mini-Quest - Gather Bass III", "Mini-Quest - Gather Bass IV", "Mini-Quest - Gather Birch Logs", "Mini-Quest - Gather Carp", "Mini-Quest - Gather Carp II", "Mini-Quest - Gather Cobalt", "Mini-Quest - Gather Cobalt II", "Mini-Quest - Gather Cobalt III", "Mini-Quest - Gather Copper", "Mini-Quest - Gather Dark Logs", "Mini-Quest - Gather Dark Logs II", "Mini-Quest - Gather Dark Logs III", "Mini-Quest - Gather Decay Roots", "Mini-Quest - Gather Decay Roots II", "Mini-Quest - Gather Decay Roots III", "Mini-Quest - Gather Diamonds", "Mini-Quest - Gather Diamonds II", "Mini-Quest - Gather Diamonds III", "Mini-Quest - Gather Diamonds IV", "Mini-Quest - Gather Gold", "Mini-Quest - Gather Gold II", "Mini-Quest - Gather Granite", "Mini-Quest - Gather Gudgeon", "Mini-Quest - Gather Gylia Fish", "Mini-Quest - Gather Gylia Fish II", "Mini-Quest - Gather Gylia Fish III", "Mini-Quest - Gather Hops", "Mini-Quest - Gather Hops II", "Mini-Quest - Gather Icefish", "Mini-Quest - Gather Icefish II", "Mini-Quest - Gather Iron", "Mini-Quest - Gather Iron II", "Mini-Quest - Gather Jungle Logs", "Mini-Quest - Gather Jungle Logs II", "Mini-Quest - Gather Kanderstone", "Mini-Quest - Gather Kanderstone II", "Mini-Quest - Gather Kanderstone III", "Mini-Quest - Gather Koi", "Mini-Quest - Gather Koi II", "Mini-Quest - Gather Koi III", "Mini-Quest - Gather Light Logs", "Mini-Quest - Gather Light Logs II", "Mini-Quest - Gather Light Logs III", "Mini-Quest - Gather Malt", "Mini-Quest - Gather Malt II", "Mini-Quest - Gather Millet", "Mini-Quest - Gather Millet II", "Mini-Quest - Gather Millet III", "Mini-Quest - Gather Molten Eel", "Mini-Quest - Gather Molten Eel II", "Mini-Quest - Gather Molten Eel III", "Mini-Quest - Gather Molten Eel IV", "Mini-Quest - Gather Molten Ore", "Mini-Quest - Gather Molten Ore II", "Mini-Quest - Gather Molten Ore III", "Mini-Quest - Gather Molten Ore IV", "Mini-Quest - Gather Oak Logs", "Mini-Quest - Gather Oats", "Mini-Quest - Gather Oats II", "Mini-Quest - Gather Pine Logs", "Mini-Quest - Gather Pine Logs II", "Mini-Quest - Gather Pine Logs III", "Mini-Quest - Gather Piranhas", "Mini-Quest - Gather Piranhas II", "Mini-Quest - Gather Rice", "Mini-Quest - Gather Rice II", "Mini-Quest - Gather Rice III", "Mini-Quest - Gather Rice IV", "Mini-Quest - Gather Rye", "Mini-Quest - Gather Rye II", "Mini-Quest - Gather Salmon", "Mini-Quest - Gather Salmon II", "Mini-Quest - Gather Sandstone", "Mini-Quest - Gather Sandstone II", "Mini-Quest - Gather Silver", "Mini-Quest - Gather Silver II", "Mini-Quest - Gather Sorghum", "Mini-Quest - Gather Sorghum II", "Mini-Quest - Gather Sorghum III", "Mini-Quest - Gather Sorghum IV", "Mini-Quest - Gather Spruce Logs", "Mini-Quest - Gather Spruce Logs II", "Mini-Quest - Gather Trout", "Mini-Quest - Gather Wheat", "Mini-Quest - Gather Willow Logs", "Mini-Quest - Gather Willow Logs II", "Mini-Quest - Slay Ailuropodas", "Mini-Quest - Slay Angels", "Mini-Quest - Slay Astrochelys Manis", "Mini-Quest - Slay Azers", "Mini-Quest - Slay Conures", "Mini-Quest - Slay Coyotes", "Mini-Quest - Slay Creatures of Nesaak Forest", "Mini-Quest - Slay Creatures of the Void", "Mini-Quest - Slay Dead Villagers", "Mini-Quest - Slay Dragonlings", "Mini-Quest - Slay Felrocs", "Mini-Quest - Slay Frosted Guards & Cryostone Golems", "Mini-Quest - Slay Hobgoblins", "Mini-Quest - Slay Idols", "Mini-Quest - Slay Ifrits", "Mini-Quest - Slay Jinkos", "Mini-Quest - Slay Lizardmen", "Mini-Quest - Slay Magma Entities", "Mini-Quest - Slay Mooshrooms", "Mini-Quest - Slay Myconids", "Mini-Quest - Slay Orcs", "Mini-Quest - Slay Pernix Monkeys", "Mini-Quest - Slay Robots", "Mini-Quest - Slay Scarabs", "Mini-Quest - Slay Skeletons", "Mini-Quest - Slay Slimes", "Mini-Quest - Slay Spiders", "Mini-Quest - Slay Weirds", "Mini-Quest - Slay Wraiths & Phantasms", "Misadventure on the Sea", "Mixed Feelings", "Murder Mystery", "Mushroom Man", "One Thousand Meters Under", "Out of my Mind", "Pirate's Trove", "Pit of the Dead", "Point of No Return", "Poisoning the Pest", "Potion Making", "Purple and Blue", "Realm of Light I - The Worm Holes", "Realm of Light II - Taproot", "Realm of Light III - A Headless History", "Realm of Light IV - Finding the Light", "Realm of Light V - The Realm of Light", "Recipe For Disaster", "Reclaiming the House", "Recover the Past", "Redbeard's Booty", "Reincarnation", "Rise of the Quartron", "Royal Trials", "Shattered Minds", "Stable Story", "Star Thief", "Supply and Delivery", "Taking the Tower", "Temple of the Legends", "Tempo Town Trouble", "The Bigger Picture", "The Breaking Point", "The Canary Calls", "The Canyon Guides", "The Corrupted Village", "The Dark Descent", "The Envoy Part I", "The Envoy Part II", "The Feathers Fly Part I", "The Feathers Fly Part II", "The Hero of Gavel", "The Hidden City", "The House of Twain", "The Lost", "The Maiden Tower", "The Mercenary", "The Olmic Rune", "The Order of the Grook", "The Passage", "The Qira Hive", "The Sewers of Ragni", "The Shadow of the Beast", "The Thanos Depository", "The Ultimate Weapon", "Tower of Ascension", "Tribal Aggression", "Troubled Tribesmen", "Tunnel Trouble", "Underice\u00c0", "Underwater", "Wrath of the Mummy", "WynnExcavation Site A", "WynnExcavation Site B", "WynnExcavation Site C", "WynnExcavation Site D", "Zhight Island");
    static class_2960 tabLeft = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/tableft.png");
    static class_2960 tabMid = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/tabmid.png");
    static class_2960 tagRight = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/tabright.png");
    static class_2960 tabLeftDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/tableft_dark.png");
    static class_2960 tabMidDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/tabmid_dark.png");
    static class_2960 tagRightDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/tabright_dark.png");
    static class_2960 NOTGTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/notg.png");
    static class_2960 NOLTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/nol.png");
    static class_2960 TCCTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/tcc.png");
    static class_2960 TNATexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/tna.png");
    static class_2960 backgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/profileviewerbackground.png");
    static class_2960 alsobackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/alsoprofileviewerbackground.png");
    static class_2960 raidBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/raidbackground.png");
    static class_2960 openInBrowserButtonTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/openinbrowserbuttontexture.png");
    static class_2960 openInBrowserButtonTextureW = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/openinbrowserbuttontexturewide.png");
    static class_2960 classBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundinactive.png");
    static class_2960 classBackgroundTextureGold = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundinactivegold.png");
    static class_2960 classBackgroundTextureActive = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundactive.png");
    static class_2960 onlineCircleTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/onlinecircle.png");
    static class_2960 offlineCircleTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/offlinecircle.png");
    static class_2960 backgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/profileviewerbackground_dark.png");
    static class_2960 alsobackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/alsoprofileviewerbackground_dark.png");
    static class_2960 raidBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/raidbackground_dark.png");
    static class_2960 openInBrowserButtonTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/openinbrowserbuttontexture_dark.png");
    static class_2960 openInBrowserButtonTextureWDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/openinbrowserbuttontexturewide_dark.png");
    static class_2960 classBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundinactive_dark.png");
    static class_2960 classBackgroundTextureGoldDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundinactivegold_dark.png");
    static class_2960 classBackgroundTextureActiveDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classbackgroundactive_dark.png");
    static class_2960 onlineCircleTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/onlinecircle_dark.png");
    static class_2960 offlineCircleTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/offlinecircle_dark.png");
    static class_2960 vip = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/vip.png");
    static class_2960 vipplus = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/vipplus.png");
    static class_2960 hero = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/hero.png");
    static class_2960 heroplus = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/heroplus.png");
    static class_2960 champion = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/champion.png");
    static class_2960 media = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/media.png");
    static class_2960 wynn = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/wynn.png");
    static class_2960 mod = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/moderator.png");
    static class_2960 admin = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/ranks/admin.png");
    static class_2960 warriorTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/warrior.png");
    static class_2960 warriorGoldTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/warriorgold.png");
    static class_2960 shamanTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/shaman.png");
    static class_2960 shamanGoldTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/shamangold.png");
    static class_2960 mageTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/mage.png");
    static class_2960 mageGoldTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/magegold.png");
    static class_2960 assassinTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/assassin.png");
    static class_2960 assassinGoldTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/assassingold.png");
    static class_2960 archerTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/archer.png");
    static class_2960 archerGoldTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/classes/archergold.png");
    static class_2960 decrepitSewersTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/decrepitsewers.png");
    static class_2960 infestedPitTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/infestedpit.png");
    static class_2960 underworldCryptTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/underworldcrypt.png");
    static class_2960 timelostSanctumTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/timelostsanctum.png");
    static class_2960 sandSweptTombTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/sandswepttomb.png");
    static class_2960 iceBarrowsTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/icebarrows.png");
    static class_2960 undergrowthRuinsTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/undergrowthruins.png");
    static class_2960 galleonsGraveyardTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/galleonsgraveyard.png");
    static class_2960 fallenFactoryTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/fallenfactory.png");
    static class_2960 eldritchOutlookTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/eldritchoutlook.png");
    static List<class_2960> dungeonTextures = List.of(decrepitSewersTexture, infestedPitTexture, underworldCryptTexture, timelostSanctumTexture, sandSweptTombTexture, iceBarrowsTexture, undergrowthRuinsTexture, galleonsGraveyardTexture, fallenFactoryTexture, eldritchOutlookTexture);
    static class_2960 dungeonKeyTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/dungeonkey.png");
    static class_2960 corruptedDungeonKeyTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/corrupteddungeonkey.png");
    static class_2960 dungeonBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/dungeonpagebackground.png");
    static class_2960 miscBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/miscpagebackground.png");
    static class_2960 dungeonBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/dungeonpagebackground_dark.png");
    static class_2960 miscBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/miscpagebackground_dark.png");
    static class_2960 miningTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/mining.png");
    static class_2960 woodcuttingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/woodcutting.png");
    static class_2960 farmingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/farming.png");
    static class_2960 fishingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/fishing.png");
    static class_2960 armouringTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/armouring.png");
    static class_2960 tailoringTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/tailoring.png");
    static class_2960 weaponsmithingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/weaponsmithing.png");
    static class_2960 woodworkingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/woodworking.png");
    static class_2960 jewelingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/jeweling.png");
    static class_2960 alchemismTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/alchemism.png");
    static class_2960 scribingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/scribing.png");
    static class_2960 cookingTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/cooking.png");
    static class_2960 profBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/profs/profbackground.png");
    static class_2960 profBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/profs/profbackground_dark.png");
    static class_2960 questBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/quests/questbackground.png");
    static class_2960 questBackgroundBorderTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/quests/questbackgroundborders.png");
    static class_2960 questSearchbarTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/quests/questsearchbar.png");
    static class_2960 questBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/quests/questbackground_dark.png");
    static class_2960 questBackgroundBorderTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/quests/questbackgroundborders_dark.png");
    static class_2960 questSearchbarTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/quests/questsearchbar_dark.png");
    static class_2960 warsCompletionTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/warscompletion.png");
    static class_2960 playerContentTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/playercontent.png");
    static class_2960 globalPlayerContent = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/globalplayercontent.png");
    static class_2960 combatLevelTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/combatlevel.png");
    static class_2960 totalLevelTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/totallevel.png");
    static class_2960 professionLevelTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/professionlevel.png");
    static class_2960 rankingBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/rankingbackground.png");
    static class_2960 rankingBackgroundWideTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/rankingbackgroundwide.png");
    static class_2960 ironmanTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/gamemodes/ironman.png");
    static class_2960 ultimateIronmanTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/gamemodes/ultimateironman.png");
    static class_2960 huntedTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/gamemodes/hunted.png");
    static class_2960 hardcoreTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/gamemodes/hardcore.png");
    static class_2960 hardcoreFailedTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/gamemodes/hardcorefailed.png");
    static class_2960 craftsmanTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/gamemodes/craftsman.png");
    static class_2960 rankingBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/rankingbackground_dark.png");
    static class_2960 rankingBackgroundWideTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/rankingbackgroundwide_dark.png");
    static OpenInBrowserButton openInBrowserButton;
    public static Searchbar searchBar;
    public static Searchbar questSearchBar;
    public static Searchbar treeSearchBar;
    public static Tab currentTab;
    String player;
    public static class_742 dummy;
    public static CharacterData selectedCharacter;
    public static int scrollOffset;
    private static long lastScrollTime;
    private static final long scrollCooldown = 0L;
    BackgroundImageWidget backgroundImageWidget = new BackgroundImageWidget();
    List<TabButtonWidget> tabButtonWidgets = new ArrayList<TabButtonWidget>();
    public static TabWidget currentTabWidget;
    public static DarkModeToggleWidget darkModeToggleWidget;
    public static List<String> lastViewedPlayers;
    public static List<PlayerWidget> lastViewedPlayersWidget;
    public static Map<String, class_2960> lastViewedPlayersSkins;
    static boolean addedNewest;
    public static float playerRotationY;
    private static boolean draggingAllowed;

    public PVScreen(String name) {
        super(class_2561.method_30163((String)"Player Viewer"));
        String player = name == null && McUtils.player() == null ? "null" : (name == null ? McUtils.playerName() : name);
        currentTabWidget = null;
        tabButtons.clear();
        characterButtons.clear();
        openInBrowserButton = null;
        searchBar = null;
        questSearchBar = null;
        treeSearchBar = null;
        selectedCharacter = null;
        int j = 0;
        for (Tab tab : Tab.values()) {
            this.tabButtonWidgets.add(new TabButtonWidget(j, tab, this));
            tabButtons.add(new TabButton(0, 0, 0, 0, tab));
            ++j;
        }
        for (int i = 0; i < 15; ++i) {
            characterButtons.add(new CharacterButton(-1, -1, 0, 0, null));
        }
        this.player = player;
        currentTab = Tab.General;
        this.initAsyncPlayerData();
    }

    private void initAsyncPlayerData() {
        CompletableFuture.runAsync(() -> {
            try {
                while (PV.currentPlayerData == null) {
                    Thread.sleep(50L);
                }
                SkinData skin = PVScreen.fetchSkin(PV.currentPlayerData.getUuid());
                GameProfile profile = PVScreen.createProfileWithSkin(PV.currentPlayerData.getUuid(), this.player, skin);
                final class_310 client = class_310.method_1551();
                class_638 world = client.field_1687;
                if (world != null) {
                    dummy = new class_742(this, world, profile){

                        public class_8685 method_52814() {
                            return client.method_1582().method_52862(this.method_7334());
                        }

                        public boolean method_7348(class_1664 part) {
                            return part != class_1664.field_7559;
                        }
                    };
                    dummy.method_52814().comp_1626();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void method_25426() {
        super.method_25426();
        this.rootWidgets.clear();
        lastViewedPlayersWidget.clear();
        if (currentTabWidget instanceof GeneralTabWidget) {
            currentTabWidget = null;
        }
        if (currentTabWidget == null) {
            currentTabWidget = new GeneralTabWidget(this);
        }
        this.addRootWidget(this.backgroundImageWidget);
        this.addRootWidget(darkModeToggleWidget);
        for (TabButtonWidget tabButtonWidget : this.tabButtonWidgets) {
            this.addRootWidget(tabButtonWidget);
        }
        for (int i = 0; i < lastViewedPlayers.size(); ++i) {
            PlayerWidget widget = new PlayerWidget(i);
            lastViewedPlayersWidget.add(widget);
            this.addRootWidget(widget);
        }
        addedNewest = false;
        this.registerScrolling();
    }

    @Override
    protected void scrollList(float delta) {
        if ((scrollOffset -= (int)delta) < 0) {
            scrollOffset = 0;
        }
    }

    @Override
    public void updateValues() {
        if (dummy != null) {
            class_2960 dummyTexture = dummy.method_52814().comp_1626();
            lastViewedPlayersSkins.put(PV.currentPlayerData.getUsername(), dummyTexture);
        }
        int xStart = this.getLogicalWidth() / 2 - 900 - (this.getLogicalWidth() - 1800 < 200 ? 50 : 0);
        int yStart = this.getLogicalHeight() / 2 - 375;
        this.backgroundImageWidget.setBounds(xStart, yStart, 1800, 750);
        darkModeToggleWidget.setBounds(xStart + 1800 - 120, yStart + 750, 120, 60);
        int totalWidth = 24;
        for (TabButtonWidget tabButtonWidget : this.tabButtonWidgets) {
            int signWidth = this.drawDynamicNameSign(this.drawContext, tabButtonWidget.tab.toString(), xStart + totalWidth, yStart - 57);
            tabButtonWidget.setBounds(xStart + totalWidth, yStart - 55, signWidth, 55);
            tabButtonWidget.setTextOffset(signWidth / 2, 17);
            totalWidth += signWidth + 12;
        }
        if (currentTabWidget == null) {
            return;
        }
        if (!this.rootWidgets.contains(currentTabWidget)) {
            this.addRootWidget(currentTabWidget);
        }
        currentTabWidget.setBounds(xStart, yStart, 1800, 750);
        if (!this.rootWidgets.contains(currentTabWidget)) {
            for (int i = 0; i < lastViewedPlayers.size(); ++i) {
                PlayerWidget widget = new PlayerWidget(i);
                lastViewedPlayersWidget.add(widget);
            }
        }
        for (PlayerWidget playerWidget : lastViewedPlayersWidget) {
            playerWidget.draw(this.drawContext, xStart + currentTabWidget.getWidth(), yStart + 100 * playerWidget.index + 30);
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        PVScreen.mouseX = mouseX;
        PVScreen.mouseY = mouseY;
        super.method_57734();
        this.drawContext = context;
        this.computeScaleAndOffsets();
        if (this.ui == null) {
            this.ui = new UIUtils(context, this.scaleFactor, this.xStart, this.yStart);
        } else {
            this.ui.updateContext(context, this.scaleFactor, this.xStart, this.yStart);
        }
        if (PV.currentPlayerData != null && !addedNewest && PV.currentPlayerData.getUsername() != null) {
            if (lastViewedPlayers.contains(PV.currentPlayerData.getUsername())) {
                lastViewedPlayers.remove(PV.currentPlayerData.getUsername());
            } else if (lastViewedPlayers.size() > 6) {
                lastViewedPlayers.removeLast();
            }
            lastViewedPlayers.addFirst(PV.currentPlayerData.getUsername());
            if (lastViewedPlayers.size() != lastViewedPlayersWidget.size()) {
                ArrayList<PlayerWidget> toRemove = new ArrayList<PlayerWidget>();
                for (Object widget : this.rootWidgets) {
                    if (!(widget instanceof PlayerWidget)) continue;
                    toRemove.add((PlayerWidget)widget);
                }
                this.rootWidgets.removeAll(toRemove);
                for (int i = 0; i < lastViewedPlayers.size(); ++i) {
                    Object widget;
                    widget = new PlayerWidget(i);
                    lastViewedPlayersWidget.add((PlayerWidget)widget);
                    this.addRootWidget((Widget)widget);
                }
            }
            addedNewest = true;
        }
        this.ui.drawBackground();
        this.backgroundImageWidget.draw(context, mouseX, mouseY, delta, this.ui);
        this.updateValues();
        this.updateVisibleListRange();
        this.layoutListElements();
        int xStart = this.getLogicalWidth() / 2 - 900 - (this.getLogicalWidth() - 1800 < 200 ? 50 : 0);
        int yStart = this.getLogicalHeight() / 2 - 374;
        if (openInBrowserButton == null && PV.currentPlayerData != null) {
            openInBrowserButton = new OpenInBrowserButton(-1, -1, (int)(60.0 / this.scaleFactor), (int)(261.0 / this.scaleFactor), "https://wynncraft.com/stats/player/" + String.valueOf(PV.currentPlayerData.getUuid()));
        }
        if (openInBrowserButton != null) {
            openInBrowserButton.setX((int)((double)xStart / this.scaleFactor));
            openInBrowserButton.setY((int)((double)(yStart + currentTabWidget.getHeight()) / this.scaleFactor) + 1);
            PVScreen.openInBrowserButton.buttonText = "Open in browser";
            DarkModeToggleWidget.drawImageWithFade(openInBrowserButtonTextureDark, openInBrowserButtonTexture, xStart, yStart + currentTabWidget.getHeight(), 260.0f, 60.0f, this.ui);
            openInBrowserButton.drawWithTexture(context, null);
        }
        DarkModeToggleWidget.drawImageWithFade(openInBrowserButtonTextureWDark, openInBrowserButtonTextureW, xStart + 267, yStart + currentTabWidget.getHeight(), 300.0f, 60.0f, this.ui);
        if (searchBar == null || searchBar.getInput().equals("Unknown user")) {
            searchBar = new Searchbar(-1, -1, (int)(42.0 / this.scaleFactor), (int)(300.0 / this.scaleFactor));
            if (PV.currentPlayerData == null) {
                searchBar.setInput("Unknown user");
            } else if (PV.currentPlayerData.getUsername() == null) {
                searchBar.setInput("Unknown user");
            } else {
                searchBar.setInput(PV.currentPlayerData.getUsername());
            }
        }
        if (searchBar != null) {
            searchBar.setX((int)((double)(xStart + 267) / this.ui.getScaleFactor()));
            searchBar.setY((int)((double)(yStart + currentTabWidget.getHeight() + 24) / this.ui.getScaleFactor()));
            searchBar.drawWithoutBackground(context, CustomColor.fromHexString((String)"FFFFFF"));
        }
        for (Widget widget : this.rootWidgets) {
            if (widget instanceof BackgroundImageWidget || widget instanceof PlayerWidget) continue;
            widget.draw(context, mouseX, mouseY, delta, this.ui);
        }
        for (PlayerWidget playerWidget : lastViewedPlayersWidget) {
            playerWidget.draw(context, mouseX, mouseY, delta, this.ui);
        }
        int start = Math.max(0, this.firstVisibleIndex - 1);
        int n = Math.min(this.listElements.size() - 1, this.lastVisibleIndex + 1);
        for (int i = start; i <= n; ++i) {
            WEElement e = (WEElement)this.listElements.get(i);
            e.draw(context, mouseX, mouseY, delta, this.ui);
        }
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
    }

    public static class_2960 getProfTexture(String prof) {
        return switch (prof) {
            case "mining" -> miningTexture;
            case "woodcutting" -> woodcuttingTexture;
            case "farming" -> farmingTexture;
            case "fishing" -> fishingTexture;
            case "armouring" -> armouringTexture;
            case "tailoring" -> tailoringTexture;
            case "weaponsmithing" -> weaponsmithingTexture;
            case "woodworking" -> woodworkingTexture;
            case "jeweling" -> jewelingTexture;
            case "alchemism" -> alchemismTexture;
            case "scribing" -> scribingTexture;
            case "cooking" -> cookingTexture;
            default -> null;
        };
    }

    public static int getDungeonComps(int i, Map<String, Integer> map) {
        return switch (i) {
            case 0 -> map.getOrDefault("Decrepit Sewers", 0);
            case 1 -> map.getOrDefault("Infested Pit", 0);
            case 2 -> map.getOrDefault("Underworld Crypt", 0);
            case 3 -> map.getOrDefault("Timelost Sanctum", 0);
            case 4 -> map.getOrDefault("Sand-Swept Tomb", 0);
            case 5 -> map.getOrDefault("Ice Barrows", 0);
            case 6 -> map.getOrDefault("Undergrowth Ruins", 0);
            case 7 -> map.getOrDefault("Galleon's Graveyard", 0);
            case 8 -> map.getOrDefault("Fallen Factory", 0);
            case 9 -> map.getOrDefault("Eldritch Outlook", 0);
            case 10 -> map.getOrDefault("Lost Sanctuary", 0);
            default -> 0;
        };
    }

    public static int getCorruptedComps(int i, Map<String, Integer> map) {
        return switch (i) {
            case 0 -> map.getOrDefault("Corrupted Decrepit Sewers", 0);
            case 1 -> map.getOrDefault("Corrupted Infested Pit", 0);
            case 2 -> map.getOrDefault("Corrupted Underworld Crypt", 0);
            case 3 -> map.getOrDefault("Corrupted Timelost Sanctum", 0);
            case 4 -> map.getOrDefault("Corrupted Sand-Swept Tomb", 0);
            case 5 -> map.getOrDefault("Corrupted Ice Barrows", 0);
            case 6 -> map.getOrDefault("Corrupted Undergrowth Ruins", 0);
            case 7 -> map.getOrDefault("Corrupted Galleon's Graveyard", 0);
            case 8 -> map.getOrDefault("Corrupted Lost Sanctuary", 0);
            default -> 0;
        };
    }

    public static String getDungeonName(int i) {
        return switch (i) {
            case 0 -> "Decrepit Sewers";
            case 1 -> "Infested Pit";
            case 2 -> "Underworld Crypt";
            case 3 -> "Timelost Sanctum";
            case 4 -> "Sand-Swept Tomb";
            case 5 -> "Ice Barrows";
            case 6 -> "Undergrowth Ruins";
            case 7 -> "Galleon's Graveyard";
            case 8 -> "Fallen Factory";
            case 9 -> "Eldritch Outlook";
            default -> "";
        };
    }

    public static String getClassName(CharacterData entry) {
        if (entry == null) {
            return "";
        }
        if (entry.getNickname() != null) {
            return "*\u00a7o" + entry.getNickname() + "\u00a7r";
        }
        if (entry.getReskin() != null) {
            if (entry.getReskin().equals("DARKWIZARD")) {
                return "Dark Wizard";
            }
            return entry.getReskin().charAt(0) + entry.getReskin().substring(1).toLowerCase();
        }
        if (entry.getType() == null) {
            return "";
        }
        return entry.getType().charAt(0) + entry.getType().substring(1).toLowerCase();
    }

    public void method_25419() {
        PV.currentPlayer = "";
        PV.currentPlayerData = null;
        currentTabWidget = null;
        dummy = null;
        openInBrowserButton = null;
        searchBar = null;
        questSearchBar = null;
        treeSearchBar = null;
        super.method_25419();
    }

    public static Rank getRank() {
        String rank = PV.currentPlayerData.getRank();
        if (rank == null) {
            return Rank.NONE;
        }
        if (rank.equals("Player")) {
            String string = PV.currentPlayerData.getSupportRank();
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"player", "vip", "vipplus", "hero", "heroplus", "champion"}, (Object)string, n)) {
                case 0 -> Rank.NONE;
                case 1 -> Rank.VIP;
                case 2 -> Rank.VIPPLUS;
                case 3 -> Rank.HERO;
                case 4 -> Rank.HEROPLUS;
                case 5 -> Rank.CHAMPION;
                case -1 -> Rank.NONE;
                default -> Rank.WYNN;
            };
        }
        return switch (rank) {
            case "Media" -> Rank.MEDIA;
            case "Moderator" -> Rank.MOD;
            case "Administrator" -> Rank.ADMIN;
            default -> Rank.WYNN;
        };
    }

    public static class_2960 getRankBadge() {
        Rank rank;
        Rank rank2 = rank = PVScreen.getRank();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"VIP", "VIPPLUS", "HERO", "HEROPLUS", "CHAMPION", "MEDIA", "MOD", "WYNN", "ADMIN"}, (Rank)rank2, n)) {
            case 0 -> vip;
            case 1 -> vipplus;
            case 2 -> hero;
            case 3 -> heroplus;
            case 4 -> champion;
            case 5 -> media;
            case 6 -> mod;
            case 7 -> wynn;
            case 8 -> admin;
            default -> null;
        };
    }

    public static int getRankBadgeWidth() {
        Rank rank;
        Rank rank2 = rank = PVScreen.getRank();
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"VIP", "VIPPLUS", "HERO", "HEROPLUS", "CHAMPION", "MEDIA", "ADMIN", "WYNN", "MOD"}, (Rank)rank2, n)) {
            case 0 -> 66;
            case 1 -> 87;
            case 2 -> 93;
            case 3 -> 114;
            case 4 -> 159;
            case 5, 6 -> 105;
            case 7 -> 90;
            case 8 -> 183;
            default -> 0;
        };
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && draggingAllowed) {
            playerRotationY -= (float)deltaX * 1.25f;
            playerRotationY %= 360.0f;
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void drawPlayer(class_332 context, int x, int y, int scale, float mouseX, float mouseY, class_1309 player, double scaleFactor) {
        float sleepOffsetY;
        float sleepOffsetX;
        float flipOffset = 0.0f;
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);
        rotation.rotateY((float)Math.toRadians(-20.0f + playerRotationY));
        if (dummy.method_18376() == class_4050.field_18078) {
            rotation.rotateY(1.5707964f);
            rotation.rotateX((float)Math.PI);
            sleepOffsetX = (float)(180.0 / scaleFactor);
            sleepOffsetY = (float)(30.0 / scaleFactor);
        } else {
            sleepOffsetX = 0.0f;
            sleepOffsetY = 0.0f;
        }
        if (PV.currentPlayer.equalsIgnoreCase("teslanator")) {
            rotation.rotateX((float)Math.PI);
            flipOffset = (float)(-390.0 / scaleFactor);
            rotation.rotateY((float)Math.PI);
        }
        class_898 dispatcher = class_310.method_1551().method_1561();
        dispatcher.method_3948(false);
        float smolScale = 1.0f;
        float thickScale = 1.0f;
        if (PV.currentPlayer.equalsIgnoreCase("legendaryvirus")) {
            smolScale = 0.5f;
            thickScale = 1.5f;
        }
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)(sleepOffsetX + (float)x), (double)(sleepOffsetY + flipOffset + (float)y), 50.0);
        context.method_51448().method_22905(thickScale * (float)scale, smolScale * (float)scale, (float)scale);
        context.method_51448().method_22907(rotation);
        class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
        dispatcher.method_62424((class_1297)player, 0.0, 0.0, 0.0, 1.0f, context.method_51448(), (class_4597)buffer, 0xF000F0);
        buffer.method_22993();
        context.method_51448().method_22909();
        dispatcher.method_3948(true);
    }

    public static SkinData fetchSkin(UUID uuid) throws IOException {
        String url = "https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid) + "?unsigned=false";
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        try (InputStream input = connection.getInputStream();){
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(input)).getAsJsonObject();
            JsonArray properties = json.getAsJsonArray("properties");
            JsonObject skinProperty = properties.get(0).getAsJsonObject();
            String value = skinProperty.get("value").getAsString();
            String signature = skinProperty.get("signature").getAsString();
            SkinData skinData = new SkinData(value, signature);
            return skinData;
        }
    }

    public static GameProfile createProfileWithSkin(UUID uuid, String name, SkinData skin) {
        GameProfile profile = new GameProfile(uuid, name);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.value(), skin.signature()));
        return profile;
    }

    public static class_2960 getClassTexture(String className) {
        return switch (className) {
            case "WARRIOR" -> warriorTexture;
            case "SHAMAN" -> shamanTexture;
            case "ARCHER" -> archerTexture;
            case "MAGE" -> mageTexture;
            case "ASSASSIN" -> assassinTexture;
            default -> null;
        };
    }

    public static class_2960 getGoldClassTexture(String className) {
        return switch (className) {
            case "WARRIOR" -> warriorGoldTexture;
            case "SHAMAN" -> shamanGoldTexture;
            case "ARCHER" -> archerGoldTexture;
            case "MAGE" -> mageGoldTexture;
            case "ASSASSIN" -> assassinGoldTexture;
            default -> null;
        };
    }

    public static void onClick() {
        if (openInBrowserButton == null || searchBar == null || currentTab == Tab.Quests && questSearchBar == null || currentTab == Tab.Tree && treeSearchBar == null) {
            return;
        }
        if (openInBrowserButton.isClickInBounds(mouseX, mouseY)) {
            McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
            openInBrowserButton.click();
        }
        if (searchBar != null) {
            if (searchBar.isClickInBounds(mouseX, mouseY)) {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                searchBar.click();
            } else {
                searchBar.setActive(false);
            }
        }
        if (questSearchBar != null) {
            if (questSearchBar.isClickInBounds(mouseX, mouseY)) {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                questSearchBar.click();
            } else {
                questSearchBar.setActive(false);
            }
        }
        if (treeSearchBar != null) {
            if (treeSearchBar.isClickInBounds(mouseX, mouseY)) {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                treeSearchBar.click();
            } else {
                treeSearchBar.setActive(false);
            }
        }
    }

    public int drawDynamicNameSign(class_332 context, String input, int x, int y) {
        class_327 textRenderer = class_310.method_1551().field_1772;
        int strWidth = textRenderer.method_1727(input) + 10;
        int strMidWidth = strWidth - 15;
        int amount = Math.max(0, Math.ceilDiv(strMidWidth, 10));
        DarkModeToggleWidget.drawImageWithFade(tabLeftDark, tabLeft, x, y, 30.0f, 60.0f, this.ui);
        for (int i = 0; i < amount; ++i) {
            DarkModeToggleWidget.drawImageWithFade(tabMidDark, tabMid, x + 30 * (i + 1), y, 30.0f, 60.0f, this.ui);
        }
        DarkModeToggleWidget.drawImageWithFade(tagRightDark, tagRight, x + 30 * (amount + 1), y, 30.0f, 60.0f, this.ui);
        return 60 + amount * 30;
    }

    private static TabWidget getTabWidget(Tab tab, PVScreen pvScreen) {
        Tab tab2 = tab;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"General", "Raids", "Rankings", "Professions", "Dungeons", "Quests", "Tree", "Aspects", "Misc"}, (Tab)tab2, n)) {
            case 0 -> new GeneralTabWidget(pvScreen);
            case 1 -> new RaidsTabWidget();
            case 2 -> new RankingsTabWidget();
            case 3 -> new ProfessionsTabWidget();
            case 4 -> new DungeonsTabWidget();
            case 5 -> new QuestsTabWidget();
            case 6 -> new TreeTabWidget();
            case 7 -> new AspectsTabWidget();
            case 8 -> new MiscTabWidget();
            default -> new TabWidget(0, 0, 0, 0);
        };
    }

    static {
        currentTab = Tab.General;
        scrollOffset = 0;
        lastScrollTime = 0L;
        darkModeToggleWidget = new DarkModeToggleWidget();
        lastViewedPlayers = new ArrayList<String>();
        lastViewedPlayersWidget = new ArrayList<PlayerWidget>();
        lastViewedPlayersSkins = new HashMap<String, class_2960>();
        addedNewest = false;
        playerRotationY = 0.0f;
        draggingAllowed = false;
    }

    public static class BackgroundImageWidget
    extends Widget {
        public BackgroundImageWidget() {
            super(0, 0, 0, 0);
        }

        @Override
        protected void drawBackground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            if (currentTab == Tab.General) {
                DarkModeToggleWidget.drawImageWithFade(backgroundTextureDark, backgroundTexture, this.x, this.y, this.width, this.height, this.ui);
            } else {
                DarkModeToggleWidget.drawImageWithFade(alsobackgroundTextureDark, alsobackgroundTexture, this.x, this.y, this.width, this.height, this.ui);
            }
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        }
    }

    public static class TabWidget
    extends Widget {
        public TabWidget(int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        }

        @Override
        protected void drawForeground(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        }

        @Override
        public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return false;
        }

        @Override
        public boolean mouseReleased(double mx, double my, int button) {
            return super.mouseReleased(mx, my, button);
        }
    }

    public static enum Tab {
        General,
        Raids,
        Rankings,
        Professions,
        Dungeons,
        Quests,
        Tree,
        Aspects,
        Misc;

    }

    public static class TabButtonWidget
    extends Widget {
        int index;
        Tab tab;
        private Runnable action;
        int textXOffset = 0;
        int textYOffset = 0;

        public TabButtonWidget(int index, Tab tab, PVScreen parent) {
            super(0, 0, 0, 0);
            this.index = index;
            this.tab = tab;
            this.action = () -> {
                if (PV.currentPlayerData == null) {
                    return;
                }
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                if (tab == currentTab) {
                    return;
                }
                currentTab = tab;
                TabWidget tabWidget = PVScreen.getTabWidget(tab, parent);
                if (tabWidget == null || tabWidget.equals(currentTabWidget)) {
                    parent.removeRootWidget(currentTabWidget);
                    currentTabWidget = null;
                } else {
                    parent.removeRootWidget(currentTabWidget);
                    currentTabWidget = tabWidget;
                    scrollOffset = 0;
                    if (!parent.rootWidgets.contains(tabWidget)) {
                        parent.addRootWidget(tabWidget);
                    }
                }
            };
        }

        protected void setTextOffset(int x, int y) {
            this.textXOffset = x;
            this.textYOffset = y;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            CustomColor tabStringColor = this.tab.equals((Object)currentTab) || this.hovered ? CustomColor.fromHexString((String)"FFFF00") : (selectedCharacter == null && (this.tab.equals((Object)Tab.Professions) || this.tab.equals((Object)Tab.Quests) || this.tab.equals((Object)Tab.Tree)) ? CustomColor.fromHexString((String)"9e9e9e") : CustomColor.fromHexString((String)"FFFFFF"));
            String tabString = this.tab.toString();
            this.ui.drawText(tabString, this.x + this.textXOffset, this.y + this.textYOffset, tabStringColor, HorizontalAlignment.CENTER, VerticalAlignment.TOP, 3.0f);
        }

        @Override
        protected boolean onClick(int button) {
            if (!this.isEnabled()) {
                return false;
            }
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }
    }

    public static class DarkModeToggleWidget
    extends Widget {
        static class_2960 darkmodeToggleBackground = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/darkmodetogglebackground.png");
        static class_2960 darkmodeToggleBackgroundDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/darkmodetogglebackground_dark.png");
        static class_2960 sun = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/sun.png");
        static class_2960 moon = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/moon.png");
        public Runnable action;
        public static float targetX;
        public static float currentX;
        public static float fade;
        private static float targetFade;

        public DarkModeToggleWidget() {
            super(0, 0, 120, 0);
            targetX = SimpleConfig.getInstance(WynnExtrasConfig.class).pvDarkmodeToggle ? (float)this.width - 37.5f : 7.5f;
            this.action = () -> {
                McUtils.playSoundUI((class_3414)((class_3414)class_3417.field_15015.comp_349()));
                SimpleConfig.getInstance(WynnExtrasConfig.class).pvDarkmodeToggle = !SimpleConfig.getInstance(WynnExtrasConfig.class).pvDarkmodeToggle;
                targetX = SimpleConfig.getInstance(WynnExtrasConfig.class).pvDarkmodeToggle ? (float)this.width - 37.5f : 7.5f;
                targetFade = SimpleConfig.getInstance(WynnExtrasConfig.class).pvDarkmodeToggle ? 1.0f : 0.0f;
                SimpleConfig.save(WynnExtrasConfig.class);
            };
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            DarkModeToggleWidget.drawImageWithFade(darkmodeToggleBackgroundDark, darkmodeToggleBackground, this.x, this.y, this.width, this.height, this.ui);
            this.ui.drawImage(sun, (float)this.x + currentX, (float)this.y + 22.5f, 30.0f, 30.0f, 1.0f - fade);
            this.ui.drawImage(moon, (float)this.x + currentX, (float)this.y + 22.5f, 30.0f, 30.0f, fade);
            if (currentX < targetX && (currentX += 10.0f * tickDelta) >= targetX) {
                currentX = targetX;
            }
            if (currentX > targetX && (currentX -= 10.0f * tickDelta) <= targetX) {
                currentX = targetX;
            }
            fade += (targetFade - fade) * 0.15f;
            fade = Math.clamp(fade, 0.0f, 1.0f);
        }

        @Override
        protected boolean onClick(int button) {
            if (!this.isEnabled()) {
                return false;
            }
            if (this.action != null) {
                this.action.run();
            }
            return true;
        }

        public static void drawImageWithFade(class_2960 dark, class_2960 light, float x, float y, float width, float height, UIUtils ui) {
            float a = fade;
            ui.drawImage(light, x, y, width, height, 1.0f - a);
            ui.drawImage(dark, x, y, width, height, a);
        }

        static {
            fade = 0.0f;
            targetFade = 0.0f;
        }
    }

    public static enum Rank {
        NONE,
        VIP,
        VIPPLUS,
        HERO,
        HEROPLUS,
        CHAMPION,
        MEDIA,
        WYNN,
        MOD,
        ADMIN;

    }

    public record SkinData(String value, String signature) {
    }
}

