/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.Time;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import julianh06.wynnextras.annotations.WEModule;
import julianh06.wynnextras.core.CurrentVersionData;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.core.command.Command;
import julianh06.wynnextras.features.guildviewer.data.GuildData;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapDataDeserializer;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeDataDeserializer;
import julianh06.wynnextras.features.profileviewer.data.ApiAspect;
import julianh06.wynnextras.features.profileviewer.data.Aspect;
import julianh06.wynnextras.features.profileviewer.data.IconDeserializer;
import julianh06.wynnextras.features.profileviewer.data.NodeDeserializer;
import julianh06.wynnextras.features.profileviewer.data.OffsetDateTimeAdapter;
import julianh06.wynnextras.features.profileviewer.data.PlayerData;
import julianh06.wynnextras.features.profileviewer.data.User;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5251;

@WEModule
public class WynncraftApiHandler {
    public static WynncraftApiHandler INSTANCE = new WynncraftApiHandler();
    public List<ApiAspect> aspectList = new ArrayList<ApiAspect>();
    public boolean[] waitingForAspectResponse = new boolean[5];
    private static Command apiKeyCmd = new Command("apikey", "", context -> {
        String arg;
        WynncraftApiHandler.INSTANCE.API_KEY = arg = StringArgumentType.getString((CommandContext)context, (String)"key");
        WynncraftApiHandler.save();
        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"You have successfully set your api key. It has been saved in your config. Don't share it publicly.")));
        return 1;
    }, null, List.of(ClientCommandManager.argument((String)"key", (ArgumentType)StringArgumentType.word())));
    private static Command apiKeyCmdNoArgs = new Command("apikey", "", context -> {
        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Add an API key like this: \"/WynnExtras apikey <your key>\". If you play on multiple accounts you can either:\n   1. Add your alt(s) to your existing Wynncraft account so they can share the same API key\n   2. Create a separate Wynncraft account for each Minecraft account, and generate an API key for each\nYou can find a tutorial on how to get your api key in #infos on our discord. Run \"/WynnExtras discord\" to join.")));
        return 1;
    }, null, null);
    private static final String BASE_URL = "https://api.wynncraft.com/v3/player/";
    private static final String BASE_URL_GUILD = "https://api.wynncraft.com/v3/guild/";
    public String API_KEY;
    static Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static CompletableFuture<String> fetchUUID(String playerName) {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.mojang.com/users/profiles/minecraft/" + playerName)).GET().build();
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(body -> {
            try {
                JsonObject json = JsonParser.parseString((String)body).getAsJsonObject();
                return json.get("id").getAsString();
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public static String formatUUID(String rawUUID) {
        return rawUUID.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5");
    }

    public static CompletableFuture<GuildData> fetchGuildData(String prefix) {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        if (WynncraftApiHandler.INSTANCE.API_KEY == null) {
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"\u00a74You currently don't have an api key set, some stats may be hidden to you. Run \"/WynnExtras apikey\" to learn more.")));
            request = HttpRequest.newBuilder().uri(URI.create("https://api.wynncraft.com/v3/guild/prefix/" + prefix + "?identifier=uuid")).GET().build();
        } else {
            request = HttpRequest.newBuilder().uri(URI.create("https://api.wynncraft.com/v3/guild/prefix/" + prefix + "?identifier=uuid")).header("Authorization", "Bearer " + WynncraftApiHandler.INSTANCE.API_KEY).GET().build();
        }
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(WynncraftApiHandler::parseGuildData);
    }

    public static CompletableFuture<List<ApiAspect>> fetchAspectList(String className) {
        HttpClient client = HttpClient.newHttpClient();
        if (WynncraftApiHandler.INSTANCE.API_KEY == null) {
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("You need to set you api-key to upload your aspects. For more info run \"/WynnExtras apikey\""));
            return null;
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.wynncraft.com/v3/aspects/" + className)).header("Authorization", "Bearer " + WynncraftApiHandler.INSTANCE.API_KEY).GET().build();
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(WynncraftApiHandler::parseAspectData);
    }

    public static List<ApiAspect> fetchAllAspects() {
        List<String> classes = List.of("warrior", "shaman", "mage", "archer", "assassin");
        List<ApiAspect> aspectList = WynncraftApiHandler.INSTANCE.aspectList;
        if (!aspectList.isEmpty()) {
            return aspectList;
        }
        int i = 0;
        for (String className : classes) {
            if (WynncraftApiHandler.INSTANCE.waitingForAspectResponse[i]) continue;
            WynncraftApiHandler.INSTANCE.waitingForAspectResponse[i] = true;
            int finalI = i++;
            ((CompletableFuture)WynncraftApiHandler.fetchAspectList(className).thenAccept(result -> {
                if (result == null) {
                    return;
                }
                if (result.isEmpty()) {
                    return;
                }
                WynncraftApiHandler.INSTANCE.waitingForAspectResponse[finalI] = false;
                aspectList.addAll((Collection<ApiAspect>)result);
            })).exceptionally(ex -> {
                System.err.println("Unexpected error: " + ex.getMessage());
                return null;
            });
        }
        return aspectList;
    }

    public static CompletableFuture<PlayerData> fetchPlayerData(String playerName) {
        return WynncraftApiHandler.fetchUUID(playerName).thenCompose(rawUUID -> {
            HttpRequest request;
            if (rawUUID == null) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"\u00a7cPlayername is incorrect or unknown.")));
                return CompletableFuture.completedFuture(null);
            }
            String formattedUUID = WynncraftApiHandler.formatUUID(rawUUID);
            HttpClient client = HttpClient.newHttpClient();
            if (WynncraftApiHandler.INSTANCE.API_KEY == null) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"\u00a74You currently don't have an api key set, some stats may be hidden to you. Run \"/WynnExtras apikey\" to learn more.")));
                request = HttpRequest.newBuilder().uri(URI.create(BASE_URL + formattedUUID + "?fullResult")).GET().build();
            } else {
                request = HttpRequest.newBuilder().uri(URI.create(BASE_URL + formattedUUID + "?fullResult")).header("Authorization", "Bearer " + WynncraftApiHandler.INSTANCE.API_KEY).GET().build();
            }
            return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(WynncraftApiHandler::parsePlayerData);
        });
    }

    public static CompletableFuture<FetchResult> fetchPlayerAspectData(String playerUUID, String requestingUUID) {
        if (playerUUID == null) {
            McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)"\u00a7cUUID is null!"));
            return CompletableFuture.completedFuture(null);
        }
        if (WynncraftApiHandler.INSTANCE.API_KEY == null) {
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("You need to set you api-key to upload your aspects. For more info run \"/we apikey\""));
            return CompletableFuture.completedFuture(new FetchResult(FetchStatus.NOKEYSET, null));
        }
        try {
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(3L)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://wynnextras.com/user")).header("playerUUID", playerUUID).header("Wynncraft-Api-Key", WynncraftApiHandler.INSTANCE.API_KEY).header("RequestingUUID", requestingUUID).timeout(Duration.ofSeconds(8L)).GET().build();
            return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).handle((response, ex) -> {
                if (ex != null) {
                    System.err.println("Server unreachable: " + ex.getMessage());
                    return new FetchResult(FetchStatus.SERVER_UNREACHABLE, null);
                }
                int code = response.statusCode();
                if (code == 403) {
                    return new FetchResult(FetchStatus.FORBIDDEN, null);
                }
                if (code == 401) {
                    return new FetchResult(FetchStatus.UNAUTHORIZED, null);
                }
                if (code == 400) {
                    return new FetchResult(FetchStatus.UNKNOWN_ERROR, null);
                }
                if (code >= 500) {
                    return new FetchResult(FetchStatus.SERVER_ERROR, null);
                }
                if (code != 200) {
                    return new FetchResult(FetchStatus.UNKNOWN_ERROR, null);
                }
                User user = WynncraftApiHandler.parsePlayerAspectData((String)response.body());
                return new FetchResult(FetchStatus.OK, user);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(new FetchResult(FetchStatus.UNKNOWN_ERROR, null));
        }
    }

    public static void processAspects(Map<String, class_3545<String, String>> map) {
        if (WynncraftApiHandler.INSTANCE.API_KEY == null) {
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("You need to set you api-key to upload your aspects. For more info run \"/WynnExtras apikey\""));
            return;
        }
        ArrayList<Aspect> aspects = new ArrayList<Aspect>();
        for (String entry : map.keySet()) {
            int amount = WynncraftApiHandler.parseAspectAmount(map.get(entry));
            Aspect aspect2 = new Aspect();
            aspect2.setAmount(amount);
            aspect2.setName(entry);
            aspect2.setRarity((String)map.get(entry).method_15441());
            aspects.add(aspect2);
        }
        User user = new User();
        user.setUuid(McUtils.player().method_5845());
        user.setPlayerName(McUtils.playerName());
        user.setAspects(aspects);
        user.setModVersion(CurrentVersionData.INSTANCE.version);
        user.setUpdatedAt(Time.now().timestamp());
        WynncraftApiHandler.postPlayerAspectData(user).thenAccept(result -> {
            if (result.status() == FetchStatus.OK) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("\u00a7aSuccessfully uploaded your aspects!"));
            } else if (result.status == FetchStatus.NOKEYSET) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("\u00a7You need to set your api-key to use this feature. Run \"/we apikey\" for more information."));
            } else if (result.status == FetchStatus.FORBIDDEN) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("\u00a74You need to upload your own aspects first to view other peoples aspects. Run \"/we apikey\" for more information."));
            } else if (result.status == FetchStatus.UNAUTHORIZED) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("\u00a74The api-key you have set is not connected to your minecraft account. Run \"/we apikey\" for more information."));
            } else {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix("\u00a74Error: " + String.valueOf((Object)result.status())));
            }
        });
    }

    public static CompletableFuture<FetchResult> postPlayerAspectData(User user) {
        if (user == null) {
            McUtils.sendMessageToClient((class_2561)class_2561.method_30163((String)"\u00a7cUser object is null!"));
            return CompletableFuture.completedFuture(new FetchResult(FetchStatus.UNKNOWN_ERROR, null));
        }
        try {
            String json = gson.toJson((Object)user);
            HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://wynnextras.com/user")).header("Content-Type", "application/json").header("Wynncraft-Api-Key", WynncraftApiHandler.INSTANCE.API_KEY).POST(HttpRequest.BodyPublishers.ofString(json)).timeout(Duration.ofSeconds(8L)).build();
            return client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).handle((response, ex) -> {
                if (ex != null) {
                    System.err.println("Server unreachable: " + ex.getMessage());
                    return new FetchResult(FetchStatus.SERVER_UNREACHABLE, null);
                }
                int code = response.statusCode();
                if (code == 401) {
                    return new FetchResult(FetchStatus.UNAUTHORIZED, null);
                }
                if (code == 400) {
                    return new FetchResult(FetchStatus.UNKNOWN_ERROR, null);
                }
                if (code >= 500) {
                    return new FetchResult(FetchStatus.SERVER_ERROR, null);
                }
                if (code != 200) {
                    System.err.println("POST ERROR: " + code + " \u2192 " + (String)response.body());
                    return new FetchResult(FetchStatus.UNKNOWN_ERROR, null);
                }
                User savedUser = WynncraftApiHandler.parsePlayerAspectData((String)response.body());
                return new FetchResult(FetchStatus.OK, savedUser);
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            return CompletableFuture.completedFuture(new FetchResult(FetchStatus.UNKNOWN_ERROR, null));
        }
    }

    private static int parseAspectAmount(class_3545<String, String> aspect2) {
        String tierText = (String)aspect2.method_15442();
        String rarity = (String)aspect2.method_15441();
        int[] tier1 = new int[]{1, 1, 1};
        int[] tier2 = new int[]{4, 14, 4};
        int[] tier3 = new int[]{10, 60, 25};
        int[] tier4 = new int[]{0, 0, 120};
        int rarityIndex = switch (rarity) {
            case "Mythic" -> 0;
            case "Fabled" -> 1;
            case "Legendary" -> 2;
            default -> -1;
        };
        if (rarityIndex == -1) {
            return 0;
        }
        if (tierText.contains("[MAX]")) {
            return tier1[rarityIndex] + tier2[rarityIndex] + tier3[rarityIndex] + tier4[rarityIndex];
        }
        String currentTier = "";
        if (tierText.contains("Tier I ")) {
            currentTier = "Tier I";
        } else if (tierText.contains("Tier II ")) {
            currentTier = "Tier II";
        } else if (tierText.contains("Tier III ")) {
            currentTier = "Tier III";
        }
        int sum = 0;
        switch (currentTier) {
            case "Tier I": {
                sum += tier1[rarityIndex];
                break;
            }
            case "Tier II": {
                sum += tier1[rarityIndex] + tier2[rarityIndex];
                break;
            }
            case "Tier III": {
                sum += tier1[rarityIndex] + tier2[rarityIndex] + tier3[rarityIndex];
            }
        }
        if (tierText.matches(".*\\[(\\d+)/(\\d+)\\].*")) {
            String bracketContent = tierText.replaceAll(".*\\[(\\d+)/(\\d+)\\].*", "$1");
            int currentProgress = Integer.parseInt(bracketContent);
            sum += currentProgress;
        }
        return sum;
    }

    public static CompletableFuture<AbilityMapData> fetchPlayerAbilityMap(String playerUUID, String characterUUUID) {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        if (WynncraftApiHandler.INSTANCE.API_KEY == null) {
            McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"\u00a74You currently don't have an api key set, some stats may be hidden to you. Run \"/WynnExtras apikey\" to learn more.")));
            request = HttpRequest.newBuilder().uri(URI.create(BASE_URL + playerUUID + "/characters/" + characterUUUID + "/abilities")).GET().build();
        } else {
            request = HttpRequest.newBuilder().uri(URI.create(BASE_URL + playerUUID + "/characters/" + characterUUUID + "/abilities")).header("Authorization", "Bearer " + WynncraftApiHandler.INSTANCE.API_KEY).GET().build();
        }
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(WynncraftApiHandler::parseAbilityMapData);
    }

    public static CompletableFuture<AbilityMapData> fetchClassAbilityMap(String className) {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.wynncraft.com/v3/ability/map/" + className)).GET().build();
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(WynncraftApiHandler::parseAbilityMapData);
    }

    public static CompletableFuture<AbilityTreeData> fetchClassAbilityTree(String className) {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.wynncraft.com/v3/ability/tree/" + className)).GET().build();
        return ((CompletableFuture)client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenApply(WynncraftApiHandler::parseAbilityTreeData);
    }

    private static PlayerData parsePlayerData(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(OffsetDateTime.class, (Object)new OffsetDateTimeAdapter()).create();
        return (PlayerData)gson.fromJson(json, PlayerData.class);
    }

    private static GuildData parseGuildData(String json) {
        Gson gson = new Gson();
        return (GuildData)gson.fromJson(json, GuildData.class);
    }

    private static User parsePlayerAspectData(String json) {
        Gson gson = new Gson();
        return (User)gson.fromJson(json, User.class);
    }

    private static List<ApiAspect> parseAspectData(String json) {
        System.out.println(json);
        Gson gson = new GsonBuilder().registerTypeAdapter(ApiAspect.Icon.class, (Object)new ApiAspect.IconDeserializer()).create();
        Type mapType = new TypeToken<Map<String, ApiAspect>>(){}.getType();
        Map aspectMap = (Map)gson.fromJson(json, mapType);
        return new ArrayList<ApiAspect>(aspectMap.values());
    }

    private static AbilityMapData parseAbilityMapData(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbilityMapData.class, (Object)new AbilityMapDataDeserializer()).registerTypeAdapter(AbilityMapData.Node.class, (Object)new NodeDeserializer()).registerTypeAdapter(AbilityMapData.Icon.class, (Object)new IconDeserializer()).create();
        return (AbilityMapData)gson.fromJson(json, AbilityMapData.class);
    }

    private static AbilityTreeData parseAbilityTreeData(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbilityTreeData.class, (Object)new AbilityTreeDataDeserializer()).registerTypeAdapter(AbilityMapData.Node.class, (Object)new NodeDeserializer()).registerTypeAdapter(AbilityMapData.Icon.class, (Object)new IconDeserializer()).create();
        return (AbilityTreeData)gson.fromJson(json, AbilityTreeData.class);
    }

    public static void load() {
        Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/" + McUtils.player().method_5667().toString() + "/apikeyDoNotShare.json");
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                WynncraftApiHandler loaded = (WynncraftApiHandler)gson.fromJson((Reader)reader, WynncraftApiHandler.class);
                if (loaded != null) {
                    INSTANCE = loaded;
                } else {
                    System.err.println("[WynnExtras] Deserialized data was null, keeping default INSTANCE.");
                }
            }
            catch (IOException e) {
                System.err.println("[WynnExtras] Couldn't read the apikey file:");
                e.printStackTrace();
            }
        }
    }

    public static void save() {
        Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("wynnextras/" + McUtils.player().method_5667().toString() + "/apikeyDoNotShare.json");
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            gson.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[WynnExtras] Couldn't write the apikey file:");
            e.printStackTrace();
        }
    }

    public static List<class_2561> parseStyledHtml(List<String> htmlLines) {
        return htmlLines.stream().map(line -> WynncraftApiHandler.parseSpan(line, class_2583.field_24360)).collect(Collectors.toList());
    }

    public static String sanitizeHtmlString(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("", "");
    }

    private static class_2561 parseSpan(String html, class_2583 inheritedStyle) {
        class_5250 result = null;
        int index = 0;
        while (index < html.length()) {
            class_2561 parsedInner;
            int contentStart;
            int spanEnd;
            int tagEnd;
            int spanStart = html.indexOf("<span", index);
            if (spanStart == -1) {
                String remaining = WynncraftApiHandler.stripHtml(html.substring(index));
                if (remaining.isEmpty()) break;
                class_5250 piece = class_2561.method_43470((String)remaining).method_10862(inheritedStyle);
                result = result == null ? piece : result.method_10852((class_2561)piece);
                break;
            }
            String before = WynncraftApiHandler.stripHtml(html.substring(index, spanStart));
            if (!before.isEmpty()) {
                class_5250 piece = class_2561.method_43470((String)before).method_10862(inheritedStyle);
                class_5250 class_52502 = result = result == null ? piece : result.method_10852((class_2561)piece);
            }
            if ((tagEnd = html.indexOf(">", spanStart)) == -1) break;
            String tag = html.substring(spanStart, tagEnd + 1);
            String style = "";
            Matcher styleMatcher = Pattern.compile("style\\s*=\\s*(['\"])(.*?)\\1").matcher(tag);
            if (styleMatcher.find()) {
                style = styleMatcher.group(2);
            }
            String classAttr = "";
            Matcher classMatcher = Pattern.compile("class\\s*=\\s*(['\"])(.*?)\\1").matcher(tag);
            if (classMatcher.find()) {
                classAttr = classMatcher.group(2);
            }
            if ((spanEnd = WynncraftApiHandler.findMatchingSpanEnd(html, contentStart = tagEnd + 1)) == -1) break;
            String inner = html.substring(contentStart, spanEnd);
            class_2583 newStyle = inheritedStyle.method_10978(Boolean.valueOf(false));
            Matcher colorMatch = Pattern.compile("color:\\s*#([0-9a-fA-F]{6})").matcher(style);
            if (colorMatch.find()) {
                int rgb = Integer.parseInt(colorMatch.group(1), 16);
                newStyle = newStyle.method_27703(class_5251.method_27717((int)rgb));
            }
            if (style.contains("font-weight:bold") || style.contains("font-weight:bolder")) {
                newStyle = newStyle.method_10982(Boolean.valueOf(true));
            }
            if (classAttr != null && !classAttr.isEmpty()) {
                if (classAttr.contains("font-common")) {
                    newStyle = newStyle.method_27704(class_2960.method_60655((String)"minecraft", (String)"common"));
                } else if (classAttr.contains("font-ascii")) {
                    newStyle = newStyle.method_27704(class_2960.method_60655((String)"minecraft", (String)"default"));
                }
            }
            class_5250 piece = (parsedInner = WynncraftApiHandler.parseSpan(inner, newStyle)) instanceof class_5250 ? (class_5250)parsedInner : class_2561.method_43470((String)parsedInner.getString()).method_10862(newStyle);
            result = result == null ? piece : result.method_10852((class_2561)piece);
            index = spanEnd + "</span>".length();
        }
        return result == null ? class_2561.method_43473() : result;
    }

    public static String stripHtml(String input) {
        return input.replaceAll("<[^>]*>", "");
    }

    private static int findMatchingSpanEnd(String html, int contentStart) {
        int index = contentStart;
        int depth = 0;
        while (index < html.length()) {
            int nextOpen = html.indexOf("<span", index);
            int nextClose = html.indexOf("</span>", index);
            if (nextClose == -1) {
                return -1;
            }
            if (nextOpen != -1 && nextOpen < nextClose) {
                ++depth;
                index = nextOpen + 5;
                continue;
            }
            if (depth == 0) {
                return nextClose;
            }
            --depth;
            index = nextClose + 7;
        }
        return -1;
    }

    public record FetchResult(FetchStatus status, User user) {
    }

    public static enum FetchStatus {
        OK,
        NOT_FOUND,
        FORBIDDEN,
        SERVER_UNREACHABLE,
        SERVER_ERROR,
        UNKNOWN_ERROR,
        UNAUTHORIZED,
        NOKEYSET;

    }
}

