/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;

public class AbilityMapDataDeserializer
implements JsonDeserializer<AbilityMapData> {
    public AbilityMapData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        AbilityMapData atd = new AbilityMapData();
        atd.pages = new HashMap<Integer, List<AbilityMapData.Node>>();
        JsonElement root = json;
        if (root.isJsonObject()) {
            JsonObject rootObj = root.getAsJsonObject();
            boolean looksLikePages = true;
            for (Map.Entry e : rootObj.entrySet()) {
                String key = (String)e.getKey();
                if (key.matches("\\d+")) continue;
                looksLikePages = false;
                break;
            }
            if (looksLikePages) {
                for (Map.Entry entry : rootObj.entrySet()) {
                    int page = Integer.parseInt((String)entry.getKey());
                    JsonElement arr = (JsonElement)entry.getValue();
                    if (!arr.isJsonArray()) continue;
                    ArrayList<AbilityMapData.Node> nodes = new ArrayList<AbilityMapData.Node>();
                    for (JsonElement el : arr.getAsJsonArray()) {
                        AbilityMapData.Node node = (AbilityMapData.Node)ctx.deserialize(el, AbilityMapData.Node.class);
                        nodes.add(node);
                    }
                    atd.pages.put(page, nodes);
                }
                return atd;
            }
        }
        if (root.isJsonArray()) {
            for (JsonElement el : root.getAsJsonArray()) {
                AbilityMapData.Node node = (AbilityMapData.Node)ctx.deserialize(el, AbilityMapData.Node.class);
                int page = 0;
                if (node != null && node.meta != null) {
                    page = node.meta.page;
                }
                atd.pages.computeIfAbsent(page, k -> new ArrayList()).add(node);
            }
            return atd;
        }
        JsonObject obj = root.getAsJsonObject();
        if (obj.has("pages") && obj.get("pages").isJsonObject()) {
            JsonObject pagesObj = obj.getAsJsonObject("pages");
            for (Map.Entry entry : pagesObj.entrySet()) {
                int page = Integer.parseInt((String)entry.getKey());
                JsonArray arr = ((JsonElement)entry.getValue()).getAsJsonArray();
                ArrayList<AbilityMapData.Node> nodes = new ArrayList<AbilityMapData.Node>();
                for (JsonElement el : arr) {
                    nodes.add((AbilityMapData.Node)ctx.deserialize(el, AbilityMapData.Node.class));
                }
                atd.pages.put(page, nodes);
            }
            return atd;
        }
        return atd;
    }
}

