/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.WynncraftApiHandler;
import julianh06.wynnextras.features.profileviewer.data.AbilityMapData;
import julianh06.wynnextras.features.profileviewer.data.AbilityTreeData;

public class AbilityTreeCache {
    private static final Map<String, AbilityMapData> classMaps = new HashMap<String, AbilityMapData>();
    private static final Map<String, AbilityTreeData> classTrees = new HashMap<String, AbilityTreeData>();
    private static final Map<String, AbilityMapData> playerTrees = new HashMap<String, AbilityMapData>();
    private static final Set<String> loading = new HashSet<String>();

    public static boolean isLoading(String className) {
        return loading.contains(className);
    }

    public static void loadClassTree(String className) {
        if (classMaps.containsKey(className) || loading.contains(className)) {
            return;
        }
        loading.add(className);
        ((CompletableFuture)WynncraftApiHandler.fetchClassAbilityMap(className).thenAccept(tree -> {
            classMaps.put(className, (AbilityMapData)tree);
            loading.remove(className);
        })).exceptionally(ex -> {
            System.err.println("Failed to load ability tree for " + className + ": " + ex.getMessage());
            loading.remove(className);
            return null;
        });
        loading.add(className + "tree");
        ((CompletableFuture)WynncraftApiHandler.fetchClassAbilityTree(className).thenAccept(tree -> {
            classTrees.put(className, (AbilityTreeData)tree);
            loading.remove(className + "tree");
        })).exceptionally(ex -> {
            System.err.println("Failed to load ability tree for " + className + ": " + ex.getMessage());
            loading.remove(className + "tree");
            return null;
        });
    }

    public static void loadCharacterTree(String characterUUID) {
        if (playerTrees.containsKey(characterUUID) || loading.contains(characterUUID)) {
            return;
        }
        loading.add(characterUUID);
        ((CompletableFuture)WynncraftApiHandler.fetchPlayerAbilityMap(PV.currentPlayerData.getUuid().toString(), characterUUID).thenAccept(tree -> {
            playerTrees.put(characterUUID, (AbilityMapData)tree);
            loading.remove(characterUUID);
        })).exceptionally(ex -> {
            System.err.println("Failed to load ability tree for " + characterUUID + ": " + ex.getMessage());
            loading.remove(characterUUID);
            return null;
        });
    }

    public static void cacheClassTree(String className, AbilityMapData tree) {
        classMaps.put(className, tree);
    }

    public static AbilityMapData getClassMap(String className) {
        return classMaps.get(className);
    }

    public static AbilityTreeData getClassTree(String className) {
        return classTrees.get(className);
    }

    public static void cachePlayerTree(String characterUUID, AbilityMapData tree) {
        playerTrees.put(characterUUID, tree);
    }

    public static AbilityMapData getPlayerTree(String characterUUID) {
        return playerTrees.get(characterUUID);
    }

    public static void clear() {
        classMaps.clear();
        classTrees.clear();
        playerTrees.clear();
    }
}

