/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.tabs;

import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.PVScreen;
import julianh06.wynnextras.features.profileviewer.data.Dungeons;
import julianh06.wynnextras.utils.UI.Widget;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class DungeonsTabWidget
extends PVScreen.TabWidget {
    static class_2960 dungeonKeyTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/dungeonkey.png");
    static class_2960 corruptedDungeonKeyTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/corrupteddungeonkey.png");
    static class_2960 dungeonBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/dungeonpagebackground.png");
    static class_2960 dungeonBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/dungeonpagebackground_dark.png");
    static class_2960 decrepitSewersTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/decrepitsewers.png");
    static class_2960 infestedPitTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/infestedpit.png");
    static class_2960 underworldCryptTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/underworldcrypt.png");
    static class_2960 timelostSanctumTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/timelostsanctum.png");
    static class_2960 sandSweptTombTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/sandswepttomb.png");
    static class_2960 iceBarrowsTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/icebarrows.png");
    static class_2960 undergrowthRuinsTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/undergrowthruins.png");
    static class_2960 galleonsGraveyardTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/galleonsgraveyard.png");
    static class_2960 fallenFactoryTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/fallenfactory.png");
    static class_2960 eldritchOutlookTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/dungeons/eldritchoutlook.png");
    static List<class_2960> dungeonTextures = List.of(decrepitSewersTexture, infestedPitTexture, underworldCryptTexture, timelostSanctumTexture, sandSweptTombTexture, iceBarrowsTexture, undergrowthRuinsTexture, galleonsGraveyardTexture, fallenFactoryTexture, eldritchOutlookTexture);
    private InfoWidget infoWidget = null;

    public DungeonsTabWidget() {
        super(0, 0, 0, 0);
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        Dungeons dungeons;
        if (PV.currentPlayerData == null) {
            return;
        }
        if (PV.currentPlayerData.getGlobalData() == null) {
            this.ui.drawCenteredText("This player has their dungeon stats private.", this.x + 900, this.y + 345, CustomColor.fromHexString((String)"FF0000"), 5.0f);
            return;
        }
        if (PV.currentPlayerData.getGlobalData().getDungeons() == null) {
            this.ui.drawCenteredText("This player has their dungeon stats private.", this.x + 900, this.y + 345, CustomColor.fromHexString((String)"FF0000"), 5.0f);
            return;
        }
        HashMap<String, Integer> normalComps = new HashMap<String, Integer>();
        HashMap<String, Integer> corruptedComps = new HashMap<String, Integer>();
        if (PVScreen.selectedCharacter == null) {
            dungeons = PV.currentPlayerData.getGlobalData().getDungeons();
        } else {
            dungeons = PVScreen.selectedCharacter.getDungeons();
            if (PVScreen.selectedCharacter.getDungeons() == null) {
                dungeons = new Dungeons();
            }
        }
        for (Map.Entry<String, Integer> entry : dungeons.getList().entrySet()) {
            if (entry.getKey().contains("Corrupted")) {
                corruptedComps.put(entry.getKey(), entry.getValue());
                continue;
            }
            normalComps.put(entry.getKey(), entry.getValue());
        }
        PVScreen.DarkModeToggleWidget.drawImageWithFade(dungeonBackgroundTextureDark, dungeonBackgroundTexture, this.x + 30, this.y + 87, 1740.0f, 633.0f, this.ui);
        int i = 0;
        DecimalFormat formatter = new DecimalFormat("#,###");
        for (class_2960 dungeon : dungeonTextures) {
            int comps = PVScreen.getDungeonComps(i, normalComps);
            int cComps = PVScreen.getCorruptedComps(i, corruptedComps);
            int dungeonX = this.x + 90 + 345 * (i % 5);
            int dungeonY = this.y + 90 + Math.floorDiv(i, 5) * 350;
            if (Math.floorDiv(i, 5) > 0) {
                this.ui.drawImage(dungeon, dungeonX + 30, dungeonY + 45, 180.0f, 180.0f);
                this.ui.drawCenteredText(PVScreen.getDungeonName(i), dungeonX + 120, dungeonY + 250, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
                if (i < 8) {
                    this.ui.drawImage(dungeonKeyTexture, dungeonX + 60, dungeonY - 15, 60.0f, 60.0f);
                    this.ui.drawText(formatter.format(comps), dungeonX + 55, dungeonY, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.0f);
                    this.ui.drawImage(corruptedDungeonKeyTexture, dungeonX + 120, dungeonY - 15, 60.0f, 60.0f);
                    this.ui.drawText(formatter.format(cComps), dungeonX + 190, dungeonY, CustomColor.fromHexString((String)"FFFFFF"));
                } else {
                    this.ui.drawImage(dungeonKeyTexture, dungeonX + 90, dungeonY - 15, 60.0f, 60.0f);
                    this.ui.drawText(formatter.format(comps), dungeonX + 90, dungeonY, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.0f);
                }
            } else {
                this.ui.drawImage(dungeon, dungeonX + 30, dungeonY + 45, 180.0f, 180.0f);
                this.ui.drawCenteredText(PVScreen.getDungeonName(i), dungeonX + 120, dungeonY + 30, CustomColor.fromHexString((String)"FFFFFF"), 3.0f);
                if (i != 3) {
                    this.ui.drawImage(dungeonKeyTexture, dungeonX + 60, dungeonY + 230, 60.0f, 60.0f);
                    this.ui.drawText(formatter.format(comps), dungeonX + 55, dungeonY + 250, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.0f);
                    this.ui.drawImage(corruptedDungeonKeyTexture, dungeonX + 120, dungeonY + 230, 60.0f, 60.0f);
                    this.ui.drawText(formatter.format(cComps), dungeonX + 190, dungeonY + 250, CustomColor.fromHexString((String)"FFFFFF"));
                } else {
                    this.ui.drawImage(dungeonKeyTexture, dungeonX + 90, dungeonY + 230, 60.0f, 60.0f);
                    this.ui.drawText(formatter.format(comps), dungeonX + 90, dungeonY + 250, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.0f);
                }
            }
            ++i;
            long TotalComps = dungeons.getTotal();
            Object characterNameString = PVScreen.selectedCharacter != null && PVScreen.selectedCharacter.getRaids() != null ? " on " + PVScreen.getClassName(PVScreen.selectedCharacter) + ": " : ": ";
            this.ui.drawCenteredText("Total Completions" + (String)characterNameString + formatter.format(TotalComps), this.x + 900, this.y + 45, CustomColor.fromHexString((String)"FFFFFF"), 3.9f);
        }
        if (this.infoWidget == null) {
            this.infoWidget = new InfoWidget(PVScreen.getDungeonComps(10, normalComps), PVScreen.getCorruptedComps(8, corruptedComps));
            this.addChild(this.infoWidget);
        }
        this.infoWidget.setBounds(this.x + this.width - 80, this.y + 20, 50, 50);
    }

    private static class InfoWidget
    extends Widget {
        static class_2960 infoIcon = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/infoicon.png");
        static class_2960 infoIconDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/infoicon_dark.png");
        int comps;
        int corruptedComps;

        public InfoWidget(int comps, int corruptedComps) {
            super(0, 0, 0, 0);
            this.comps = comps;
            this.corruptedComps = corruptedComps;
        }

        @Override
        protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
            PVScreen.DarkModeToggleWidget.drawImageWithFade(infoIconDark, infoIcon, this.x, this.y, this.width, this.height, this.ui);
            if (this.hovered) {
                ctx.method_51434(class_310.method_1551().field_1772, List.of(class_2561.method_30163((String)"Lost Sanctuary"), class_2561.method_30163((String)""), class_2561.method_30163((String)("Normal Completions: " + this.comps)), class_2561.method_30163((String)("Corrupted Completions: " + this.corruptedComps)), class_2561.method_30163((String)""), class_2561.method_30163((String)"\u00a74The normal version of the Lost Sanctuary"), class_2561.method_30163((String)"\u00a74has been replaced with the Timelost Sanctum"), class_2561.method_30163((String)"\u00a74in 2023. The corrupted version has not been"), class_2561.method_30163((String)"\u00a74updated yet and is still playable in the forgery.")), mouseX, mouseY);
            }
        }
    }
}

