/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.profileviewer.tabs;

import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.text.DecimalFormat;
import java.util.Map;
import julianh06.wynnextras.features.profileviewer.PV;
import julianh06.wynnextras.features.profileviewer.PVScreen;
import julianh06.wynnextras.features.profileviewer.data.Raids;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class RaidsTabWidget
extends PVScreen.TabWidget {
    static class_2960 raidBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/raidbackground.png");
    static class_2960 raidBackgroundTextureDark = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/raidbackground_dark.png");
    static class_2960 NOTGTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/notg.png");
    static class_2960 NOLTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/nol.png");
    static class_2960 TCCTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/tcc.png");
    static class_2960 TNATexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/profileviewer/rankingicons/tna.png");

    public RaidsTabWidget() {
        super(0, 0, 0, 0);
    }

    @Override
    protected void drawContent(class_332 ctx, int mouseX, int mouseY, float tickDelta) {
        Raids raids;
        Object characterNameString;
        if (PV.currentPlayerData == null) {
            return;
        }
        DecimalFormat formatter = new DecimalFormat("#,###");
        if (PV.currentPlayerData.getGlobalData() == null) {
            this.ui.drawCenteredText("This player has their raid stats private.", this.x + 900, this.y + 345, CustomColor.fromHexString((String)"FF0000"), 5.0f);
            return;
        }
        PVScreen.DarkModeToggleWidget.drawImageWithFade(raidBackgroundTextureDark, raidBackgroundTexture, this.x + 30, this.y + 90, 825.0f, 300.0f, this.ui);
        PVScreen.DarkModeToggleWidget.drawImageWithFade(raidBackgroundTextureDark, raidBackgroundTexture, this.x + 945, this.y + 90, 825.0f, 300.0f, this.ui);
        PVScreen.DarkModeToggleWidget.drawImageWithFade(raidBackgroundTextureDark, raidBackgroundTexture, this.x + 30, this.y + 420, 825.0f, 300.0f, this.ui);
        PVScreen.DarkModeToggleWidget.drawImageWithFade(raidBackgroundTextureDark, raidBackgroundTexture, this.x + 945, this.y + 420, 825.0f, 300.0f, this.ui);
        this.ui.drawImage(NOTGTexture, this.x + 30, this.y + 90, 300.0f, 300.0f);
        this.ui.drawImage(TCCTexture, this.x + 1470, this.y + 90, 300.0f, 300.0f);
        this.ui.drawImage(NOLTexture, this.x + 30, this.y + 420, 300.0f, 300.0f);
        this.ui.drawImage(TNATexture, this.x + 1470, this.y + 420, 300.0f, 300.0f);
        Map<String, Long> ranking = null;
        if (PVScreen.selectedCharacter == null) {
            ranking = PV.currentPlayerData.getRanking();
        }
        CustomColor notgColor = CustomColor.fromHexString((String)"FFFFFF");
        CustomColor nolColor = CustomColor.fromHexString((String)"FFFFFF");
        CustomColor tccColor = CustomColor.fromHexString((String)"FFFFFF");
        CustomColor tnaColor = CustomColor.fromHexString((String)"FFFFFF");
        if (ranking != null) {
            long TNARank;
            long TCCRank;
            long NOLRank;
            long NOTGRank = ranking.getOrDefault("grootslangCompletion", -1L);
            if (NOTGRank <= 100L && NOTGRank > 0L) {
                notgColor = CommonColors.RAINBOW;
            }
            if ((NOLRank = ranking.getOrDefault("orphionCompletion", -1L).longValue()) <= 100L && NOLRank > 0L) {
                nolColor = CommonColors.RAINBOW;
            }
            if ((TCCRank = ranking.getOrDefault("colossusCompletion", -1L).longValue()) <= 100L && TCCRank > 0L) {
                tccColor = CommonColors.RAINBOW;
            }
            if ((TNARank = ranking.getOrDefault("namelessCompletion", -1L).longValue()) <= 100L && TNARank > 0L) {
                tnaColor = CommonColors.RAINBOW;
            }
            if (NOTGRank != -1L) {
                this.ui.drawText("Rank #" + formatter.format(NOTGRank), (float)this.x + 345.0f, (float)this.y + 255.0f, notgColor, 3.9f);
            }
            if (NOLRank != -1L) {
                this.ui.drawText("Rank #" + formatter.format(NOLRank), (float)this.x + 345.0f, (float)this.y + 585.0f, nolColor, 3.9f);
            }
            if (TCCRank != -1L) {
                this.ui.drawText("Rank #" + formatter.format(TCCRank), (float)this.x + 1470.0f, (float)this.y + 255.0f, tccColor, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.9f);
            }
            if (TNARank != -1L) {
                this.ui.drawText("Rank #" + formatter.format(TNARank), (float)this.x + 1470.0f, (float)this.y + 585.0f, tnaColor, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.9f);
            }
        }
        if (PVScreen.selectedCharacter != null && PVScreen.selectedCharacter.getRaids() != null) {
            characterNameString = " on " + PVScreen.getClassName(PVScreen.selectedCharacter) + ": ";
            raids = PVScreen.selectedCharacter.getRaids();
        } else {
            characterNameString = ": ";
            raids = PV.currentPlayerData.getGlobalData().getRaids();
        }
        this.ui.drawText("Nest of the Grootslangs", (float)this.x + 345.0f, (float)this.y + 165.0f, notgColor, 3.9f);
        this.ui.drawText("Orphion's Nexus of Light", (float)this.x + 345.0f, (float)this.y + 495.0f, nolColor, 3.9f);
        this.ui.drawText("The Canyon Colossus", (float)this.x + 1470.0f, (float)this.y + 165.0f, tccColor, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.9f);
        this.ui.drawText("The Nameless Anomaly", (float)this.x + 1470.0f, (float)this.y + 495.0f, tnaColor, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.9f);
        if (raids != null) {
            long NOTGComps = raids.getList().getOrDefault("Nest of the Grootslangs", 0).intValue();
            long NOLComps = raids.getList().getOrDefault("Orphion's Nexus of Light", 0).intValue();
            long TCCComps = raids.getList().getOrDefault("The Canyon Colossus", 0).intValue();
            long TNAComps = raids.getList().getOrDefault("The Nameless Anomaly", 0).intValue();
            long TotalComps = raids.getTotal();
            this.ui.drawText(formatter.format(NOTGComps) + " Completions", (float)this.x + 345.0f, (float)this.y + 210.0f, notgColor, 3.9f);
            this.ui.drawText(formatter.format(NOLComps) + " Completions", (float)this.x + 345.0f, (float)this.y + 540.0f, nolColor, 3.9f);
            this.ui.drawText(formatter.format(TCCComps) + " Completions", (float)this.x + 1470.0f, (float)this.y + 210.0f, tccColor, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.9f);
            this.ui.drawText(formatter.format(TNAComps) + " Completions", (float)this.x + 1470.0f, (float)this.y + 540.0f, tnaColor, HorizontalAlignment.RIGHT, VerticalAlignment.TOP, 3.9f);
            this.ui.drawCenteredText("Total Completions" + (String)characterNameString + formatter.format(TotalComps), (float)this.x + 900.0f, (float)this.y + 48.0f, CustomColor.fromHexString((String)"FFFFFF"), 3.9f);
        }
    }
}

