/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.raid;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.wynntils.models.raid.raids.NestOfTheGrootslangsRaid;
import com.wynntils.models.raid.raids.OrphionsNexusOfLightRaid;
import com.wynntils.models.raid.raids.RaidKind;
import com.wynntils.models.raid.raids.TheCanyonColossusRaid;
import com.wynntils.models.raid.raids.TheNamelessAnomalyRaid;
import java.io.IOException;

public class RaidKindAdapter
extends TypeAdapter<RaidKind> {
    private final Gson gson;

    public RaidKindAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, RaidKind value) throws IOException {
        JsonObject obj = this.gson.toJsonTree((Object)value).getAsJsonObject();
        obj.addProperty("type", value.getAbbreviation());
        this.gson.toJson((JsonElement)obj, out);
    }

    public RaidKind read(JsonReader in) throws IOException {
        String abbreviation;
        JsonObject obj = JsonParser.parseReader((JsonReader)in).getAsJsonObject();
        switch (abbreviation = obj.get("abbreviation").getAsString()) {
            case "TNA": {
                return (RaidKind)this.gson.fromJson((JsonElement)obj, TheNamelessAnomalyRaid.class);
            }
            case "TCC": {
                return (RaidKind)this.gson.fromJson((JsonElement)obj, TheCanyonColossusRaid.class);
            }
            case "NOL": {
                return (RaidKind)this.gson.fromJson((JsonElement)obj, OrphionsNexusOfLightRaid.class);
            }
            case "NOG": {
                return (RaidKind)this.gson.fromJson((JsonElement)obj, NestOfTheGrootslangsRaid.class);
            }
        }
        throw new JsonParseException("Unknown raid: " + abbreviation);
    }
}

