/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.raid;

import com.wynntils.core.text.StyledText;
import com.wynntils.models.raid.raids.NestOfTheGrootslangsRaid;
import com.wynntils.models.raid.raids.OrphionsNexusOfLightRaid;
import com.wynntils.models.raid.raids.RaidKind;
import com.wynntils.models.raid.raids.TheCanyonColossusRaid;
import com.wynntils.models.raid.raids.TheNamelessAnomalyRaid;
import com.wynntils.models.raid.type.RaidRoomInfo;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import julianh06.wynnextras.annotations.WEModule;
import julianh06.wynnextras.event.CharInputEvent;
import julianh06.wynnextras.event.KeyInputEvent;
import julianh06.wynnextras.features.raid.RaidData;
import julianh06.wynnextras.features.raid.RaidFilterButton;
import julianh06.wynnextras.features.raid.RaidListData;
import julianh06.wynnextras.features.raid.RaidListElement;
import julianh06.wynnextras.features.raid.RaidListFilter;
import julianh06.wynnextras.features.raid.RaidParser;
import julianh06.wynnextras.utils.Pair;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.neoforged.bus.api.SubscribeEvent;

@WEModule
public class RaidListScreen
extends class_437 {
    public static int scrollOffset = 0;
    private static long lastScrollTime = 0L;
    private static final long scrollCooldown = 0L;
    public static List<Boolean> currentCollapsed = new ArrayList<Boolean>();
    private static List<Float> currentCollapsedProgress = new ArrayList<Float>();
    public static List<RaidListElement> listElements = new ArrayList<RaidListElement>();
    public static List<String> currentPlayers = new ArrayList<String>();
    RaidFilterButton NOTGFilterButton = new RaidFilterButton(-1, -1, 40, 40);
    RaidFilterButton NOLFilterButton = new RaidFilterButton(-1, -1, 40, 40);
    RaidFilterButton TCCFilterButton = new RaidFilterButton(-1, -1, 40, 40);
    RaidFilterButton TNAFilterButton = new RaidFilterButton(-1, -1, 40, 40);
    RaidFilterButton PBFilterButton = new RaidFilterButton(-1, -1, 40, 40);
    RaidListFilter Filter = new RaidListFilter(-1, -1, -1, -1);
    class_2960 InputFieldTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/bankoverlay/button.png");
    class_2960 ButtonBackgroundLeftTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/buttonbackgroundleft.png");
    class_2960 ButtonBackgroundMidTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/buttonbackgroundmid.png");
    class_2960 ButtonBackgroundRightTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/buttonbackgroundright.png");
    class_2960 NOTGTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/nestofthegrootslangs-small.png");
    class_2960 NOLTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/orphionsnexusoflight-small.png");
    class_2960 TCCTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/thecanyoncolossus-small.png");
    class_2960 TNATexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/thenamelessanomaly-small.png");
    class_2960 NOTGTextureBW = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/nestofthegrootslangs-small-bw.png");
    class_2960 NOLTextureBW = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/orphionsnexusoflight-small-bw.png");
    class_2960 TCCTextureBW = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/thecanyoncolossus-small-bw.png");
    class_2960 TNATextureBW = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/thenamelessanomaly-small-bw.png");
    class_2960 ScrollTextureTopLeft = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrolltop/scrollleft.png");
    class_2960 ScrollTextureTopMid = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrolltop/scrollmid.png");
    class_2960 ScrollTextureTopRight = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrolltop/scrollright.png");
    class_2960 ScrollTextureBottomLeft = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrollbot/scrollleft.png");
    class_2960 ScrollTextureBottomMid = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrollbot/scrollmid.png");
    class_2960 ScrollTextureBottomRight = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrollbot/scrollright.png");
    class_2960 ScrollTextureMiddleLeft = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrollmid/scrollmidleft.png");
    class_2960 ScrollTextureMiddleMid = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrollmid/scrollmidmid.png");
    class_2960 ScrollTextureMiddleRight = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/scrollmid/scrollmidright.png");
    class_2960 PBTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/trophy-small.png");
    class_2960 PBTextureBW = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/raid/raidicons/trophy-small-bw.png");

    public RaidListScreen() {
        super(class_2561.method_30163((String)"Raid List"));
        scrollOffset = 0;
        this.PBFilterButton.isActive = false;
    }

    protected void method_25426() {
        listElements.clear();
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int width = (int)((double)screenWidth * 0.5);
        int xStart = screenWidth / 2 - width / 2;
        for (int i = 0; i < RaidListData.INSTANCE.raids.size(); ++i) {
            int yPos = 10 + 50 * i;
            listElements.add(new RaidListElement(xStart, yPos, 40, width));
        }
        ScreenMouseEvents.afterMouseScroll((class_437)this).register((screen, mX, mY, horizontalAmount, verticalAmount) -> {
            long now = System.currentTimeMillis();
            if (now - lastScrollTime < 0L) {
                return;
            }
            lastScrollTime = now;
            scrollOffset = verticalAmount > 0.0 ? (scrollOffset -= 30 / (int)class_310.method_1551().method_22683().method_4495()) : (scrollOffset += 30 / (int)class_310.method_1551().method_22683().method_4495());
            if (scrollOffset < 0) {
                scrollOffset = 0;
            }
        });
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        int width = (int)Math.max((double)screenWidth * 0.5, 400.0);
        int xStart = screenWidth / 2 - width / 2;
        RenderUtils.drawRect((class_4587)context.method_51448(), (CustomColor)CustomColor.fromInt((int)-804253680), (float)0.0f, (float)0.0f, (float)0.0f, (float)class_310.method_1551().field_1755.field_22789, (float)class_310.method_1551().field_1755.field_22790);
        List<RaidData> filteredList = this.filterList((List<RaidData>)RaidListData.INSTANCE.raids.reversed());
        List<RaidData> sortedList = this.sort(filteredList);
        int i = 0;
        for (RaidData raid : sortedList) {
            while (i >= currentCollapsedProgress.size()) {
                currentCollapsedProgress.add(Float.valueOf(0.0f));
            }
            while (i >= currentCollapsed.size()) {
                currentCollapsed.add(false);
            }
            float yPos = this.getElementY(i);
            yPos += (float)(10 - scrollOffset);
            if ((yPos += (float)(50 * i)) + 80.0f + currentCollapsedProgress.get(i).floatValue() >= 0.0f && yPos <= (float)screenHeight) {
                class_2960 raidTexture = this.getTexture(raid.raidInfo.getRaidKind());
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureTopLeft, (float)xStart, (float)yPos, (float)0.0f, (float)12.0f, (float)20.0f, (int)12, (int)20);
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureTopMid, (float)(xStart + 12), (float)yPos, (float)0.0f, (float)(width - 24), (float)20.0f, (int)(width - 24), (int)20);
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureTopRight, (float)(xStart - 12 + width), (float)yPos, (float)0.0f, (float)12.0f, (float)20.0f, (int)12, (int)20);
                if (currentCollapsedProgress.get(i).floatValue() >= 0.0f) {
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleLeft, (float)xStart, (float)(yPos + 20.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleMid, (float)(xStart + 16), (float)(yPos + 20.0f), (float)0.0f, (float)(width - 32), (float)20.0f, (int)(width - 32), (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleRight, (float)(xStart + width - 16), (float)(yPos + 20.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                }
                if (currentCollapsedProgress.get(i).floatValue() >= 20.0f) {
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleLeft, (float)xStart, (float)(yPos + 40.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleMid, (float)(xStart + 16), (float)(yPos + 40.0f), (float)0.0f, (float)(width - 32), (float)20.0f, (int)(width - 32), (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleRight, (float)(xStart + width - 16), (float)(yPos + 40.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                }
                if (currentCollapsedProgress.get(i).floatValue() >= 40.0f) {
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleLeft, (float)xStart, (float)(yPos + 60.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleMid, (float)(xStart + 16), (float)(yPos + 60.0f), (float)0.0f, (float)(width - 32), (float)20.0f, (int)(width - 32), (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleRight, (float)(xStart + width - 16), (float)(yPos + 60.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                }
                if (currentCollapsedProgress.get(i).floatValue() >= 60.0f) {
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleLeft, (float)xStart, (float)(yPos + 80.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleMid, (float)(xStart + 16), (float)(yPos + 80.0f), (float)0.0f, (float)(width - 32), (float)20.0f, (int)(width - 32), (int)20);
                    RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureMiddleRight, (float)(xStart + width - 16), (float)(yPos + 80.0f), (float)0.0f, (float)16.0f, (float)20.0f, (int)16, (int)20);
                }
                for (int j = 0; j < 4; ++j) {
                    Object name = j >= raid.players.size() ? "Player " + j : raid.players.get(j);
                    if (!(currentCollapsedProgress.get(i).floatValue() >= (float)(20 * j))) continue;
                    FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)name), (float)(xStart + 20), yPos + 26.0f + (float)(j * 20), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                }
                Map challenges = raid.raidInfo.getChallenges();
                if (challenges != null) {
                    for (int j = 0; j < challenges.size(); ++j) {
                        RaidRoomInfo room;
                        if (!(currentCollapsedProgress.get(i).floatValue() >= (float)(20 * j)) || (room = (RaidRoomInfo)challenges.get(j + 1)) == null) continue;
                        long roomDuration = room.getRoomTotalTime();
                        if (room.getRoomEndTime() == -1L) {
                            roomDuration = -1L;
                        }
                        String roomString = room.getRoomName() + ": " + RaidListScreen.formatDuration(roomDuration);
                        if (raid.raidInfo.getRaidKind() instanceof OrphionsNexusOfLightRaid) {
                            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)roomString), (float)(xStart + width - this.field_22793.method_1727(roomString) - 20), yPos + 24.0f + (float)(j * 16), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                            continue;
                        }
                        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)roomString), (float)(xStart + width - this.field_22793.method_1727(roomString) - 20), yPos + 26.0f + (float)(j * 20), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                    }
                }
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureBottomLeft, (float)xStart, (float)(yPos + 20.0f + currentCollapsedProgress.get(i).floatValue()), (float)0.0f, (float)12.0f, (float)20.0f, (int)12, (int)20);
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureBottomMid, (float)(xStart + 12), (float)(yPos + 20.0f + currentCollapsedProgress.get(i).floatValue()), (float)0.0f, (float)(width - 24), (float)20.0f, (int)(width - 24), (int)20);
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ScrollTextureBottomRight, (float)(xStart - 12 + width), (float)(yPos + 20.0f + currentCollapsedProgress.get(i).floatValue()), (float)0.0f, (float)12.0f, (float)20.0f, (int)12, (int)20);
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)raidTexture, (float)(xStart + width / 2 - 15), (float)(yPos - 5.0f), (float)0.0f, (float)30.0f, (float)30.0f, (int)30, (int)30);
                FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)raid.raidInfo.getRaidKind().getRaidName()), (float)(xStart + 10), (float)((int)(yPos + 6.0f)), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)RaidListScreen.convertTime(raid.raidEndTime)), (float)(xStart + width - this.field_22793.method_1727(RaidListScreen.convertTime(raid.raidEndTime)) - 8), (float)((int)(yPos + 6.0f)), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)RaidListScreen.formatDuration(raid.duration)), (float)(xStart + width - this.field_22793.method_1727(RaidListScreen.formatDuration(raid.duration)) - 8), (float)((int)(yPos + 26.0f + currentCollapsedProgress.get(i).floatValue())), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                if (raid.completed) {
                    FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)"Completed"), (float)(xStart + 10), (float)((int)(yPos + 26.0f + currentCollapsedProgress.get(i).floatValue())), CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                } else {
                    FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)"FAILED"), (float)(xStart + 10), (float)((int)(yPos + 26.0f + currentCollapsedProgress.get(i).floatValue())), CustomColor.fromHexString((String)"FF0000"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
                }
            }
            ++i;
        }
        int MidButtonBackgroundWidth = width - 80;
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ButtonBackgroundLeftTexture, (float)(xStart - 70), (float)0.0f, (float)0.0f, (float)120.0f, (float)80.0f, (int)120, (int)80);
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ButtonBackgroundMidTexture, (float)(xStart + 40), (float)0.0f, (float)0.0f, (float)MidButtonBackgroundWidth, (float)80.0f, (int)MidButtonBackgroundWidth, (int)80);
        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)this.ButtonBackgroundRightTexture, (float)(xStart + width - 50), (float)0.0f, (float)0.0f, (float)120.0f, (float)80.0f, (int)120, (int)80);
        this.NOTGFilterButton.setX(xStart + width / 2 - 180);
        this.NOTGFilterButton.setY(16);
        this.NOLFilterButton.setX(xStart + width / 2 - 100);
        this.NOLFilterButton.setY(16);
        this.PBFilterButton.setX(xStart + width / 2 - 20);
        this.PBFilterButton.setY(16);
        this.TCCFilterButton.setX(xStart + width / 2 + 60);
        this.TCCFilterButton.setY(16);
        this.TNAFilterButton.setX(xStart + width / 2 + 140);
        this.TNAFilterButton.setY(16);
        this.Filter.setHeight(14);
        this.Filter.setWidth(width);
        this.Filter.setX(xStart);
        this.Filter.setY(2);
        this.Filter.setSearchText("Example: from:-7d4h until:2025-01-31/23:59 players:player1,player2,player3");
        this.Filter.drawWithTexture(context, this.InputFieldTexture);
        if (this.NOTGFilterButton.isActive) {
            this.NOTGFilterButton.drawWithTexture(context, this.NOTGTexture);
        } else {
            this.NOTGFilterButton.drawWithTexture(context, this.NOTGTextureBW);
        }
        if (this.NOLFilterButton.isActive) {
            this.NOLFilterButton.drawWithTexture(context, this.NOLTexture);
        } else {
            this.NOLFilterButton.drawWithTexture(context, this.NOLTextureBW);
        }
        if (this.TCCFilterButton.isActive) {
            this.TCCFilterButton.drawWithTexture(context, this.TCCTexture);
        } else {
            this.TCCFilterButton.drawWithTexture(context, this.TCCTextureBW);
        }
        if (this.TNAFilterButton.isActive) {
            this.TNAFilterButton.drawWithTexture(context, this.TNATexture);
        } else {
            this.TNAFilterButton.drawWithTexture(context, this.TNATextureBW);
        }
        if (this.PBFilterButton.isActive) {
            this.PBFilterButton.drawWithTexture(context, this.PBTexture);
        } else {
            this.PBFilterButton.drawWithTexture(context, this.PBTextureBW);
        }
        Pair<Integer, Integer> runs = this.getCompletedAndFailed(sortedList);
        String completed = "\u00a7aCompleted: " + String.valueOf(runs.getFirst());
        String total = "\u00a7fTotal: " + sortedList.size();
        String failed = "\u00a7cFailed: " + String.valueOf(runs.getSecond());
        String combined = completed + " " + total + " " + failed;
        int totalStringStart = Math.round((float)xStart + (float)width / 2.0f - (float)this.field_22793.method_1727(total) / 2.0f) - 4;
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromString((String)combined), (float)(totalStringStart - this.field_22793.method_1727(completed)), 57.0f, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 1.0f);
        for (int j = 0; j < listElements.size(); ++j) {
            if (currentCollapsed.get(j).booleanValue()) {
                while (j >= currentCollapsedProgress.size()) {
                    currentCollapsedProgress.add(Float.valueOf(0.0f));
                }
                if (currentCollapsedProgress.get(j).floatValue() < 80.0f) {
                    currentCollapsedProgress.set(j, Float.valueOf(currentCollapsedProgress.get(j).floatValue() + 10.0f * delta));
                    listElements.get(j).setHeight(listElements.get(j).getHeight() + 10.0f * delta);
                    continue;
                }
                currentCollapsedProgress.set(j, Float.valueOf(80.0f));
                listElements.get(j).setHeight(120.0f);
                continue;
            }
            while (j >= currentCollapsedProgress.size()) {
                currentCollapsedProgress.add(Float.valueOf(0.0f));
            }
            if (currentCollapsedProgress.get(j).floatValue() > 0.0f) {
                currentCollapsedProgress.set(j, Float.valueOf(currentCollapsedProgress.get(j).floatValue() - 10.0f * delta));
                RaidListElement currentElement = listElements.get(j);
                listElements.get(j).setHeight(listElements.get(j).getHeight() - 10.0f * delta);
                continue;
            }
            currentCollapsed.set(j, false);
            currentCollapsedProgress.set(j, Float.valueOf(0.0f));
            listElements.get(j).setHeight(40.0f);
        }
    }

    public void method_25419() {
        currentCollapsed.clear();
        currentCollapsedProgress.clear();
        super.method_25419();
    }

    public class_2960 getTexture(RaidKind raidKind) {
        return switch (raidKind.getAbbreviation()) {
            case "NOG" -> this.NOTGTexture;
            case "TNA" -> this.TNATexture;
            case "NOL" -> this.NOLTexture;
            case "TCC" -> this.TCCTexture;
            default -> null;
        };
    }

    public static String convertTime(long time) {
        ZonedDateTime dateTime = Instant.ofEpochMilli(time).atZone(ZoneId.systemDefault());
        return dateTime.format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss"));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.Filter.isActive() && this.Filter.isClickInBounds((int)mouseX, (int)mouseY) || this.Filter.isActive() && !this.Filter.isClickInBounds((int)mouseX, (int)mouseY)) {
            this.Filter.click();
            return true;
        }
        if (this.NOTGFilterButton.isClickInBounds((int)mouseX, (int)mouseY)) {
            this.NOTGFilterButton.click();
            return true;
        }
        if (this.NOLFilterButton.isClickInBounds((int)mouseX, (int)mouseY)) {
            this.NOLFilterButton.click();
            return true;
        }
        if (this.TCCFilterButton.isClickInBounds((int)mouseX, (int)mouseY)) {
            this.TCCFilterButton.click();
            return true;
        }
        if (this.TNAFilterButton.isClickInBounds((int)mouseX, (int)mouseY)) {
            this.TNAFilterButton.click();
            return true;
        }
        if (this.PBFilterButton.isClickInBounds((int)mouseX, (int)mouseY)) {
            this.PBFilterButton.click();
            return true;
        }
        for (int i = 0; i < listElements.size(); ++i) {
            int yPos;
            RaidListElement element = listElements.get(i);
            if (!element.isClickInBounds((int)mouseX, (int)mouseY - (yPos = this.getElementY(i)) + scrollOffset)) continue;
            if (currentCollapsed.get(i).booleanValue()) {
                currentCollapsed.set(i, false);
            } else {
                element.click();
                currentCollapsed.set(i, true);
                currentCollapsedProgress.set(i, Float.valueOf(0.0f));
            }
            return true;
        }
        return false;
    }

    private int getElementY(int index) {
        int y = 80;
        for (int i = 0; i < listElements.size() && index > i; ++i) {
            while (i >= currentCollapsedProgress.size()) {
                currentCollapsedProgress.add(Float.valueOf(0.0f));
            }
            while (i >= currentCollapsed.size()) {
                currentCollapsed.add(false);
            }
            y = (int)((float)y + currentCollapsedProgress.get(i).floatValue());
        }
        return y;
    }

    public static String formatDuration(long durationMs) {
        if (durationMs == -1L) {
            return "\u00a7cFAILED";
        }
        long minutes = durationMs / 60000L;
        long seconds = durationMs % 60000L / 1000L;
        long millis = durationMs % 1000L;
        return String.format("%02d:%02d:%03d", minutes, seconds, millis);
    }

    public List<RaidData> filterList(List<RaidData> rawList) {
        ArrayList<RaidData> result = new ArrayList<RaidData>();
        RaidParser parsed = RaidParser.parse(this.Filter.getInput());
        LocalDateTime from = parsed.from;
        ZoneId zoneId = ZoneId.systemDefault();
        long fromEpoch = 0L;
        if (from != null) {
            fromEpoch = from.atZone(zoneId).toEpochSecond() * 1000L;
        }
        LocalDateTime until = parsed.until;
        long untilEpoch = 0L;
        if (until != null) {
            untilEpoch = until.atZone(zoneId).toEpochSecond() * 1000L;
        }
        List<String> players = parsed.players;
        for (RaidData raid : rawList) {
            if (from != null && fromEpoch != 0L && raid.raidEndTime < fromEpoch || until != null && untilEpoch != 0L && raid.raidEndTime > untilEpoch) continue;
            if (!players.isEmpty()) {
                boolean playerNotContained = false;
                for (String player : players) {
                    if (!raid.players.stream().noneMatch(p -> p.equalsIgnoreCase(player))) continue;
                    playerNotContained = true;
                    break;
                }
                if (playerNotContained) continue;
            }
            if (this.PBFilterButton.isActive && !raid.completed) continue;
            if (this.NOTGFilterButton.isActive && raid.raidInfo.getRaidKind() instanceof NestOfTheGrootslangsRaid) {
                result.add(raid);
                continue;
            }
            if (this.NOLFilterButton.isActive && raid.raidInfo.getRaidKind() instanceof OrphionsNexusOfLightRaid) {
                result.add(raid);
                continue;
            }
            if (this.TCCFilterButton.isActive && raid.raidInfo.getRaidKind() instanceof TheCanyonColossusRaid) {
                result.add(raid);
                continue;
            }
            if (!this.TNAFilterButton.isActive || !(raid.raidInfo.getRaidKind() instanceof TheNamelessAnomalyRaid)) continue;
            result.add(raid);
        }
        return result;
    }

    public List<RaidData> sort(List<RaidData> rawList) {
        if (!this.PBFilterButton.isActive) {
            return rawList;
        }
        rawList.sort(Comparator.comparingLong(raid -> raid.duration));
        return rawList;
    }

    @SubscribeEvent
    public void onInput(KeyInputEvent event) {
        this.Filter.onInput(event);
    }

    @SubscribeEvent
    public void onChar(CharInputEvent event) {
        this.Filter.onCharInput(event);
    }

    public Pair<Integer, Integer> getCompletedAndFailed(List<RaidData> rawList) {
        int completed = 0;
        int failed = 0;
        for (RaidData data : rawList) {
            if (data.completed) {
                ++completed;
                continue;
            }
            ++failed;
        }
        return new Pair<Integer, Integer>(completed, failed);
    }
}

