/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.features.waypoints;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.wynntils.core.text.StyledText;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import julianh06.wynnextras.core.WynnExtras;
import julianh06.wynnextras.features.waypoints.CategoryElement;
import julianh06.wynnextras.features.waypoints.PackageElement;
import julianh06.wynnextras.features.waypoints.Waypoint;
import julianh06.wynnextras.features.waypoints.WaypointCategory;
import julianh06.wynnextras.features.waypoints.WaypointData;
import julianh06.wynnextras.features.waypoints.WaypointElement;
import julianh06.wynnextras.features.waypoints.WaypointPackage;
import julianh06.wynnextras.utils.overlays.EasyButton;
import julianh06.wynnextras.utils.overlays.EasyDropdown;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import org.lwjgl.glfw.GLFW;

public class WaypointScreen
extends class_437 {
    public static int mouseX = 0;
    public static int mouseY = 0;
    public static int scaleFactor;
    public static int scrollOffset;
    private static long lastScrollTime;
    private static final long scrollCooldown = 0L;
    static List<WaypointElement> elements;
    static List<CategoryElement> categories;
    public static boolean clickWhileExpanded;
    public static boolean inMainScreen;
    static EasyButton addNewButton;
    static EasyButton editCategoriesButton;
    static EasyButton importButton;
    static EasyButton backToPackagesButton;
    static List<PackageElement> packageElements;
    public static EasyDropdown categoryDropdown;
    class_2960 addNewButtonTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/addnewbutton.png");
    class_2960 importButtonTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/importbutton.png");
    static List<WaypointCategory> activeCategories;
    class_2960 categorySingleTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categoryboxsingle.png");
    class_2960 categoryTopTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categoryboxtop.png");
    class_2960 categoryMidTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categoryboxmid.png");
    class_2960 categoryBotTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categoryboxbot.png");
    class_2960 nameBackgroundTexture = class_2960.method_60655((String)"wynnextras", (String)"textures/gui/waypoints/categoryboxsingle.png");

    protected WaypointScreen() {
        super(class_2561.method_30163((String)"Waypoints"));
        addNewButton = new EasyButton(-1, -1, -1, -1){

            @Override
            public void click() {
                if (WaypointData.INSTANCE.activePackage == null) {
                    WaypointPackage waypointPackage = new WaypointPackage(WaypointData.INSTANCE.generateUniqueName("New package"));
                    packageElements.add(new PackageElement(-1, -1, -1, -1, waypointPackage));
                    WaypointData.INSTANCE.packages.add(waypointPackage);
                    return;
                }
                if (inMainScreen) {
                    if (class_310.method_1551().field_1724 == null) {
                        return;
                    }
                    int x = (int)Math.floor(class_310.method_1551().field_1724.method_23317());
                    int y = (int)Math.floor(class_310.method_1551().field_1724.method_23318()) - 1;
                    int z = (int)Math.floor(class_310.method_1551().field_1724.method_23321());
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Waypoint added at " + x + " " + y + " " + z))));
                    Waypoint waypoint = new Waypoint(x, y, z);
                    WaypointData.INSTANCE.activePackage.waypoints.add(waypoint);
                    elements.add(new WaypointElement(waypoint));
                } else {
                    WaypointCategory category = new WaypointCategory("New Category");
                    categories.add(new CategoryElement(category));
                    WaypointData.INSTANCE.activePackage.categories.add(category);
                }
                WaypointData.save();
            }

            @Override
            public void draw(class_332 context) {
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)WaypointScreen.this.addNewButtonTexture, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (int)((int)this.width), (int)((int)this.height));
            }
        };
        editCategoriesButton = new EasyButton(-1, -1, -1, -1){

            @Override
            public void click() {
                inMainScreen = !inMainScreen;
                activeCategories.clear();
                activeCategories.addAll(WaypointData.INSTANCE.activePackage.categories);
                scrollOffset = 0;
                if (categories == null) {
                    return;
                }
                for (CategoryElement element : categories) {
                    String newName;
                    String oldName;
                    if (element.category == null || (oldName = element.category.name).equals(newName = element.nameInput.getInput())) continue;
                    element.category.name = newName;
                    for (Waypoint waypoint : WaypointData.INSTANCE.activePackage.waypoints) {
                        if (waypoint.categoryName == null || !waypoint.categoryName.equals(oldName)) continue;
                        waypoint.categoryName = newName;
                    }
                }
                for (int i = 0; i < Math.min(categories.size(), WaypointData.INSTANCE.activePackage.categories.size()); ++i) {
                    CategoryElement element;
                    element = categories.get(i);
                    WaypointData.INSTANCE.activePackage.categories.get((int)i).name = element.nameInput.getInput();
                    WaypointData.INSTANCE.activePackage.categories.get((int)i).color = element.colorPicker.getSelectedColor();
                }
                WaypointData.save();
            }

            @Override
            public void draw(class_332 context) {
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)WaypointScreen.this.addNewButtonTexture, (float)this.x, (float)this.y, (float)this.width, (float)this.height, (int)((int)this.width), (int)((int)this.height));
            }
        };
        importButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                String json = class_310.method_1551().field_1774.method_1460();
                try {
                    WaypointPackage imported = (WaypointPackage)new Gson().fromJson(json, WaypointPackage.class);
                    if (imported == null) {
                        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Invalid package.")));
                        return;
                    }
                    if (imported.name == null || imported.name.isEmpty()) {
                        imported.name = "unnamed package";
                    }
                    block2: for (Waypoint waypoint : imported.waypoints) {
                        if (waypoint.categoryName == null) continue;
                        for (WaypointCategory cat : imported.categories) {
                            if (!cat.name.equals(waypoint.categoryName)) continue;
                            waypoint.setCategory(cat);
                            continue block2;
                        }
                    }
                    boolean exists = WaypointData.INSTANCE.packages.stream().anyMatch(pkg -> pkg.name.equals(imported.name));
                    if (exists) {
                        imported.name = WaypointData.INSTANCE.generateUniqueName(imported.name);
                    }
                    WaypointData.INSTANCE.packages.add(imported);
                    WaypointData.save();
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)("Imported package \"" + imported.name + "\" with " + imported.waypoints.size() + (imported.waypoints.size() == 1 ? " waypoint" : " waypoints") + " and " + imported.categories.size() + (imported.categories.size() == 1 ? " category." : " categories.")))));
                    WaypointData.INSTANCE.activePackage = null;
                    elements.clear();
                    categories.clear();
                    packageElements.clear();
                    for (WaypointPackage pkg2 : WaypointData.INSTANCE.packages) {
                        packageElements.add(new PackageElement(-1, -1, -1, -1, pkg2));
                    }
                }
                catch (JsonSyntaxException e) {
                    McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"Invalid JSON format in clipboard.")));
                    e.printStackTrace();
                }
            }
        };
        backToPackagesButton = new EasyButton(this, -1, -1, -1, -1){

            @Override
            public void click() {
                for (WaypointElement element : elements) {
                    element.waypoint.name = element.nameInput.getInput();
                    try {
                        int x = Integer.parseInt(element.xInput.getInput());
                        int y = Integer.parseInt(element.yInput.getInput());
                        int z = Integer.parseInt(element.zInput.getInput());
                        element.waypoint.x = x;
                        element.waypoint.y = y;
                        element.waypoint.z = z;
                    }
                    catch (NumberFormatException e) {
                        McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"\u00a7cThe coordinates must be a number")));
                    }
                }
                WaypointData.INSTANCE.activePackage = null;
            }
        };
        packageElements.clear();
        for (WaypointPackage pkg : WaypointData.INSTANCE.packages) {
            packageElements.add(new PackageElement(-1, -1, -1, -1, pkg));
        }
        categoryDropdown = new EasyDropdown(0, 0, -1, -1){

            @Override
            public void click() {
                if (!this.isExpanded) {
                    this.isExpanded = true;
                } else {
                    int ySection = Math.floorDiv(mouseY - 60 / scaleFactor, 39 / scaleFactor);
                    if (ySection < 1 || ySection > WaypointData.INSTANCE.activePackage.categories.size()) {
                        this.isExpanded = false;
                        return;
                    }
                    WaypointCategory category = WaypointData.INSTANCE.activePackage.categories.get(ySection - 1);
                    if (activeCategories.contains(category)) {
                        activeCategories.remove(category);
                    } else {
                        activeCategories.add(category);
                    }
                }
            }

            @Override
            public void draw(class_332 context) {
                List<WaypointCategory> categoriez = WaypointData.INSTANCE.activePackage.categories;
                RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)WaypointScreen.this.nameBackgroundTexture, (float)0.0f, (float)(60.0f / (float)scaleFactor), (float)(267.0f / (float)scaleFactor), (float)(39.0f / (float)scaleFactor), (int)(267 / scaleFactor), (int)(39 / scaleFactor));
                FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Category filter")), 8.0f / (float)scaleFactor, 68.0f / (float)scaleFactor, CustomColor.fromHexString((String)"FFFFFF"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.75f / (float)scaleFactor);
                if (this.isExpanded) {
                    if (categories.size() <= 1) {
                        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)WaypointScreen.this.categorySingleTexture, (float)this.x, (float)((float)this.y + this.height), (float)this.width, (float)(39.0f / (float)scaleFactor), (int)((int)this.width), (int)(39 / scaleFactor));
                        if (categories.isEmpty()) {
                            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Create a category!")), (float)this.x + 6.0f / (float)scaleFactor, (float)this.y + this.height + 10.0f / (float)scaleFactor, CustomColor.fromHexString((String)"FF0000"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.65f / (float)scaleFactor);
                        } else {
                            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)WaypointData.INSTANCE.activePackage.categories.getFirst().name)), (float)this.x + 6.0f / (float)scaleFactor, (float)this.y + this.height + 10.0f / (float)scaleFactor, WaypointData.INSTANCE.activePackage.categories.getFirst().color, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
                        }
                        return;
                    }
                    for (int i = 0; i < categoriez.size(); ++i) {
                        class_2960 texture = WaypointScreen.this.categoryMidTexture;
                        if (i == 0) {
                            texture = WaypointScreen.this.categoryTopTexture;
                        }
                        if (i == categoriez.size() - 1) {
                            texture = WaypointScreen.this.categoryBotTexture;
                        }
                        RenderUtils.drawTexturedRect((class_4587)context.method_51448(), (class_2960)texture, (float)this.x, (float)((float)this.y + this.height + (float)i * 39.0f / (float)scaleFactor), (float)this.width, (float)(39.0f / (float)scaleFactor), (int)((int)this.width), (int)(39 / scaleFactor));
                        CustomColor textColor = CustomColor.fromHexString((String)"808080");
                        if (activeCategories.contains(categoriez.get(i))) {
                            textColor = WaypointData.INSTANCE.activePackage.categories.get((int)i).color;
                        }
                        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)WaypointData.INSTANCE.activePackage.categories.get((int)i).name)), (float)this.x + 6.0f / (float)scaleFactor, (float)this.y + this.height + (float)i * 39.0f / (float)scaleFactor + 10.0f / (float)scaleFactor, textColor, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
                    }
                }
            }

            @Override
            public boolean isClickInBounds(int x, int y) {
                mouseX = x;
                mouseY = y;
                if (x < this.x) {
                    return false;
                }
                if (y < this.y) {
                    return false;
                }
                if ((float)x > (float)this.x + this.width) {
                    return false;
                }
                if (this.isExpanded) {
                    clickWhileExpanded = true;
                }
                return !(this.isExpanded && WaypointData.INSTANCE.activePackage.categories != null ? (float)y > (float)this.y + this.height + (float)WaypointData.INSTANCE.activePackage.categories.size() * (39.0f / (float)scaleFactor) : (float)y > (float)this.y + this.height);
            }
        };
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        String editCategoriesText;
        String addButtonText;
        if (class_310.method_1551().method_22683() == null) {
            return;
        }
        if (class_310.method_1551().field_1755 == null) {
            return;
        }
        scaleFactor = (int)class_310.method_1551().method_22683().method_4495();
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        int width = 1800 / scaleFactor;
        int height = 750 / scaleFactor;
        int xStart = screenWidth / 2 - 300 / scaleFactor;
        WaypointScreen.mouseX = mouseX;
        WaypointScreen.mouseY = mouseY;
        RenderUtils.drawRect((class_4587)context.method_51448(), (CustomColor)CustomColor.fromInt((int)-804253680), (float)0.0f, (float)0.0f, (float)0.0f, (float)class_310.method_1551().field_1755.field_22789, (float)class_310.method_1551().field_1755.field_22790);
        int i = 0;
        float yOffset = 30.0f / (float)scaleFactor;
        if (WaypointData.INSTANCE.activePackage == null) {
            int max = Math.min(WaypointData.INSTANCE.packages.size(), packageElements.size());
            int j = 0;
            for (PackageElement element : packageElements) {
                if (j >= WaypointData.INSTANCE.packages.size()) {
                    return;
                }
                int x = (int)((float)xStart + (float)width / 2.0f - 900.0f / (float)scaleFactor);
                int y = (int)yOffset + j * 300 / scaleFactor - scrollOffset;
                element.draw(x, y, 600 / scaleFactor, 275 / scaleFactor, context);
                ++j;
            }
            importButton.setX(1);
            importButton.setY(screenHeight - 50 / scaleFactor - 5);
            importButton.setWidth(360.0f / (float)scaleFactor);
            importButton.setHeight(60.0f / (float)scaleFactor);
            importButton.drawWithTexture(context, this.importButtonTexture);
            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Import from clipboard")), 180.0f / (float)scaleFactor, (float)screenHeight - 30.0f / (float)scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
            addNewButton.setX(xStart + width / 2 - 750 / scaleFactor);
            addNewButton.setY((int)(yOffset + (float)j * 300.0f / (float)scaleFactor - (float)scrollOffset));
            addNewButton.setHeight(60.0f / (float)scaleFactor);
            addNewButton.setWidth(300.0f / (float)scaleFactor);
            addNewButton.draw(context);
            FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Add new package")), (float)xStart + (float)width / 2.0f - 600.0f / (float)scaleFactor, (float)((int)(yOffset + (float)j * 300.0f / (float)scaleFactor - (float)scrollOffset + 30.0f / (float)scaleFactor)), CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
            return;
        }
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"I know that this menu is ugly,")), 5.0f, 25.0f, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.0f / (float)scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"it will be reworked in the future")), 5.0f, 35.0f, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.0f / (float)scaleFactor);
        if (inMainScreen) {
            for (WaypointElement element : elements) {
                if (element.waypoint.getCategory() != null) {
                    if (!WaypointData.INSTANCE.activePackage.categories.contains(element.waypoint.getCategory())) {
                        element.waypoint.setCategory(null);
                    } else if (!activeCategories.contains(element.waypoint.getCategory())) continue;
                }
                element.draw(xStart, (int)yOffset + i * 180 / scaleFactor - scrollOffset, 600 / scaleFactor, 150 / scaleFactor, context);
                ++i;
            }
        } else {
            for (CategoryElement category : categories) {
                if (GLFW.glfwGetMouseButton((long)class_310.method_1551().method_22683().method_4490(), (int)0) == 1 && category.colorPicker.isClickInBounds(mouseX, mouseY)) {
                    category.colorPicker.click(mouseX, mouseY);
                }
                category.draw(xStart, (int)yOffset + i * 305 / scaleFactor - scrollOffset, 600 / scaleFactor, 275 / scaleFactor, context);
                ++i;
            }
        }
        int x = (int)((float)xStart + (float)width / 2.0f - 750.0f / (float)scaleFactor);
        int y = inMainScreen ? (int)yOffset + i * 180 / scaleFactor - scrollOffset : (int)yOffset + i * 305 / scaleFactor - scrollOffset;
        addNewButton.setX(x);
        addNewButton.setY(y);
        addNewButton.setHeight(60.0f / (float)scaleFactor);
        addNewButton.setWidth(300.0f / (float)scaleFactor);
        editCategoriesButton.setX(screenWidth - 300 / scaleFactor);
        editCategoriesButton.setY(0);
        editCategoriesButton.setHeight(60.0f / (float)scaleFactor);
        editCategoriesButton.setWidth(300.0f / (float)scaleFactor);
        backToPackagesButton.setX(0);
        backToPackagesButton.setY(0);
        backToPackagesButton.setWidth(360.0f / (float)scaleFactor);
        backToPackagesButton.setHeight(60.0f / (float)scaleFactor);
        backToPackagesButton.drawWithTexture(context, this.importButtonTexture);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)"Back to packages")), 180.0f / (float)scaleFactor, 30.0f / (float)scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
        if (inMainScreen) {
            addButtonText = "Add new Waypoint";
            editCategoriesText = "Edit Categories";
            categoryDropdown.setX(0);
            categoryDropdown.setY(60 / scaleFactor);
            categoryDropdown.setWidth(267.0f / (float)scaleFactor);
            categoryDropdown.setHeight(36.0f / (float)scaleFactor);
            categoryDropdown.draw(context);
        } else {
            addButtonText = "Add new Category";
            editCategoriesText = "Back to waypoints";
        }
        addNewButton.draw(context);
        editCategoriesButton.draw(context);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)addButtonText)), (float)x + 150.0f / (float)scaleFactor, (float)y + 30.0f / (float)scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
        FontRenderer.getInstance().renderText(context.method_51448(), StyledText.fromComponent((class_2561)class_2561.method_30163((String)editCategoriesText)), (float)editCategoriesButton.getX() + 150.0f / (float)scaleFactor, (float)editCategoriesButton.getY() + 30.0f / (float)scaleFactor, CustomColor.fromHexString((String)"ffffff"), HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.NORMAL, 3.0f / (float)scaleFactor);
        for (WaypointElement element : elements) {
            if (!element.categoryDropdown.isExpanded) continue;
            element.categoryDropdown.draw(context);
        }
    }

    public void method_25426() {
        WaypointData.INSTANCE.activePackage = null;
        super.method_25426();
        ScreenMouseEvents.afterMouseScroll((class_437)this).register((screen, mX, mY, horizontalAmount, verticalAmount) -> {
            long now = System.currentTimeMillis();
            if (now - lastScrollTime < 0L) {
                return;
            }
            lastScrollTime = now;
            scrollOffset = verticalAmount > 0.0 ? (scrollOffset -= 30 / scaleFactor) : (scrollOffset += 30 / scaleFactor);
            if (scrollOffset < 0) {
                scrollOffset = 0;
            }
        });
    }

    public void method_25419() {
        mouseX = 0;
        mouseY = 0;
        scrollOffset = 0;
        int i = 0;
        for (WaypointPackage waypointPackage : WaypointData.INSTANCE.packages) {
            if (packageElements == null) {
                return;
            }
            if (packageElements.isEmpty()) {
                return;
            }
            if (packageElements.get(i) == null) {
                return;
            }
            String rawName = WaypointScreen.packageElements.get((int)i).nameInput.getInput();
            if (rawName == null) {
                rawName = WaypointData.INSTANCE.generateUniqueName("Unnamed Package");
            }
            waypointPackage.name = rawName.replaceAll("[\\\\/:*?\"<>|]", "");
            ++i;
        }
        for (WaypointElement waypointElement : elements) {
            waypointElement.waypoint.name = waypointElement.nameInput.getInput();
            try {
                int x = Integer.parseInt(waypointElement.xInput.getInput());
                int y = Integer.parseInt(waypointElement.yInput.getInput());
                int z = Integer.parseInt(waypointElement.zInput.getInput());
                waypointElement.waypoint.x = x;
                waypointElement.waypoint.y = y;
                waypointElement.waypoint.z = z;
            }
            catch (NumberFormatException e) {
                McUtils.sendMessageToClient((class_2561)WynnExtras.addWynnExtrasPrefix(class_2561.method_30163((String)"\u00a7cThe coordinates must be a number")));
            }
        }
        if (WaypointData.INSTANCE.activePackage != null) {
            for (i = 0; i < Math.min(categories.size(), WaypointData.INSTANCE.activePackage.categories.size()); ++i) {
                CategoryElement categoryElement = categories.get(i);
                WaypointData.INSTANCE.activePackage.categories.get((int)i).name = categoryElement.nameInput.getInput();
            }
        }
        for (CategoryElement categoryElement : categories) {
            String newName;
            String oldName;
            if (categoryElement.category == null || (oldName = categoryElement.category.name).equals(newName = categoryElement.nameInput.getInput())) continue;
            categoryElement.category.name = newName;
            if (WaypointData.INSTANCE.activePackage == null) continue;
            for (Waypoint waypoint : WaypointData.INSTANCE.activePackage.waypoints) {
                if (waypoint.categoryName == null || !waypoint.categoryName.equals(oldName)) continue;
                waypoint.categoryName = newName;
            }
        }
        if (WaypointData.INSTANCE.activePackage != null) {
            for (i = 0; i < Math.min(categories.size(), WaypointData.INSTANCE.activePackage.categories.size()); ++i) {
                CategoryElement categoryElement = categories.get(i);
                WaypointData.INSTANCE.activePackage.categories.get((int)i).name = categoryElement.nameInput.getInput();
                WaypointData.INSTANCE.activePackage.categories.get((int)i).color = categoryElement.colorPicker.getSelectedColor();
            }
        }
        WaypointData.INSTANCE.activePackage = null;
        categories.clear();
        activeCategories.clear();
        elements.clear();
        WaypointData.save();
        super.method_25419();
    }

    public static void onClick() {
        if (scaleFactor == 0) {
            return;
        }
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        ArrayList<WaypointElement> toRemoveWaypoint = new ArrayList<WaypointElement>();
        ArrayList<CategoryElement> toRemoveCategory = new ArrayList<CategoryElement>();
        if (WaypointData.INSTANCE.activePackage == null) {
            for (PackageElement packageElement : new ArrayList<PackageElement>(packageElements)) {
                packageElement.click(mouseX, mouseY);
            }
        }
        if (inMainScreen) {
            for (WaypointElement waypointElement : elements) {
                if (waypointElement.waypoint.getCategory() != null && !activeCategories.contains(waypointElement.waypoint.getCategory())) continue;
                if (waypointElement.deleteButton.isClickInBounds(mouseX, mouseY)) {
                    waypointElement.deleteButton.click();
                    toRemoveWaypoint.add(waypointElement);
                    WaypointData.INSTANCE.activePackage.waypoints.remove(waypointElement.waypoint);
                }
                waypointElement.click(mouseX, mouseY);
                if (!clickWhileExpanded) continue;
                clickWhileExpanded = false;
                break;
            }
            if (categoryDropdown.isClickInBounds(mouseX, mouseY)) {
                categoryDropdown.click();
            } else {
                WaypointScreen.categoryDropdown.isExpanded = false;
            }
        } else {
            for (CategoryElement categoryElement : categories) {
                if (categoryElement.deleteButton.isClickInBounds(mouseX, mouseY)) {
                    categoryElement.deleteButton.click();
                    toRemoveCategory.add(categoryElement);
                    WaypointData.INSTANCE.activePackage.categories.remove(categoryElement.category);
                }
                categoryElement.click(mouseX, mouseY);
            }
        }
        WaypointData.save();
        elements.removeAll(toRemoveWaypoint);
        categories.removeAll(toRemoveCategory);
        if (importButton.isClickInBounds(mouseX, mouseY)) {
            importButton.click();
        }
        if (addNewButton.isClickInBounds(mouseX, mouseY)) {
            addNewButton.click();
        }
        if (WaypointData.INSTANCE.activePackage == null) {
            return;
        }
        if (editCategoriesButton.isClickInBounds(mouseX, mouseY)) {
            editCategoriesButton.click();
        }
        if (backToPackagesButton.isClickInBounds(mouseX, mouseY)) {
            backToPackagesButton.click();
        }
    }

    static {
        scrollOffset = 0;
        lastScrollTime = 0L;
        elements = new ArrayList<WaypointElement>();
        categories = new ArrayList<CategoryElement>();
        clickWhileExpanded = false;
        inMainScreen = true;
        packageElements = new ArrayList<PackageElement>();
        activeCategories = new ArrayList<WaypointCategory>();
    }
}

