/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.mixin;

import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.models.territories.TerritoryInfo;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.models.territories.type.GuildResourceValues;
import com.wynntils.screens.maps.AbstractMapScreen;
import com.wynntils.screens.maps.GuildMapScreen;
import com.wynntils.services.map.pois.TerritoryPoi;
import com.wynntils.services.map.type.TerritoryDefenseFilterType;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.BoundingBox;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.duckInterfaces.TerritoryInfoMixinDuck;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuildMapScreen.class})
public class GuildMapScreenMixin
extends AbstractMapScreen {
    @Shadow(remap=false)
    private boolean territoryDefenseFilterEnabled;
    @Shadow(remap=false)
    private boolean hybridMode;
    @Shadow(remap=false)
    private GuildResourceValues territoryDefenseFilterLevel;
    @Shadow(remap=false)
    private TerritoryDefenseFilterType territoryDefenseFilterType;

    @Unique
    private void fixTradeRoutes(List<TerritoryPoi> advancementPois) {
        int fixes = 0;
        Map poiByName = advancementPois.stream().collect(Collectors.toMap(TerritoryPoi::getName, Function.identity(), (a, b) -> a));
        for (TerritoryPoi territoryPoi : advancementPois) {
            for (String route : territoryPoi.getTerritoryInfo().getTradingRoutes()) {
                List tradeRoutes;
                TerritoryPoi routePoi = (TerritoryPoi)poiByName.get(route);
                if (routePoi == null || (tradeRoutes = routePoi.getTerritoryInfo().getTradingRoutes()).contains(territoryPoi.getName())) continue;
                tradeRoutes.add(territoryPoi.getName());
                ++fixes;
            }
        }
        if (fixes > 0) {
            System.out.println("Applied " + fixes + " trade route fixes");
        }
    }

    @Inject(method={"renderPois(Lnet/minecraft/client/util/math/MatrixStack;II)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderPois(class_4587 poseStack, int mouseX, int mouseY, CallbackInfo ci) {
        if (!SimpleConfig.getInstance(WynnExtrasConfig.class).territoryEstimateToggle) {
            return;
        }
        List advancementPois = this.territoryDefenseFilterEnabled ? Models.Territory.getFilteredTerritoryPoisFromAdvancement(this.territoryDefenseFilterLevel.getLevel(), this.territoryDefenseFilterType) : Models.Territory.getTerritoryPoisFromAdvancement();
        this.fixTradeRoutes(advancementPois);
        ArrayList<TerritoryPoi> renderedPois = new ArrayList<TerritoryPoi>();
        if (this.hybridMode) {
            for (TerritoryPoi poi : advancementPois) {
                TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfile(poi.getName());
                if (territoryProfile != null && territoryProfile.getGuild().equals(poi.getTerritoryInfo().getGuildName())) {
                    renderedPois.add(poi);
                    continue;
                }
                renderedPois.add(new TerritoryPoi(territoryProfile, poi.getTerritoryInfo()));
            }
        } else {
            renderedPois.addAll(advancementPois);
        }
        MarkerModel.USER_WAYPOINTS_PROVIDER.getPois().forEach(renderedPois::add);
        this.renderPois(renderedPois, poseStack, BoundingBox.centered((float)this.mapCenterX, (float)this.mapCenterZ, (float)((float)this.field_22789 / this.zoomRenderScale), (float)((float)this.field_22790 / this.zoomRenderScale)), 1.0f, mouseX, mouseY);
        ci.cancel();
    }

    @Inject(method={"renderTerritoryTooltip"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderTerritoryTooltip(class_4587 poseStack, int xOffset, int yOffset, TerritoryPoi territoryPoi, CallbackInfo ci) {
        List<String> estimatedDefences;
        if (!SimpleConfig.getInstance(WynnExtrasConfig.class).territoryEstimateToggle) {
            return;
        }
        TerritoryInfo territoryInfo = territoryPoi.getTerritoryInfo();
        TerritoryProfile territoryProfile = territoryPoi.getTerritoryProfile();
        int textureWidth = Texture.MAP_INFO_TOOLTIP_CENTER.width();
        float centerHeight = 75 + (territoryInfo.getStorage().size() + territoryInfo.getGenerators().size()) * 10 + (territoryInfo.isHeadquarters() ? 20 : 0) + (((TerritoryInfoMixinDuck)territoryInfo).wynnextras$getEstimatedDefences() != null ? 20 + 10 * ((TerritoryInfoMixinDuck)territoryInfo).wynnextras$getEstimatedDefences().size() : 0);
        RenderUtils.drawTexturedRect((class_4587)poseStack, (Texture)Texture.MAP_INFO_TOOLTIP_TOP, (float)xOffset, (float)yOffset);
        RenderUtils.drawTexturedRect((class_4587)poseStack, (class_2960)Texture.MAP_INFO_TOOLTIP_CENTER.resource(), (float)xOffset, (float)(Texture.MAP_INFO_TOOLTIP_TOP.height() + yOffset), (float)textureWidth, (float)centerHeight, (int)textureWidth, (int)Texture.MAP_INFO_TOOLTIP_CENTER.height());
        RenderUtils.drawTexturedRect((class_4587)poseStack, (Texture)Texture.MAP_INFO_NAME_BOX, (float)xOffset, (float)((float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)yOffset));
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((String)"%s [%s]".formatted(territoryInfo.getGuildName(), territoryInfo.getGuildPrefix())), (float)(10 + xOffset), (float)(10 + yOffset), CommonColors.MAGENTA, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        float renderYOffset = 20 + yOffset;
        for (GuildResource value : GuildResource.values()) {
            int generation = territoryInfo.getGeneration(value);
            CappedValue storage = territoryInfo.getStorage(value);
            if (generation != 0) {
                StyledText formattedGenerated = StyledText.fromString((String)"%s+%d %s per Hour".formatted(value.getPrettySymbol(), generation, value.getName()));
                FontRenderer.getInstance().renderText(poseStack, formattedGenerated, (float)(10 + xOffset), 10.0f + renderYOffset, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
                renderYOffset += 10.0f;
            }
            if (storage == null) continue;
            StyledText formattedStored = StyledText.fromString((String)"%s%d/%d %s stored".formatted(value.getPrettySymbol(), storage.current(), storage.max(), value.getName()));
            FontRenderer.getInstance().renderText(poseStack, formattedStored, (float)(10 + xOffset), 10.0f + renderYOffset, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
            renderYOffset += 10.0f;
        }
        StyledText treasury = StyledText.fromString((String)(String.valueOf(class_124.field_1080) + "\u2726 Treasury: %s".formatted(String.valueOf(territoryInfo.getTreasury().getTreasuryColor()) + territoryInfo.getTreasury().getAsString())));
        StyledText defences = StyledText.fromString((String)(String.valueOf(class_124.field_1080) + "Territory Defences: %s".formatted(String.valueOf(territoryInfo.getDefences().getDefenceColor()) + territoryInfo.getDefences().getAsString())));
        FontRenderer.getInstance().renderText(poseStack, treasury, (float)(10 + xOffset), 10.0f + (renderYOffset += 10.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderText(poseStack, defences, (float)(10 + xOffset), 10.0f + (renderYOffset += 10.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        if (territoryInfo.isHeadquarters()) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((String)"Guild Headquarters"), (float)(10 + xOffset), 10.0f + (renderYOffset += 20.0f), CommonColors.RED, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        }
        if ((estimatedDefences = ((TerritoryInfoMixinDuck)territoryInfo).wynnextras$getEstimatedDefences()) != null) {
            FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((String)(String.valueOf(class_124.field_1080) + "Estimated Defences: " + String.valueOf(class_124.field_1063) + "(by @drzxm)")), (float)(10 + xOffset), 10.0f + (renderYOffset += 20.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
            for (String line : estimatedDefences) {
                FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((String)line), (float)(10 + xOffset), 10.0f + (renderYOffset += 10.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
            }
        }
        String timeHeldString = territoryProfile.getGuild().equals(territoryInfo.getGuildName()) ? String.valueOf(territoryProfile.getTimeAcquiredColor()) + territoryProfile.getReadableRelativeTimeAcquired() : "-";
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString((String)(String.valueOf(class_124.field_1080) + "Time Held: " + timeHeldString)), (float)(10 + xOffset), 10.0f + (renderYOffset += 20.0f), CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString((String)territoryPoi.getName()), (float)(7 + xOffset), (float)(textureWidth + xOffset), (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)yOffset, (float)Texture.MAP_INFO_TOOLTIP_TOP.height() + centerHeight + (float)Texture.MAP_INFO_NAME_BOX.height() + (float)yOffset, 0.0f, CommonColors.WHITE, HorizontalAlignment.LEFT, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
        ci.cancel();
    }
}

