/*
 * Decompiled with CFR 0.152.
 */
package julianh06.wynnextras.mixin;

import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.utils.mc.TooltipUtils;
import java.util.List;
import julianh06.wynnextras.config.WynnExtrasConfig;
import julianh06.wynnextras.config.simpleconfig.SimpleConfig;
import julianh06.wynnextras.features.inventory.WeightDisplay;
import julianh06.wynnextras.utils.ItemUtils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TooltipUtils.class}, remap=false)
public class TooltipUtilsMixin {
    @Inject(method={"getWynnItemTooltip"}, at={@At(value="RETURN")}, cancellable=true)
    private static void injectWeights(class_1799 itemStack, WynnItem wynnItem, CallbackInfoReturnable<List<class_2561>> cir) {
        List tooltips = (List)cir.getReturnValue();
        if (!SimpleConfig.getInstance(WynnExtrasConfig.class).showWeight) {
            return;
        }
        if (!ItemUtils.isTier(itemStack, GearTier.MYTHIC)) {
            return;
        }
        String itemString = ItemUtils.itemStackToItemString(itemStack);
        if (itemString == null) {
            return;
        }
        if (!(wynnItem instanceof GearItem)) {
            return;
        }
        itemStack.method_57379(class_9334.field_49631, (Object)class_2561.method_30163((String)((GearItem)wynnItem).getName()));
        WeightDisplay.WeightData cached = WeightDisplay.getCachedWeight(itemString, true, itemStack, tooltips);
        if (cached == null) {
            return;
        }
        if ((WeightDisplay.upPressed || WeightDisplay.downPressed) && itemStack.method_65130() != null) {
            String key = itemStack.method_65130().getString().replace("\u00c0", "").replaceAll("\u00a7[0-9a-fk-or]", "").replace("\u2b21 Shiny ", "").strip();
            WeightDisplay.ItemData itemData = WeightDisplay.itemCache.get(key);
            if (itemData != null && !itemData.data().isEmpty()) {
                int nextIndex = itemData.index();
                if (WeightDisplay.downPressed) {
                    nextIndex = (itemData.index() + 1) % itemData.data().size();
                } else if (WeightDisplay.upPressed) {
                    nextIndex = (itemData.index() - 1 + itemData.data().size()) % itemData.data().size();
                }
                WeightDisplay.itemCache.put(key, new WeightDisplay.ItemData(itemData.name(), itemData.data(), nextIndex));
            }
            WeightDisplay.upPressed = false;
            WeightDisplay.downPressed = false;
        }
        List<class_2561> modified = WeightDisplay.modifyTooltip(tooltips, cached, itemStack, itemString);
        cir.setReturnValue(modified);
    }
}

